/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.patreon.effects;

import io.github.flemmli97.tenshilib.patreon.RenderLocation;
import io.github.flemmli97.tenshilib.patreon.effects.GuiElement;
import io.github.flemmli97.tenshilib.patreon.effects.PatreonEffectConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class ParticleEffect
extends PatreonEffectConfig {
    private static final Set<GuiElement> NONE = Set.of();
    private static final Vector3f YP = new Vector3f(0.0f, 1.0f, 0.0f);
    private final Particle[] particles;

    public ParticleEffect(String id, int tier, Particle ... particles) {
        super(id, tier);
        this.particles = particles;
    }

    @Override
    public void tick(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        for (int i = 0; i < this.particles.length; ++i) {
            Particle particle = this.particles[i];
            if (particle.chance < 1.0f && player.method_59922().method_43057() < particle.chance) continue;
            Vector3d off = new Vector3d(particle.position.method_10216(), particle.position.method_10214(), particle.position.method_10215()).rotateY((double)(-player.method_5791() * ((float)Math.PI / 180)));
            class_243 pos = player.method_19538().method_1031(off.x(), off.y(), off.z());
            if (particle.container.positionMod.isPresent()) {
                pos = pos.method_1019(particle.container.positionMod.get().apply(player, i));
            }
            class_243 delta = class_243.field_1353;
            if (particle.container.delta.isPresent()) {
                delta = particle.container.delta.get().apply(player, i);
            }
            serverPlayer.method_51469().method_14199(particle.container.particle, pos.method_10216(), pos.method_10214(), pos.method_10215(), 0, delta.field_1352, delta.field_1351, delta.field_1350, 1.0);
        }
    }

    @Override
    public boolean locationAllowed(RenderLocation loc) {
        return false;
    }

    @Override
    public RenderLocation defaultLoc() {
        return RenderLocation.HAT;
    }

    @Override
    public Set<GuiElement> guiElements() {
        return NONE;
    }

    public record Particle(class_243 position, float chance, ParticleContainer container) {
    }

    private record ParticleContainer(class_2394 particle, Optional<ParticleVector> positionMod, Optional<ParticleVector> delta) {
    }

    public static interface ParticleVector {
        public class_243 apply(class_1657 var1, int var2);
    }

    public static class Pattern {
        private final class_2350.class_2351 axis;
        private final class_243 initialOffset;
        private double spacing = 0.5;
        private final Map<Character, ParticleContainer> particles = new HashMap<Character, ParticleContainer>();
        private final List<String> patterns = new ArrayList<String>();

        public static Function<class_1657, class_243> randomAll(double scale) {
            return player -> new class_243(player.method_59922().method_43059() * scale, player.method_59922().method_43059() * scale, player.method_59922().method_43059() * scale);
        }

        public Pattern(class_2350.class_2351 axis, class_243 initialOffset) {
            this.axis = axis;
            this.initialOffset = initialOffset;
        }

        public Pattern setSpacing(double spacing) {
            this.spacing = spacing;
            return this;
        }

        public Pattern addParticle(char key, class_2394 particle) {
            return this.addParticle(key, particle, null, null);
        }

        public Pattern addParticleDelta(char key, class_2394 particle, ParticleVector delta) {
            return this.addParticle(key, particle, null, delta);
        }

        public Pattern addParticlePos(char key, class_2394 particle, ParticleVector position) {
            return this.addParticle(key, particle, position, null);
        }

        public Pattern addParticle(char key, class_2394 particle, ParticleVector position, ParticleVector delta) {
            this.particles.put(Character.valueOf(key), new ParticleContainer(particle, Optional.ofNullable(position), Optional.ofNullable(delta)));
            return this;
        }

        public Pattern addPattern(String ... pattern) {
            this.patterns.addAll(List.of(pattern));
            return this;
        }

        public List<Particle> compile() {
            ArrayList<Particle> result = new ArrayList<Particle>();
            double planeX = 0.0;
            double planeY = 0.0;
            for (String pattern : this.patterns) {
                for (char c : pattern.toCharArray()) {
                    ParticleContainer particle = this.particles.get(Character.valueOf(c));
                    if (particle != null) {
                        class_243 pos = switch (this.axis) {
                            default -> throw new MatchException(null, null);
                            case class_2350.class_2351.field_11048 -> this.initialOffset.method_1031(planeX, planeY, 0.0);
                            case class_2350.class_2351.field_11052 -> this.initialOffset.method_1031(planeX, 0.0, planeY);
                            case class_2350.class_2351.field_11051 -> this.initialOffset.method_1031(0.0, planeY, planeX);
                        };
                        result.add(new Particle(pos, 1.0f, particle));
                    }
                    planeX += this.spacing;
                }
                planeY += this.spacing;
                planeX = 0.0;
            }
            return result;
        }
    }

    public static class Builder {
        private final List<Particle> particles = new ArrayList<Particle>();

        public static Builder of() {
            return new Builder();
        }

        public Builder add(Pattern pattern) {
            this.particles.addAll(pattern.compile());
            return this;
        }

        public ParticleEffect build(String id, int tier) {
            return new ParticleEffect(id, tier, this.particles.toArray(new Particle[0]));
        }
    }
}

