/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import io.github.flemmli97.tenshilib.mixin.BufferBuilderAccessor;
import io.github.flemmli97.tenshilib.mixin.VertexFormatElementMixin;
import java.util.function.Supplier;
import org.lwjgl.system.MemoryUtil;

public class VertexUtils {
    public static final Supplier<VertexFormatElement> SINGLE_FLOAT = Suppliers.memoize(() -> VertexUtils.register(VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.GENERIC, 1));

    public static VertexFormatElement register(VertexFormatElement.Type type, VertexFormatElement.Usage usage, int count) {
        int next = VertexUtils.findNextId();
        return VertexFormatElement.register((int)next, (int)0, (VertexFormatElement.Type)type, (VertexFormatElement.Usage)usage, (int)count);
    }

    private static int findNextId() {
        VertexFormatElement[] lookup = VertexFormatElementMixin.fetchIdLookup();
        for (int i = 0; i < lookup.length; ++i) {
            if (lookup[i] != null) continue;
            return i;
        }
        throw new IllegalStateException("VertexFormatElement count limit exceeded");
    }

    public static VertexConsumer addVertexData(VertexConsumer consumer, VertexFormatElement element, byte ... data) {
        if (!(consumer instanceof BufferBuilder)) {
            return consumer;
        }
        BufferBuilder builder = (BufferBuilder)consumer;
        if (data.length != element.count() || element.type() != VertexFormatElement.Type.BYTE) {
            return consumer;
        }
        long l = ((BufferBuilderAccessor)builder).doBeginElement(element);
        for (int i = 0; i < data.length; ++i) {
            MemoryUtil.memPutByte((long)(l + (long)i), (byte)data[i]);
        }
        return consumer;
    }

    public static VertexConsumer addVertexData(VertexConsumer consumer, VertexFormatElement element, int ... data) {
        if (!(consumer instanceof BufferBuilder)) {
            return consumer;
        }
        BufferBuilder builder = (BufferBuilder)consumer;
        if (data.length != element.count() || element.type() != VertexFormatElement.Type.INT) {
            return consumer;
        }
        long l = ((BufferBuilderAccessor)builder).doBeginElement(element);
        for (int i = 0; i < data.length; ++i) {
            MemoryUtil.memPutInt((long)(l + (long)i), (int)data[i]);
        }
        return consumer;
    }

    public static VertexConsumer addVertexData(VertexConsumer consumer, VertexFormatElement element, float ... data) {
        if (!(consumer instanceof BufferBuilder)) {
            return consumer;
        }
        BufferBuilder builder = (BufferBuilder)consumer;
        if (data.length != element.count() || element.type() != VertexFormatElement.Type.FLOAT) {
            return consumer;
        }
        long l = ((BufferBuilderAccessor)builder).doBeginElement(element);
        for (int i = 0; i < data.length; ++i) {
            MemoryUtil.memPutFloat((long)(l + (long)i), (float)data[i]);
        }
        return consumer;
    }
}

