/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.registry.TenshilibMemoryModules;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetAnimationToPlay<E extends Mob>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORIES = MemoryTest.builder((int)1).usesMemory((MemoryModuleType)TenshilibMemoryModules.ANIMATION_TO_PLAY.get());
    private final List<AnimationPlayHolder<E>> animations;
    private List<AnimationPlayHolder<E>> selectable;
    private BiPredicate<String, E> filter;

    public SetAnimationToPlay(String ... animations) {
        this.animations = Arrays.stream(animations).map(s -> new AnimationPlayHolder((String)s)).toList();
    }

    @SafeVarargs
    public SetAnimationToPlay(AnimationPlayHolder<E> ... animations) {
        this.animations = List.of(animations);
    }

    public SetAnimationToPlay<E> filter(BiPredicate<String, E> filter) {
        this.filter = filter;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        if (((AnimatedEntity)entity).getAnimationHandler().hasAnimation()) {
            return false;
        }
        this.selectable = this.filter == null ? this.animations : this.animations.stream().filter((? super T h) -> this.filter.test(h.animation(), entity)).toList();
        return !this.selectable.isEmpty();
    }

    protected void start(E entity) {
        AnimationPlayHolder<E> selected = this.selectable.get(entity.getRandom().nextInt(this.selectable.size()));
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)TenshilibMemoryModules.ANIMATION_TO_PLAY.get()), selected);
    }
}

