/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.data;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.network.S2CSyncedMobData;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class SyncedDataContainer<T extends Entity> {
    private final T entity;
    private final Map<TypedResource<?>, SyncedContainer<?>> map;
    private boolean isDirty;

    private SyncedDataContainer(T entity, Map<TypedResource<?>, SyncedContainer<?>> map) {
        this.entity = entity;
        this.map = map;
    }

    public static <T extends Entity> Builder<T> builder(T mob) {
        return new Builder<T>(mob);
    }

    public <D> SyncedContainer<D> getContainer(TypedResource<D> id) {
        return this.map.get(id);
    }

    public <D> D get(TypedResource<D> id) {
        return this.getContainer(id).value();
    }

    public <D> void set(TypedResource<D> id, D value) {
        this.set(id, value, true);
    }

    public <D> void set(TypedResource<D> id, D value, boolean syncImmediate) {
        SyncedContainer<D> container = this.getContainer(id);
        if (!Objects.equals(value, container.value)) {
            container.value = value;
            if (!syncImmediate) {
                container.dirty = true;
                this.isDirty = true;
            } else {
                S2CSyncedMobData.send(this.entity, List.of(container));
            }
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void sendDirtyEntriesToTracking() {
        ArrayList list = new ArrayList();
        for (SyncedContainer<?> container : this.map.values()) {
            if (!container.dirty) continue;
            list.add(container);
            container.dirty = false;
        }
        this.isDirty = false;
        S2CSyncedMobData.send(this.entity, list);
    }

    public void sendEntriesTo(ServerPlayer player) {
        S2CSyncedMobData.sendTo(this.entity, List.copyOf(this.map.values()), player);
    }

    public void update(List<SyncedContainer<?>> values) {
        for (SyncedContainer<?> container : values) {
            SyncedContainer<?> get = this.getContainer(container.id());
            if (get == null) continue;
            this.assign(get, container);
        }
    }

    private <D> void assign(SyncedContainer<?> source, SyncedContainer<D> target) {
        if (!Objects.equals(source.syncedEntityData, target.syncedEntityData)) {
            throw new IllegalStateException(String.format("Invalid entity data for entity %s - [source: %s, target: %s]", this.entity, source, target));
        }
        SyncedContainer<?> current = source;
        current.setValue(target.value);
    }

    public static class Builder<T extends Entity> {
        private final T entity;
        private final Map<TypedResource<?>, SyncedContainer<?>> map = new HashMap();

        public Builder(T entity) {
            this.entity = entity;
        }

        public <D> Builder<T> define(TypedResource<D> id, SyncedEntityData<D> type, D initialValue) {
            this.map.put(id, new SyncedContainer<D>(id, type, initialValue));
            return this;
        }

        public SyncedDataContainer<T> build() {
            return new SyncedDataContainer<T>(this.entity, (Map<TypedResource<?>, SyncedContainer<?>>)ImmutableMap.copyOf(this.map));
        }
    }

    public static class SyncedContainer<T> {
        private final TypedResource<T> id;
        private final SyncedEntityData<T> syncedEntityData;
        private T value;
        private boolean dirty;

        public SyncedContainer(TypedResource<T> id, SyncedEntityData<T> syncedEntityData, T initialValue) {
            this.id = id;
            this.syncedEntityData = syncedEntityData;
            this.value = initialValue;
        }

        public static <T> SyncedContainer<T> from(RegistryFriendlyByteBuf buf) {
            TypedResource id = (TypedResource)TypedResource.STREAM_CODEC.decode((Object)buf);
            SyncedEntityData data = (SyncedEntityData)SyncedEntityData.STREAM_CODEC.decode((Object)buf);
            boolean none = buf.readBoolean();
            return new SyncedContainer<Object>(id, data, (none ? data.serializer().decode((Object)buf) : null));
        }

        public void write(RegistryFriendlyByteBuf buf) {
            TypedResource.STREAM_CODEC.encode((Object)buf, this.id);
            SyncedEntityData.STREAM_CODEC.encode((Object)buf, this.syncedEntityData);
            buf.writeBoolean(this.value != null);
            if (this.value != null) {
                this.syncedEntityData.serializer().encode((Object)buf, this.value);
            }
        }

        private void setValue(T value) {
            this.value = value;
        }

        public TypedResource<T> id() {
            return this.id;
        }

        public T value() {
            return this.value;
        }
    }
}

