/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.data;

import com.google.gson.JsonElement;
import io.github.flemmli97.tenshilib.TenshiLib;
import io.github.flemmli97.tenshilib.client.data.ReloadableCache;
import io.github.flemmli97.tenshilib.client.model.BedrockAnimations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class GeoAnimationManager
extends class_4309 {
    public static final class_2960 ID = class_2960.method_60655((String)"tenshilib", (String)"animations");
    public static final String DIRECTORY = String.format("%s/%s", ID.method_12836(), ID.method_12832());
    private static final GeoAnimationManager INSTANCE = new GeoAnimationManager();
    private final Map<class_2960, ReloadableCache<BedrockAnimations>> animations = new HashMap<class_2960, ReloadableCache<BedrockAnimations>>();
    private boolean reloaded;

    private GeoAnimationManager() {
        super(BedrockAnimations.GSON, DIRECTORY);
    }

    public static GeoAnimationManager getInstance() {
        return INSTANCE;
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        HashSet present = new HashSet();
        map.forEach((id, json) -> {
            try {
                BedrockAnimations read = (BedrockAnimations)BedrockAnimations.GSON.fromJson(json, BedrockAnimations.class);
                this.getAnimation((class_2960)id).update(read);
                present.add(id);
            }
            catch (Exception e) {
                TenshiLib.LOGGER.error("Unable to parse animation file {}", id, (Object)e);
            }
        });
        this.reloaded = true;
        ArrayList missing = new ArrayList();
        this.animations.keySet().forEach(id -> {
            if (!present.contains(id)) {
                missing.add(id);
            }
        });
        if (!missing.isEmpty()) {
            throw new IllegalStateException("Following animations could not be found! " + String.valueOf(missing));
        }
    }

    public ReloadableCache<BedrockAnimations> getAnimation(class_2960 id) {
        return this.animations.computeIfAbsent(id, r -> {
            if (this.reloaded) {
                TenshiLib.LOGGER.error("Animation {} is not present! Returned result will be empty!", r);
            }
            return new ReloadableCache();
        });
    }
}

