/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.data;

import com.google.gson.JsonElement;
import io.github.flemmli97.tenshilib.TenshiLib;
import io.github.flemmli97.tenshilib.client.data.ReloadableCache;
import io.github.flemmli97.tenshilib.client.model.BedrockGeometryParser;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class GeoModelManager
extends class_4309 {
    public static final class_2960 ID = class_2960.method_60655((String)"tenshilib", (String)"models");
    public static final String DIRECTORY = String.format("%s/%s", ID.method_12836(), ID.method_12832());
    private static final GeoModelManager INSTANCE = new GeoModelManager();
    private final Map<class_2960, ReloadableCache<ModelPartsContainer>> models = new HashMap<class_2960, ReloadableCache<ModelPartsContainer>>();
    private boolean reloaded;

    private GeoModelManager() {
        super(BedrockGeometryParser.GSON, DIRECTORY);
    }

    public static GeoModelManager getInstance() {
        return INSTANCE;
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 manager, class_3695 profiler) {
        HashSet present = new HashSet();
        map.forEach((res, json) -> {
            try {
                ModelPartsContainer read = (ModelPartsContainer)BedrockGeometryParser.GSON.fromJson(json, ModelPartsContainer.class);
                class_2960 id = class_2960.method_60655((String)res.method_12836(), (String)res.method_12832().replace(".geo", ""));
                this.getModel(id).update(read);
                present.add(id);
            }
            catch (Exception e) {
                TenshiLib.LOGGER.error("Unable to parse geo model file {}", res, (Object)e);
            }
        });
        this.reloaded = true;
        ArrayList missing = new ArrayList();
        this.models.keySet().forEach(id -> {
            if (!present.contains(id)) {
                missing.add(id);
            }
        });
        if (!missing.isEmpty()) {
            throw new IllegalStateException("Following models could not be found! " + String.valueOf(missing));
        }
    }

    public ReloadableCache<ModelPartsContainer> getModel(class_2960 id) {
        return this.getModel(id, null);
    }

    public ReloadableCache<ModelPartsContainer> getModel(class_2960 id, Consumer<ModelPartsContainer> onChange) {
        return this.models.computeIfAbsent(id, r -> {
            if (this.reloaded) {
                TenshiLib.LOGGER.error("Model {} is not present! Returned result will be empty!", r);
            }
            return new ReloadableCache();
        }).onChange(onChange);
    }
}

