/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.gui.widget.list;

import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableEntry;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableListWidget;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import net.minecraft.class_8666;

public class SelectableText
implements SelectableEntry {
    private final class_2561 text;
    private int paddingX = 4;
    private SelectButton[] button;
    private class_8666 entryTexture;
    private boolean selectable = true;
    private class_5481 sequence;
    private class_5481 blankSequence;
    private int lastWidth;
    private int width;
    private int height;

    public SelectableText(String text, class_124 ... chatFormattings) {
        this((class_2561)class_2561.method_43471((String)text).method_27695(chatFormattings));
    }

    public SelectableText(class_2561 text) {
        this.text = text;
    }

    public SelectableText padding(int padding) {
        this.paddingX = padding;
        return this;
    }

    public SelectableText with(SelectButton ... clickHandler) {
        return this.with(false, clickHandler);
    }

    public SelectableText with(boolean canSelect, SelectButton ... clickHandler) {
        this.selectable = canSelect;
        this.button = clickHandler;
        return this;
    }

    public SelectableText withTexture(class_8666 entryTexture) {
        this.entryTexture = entryTexture;
        return this;
    }

    public SelectableText noSelect() {
        this.selectable = false;
        return this;
    }

    @Override
    public void updateDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void render(SelectableListWidget widget, class_332 graphics, int mouseX, int mouseY, float partialTick, int x, int y, boolean selected, boolean hovered) {
        if (this.entryTexture != null) {
            graphics.method_52706(this.entryTexture.method_52729(true, hovered), x, y, this.width, this.height);
        } else if (selected || hovered) {
            graphics.method_25294(x, y, x + this.width, y + this.height, -1609560048);
        }
        int textWidth = this.width - this.paddingX;
        if (this.getButtons() != null && this.getButtons().length > 0) {
            int skipped = 0;
            for (int idx = 0; idx < this.getButtons().length; ++idx) {
                SelectButton btn = this.getButtons()[this.getButtons().length - 1 - idx];
                if (!btn.shouldRender().getAsBoolean()) {
                    ++skipped;
                    continue;
                }
                int[] xY = this.getButtonStart(idx - skipped);
                int bX = xY[0] + x;
                int bY = xY[1] + y;
                textWidth = xY[0] - 2;
                boolean over = mouseX >= bX && mouseY >= bY && mouseX < bX + 12 && mouseY < bY + 12;
                graphics.method_52706(btn.texture().method_52729(true, over), bX, bY, 12, 12);
            }
        }
        graphics.method_35720(widget.getFont(), this.getText(widget.getFont(), textWidth - this.paddingX, selected || hovered), x + this.paddingX, y + (int)(0.5 * (double)this.height - 3.5), selected ? class_124.field_1076.method_532() : (hovered ? class_124.field_1054.method_532() : 0xFFFFFF));
    }

    @Override
    public boolean onClick(double relativeMouseX, double relativeMouseY, boolean selected) {
        if (this.getButtons() != null && this.getButtons().length > 0) {
            int skipped = 0;
            for (int idx = 0; idx < this.getButtons().length; ++idx) {
                int[] xY;
                boolean over;
                SelectButton btn = this.getButtons()[this.getButtons().length - 1 - idx];
                if (!btn.shouldRender().getAsBoolean()) {
                    ++skipped;
                }
                boolean bl = over = relativeMouseX >= (double)(xY = this.getButtonStart(idx - skipped))[0] && relativeMouseY >= (double)xY[1] && relativeMouseX < (double)(xY[0] + 12) && relativeMouseY < (double)(xY[1] + 12);
                if (!over) continue;
                btn.onClick().run();
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                return false;
            }
        }
        return this.selectable;
    }

    public class_5481 getText(class_327 font, int width, boolean highlight) {
        if (this.sequence == null || this.lastWidth != width) {
            this.sequence = SelectableEntry.dottedWith(font, this.text, width, false);
            this.blankSequence = SelectableEntry.dottedWith(font, this.text, width, true);
            this.lastWidth = width;
        }
        return highlight ? this.blankSequence : this.sequence;
    }

    public SelectButton[] getButtons() {
        return this.button;
    }

    private int[] getButtonStart(int position) {
        int btnX = this.width - this.paddingX - 12 - position * 14;
        int btnY = (int)(0.5 * (double)this.height) - 6;
        return new int[]{btnX, btnY};
    }

    public record SelectButton(class_8666 texture, Runnable onClick, BooleanSupplier shouldRender) {
        private static final BooleanSupplier ALWAYS = () -> true;

        public SelectButton(class_8666 texture, Runnable onClick) {
            this(texture, onClick, ALWAYS);
        }
    }
}

