/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.render.layer;

import io.github.flemmli97.tenshilib.client.ClientHandlers;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5498;
import net.minecraft.class_5539;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_922;

public class RiderEntityLayer<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M> {
    private final class_898 dispatcher;
    private final class_922<T, M> renderer;

    public RiderEntityLayer(class_922<T, M> renderer) {
        super(renderer);
        this.renderer = renderer;
        this.dispatcher = class_310.method_1551().method_1561();
    }

    public void render(class_4587 stack, class_4597 buffer, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        for (int i = 0; i < entity.method_5685().size(); ++i) {
            class_1297 rider = (class_1297)entity.method_5685().get(i);
            if (rider == null || class_310.method_1551().field_1719 == rider && class_310.method_1551().field_1690.method_31044() == class_5498.field_26664) continue;
            ClientHandlers.RIDING_RENDER_BLACKLIST.add(rider.method_5667());
            stack.method_22903();
            class_897 entityRenderer = this.dispatcher.method_3953(rider);
            boolean transformed = ((RideableModel)this.method_17165()).transform(entity, this.renderer, rider, (class_897<?>)entityRenderer, stack, i);
            this.renderPassenger(entity, entityRenderer, rider, partialTicks, stack, buffer, light, transformed);
            stack.method_22909();
            ClientHandlers.RIDING_RENDER_BLACKLIST.remove(rider.method_5667());
        }
    }

    protected void undoLivingRendererTransform(class_897<?> entityRenderer, class_4587 stack, T entity, class_1297 rider, float partialTicks, boolean transformed) {
        float yaw = class_3532.method_17821((float)partialTicks, (float)((class_1309)entity).field_6220, (float)((class_1309)entity).field_6283);
        if (rider instanceof class_1309) {
            class_1309 livingRider = (class_1309)rider;
            float headRot = class_3532.method_17821((float)partialTicks, (float)livingRider.field_6259, (float)livingRider.field_6241);
            float diff = class_3532.method_15393((float)(headRot - yaw));
            if (diff < -85.0f) {
                diff = -85.0f;
            }
            if (diff >= 85.0f) {
                diff = 85.0f;
            }
            yaw = headRot - diff;
            if (diff * diff > 2500.0f) {
                yaw += diff * 0.2f;
            }
        }
        if (!transformed) {
            stack.method_22904(0.0, (double)1.501f, 0.0);
        }
        stack.method_22905(-1.0f, -1.0f, 1.0f);
        stack.method_22907(class_7833.field_40716.rotationDegrees(yaw + 180.0f));
    }

    public <E extends class_1297> void renderPassenger(T vehicle, class_897<E> entityRenderer, E entity, float partialTicks, class_4587 stack, class_4597 buffer, int packedLight, boolean transformed) {
        try {
            this.undoLivingRendererTransform(entityRenderer, stack, vehicle, entity, partialTicks, transformed);
            if (!transformed) {
                class_243 diff = entity.method_19538().method_1020(vehicle.method_19538());
                stack.method_22904(diff.field_1352, diff.field_1351, diff.field_1350);
            }
            entityRenderer.method_3936(entity, 0.0f, partialTicks, stack, buffer, packedLight);
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)("Rendering entity in level from " + String.valueOf(((Object)((Object)this)).getClass())));
            class_129 crashReportCategory = crashReport.method_562("Entity being rendered");
            entity.method_5819(crashReportCategory);
            class_129 crashReportCategory2 = crashReport.method_562("Renderer details");
            crashReportCategory2.method_578("Assigned renderer", entityRenderer);
            crashReportCategory2.method_578("Location", (Object)class_129.method_583((class_5539)entity.method_37908(), (double)entity.method_19538().field_1352, (double)entity.method_19538().field_1351, (double)entity.method_19538().field_1350));
            crashReportCategory2.method_578("Delta", (Object)Float.valueOf(partialTicks));
            throw new class_148(crashReport);
        }
    }
}

