/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity;

import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.loader.TenshiLibCrossPlat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public abstract class AdvancedProjectile
extends class_1676 {
    protected static final class_2940<Optional<UUID>> SHOOTER_UUID = class_2945.method_12791(AdvancedProjectile.class, (class_2941)class_2943.field_13313);
    private class_1297 shooter;
    protected boolean inGround;
    protected int ticksInGround;
    protected int livingTicks;
    public final List<UUID> attackedEntities = new ArrayList<UUID>();
    public final List<UUID> checkedEntities = new ArrayList<UUID>();
    protected class_2680 groundState;
    protected class_2338 groundPos;

    public AdvancedProjectile(class_1299<? extends AdvancedProjectile> type, class_1937 level) {
        super(type, level);
    }

    public AdvancedProjectile(class_1299<? extends AdvancedProjectile> type, class_1937 level, double x, double y, double z) {
        this(type, level);
        this.method_5814(x, y, z);
    }

    public AdvancedProjectile(class_1299<? extends AdvancedProjectile> type, class_1937 level, class_1309 shooter) {
        this(type, level, shooter.method_23317(), shooter.method_23318() + (double)shooter.method_5751() - 0.1, shooter.method_23321());
        this.shooter = shooter;
        this.field_6011.method_12778(SHOOTER_UUID, Optional.of(shooter.method_5667()));
        this.method_5710(shooter.method_36454(), shooter.method_36455());
        this.onUpdateOwner();
    }

    public static double getGravityOffset(AdvancedProjectile projectile, class_243 dir, class_243 motion) {
        if (projectile.getGravityVelocity() == 0.0f) {
            return 0.0;
        }
        double gravityOffset = dir.method_1033() / motion.method_1033() * 0.5 * (double)projectile.getGravityVelocity();
        return gravityOffset * 0.99;
    }

    public boolean isPiercing() {
        return false;
    }

    public int maxPierceAmount() {
        return -1;
    }

    public float radius() {
        return 0.0f;
    }

    public int livingTicks() {
        return this.livingTicks;
    }

    public int livingTickMax() {
        return 6000;
    }

    public boolean canHitShooter() {
        return false;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(SHOOTER_UUID, Optional.empty());
    }

    public boolean method_5640(double distance) {
        double d0 = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void shoot(class_1297 entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -class_3532.method_15374((float)(rotationYawIn * ((float)Math.PI / 180))) * class_3532.method_15362((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -class_3532.method_15374((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = class_3532.method_15362((float)(rotationYawIn * ((float)Math.PI / 180))) * class_3532.method_15362((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.method_7485(f, f1, f2, velocity, inaccuracy);
        class_243 throwerMotion = entityThrower.method_18798();
        this.method_18799(this.method_18798().method_1031(throwerMotion.field_1352, entityThrower.method_24828() ? 0.0 : throwerMotion.field_1351, throwerMotion.field_1350));
        this.method_18798().method_1031(throwerMotion.field_1352, 0.0, throwerMotion.field_1350);
    }

    public void shootAtEntity(class_1297 target, float velocity, float inaccuracy) {
        this.shootAtEntity(target, velocity, inaccuracy, false);
    }

    public void shootAtEntity(class_1297 target, float velocity, float inaccuracy, boolean ignoreGravity) {
        class_243 targetPos = EntityUtils.getStraightProjectileTarget(this.method_19538(), target);
        this.shootAtPosition(targetPos.method_10216(), targetPos.method_10214(), targetPos.method_10215(), velocity, inaccuracy, ignoreGravity);
    }

    public void shootAtPosition(double x, double y, double z, float velocity, float inaccuracy) {
        this.shootAtPosition(x, y, z, velocity, inaccuracy, false);
    }

    public void shootAtPosition(double x, double y, double z, float velocity, float inaccuracy, boolean ignoreGravity) {
        class_243 dir = new class_243(x - this.method_23317(), y - this.method_23318(), z - this.method_23321());
        if (this.getGravityVelocity() == 0.0f || ignoreGravity) {
            this.method_7485(dir.field_1352, dir.field_1351, dir.field_1350, velocity, inaccuracy);
        } else {
            class_243 motion = dir.method_1029().method_1031(this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy).method_1021((double)velocity);
            motion = motion.method_1031(0.0, AdvancedProjectile.getGravityOffset(this, dir, motion), 0.0);
            this.setMotionWithRotation(motion);
        }
    }

    public void method_7485(double x, double y, double z, float velocity, float inaccuracy) {
        class_243 motion = new class_243(x, y, z).method_1029().method_1031(this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy).method_1021((double)velocity);
        this.setMotionWithRotation(motion);
    }

    private void setMotionWithRotation(class_243 motion) {
        this.method_18799(motion);
        double f = Math.sqrt(AdvancedProjectile.horizontalMag(motion));
        this.method_36456((float)(class_3532.method_15349((double)motion.field_1352, (double)motion.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)motion.field_1351, (double)f) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        this.ticksInGround = 0;
    }

    public void method_5750(double x, double y, double z) {
        this.method_18800(x, y, z);
        if (this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            double f = Math.sqrt(x * x + z * z);
            this.method_36457((float)(class_3532.method_15349((double)y, (double)f) * 57.2957763671875));
            this.method_36456((float)(class_3532.method_15349((double)x, (double)z) * 57.2957763671875));
            this.field_6004 = this.method_36455();
            this.field_5982 = this.method_36454();
            this.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
        }
    }

    public void setInGround(class_2338 pos) {
        class_2680 state = this.method_37908().method_8320(pos);
        if (this.method_37908().method_18026(new class_238(this.method_19538(), this.method_19538()).method_1014(0.06))) {
            this.inGround = false;
            this.groundPos = null;
            this.groundState = null;
            return;
        }
        this.inGround = true;
        this.groundPos = pos;
        this.groundState = state;
    }

    public void method_5773() {
        class_2680 groundState;
        super.method_5773();
        ++this.livingTicks;
        if (!this.method_37908().field_9236 && this.livingTicks > this.livingTickMax()) {
            this.method_5650(class_1297.class_5529.field_26998);
            return;
        }
        class_243 motion = this.method_18798();
        if (this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            double f = Math.sqrt(AdvancedProjectile.horizontalMag(motion));
            this.method_36457((float)(class_3532.method_15349((double)motion.field_1352, (double)motion.field_1350) * 57.2957763671875));
            this.method_36456((float)(class_3532.method_15349((double)motion.field_1351, (double)f) * 57.2957763671875));
            this.field_6004 = this.method_36455();
            this.field_5982 = this.method_36454();
        }
        class_2680 class_26802 = groundState = this.groundPos != null ? this.method_37908().method_8320(this.groundPos) : null;
        if (this.inGround) {
            if (groundState != this.groundState && this.noGround()) {
                this.resetInGround();
            }
            this.tickInGround();
            return;
        }
        if (!this.method_37908().field_9236) {
            this.doCollision();
        }
        this.moveEntity();
    }

    protected void tickInGround() {
        ++this.ticksInGround;
        if (!this.method_37908().field_9236 && this.ticksInGround == 1200) {
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public void moveEntity() {
        class_243 motion = this.method_18798();
        double newX = this.method_23317() + motion.field_1352;
        double newY = this.method_23318() + motion.field_1351;
        double newZ = this.method_23321() + motion.field_1350;
        double f = Math.sqrt(AdvancedProjectile.horizontalMag(motion));
        this.method_36456(this.updateRotation(this.field_5982, (float)(class_3532.method_15349((double)motion.field_1352, (double)motion.field_1350) * 57.29577951308232)));
        this.method_36457(this.updateRotation(this.field_6004, (float)(class_3532.method_15349((double)motion.field_1351, (double)f) * 57.2957763671875)));
        boolean water = this.method_5799();
        if (water) {
            for (int i = 0; i < 4; ++i) {
                this.method_37908().method_8406((class_2394)class_2398.field_11247, this.method_23317() * 0.25, this.method_23318() * 0.25, this.method_23321() * 0.25, motion.field_1352, motion.field_1351, motion.field_1350);
            }
        }
        float friction = this.motionReduction(water);
        this.method_18799(motion.method_1021((double)friction));
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1023(0.0, (double)this.getGravityVelocity(), 0.0));
        }
        this.method_5814(newX, newY, newZ);
    }

    public static double horizontalMag(class_243 vec) {
        return vec.field_1352 * vec.field_1352 + vec.field_1350 * vec.field_1350;
    }

    private float updateRotation(float prev, float current) {
        while (current - prev < -180.0f) {
            prev -= 360.0f;
        }
        while (current - prev >= 180.0f) {
            prev += 360.0f;
        }
        return class_3532.method_16439((float)0.2f, (float)prev, (float)current);
    }

    protected void doCollision() {
        class_243 pos = this.method_19538();
        class_243 to = pos.method_1019(this.method_18798());
        class_3965 raytraceresult = this.method_37908().method_17742(new class_3959(pos, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (raytraceresult.method_17783() != class_239.class_240.field_1333) {
            to = raytraceresult.method_17784();
        }
        if (raytraceresult.method_17783() == class_239.class_240.field_1332) {
            if (!TenshiLibCrossPlat.INSTANCE.projectileImpactEvent(this, (class_239)raytraceresult)) {
                this.method_24920(raytraceresult);
                class_2338 blockPos = raytraceresult.method_17777();
                this.method_37908().method_43276((class_6880)class_5712.field_28162, blockPos, class_5712.class_7397.method_43286((class_1297)this, (class_2680)this.method_37908().method_8320(blockPos)));
            }
        } else {
            class_3966 res;
            while ((res = this.getEntityHit(pos, to)) != null && this.method_5805()) {
                this.checkedEntities.add(res.method_17782().method_5667());
                if (TenshiLibCrossPlat.INSTANCE.projectileImpactEvent(this, (class_239)res) || this.attackedEntities.contains(res.method_17782().method_5667()) || !this.entityRayTraceHit(res)) continue;
                this.attackedEntities.add(res.method_17782().method_5667());
                if (this.maxPierceAmount() == -1 || this.attackedEntities.size() <= this.maxPierceAmount()) continue;
                this.onReachMaxPierce();
            }
        }
    }

    protected boolean noGround() {
        return this.inGround && this.method_37908().method_18026(new class_238(this.method_19538(), this.method_19538()).method_1014(0.06));
    }

    protected void resetInGround() {
        this.inGround = false;
        this.groundPos = null;
        this.groundState = null;
        this.method_18799(this.method_18798().method_18805((double)(this.field_5974.method_43057() * 0.2f), (double)(this.field_5974.method_43057() * 0.2f), (double)(this.field_5974.method_43057() * 0.2f)));
        this.ticksInGround = 0;
    }

    public void method_5784(class_1313 type, class_243 to) {
        super.method_5784(type, to);
        if (type != class_1313.field_6308 && this.noGround()) {
            this.resetInGround();
        }
    }

    protected boolean canHit(class_1297 target) {
        if (target.method_7325() || !target.method_5805() || !target.method_5863() || this.checkedEntities.contains(target.method_5667())) {
            return false;
        }
        class_1297 entity = this.method_24921();
        if (entity == null) {
            return true;
        }
        if (entity.method_5794(target) || TenshiLibCrossPlat.INSTANCE.isSameMultipart(target, this.method_24921())) {
            return false;
        }
        return !target.equals((Object)this.method_24921()) || this.canHitShooter() && this.field_6012 >= 5;
    }

    protected class_3966 getEntityHit(class_243 from, class_243 to) {
        if (!this.method_5805()) {
            return null;
        }
        double amount = 1.0;
        if (this.isPiercing()) {
            amount = this.maxPierceAmount();
        }
        if (amount == -1.0 || (double)this.attackedEntities.size() < amount) {
            if (this.radius() != 0.0f) {
                double dist = to.method_1020(from).method_1033();
                OrientedBoundingBox obb = new OrientedBoundingBox(OrientedBoundingBox.baseBox(this.radius() * 2.0f, this.radius() * 2.0f, dist), -this.method_36454(), this.method_36455(), this.method_19538());
                List list = this.method_37908().method_8335((class_1297)this, obb.getEncompassingBox());
                for (class_1297 e : list) {
                    if (!this.canHit(e) || !obb.intersects(e.method_5829())) continue;
                    class_238 outer = obb.getEncompassingBox();
                    class_243 hit = new class_243(class_3532.method_15350((double)e.method_19538().field_1352, (double)outer.field_1323, (double)outer.field_1320), class_3532.method_15350((double)e.method_19538().field_1351, (double)outer.field_1322, (double)outer.field_1325), class_3532.method_15350((double)e.method_19538().field_1350, (double)outer.field_1321, (double)outer.field_1324));
                    return new class_3966(e, hit);
                }
                return null;
            }
            return HitResultUtils.rayTraceEntities((class_1297)this, from, to, this::canHit);
        }
        return null;
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    protected float motionReduction(boolean inWater) {
        return inWater ? 0.8f : 0.99f;
    }

    protected abstract boolean entityRayTraceHit(class_3966 var1);

    protected abstract void onBlockHit(class_3965 var1);

    protected void onReachMaxPierce() {
    }

    protected void method_5749(class_2487 compound) {
        this.inGround = compound.method_10577("InGround");
        if (compound.method_10545("GroundPos")) {
            class_2512.method_10691((class_2487)compound, (String)"GroundPos").ifPresent(this::setInGround);
        }
        if (compound.method_25928("Shooter")) {
            this.field_6011.method_12778(SHOOTER_UUID, Optional.of(compound.method_25926("Shooter")));
        }
        this.shooter = this.method_24921();
        this.livingTicks = compound.method_10550("LivingTicks");
        class_2499 list = compound.method_10554("AttackedEntities", 8);
        list.forEach(tag -> this.attackedEntities.add(UUID.fromString(tag.method_10714())));
    }

    protected void method_5652(class_2487 compound) {
        if (this.groundPos != null) {
            compound.method_10566("GroundPos", class_2512.method_10692((class_2338)this.groundPos));
        }
        compound.method_10556("InGround", this.inGround);
        ((Optional)this.field_6011.method_12789(SHOOTER_UUID)).ifPresent(uuid -> compound.method_25927("Shooter", uuid));
        compound.method_10569("LivingTicks", this.livingTicks);
        class_2499 list = new class_2499();
        this.attackedEntities.forEach(uuid -> list.add((Object)class_2519.method_23256((String)uuid.toString())));
        compound.method_10566("AttackedEntities", (class_2520)list);
    }

    @Nullable
    public class_1297 method_24921() {
        if (this.shooter != null && !this.shooter.method_31481()) {
            return this.shooter;
        }
        ((Optional)this.field_6011.method_12789(SHOOTER_UUID)).ifPresent(uuid -> {
            this.shooter = EntityUtils.findFromUUID(class_1297.class, this.method_37908(), uuid);
            this.onUpdateOwner();
        });
        return this.shooter;
    }

    public void onUpdateOwner() {
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.field_6011.method_12789(SHOOTER_UUID)).orElse(null);
    }

    protected final void method_7454(class_3966 result) {
        this.entityRayTraceHit(result);
    }

    protected final void method_24920(class_3965 result) {
        super.method_24920(result);
        this.onBlockHit(result);
    }

    public final void method_7432(@Nullable class_1297 entity) {
        if (entity == null) {
            this.shooter = null;
            this.field_6011.method_12778(SHOOTER_UUID, Optional.empty());
        } else {
            this.shooter = entity;
            this.field_6011.method_12778(SHOOTER_UUID, Optional.of(entity.method_5667()));
        }
        this.onUpdateOwner();
    }
}

