/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.animated;

import io.github.flemmli97.tenshilib.common.data.AnimationDataManager;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.network.S2CEntityAnimation;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_6501;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationHandler<T extends class_1297> {
    public static final int DEFAULT_TRANSIT_TIME = 3;
    public static final int FALLBACK_TRANSIT_TIME = -1;
    private final T entity;
    private final AnimationDefinitionContainer definitions;
    private final List<PriorityEntry<Predicate<AnimationDefinition>>> animationChangeListener = new ArrayList<PriorityEntry<Predicate<AnimationDefinition>>>();
    private class_6501<AnimationDefinition> animationSpeedHandler;
    private AnimationState currentAnimation;
    private AnimationState lastAnimation;
    private int timeSinceLastChange = -1;

    public AnimationHandler(T entity, AnimationDefinitionContainer defaulted) {
        this.entity = entity;
        this.definitions = AnimationDataManager.getInstance().getAnimation(entity.method_5864(), defaulted);
    }

    public AnimationHandler(T entity, class_2960 id, AnimationDefinitionContainer defaulted) {
        this.entity = entity;
        this.definitions = AnimationDataManager.getInstance().getAnimation(id, defaulted);
    }

    public AnimationHandler<T> withChangeListener(Predicate<AnimationDefinition> onAnimationSet) {
        return this.withChangeListener(-1, onAnimationSet);
    }

    public AnimationHandler<T> withChangeListener(int priority, Predicate<AnimationDefinition> onAnimationSet) {
        if (priority == -1) {
            this.animationChangeListener.add(new PriorityEntry<Predicate<AnimationDefinition>>(priority, onAnimationSet));
        } else {
            this.animationChangeListener.add(new PriorityEntry<Predicate<AnimationDefinition>>(priority, onAnimationSet));
            this.animationChangeListener.sort(Comparator.reverseOrder());
        }
        return this;
    }

    public AnimationHandler<T> withAnimationSpeedHandler(class_6501<AnimationDefinition> animationSpeedHandler) {
        this.animationSpeedHandler = animationSpeedHandler;
        return this;
    }

    public T getEntity() {
        return this.entity;
    }

    @Nullable
    public AnimationState getAnimation() {
        return this.currentAnimation;
    }

    public void runIfAnimation(String id, Consumer<AnimationState> consumer) {
        if (this.isCurrent(id)) {
            consumer.accept(this.getAnimation());
        }
    }

    public void runIfNotNull(Consumer<AnimationState> consumer) {
        if (this.currentAnimation != null) {
            consumer.accept(this.currentAnimation);
        }
    }

    public boolean hasAnimation() {
        return this.currentAnimation != null;
    }

    public AnimationDefinition get(@Nullable String name) {
        if (name == null) {
            return null;
        }
        AnimationDefinition definition = this.definitions.get(name);
        if (definition == null) {
            throw new IllegalStateException("No such animation definition " + name);
        }
        return definition;
    }

    public AnimationState createDefaulted(String name) {
        return AnimationState.create(this.get(name));
    }

    public void setAnimation(@Nullable String name) {
        this.setAnimationDef(this.get(name));
    }

    public void setAnimationDef(@Nullable AnimationDefinition animation) {
        this.setAnimation(animation, -1, -1, 0.0);
    }

    public void setAnimation(@Nullable AnimationDefinition animation, int startTransition, int endTransition, double offset) {
        for (PriorityEntry<Predicate<AnimationDefinition>> listener : this.animationChangeListener) {
            if (!listener.val().test(animation)) continue;
            return;
        }
        if (this.currentAnimation != null) {
            this.lastAnimation = this.currentAnimation;
            this.timeSinceLastChange = 0;
            if (animation != null) {
                startTransition = startTransition > 0 ? startTransition : this.lastAnimation.getEndTransitionTime();
                this.lastAnimation = AnimationState.create(animation, this.currentAnimation.getStartTransition(), startTransition, this.currentAnimation.getTick(1.0f), this.currentAnimation.getSpeed());
            }
        } else if (this.lastAnimation != null && animation != null) {
            this.lastAnimation = AnimationState.create(animation, this.lastAnimation.getStartTransition(), startTransition + this.timeSinceLastChange, this.lastAnimation.getTick(1.0f), this.lastAnimation.getSpeed());
        }
        AnimationState animationState = animation == null ? null : (this.currentAnimation = AnimationState.create(animation, startTransition, endTransition, offset, this.animationSpeedHandler == null ? 1.0 : (double)this.animationSpeedHandler.method_41296((Object)animation)));
        if (!this.entity.method_37908().field_9236) {
            LoaderNetwork.INSTANCE.sendToTracking(S2CEntityAnimation.create(this.entity, startTransition, endTransition, offset), (class_1297)this.entity);
        }
    }

    public AnimationDefinitionContainer getAnimations() {
        return this.definitions;
    }

    public boolean isCurrent(AnimationDefinition ... others) {
        if (this.getAnimation() == null) {
            return false;
        }
        return this.getAnimation().is(others);
    }

    public boolean isCurrent(String ... others) {
        if (this.getAnimation() == null) {
            return false;
        }
        return this.getAnimation().is(others);
    }

    public int getTimeSinceLastChange() {
        return this.timeSinceLastChange;
    }

    public AnimationState getLastAnimation() {
        return this.lastAnimation;
    }

    public void tick() {
        ++this.timeSinceLastChange;
        if (this.lastAnimation != null && this.timeSinceLastChange > this.lastAnimation.getEndTransitionTime()) {
            this.lastAnimation = null;
        }
        if (this.hasAnimation() && this.getAnimation().tick()) {
            this.setAnimationDef(null);
        }
    }

    public void finishAnimation() {
        AnimationState anim = this.getAnimation();
        if (anim != null) {
            while (!anim.done(1)) {
                anim.tick();
            }
            if (anim.shouldRunOut()) {
                this.setAnimationDef(null);
            } else {
                this.timeSinceLastChange = class_3532.method_15384((double)anim.getLength());
            }
        }
    }

    public float getCurrentTransitionProgress(float partialTicks) {
        if (this.currentAnimation == null) {
            return 1.0f;
        }
        return (float)this.currentAnimation.getStartTransitionProgress(partialTicks);
    }

    public float getLastTransitionProgress(float partialTicks) {
        if (this.lastAnimation == null || this.lastAnimation.getEndTransitionTime() <= 0) {
            return 0.0f;
        }
        return 1.0f - class_3532.method_15363((float)(((float)(this.getTimeSinceLastChange() - 1) + partialTicks) / (float)this.lastAnimation.getEndTransitionTime()), (float)0.0f, (float)1.0f);
    }

    private record PriorityEntry<T>(int priority, T val) implements Comparable<PriorityEntry<T>>
    {
        @Override
        public int compareTo(@NotNull PriorityEntry<T> other) {
            return Integer.compare(this.priority(), other.priority());
        }
    }
}

