/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity;

import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.loader.TenshiLibCrossPlat;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class BeamEntity
extends Entity
implements TraceableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> SHOOTER_UUID = SynchedEntityData.defineId(BeamEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private Entity shooter;
    protected int livingTicks;
    protected HitResult hit;
    protected Vec3 hitVec;
    protected OrientedBoundingBox hitObb;

    public BeamEntity(EntityType<? extends BeamEntity> type, Level level) {
        super(type, level);
        this.noCulling = true;
    }

    public BeamEntity(EntityType<? extends BeamEntity> type, Level level, double x, double y, double z) {
        this(type, level);
        this.setPos(x, y, z);
    }

    public BeamEntity(EntityType<? extends BeamEntity> type, Level level, LivingEntity shooter) {
        this(type, level, shooter.getX(), shooter.getY() + (double)shooter.getEyeHeight() - 0.1, shooter.getZ());
        this.shooter = shooter;
        this.entityData.set(SHOOTER_UUID, Optional.of(shooter.getUUID()));
        this.setRot(shooter.yHeadRot, shooter.getXRot());
    }

    public void setRotationTo(Entity target, float inaccuracy) {
        Vec3 targetPos = EntityUtils.getStraightProjectileTarget(this.position(), target);
        this.setRotationTo(targetPos.x(), targetPos.y(), targetPos.z(), inaccuracy);
    }

    public void setRotationTo(double x, double y, double z, float inaccuracy) {
        double dx = x - this.getX();
        double dy = y - this.getY();
        double dz = z - this.getZ();
        this.setRotationToDir(dx, dy, dz, inaccuracy);
    }

    public void setRotationToDir(double x, double y, double z, float inaccuracy) {
        double dis = Math.sqrt((x += this.random.nextGaussian() * (double)inaccuracy) * x + (y += this.random.nextGaussian() * (double)inaccuracy) * y + (z += this.random.nextGaussian() * (double)inaccuracy) * z);
        this.setYRot((float)(Mth.atan2((double)z, (double)x) * 180.0 / Math.PI) - 90.0f);
        this.setXRot((float)(Math.acos(y / dis) * 180.0 / Math.PI) - 90.0f);
    }

    public Vec3 startVec() {
        return this.position();
    }

    public Vec3 hitVec() {
        return this.hit != null ? this.hitVec : this.startVec();
    }

    public float getRange() {
        return 32.0f;
    }

    public float radius() {
        return 1.0f;
    }

    public boolean piercing() {
        return false;
    }

    public int livingTickMax() {
        return 20;
    }

    public void updateYawPitch() {
        if (this.getHitVecFromShooter() && this.getOwner() != null) {
            Entity e = this.getOwner();
            this.setXRot(e.getXRot());
            this.setYRot(e.getYRot());
            this.xRotO = e.xRotO;
            this.yRotO = e.yRotO;
            this.setPos(e.getX(), e.getY() + (double)e.getEyeHeight() - (double)0.1f, e.getZ());
        }
    }

    public boolean getHitVecFromShooter() {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < (double)Math.max(1048.0f, (this.getRange() + 2.0f) * (this.getRange() + 2.0f));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SHOOTER_UUID, Optional.empty());
    }

    public void updateHitDetectBox() {
        double dist = this.hitVec != null ? this.hitVec.subtract(this.position()).length() : 0.0;
        this.hitObb = new OrientedBoundingBox(OrientedBoundingBox.baseBox(this.radius() * 2.0f, this.radius() * 2.0f, dist + 1.5), this.getYRot(), -this.getXRot(), this.position());
    }

    public void tick() {
        this.updateYawPitch();
        if (this.hit == null || this.getHitVecFromShooter()) {
            this.hit = this.getHitRay();
            this.hitVec = this.hit.getLocation();
            if (this.hit.getType() == HitResult.Type.BLOCK) {
                Vec3 dir = this.hitVec.subtract(this.position()).normalize();
                this.hitVec = this.hitVec.subtract(dir.scale((double)this.radius() * 0.3));
            }
            this.updateHitDetectBox();
        }
        super.tick();
        ++this.livingTicks;
        if (!this.level().isClientSide) {
            if (this.livingTicks > this.livingTickMax()) {
                this.remove(Entity.RemovalReason.KILLED);
                return;
            }
            if (this.hit != null && this.canStartDamage() && this.isAlive()) {
                List list = this.level().getEntities((Entity)this, new AABB(this.getX(), this.getY(), this.getZ(), this.hitVec.x, this.hitVec.y, this.hitVec.z).inflate((double)(1.0f + this.radius())));
                Predicate<AABB> collisionCheck = aabb -> {
                    if (this.radius() == 0.0f) {
                        Optional ray = aabb.clip(this.position(), this.hitVec);
                        return ray.isPresent() || aabb.contains(this.position());
                    }
                    return this.hitObb.intersects((AABB)aabb);
                };
                for (Entity entity : list) {
                    EntityHitResult raytraceresult;
                    if (entity.equals((Object)this.getOwner()) || !this.canHitEntity(entity) || !this.check(entity, collisionCheck) || TenshiLibCrossPlat.INSTANCE.beamHitEvent(this, (HitResult)(raytraceresult = new EntityHitResult(entity)))) continue;
                    this.onImpact(raytraceresult);
                    if (this.piercing()) continue;
                    return;
                }
            }
        }
    }

    protected boolean canHitEntity(Entity target) {
        if (target.isSpectator() || !target.isAlive() || !target.isPickable()) {
            return false;
        }
        Entity entity = this.getOwner();
        if (entity == null) {
            return true;
        }
        return target != entity && !TenshiLibCrossPlat.INSTANCE.isSameMultipart(target, entity) && !entity.isPassengerOfSameVehicle(target);
    }

    public HitResult getHitRay() {
        HitResult result = HitResultUtils.entityRayTrace(this, this.getRange(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, !this.piercing(), true, this::canHitEntity);
        if (result instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)result;
            Vec3 dir = entityHitResult.getLocation().subtract(this.getEyePosition());
            double len = dir.length();
            double bounds = Math.min(entityHitResult.getEntity().getBbWidth(), entityHitResult.getEntity().getBbHeight());
            double inc = Math.min(len + bounds, (double)this.getRange()) - len;
            return new EntityHitResult(entityHitResult.getEntity(), entityHitResult.getLocation().add(dir.normalize().scale(inc)));
        }
        return result;
    }

    protected boolean check(Entity e, Predicate<AABB> intersects) {
        if (e.isSpectator() || !e.isAlive() || !e.isPickable()) {
            return false;
        }
        AABB aabb = e.getBoundingBox();
        return intersects.test(aabb);
    }

    public abstract void onImpact(EntityHitResult var1);

    public int livingTicks() {
        return this.livingTicks;
    }

    public boolean canStartDamage() {
        return (this.livingTicks - 1) % 20 == 0;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("Shooter")) {
            this.entityData.set(SHOOTER_UUID, Optional.of(compound.getUUID("Shooter")));
        }
        this.shooter = this.getOwner();
        this.livingTicks = compound.getInt("LivingTicks");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        ((Optional)this.entityData.get(SHOOTER_UUID)).ifPresent(uuid -> compound.putUUID("Shooter", uuid));
        compound.putInt("LivingTicks", this.livingTicks);
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(SHOOTER_UUID)).orElse(null);
    }

    @Nullable
    public Entity getOwner() {
        if (this.shooter != null && !this.shooter.isRemoved()) {
            return this.shooter;
        }
        ((Optional)this.entityData.get(SHOOTER_UUID)).ifPresent(uuid -> {
            this.shooter = EntityUtils.findFromUUID(Entity.class, this.level(), uuid);
        });
        return this.shooter;
    }

    public boolean shouldRender3d(@Nullable Entity entity, int cameraState) {
        if (cameraState == 2) {
            return true;
        }
        return this.getOwner() == null || entity == null || !this.getOwner().getUUID().equals(entity.getUUID());
    }
}

