/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class LeapInDirection<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORIES = MemoryTest.builder((int)1).hasMemory(MemoryModuleType.ATTACK_TARGET);
    protected BiPredicate<E, LivingEntity> shouldLeap = (owner, target) -> true;
    protected BiFunction<E, LivingEntity, Vec3> horizontalLeapDirection = (owner, target) -> owner.getRandom().nextBoolean() ? LeapInDirection.createBackwardsVec(owner.position(), target.position()) : LeapInDirection.createSidewaysVec(owner.position(), target.position(), owner.getRandom().nextBoolean());
    protected BiFunction<E, LivingEntity, Double> verticalStrength = (owner, target) -> 0.2;
    protected BiFunction<E, LivingEntity, Double> leapStrength = (owner, target) -> 1.0;

    public static Vec3 createSidewaysVec(Vec3 from, Vec3 to, boolean left) {
        Vec3 dir = to.subtract(from);
        dir = new Vec3(dir.x(), 0.0, dir.z()).normalize();
        return dir.yRot((float)(left ? -90 : 90) * ((float)Math.PI / 180));
    }

    public static Vec3 createBackwardsVec(Vec3 from, Vec3 to) {
        Vec3 dir = to.subtract(from);
        return new Vec3(-dir.x(), 0.0, -dir.z()).normalize();
    }

    public LeapInDirection<E> shouldLeap(BiPredicate<E, LivingEntity> check) {
        this.shouldLeap = check;
        return this;
    }

    public LeapInDirection<E> horizontalDirection(BiFunction<E, LivingEntity, Vec3> direction) {
        this.horizontalLeapDirection = direction;
        return this;
    }

    public LeapInDirection<E> verticalStrength(double strength) {
        return this.verticalStrength((entity, target) -> strength);
    }

    public LeapInDirection<E> verticalStrength(BiFunction<E, LivingEntity, Double> strength) {
        this.verticalStrength = strength;
        return this;
    }

    public LeapInDirection<E> strength(double strength) {
        return this.strength((entity, target) -> strength);
    }

    public LeapInDirection<E> strength(BiFunction<E, LivingEntity, Double> strength) {
        this.leapStrength = strength;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected void start(E entity) {
        Vec3 dir;
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        if (this.shouldLeap.test(entity, target) && (dir = this.horizontalLeapDirection.apply(entity, target)) != null) {
            double strength = this.leapStrength.apply(entity, target);
            entity.setDeltaMovement(dir.x() * strength, this.verticalStrength.apply(entity, target).doubleValue(), dir.z() * strength);
        }
    }
}

