/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.network;

import io.github.flemmli97.tenshilib.client.ClientHandlers;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class S2CAnimationScreen
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<S2CAnimationScreen> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tenshilib", (String)"s2c_animation_screen"));
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CAnimationScreen> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, S2CAnimationScreen>(){

        public S2CAnimationScreen decode(RegistryFriendlyByteBuf buf) {
            return new S2CAnimationScreen((InteractionHand)buf.readEnum(InteractionHand.class), buf.readInt());
        }

        public void encode(RegistryFriendlyByteBuf buf, S2CAnimationScreen pkt) {
            buf.writeEnum((Enum)pkt.hand);
            buf.writeInt(pkt.entity);
        }
    };
    private final InteractionHand hand;
    private final int entity;

    public S2CAnimationScreen(InteractionHand hand, LivingEntity entity) {
        this.hand = hand;
        this.entity = entity.getId();
    }

    private S2CAnimationScreen(InteractionHand hand, int entity) {
        this.hand = hand;
        this.entity = entity;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(S2CAnimationScreen pkt, Player player) {
        Entity entity = player.level().getEntity(pkt.entity);
        if (!(entity instanceof LivingEntity) || !(entity instanceof AnimatedEntity)) {
            return;
        }
        ClientHandlers.openAnimationGui((LivingEntity)((AnimatedEntity)entity), pkt.hand);
    }
}

