/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.neoforge.events;

import io.github.flemmli97.tenshilib.common.effect.ExtendedMobEffect;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedMobDataHandler;
import io.github.flemmli97.tenshilib.common.item.DualWeapon;
import io.github.flemmli97.tenshilib.common.network.S2CEntityAnimation;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class CommonEvents {
    public static void disableOffhand(PlayerInteractEvent.RightClickItem event) {
        DualWeapon weapon;
        Item item;
        if (event.getHand() == InteractionHand.OFF_HAND && (item = event.getEntity().getMainHandItem().getItem()) instanceof DualWeapon && (weapon = (DualWeapon)item).disableOffhand()) {
            event.setCanceled(true);
        }
    }

    public static void disableOffhandBlock(PlayerInteractEvent.RightClickBlock event) {
        DualWeapon weapon;
        Item item;
        if (event.getHand() == InteractionHand.OFF_HAND && (item = event.getEntity().getMainHandItem().getItem()) instanceof DualWeapon && (weapon = (DualWeapon)item).disableOffhand()) {
            event.setUseItem(TriState.FALSE);
        }
    }

    public static void onTracking(PlayerEvent.StartTracking event) {
        Object object;
        AnimatedEntity animated;
        AnimationState anim;
        Entity entity = event.getTarget();
        if (entity instanceof AnimatedEntity && (anim = (animated = (AnimatedEntity)entity).getAnimationHandler().getAnimation()) != null) {
            LoaderNetwork.INSTANCE.sendToPlayer(S2CEntityAnimation.create((Entity)((AnimatedEntity)event.getTarget()), anim.getStartTransition(), anim.getEndTransitionTime(), anim.getTick(1.0f)), (ServerPlayer)event.getEntity());
        }
        if ((entity = event.getTarget()) instanceof SyncedMobDataHandler) {
            SyncedMobDataHandler handler = (SyncedMobDataHandler)entity;
            handler.getDataContainer().sendEntriesTo((ServerPlayer)event.getEntity());
        }
        if (!(event.getTarget() instanceof Player) && (object = event.getTarget()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)object;
            object = event.getEntity();
            if (object instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)object;
                for (MobEffectInstance instance : living.getActiveEffects()) {
                    ExtendedMobEffect ext;
                    Object object2 = instance.getEffect().value();
                    if (!(object2 instanceof ExtendedMobEffect) || !(ext = (ExtendedMobEffect)object2).shouldSync()) continue;
                    player.connection.send((Packet)new ClientboundUpdateMobEffectPacket(living.getId(), instance, false));
                }
            }
        }
    }
}

