/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.patreon.effects;

import io.github.flemmli97.tenshilib.patreon.RenderLocation;
import io.github.flemmli97.tenshilib.patreon.effects.GuiElement;
import io.github.flemmli97.tenshilib.patreon.effects.PatreonEffectConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class ParticleEffect
extends PatreonEffectConfig {
    private static final Set<GuiElement> NONE = Set.of();
    private static final Vector3f YP = new Vector3f(0.0f, 1.0f, 0.0f);
    private final Particle[] particles;

    public ParticleEffect(String id, int tier, Particle ... particles) {
        super(id, tier);
        this.particles = particles;
    }

    @Override
    public void tick(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        for (int i = 0; i < this.particles.length; ++i) {
            Particle particle = this.particles[i];
            if (particle.chance < 1.0f && player.getRandom().nextFloat() < particle.chance) continue;
            Vector3d off = new Vector3d(particle.position.x(), particle.position.y(), particle.position.z()).rotateY((double)(-player.getYHeadRot() * ((float)Math.PI / 180)));
            Vec3 pos = player.position().add(off.x(), off.y(), off.z());
            if (particle.container.positionMod.isPresent()) {
                pos = pos.add(particle.container.positionMod.get().apply(player, i));
            }
            Vec3 delta = Vec3.ZERO;
            if (particle.container.delta.isPresent()) {
                delta = particle.container.delta.get().apply(player, i);
            }
            serverPlayer.serverLevel().sendParticles(particle.container.particle, pos.x(), pos.y(), pos.z(), 0, delta.x, delta.y, delta.z, 1.0);
        }
    }

    @Override
    public boolean locationAllowed(RenderLocation loc) {
        return false;
    }

    @Override
    public RenderLocation defaultLoc() {
        return RenderLocation.HAT;
    }

    @Override
    public Set<GuiElement> guiElements() {
        return NONE;
    }

    public record Particle(Vec3 position, float chance, ParticleContainer container) {
    }

    private record ParticleContainer(ParticleOptions particle, Optional<ParticleVector> positionMod, Optional<ParticleVector> delta) {
    }

    public static interface ParticleVector {
        public Vec3 apply(Player var1, int var2);
    }

    public static class Pattern {
        private final Direction.Axis axis;
        private final Vec3 initialOffset;
        private double spacing = 0.5;
        private final Map<Character, ParticleContainer> particles = new HashMap<Character, ParticleContainer>();
        private final List<String> patterns = new ArrayList<String>();

        public static Function<Player, Vec3> randomAll(double scale) {
            return player -> new Vec3(player.getRandom().nextGaussian() * scale, player.getRandom().nextGaussian() * scale, player.getRandom().nextGaussian() * scale);
        }

        public Pattern(Direction.Axis axis, Vec3 initialOffset) {
            this.axis = axis;
            this.initialOffset = initialOffset;
        }

        public Pattern setSpacing(double spacing) {
            this.spacing = spacing;
            return this;
        }

        public Pattern addParticle(char key, ParticleOptions particle) {
            return this.addParticle(key, particle, null, null);
        }

        public Pattern addParticleDelta(char key, ParticleOptions particle, ParticleVector delta) {
            return this.addParticle(key, particle, null, delta);
        }

        public Pattern addParticlePos(char key, ParticleOptions particle, ParticleVector position) {
            return this.addParticle(key, particle, position, null);
        }

        public Pattern addParticle(char key, ParticleOptions particle, ParticleVector position, ParticleVector delta) {
            this.particles.put(Character.valueOf(key), new ParticleContainer(particle, Optional.ofNullable(position), Optional.ofNullable(delta)));
            return this;
        }

        public Pattern addPattern(String ... pattern) {
            this.patterns.addAll(List.of(pattern));
            return this;
        }

        public List<Particle> compile() {
            ArrayList<Particle> result = new ArrayList<Particle>();
            double planeX = 0.0;
            double planeY = 0.0;
            for (String pattern : this.patterns) {
                for (char c : pattern.toCharArray()) {
                    ParticleContainer particle = this.particles.get(Character.valueOf(c));
                    if (particle != null) {
                        Vec3 pos = switch (this.axis) {
                            default -> throw new MatchException(null, null);
                            case Direction.Axis.X -> this.initialOffset.add(planeX, planeY, 0.0);
                            case Direction.Axis.Y -> this.initialOffset.add(planeX, 0.0, planeY);
                            case Direction.Axis.Z -> this.initialOffset.add(0.0, planeY, planeX);
                        };
                        result.add(new Particle(pos, 1.0f, particle));
                    }
                    planeX += this.spacing;
                }
                planeY += this.spacing;
                planeX = 0.0;
            }
            return result;
        }
    }

    public static class Builder {
        private final List<Particle> particles = new ArrayList<Particle>();

        public static Builder of() {
            return new Builder();
        }

        public Builder add(Pattern pattern) {
            this.particles.addAll(pattern.compile());
            return this;
        }

        public ParticleEffect build(String id, int tier) {
            return new ParticleEffect(id, tier, this.particles.toArray(new Particle[0]));
        }
    }
}

