/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.parental;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import lol.sylvie.parental.command.ParentalControlsCommand;
import lol.sylvie.parental.config.Configuration;
import lol.sylvie.parental.util.Formatting;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentalControls
implements ModInitializer {
    public static final String MOD_ID = "parentalcontrols";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"parentalcontrols");
    private static int dailyMinutesAllowedInTicks;
    private static int maxAccumulableHoursInTicks;
    private static int warningThresholdInTicks;
    private static int ticksPerCheck;
    public static final HashMap<UUID, Integer> ticksUsedToday;
    public static final HashMap<UUID, Integer> accumulatedTicks;
    private static final HashSet<UUID> playersWarned;
    private LocalDateTime lastTickTime = LocalDateTime.now();
    private int tickCounter = 0;

    public static void updateTimeConstants() {
        ticksPerCheck = Configuration.INSTANCE.checkIntervalTicks;
        warningThresholdInTicks = Configuration.INSTANCE.warningThresholdSeconds * 20;
        dailyMinutesAllowedInTicks = (int)(Configuration.INSTANCE.minutesAllowed * 60.0f * 20.0f);
        maxAccumulableHoursInTicks = (int)(Configuration.INSTANCE.maxStackedHours * 60.0f * 60.0f * 20.0f);
    }

    public static void loadAccumulatedTicksFromConfig() {
        accumulatedTicks.putAll(Configuration.INSTANCE.playerAccumulatedTicks);
    }

    public static int ticksRemaining(UUID player) {
        int usedToday = ticksUsedToday.getOrDefault(player, 0);
        int accumulated = Configuration.INSTANCE.allowTimeStacking ? accumulatedTicks.getOrDefault(player, 0) : 0;
        int remainingDaily = Math.max(0, dailyMinutesAllowedInTicks - usedToday);
        return remainingDaily + accumulated;
    }

    private static void consumeTime(UUID playerId, int ticksToConsume) {
        int usedToday = ticksUsedToday.getOrDefault(playerId, 0);
        int accumulated = accumulatedTicks.getOrDefault(playerId, 0);
        int remainingDaily = Math.max(0, dailyMinutesAllowedInTicks - usedToday);
        if (remainingDaily >= ticksToConsume) {
            ticksUsedToday.put(playerId, usedToday + ticksToConsume);
        } else {
            if (remainingDaily > 0) {
                ticksUsedToday.put(playerId, usedToday + remainingDaily);
                ticksToConsume -= remainingDaily;
            }
            if (accumulated > 0) {
                int stackedToConsume = Math.min(ticksToConsume, accumulated);
                accumulatedTicks.put(playerId, accumulated - stackedToConsume);
            }
        }
    }

    private static void checkAndWarnPlayer(class_3222 player) {
        UUID playerId = player.method_5667();
        if (playersWarned.contains(playerId)) {
            return;
        }
        if (player.method_64475(4) && Configuration.INSTANCE.excludeOperators) {
            return;
        }
        int remaining = ParentalControls.ticksRemaining(playerId);
        if (remaining <= warningThresholdInTicks && remaining > 0) {
            String timeMessage = Formatting.ticksAsWords(remaining);
            String warningMessage = Configuration.INSTANCE.warningMessage.replace("%time%", timeMessage);
            player.method_7353((class_2561)class_2561.method_43470((String)warningMessage), false);
            playersWarned.add(playerId);
        }
    }

    public static boolean canPlayerJoin(class_3222 player) {
        return ParentalControls.ticksRemaining(player.method_5667()) > 0 || player.method_64475(4) && Configuration.INSTANCE.excludeOperators;
    }

    private static void disconnect(class_3244 handler) {
        handler.method_52396((class_2561)class_2561.method_43470((String)Configuration.INSTANCE.disconnectMessage));
    }

    public void onInitialize() {
        Configuration.load();
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            ++this.tickCounter;
            if (this.tickCounter >= ticksPerCheck) {
                this.tickCounter = 0;
                LocalDateTime currentTime = LocalDateTime.now();
                boolean midnightPassed = this.lastTickTime.toLocalDate().isBefore(currentTime.toLocalDate());
                if (midnightPassed) {
                    this.handleDayTransition();
                }
                ArrayList<class_3244> choppingBlock = new ArrayList<class_3244>();
                for (class_3222 player : server.method_3760().method_14571()) {
                    UUID uuid = player.method_5667();
                    if (!ParentalControls.canPlayerJoin(player)) {
                        choppingBlock.add(player.field_13987);
                        continue;
                    }
                    ParentalControls.consumeTime(uuid, ticksPerCheck);
                    ParentalControls.checkAndWarnPlayer(player);
                }
                choppingBlock.forEach(ParentalControls::disconnect);
                this.lastTickTime = currentTime;
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (ParentalControls.canPlayerJoin(handler.method_32311())) {
                return;
            }
            ParentalControls.disconnect(handler);
        });
        CommandRegistrationCallback.EVENT.register(ParentalControlsCommand::register);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Configuration.INSTANCE.playerAccumulatedTicks.clear();
            Configuration.INSTANCE.playerAccumulatedTicks.putAll(accumulatedTicks);
            Configuration.save();
        }));
    }

    private void handleDayTransition() {
        if (Configuration.INSTANCE.allowTimeStacking) {
            for (UUID playerId : ticksUsedToday.keySet()) {
                int usedToday = ticksUsedToday.get(playerId);
                int leftover = Math.max(0, dailyMinutesAllowedInTicks - usedToday);
                if (leftover <= 0) continue;
                int currentAccumulated = accumulatedTicks.getOrDefault(playerId, 0);
                int newAccumulated = Math.min(maxAccumulableHoursInTicks, currentAccumulated + leftover);
                accumulatedTicks.put(playerId, newAccumulated);
            }
            for (UUID playerId : new HashSet<UUID>(accumulatedTicks.keySet())) {
                if (ticksUsedToday.containsKey(playerId)) continue;
                int leftover = dailyMinutesAllowedInTicks;
                int currentAccumulated = accumulatedTicks.get(playerId);
                int newAccumulated = Math.min(maxAccumulableHoursInTicks, currentAccumulated + leftover);
                accumulatedTicks.put(playerId, newAccumulated);
            }
            Configuration.INSTANCE.playerAccumulatedTicks.clear();
            Configuration.INSTANCE.playerAccumulatedTicks.putAll(accumulatedTicks);
            Configuration.save();
        }
        ticksUsedToday.clear();
        playersWarned.clear();
        LOGGER.info("New day started - daily usage reset");
    }

    static {
        ticksUsedToday = new HashMap();
        accumulatedTicks = new HashMap();
        playersWarned = new HashSet();
    }
}

