/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.parental.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.UUID;
import lol.sylvie.parental.ParentalControls;
import lol.sylvie.parental.config.Configuration;
import lol.sylvie.parental.util.Formatting;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class ParentalControlsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder root = class_2170.method_9247((String)"parental");
        root.then(class_2170.method_9247((String)"remaining").executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_3222 player = source.method_9207();
            if (player.method_64475(4) && Configuration.INSTANCE.excludeOperators) {
                source.method_9213((class_2561)class_2561.method_43470((String)"You are immune to the time limit."));
                return 0;
            }
            UUID playerId = player.method_5667();
            int ticksRemaining = ParentalControls.ticksRemaining(playerId);
            String formatted = Formatting.ticksAsHours(ticksRemaining);
            StringBuilder message = new StringBuilder("You have \u00a7l" + formatted + "\u00a7r remaining.");
            if (Configuration.INSTANCE.allowTimeStacking) {
                int accumulated = ParentalControls.accumulatedTicks.getOrDefault(playerId, 0);
                String accumulatedFormatted = Formatting.ticksAsHours(accumulated);
                message.append("\n\u00a77Stacked: \u00a7f").append(accumulatedFormatted);
            }
            source.method_45068((class_2561)class_2561.method_43470((String)message.toString()));
            return 1;
        }));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(s -> s.method_9259(4))).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            if (Configuration.load()) {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7aSuccessfully reloaded!"), true);
            } else {
                source.method_9213((class_2561)class_2561.method_43470((String)"There was an error while trying to load the configuration! Check console for details."));
            }
            return 1;
        }));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stacking").requires(s -> s.method_9259(4))).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            if (!Configuration.INSTANCE.allowTimeStacking) {
                source.method_45068((class_2561)class_2561.method_43470((String)"\u00a7eTime stacking is disabled."));
                return 1;
            }
            source.method_45068((class_2561)class_2561.method_43470((String)"\u00a76=== Time Stacking ==="));
            source.method_45068((class_2561)class_2561.method_43470((String)"\u00a77Time stacking: \u00a7aEnabled"));
            source.method_45068((class_2561)class_2561.method_43470((String)("\u00a77Max stacked: \u00a7f" + Configuration.INSTANCE.maxStackedHours + " hours")));
            if (ParentalControls.accumulatedTicks.isEmpty()) {
                source.method_45068((class_2561)class_2561.method_43470((String)"\u00a77No players have accumulated time."));
            } else {
                source.method_45068((class_2561)class_2561.method_43470((String)"\u00a77Players with stacked time:"));
                ParentalControls.accumulatedTicks.forEach((playerId, ticks) -> {
                    String formatted = Formatting.ticksAsHours(ticks);
                    source.method_45068((class_2561)class_2561.method_43470((String)("\u00a7f" + String.valueOf(playerId) + "\u00a77: \u00a7a" + formatted)));
                });
            }
            return 1;
        }));
        dispatcher.register(root);
    }
}

