/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.parental.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lol.sylvie.parental.ParentalControls;
import net.fabricmc.loader.api.FabricLoader;

public class Configuration {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final File FILE = FabricLoader.getInstance().getConfigDir().resolve("parentalcontrols.json").toFile();
    public static Configuration INSTANCE = new Configuration();
    @SerializedName(value="minutes_allowed")
    public float minutesAllowed = 480.0f;
    @SerializedName(value="disconnect_message")
    public String disconnectMessage = "\u00a7cYou have reached your time limit for today.";
    @SerializedName(value="warning_message")
    public String warningMessage = "\u00a76\u26a0 Warning: You have %time% remaining before you're disconnected!";
    @SerializedName(value="exclude_operators")
    public boolean excludeOperators = false;
    @SerializedName(value="allow_time_stacking")
    public boolean allowTimeStacking = false;
    @SerializedName(value="max_stacked_hours")
    public float maxStackedHours = 24.0f;
    @SerializedName(value="warning_threshold_seconds")
    public int warningThresholdSeconds = 300;
    @SerializedName(value="check_interval_ticks")
    public int checkIntervalTicks = 20;
    @SerializedName(value="player_accumulated_ticks")
    public Map<UUID, Integer> playerAccumulatedTicks = new HashMap<UUID, Integer>();

    public static void save() {
        try (FileWriter writer = new FileWriter(FILE);){
            GSON.toJson((Object)INSTANCE, Configuration.class, (Appendable)writer);
        }
        catch (JsonSyntaxException | IOException exception) {
            ParentalControls.LOGGER.error("Couldn't create JSON configuration", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean load() {
        try (FileReader reader = new FileReader(FILE);){
            Configuration parsed = (Configuration)GSON.fromJson((Reader)reader, Configuration.class);
            if (parsed == null) {
                boolean bl = false;
                return bl;
            }
            INSTANCE = parsed;
            if (Configuration.INSTANCE.playerAccumulatedTicks == null) {
                Configuration.INSTANCE.playerAccumulatedTicks = new HashMap<UUID, Integer>();
            }
            ParentalControls.updateTimeConstants();
            ParentalControls.loadAccumulatedTicksFromConfig();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException exception) {
            ParentalControls.LOGGER.warn("Configuration file not found.");
            Configuration.save();
            ParentalControls.updateTimeConstants();
            return false;
        }
        catch (JsonSyntaxException | IOException exception) {
            ParentalControls.LOGGER.error("Couldn't load JSON configuration", exception);
        }
        return false;
    }
}

