/*
 * Decompiled with CFR 0.152.
 */
package com.lukeonuke.event;

import com.lukeonuke.model.MessageModel;
import com.lukeonuke.model.ShopModel;
import com.lukeonuke.service.DatabaseService;
import com.lukeonuke.service.InventoryUtil;
import com.lukeonuke.service.ShopCreationService;
import com.lukeonuke.service.ShopPosition;
import com.lukeonuke.service.ShopUtil;
import com.lukeonuke.service.TextService;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class SignEventListener
implements AttackBlockCallback,
UseBlockCallback,
PlayerBlockBreakEvents.Before {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public class_1269 interact(class_1657 playerEntity, class_1937 world, class_1268 hand, class_2338 blockPos, class_2350 direction) {
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        MinecraftServer server = playerEntity.method_5682();
        if (server == null) {
            return class_1269.field_5811;
        }
        if (InventoryUtil.isHoldingRedstone(playerEntity)) {
            ShopCreationService scs = ShopCreationService.getInstance();
            class_2586 block = world.method_8321(blockPos);
            if (block instanceof class_2595) {
                scs.setStorage(playerEntity, new ShopPosition(world, blockPos));
                return class_1269.field_5814;
            }
            if (block instanceof class_2625) {
                class_2625 sign = ShopUtil.getSignIfQualifiesAsShop(world, blockPos);
                if (sign == null) {
                    return class_1269.field_5811;
                }
                scs.setSignPos(playerEntity, new ShopPosition(world, blockPos));
                if (!scs.getShopCreationModel(playerEntity).isValid()) return class_1269.field_5814;
                new Thread(() -> {
                    DatabaseService ds = DatabaseService.getInstance();
                    ShopModel shop = ds.getShopByPosition(new ShopPosition(world, blockPos));
                    server.method_40000(() -> {
                        if (shop != null) {
                            return;
                        }
                        MessageModel message = scs.createShop(playerEntity);
                        playerEntity.method_7353(message.getAsTextMessage(), false);
                        scs.reset(playerEntity);
                        if (message.isSuccess()) {
                            ShopUtil.formatShop(sign, true);
                        }
                    });
                }).start();
                return class_1269.field_5814;
            }
            scs.reset(playerEntity);
            playerEntity.method_7353((class_2561)TextService.addPrefix("Reset creation storage."), false);
            return class_1269.field_5814;
        }
        class_2625 sign = ShopUtil.getSignIfQualifiesAsShop(world, blockPos);
        if (sign == null) {
            return class_1269.field_5811;
        }
        DatabaseService ds = DatabaseService.getInstance();
        ShopModel shop = ds.getShopByPosition(new ShopPosition(world, blockPos));
        if (shop == null) {
            return class_1269.field_5811;
        }
        playerEntity.method_7353((class_2561)TextService.addPrefix((class_2561)class_2561.method_43470((String)"Sells ").method_10852((class_2561)TextService.formatShopOffer(shop, world))), false);
        if (!shop.getOwner().equals(playerEntity.method_5667())) return class_1269.field_5814;
        return class_1269.field_5811;
    }

    public class_1269 interact(class_1657 playerEntity, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        class_2338 blockPos = blockHitResult.method_17777();
        class_2625 sign = ShopUtil.getSignIfQualifiesAsShop(world, blockPos);
        if (sign == null) {
            return class_1269.field_5811;
        }
        DatabaseService ds = DatabaseService.getInstance();
        ShopModel model = ds.getShopByPosition(new ShopPosition(world, blockPos));
        if (model != null) {
            MessageModel message = ShopUtil.beginTransaction(model, playerEntity, sign);
            if (message.isSuccess()) {
                playerEntity.method_7353((class_2561)class_2561.method_43470((String)"Bought ").method_10852((class_2561)TextService.formatShopOffer(model, world)), true);
            } else {
                playerEntity.method_7353(message.getAsTextMessage(), false);
                ShopUtil.formatShop(sign, false);
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public boolean beforeBlockBreak(class_1937 world, class_1657 playerEntity, class_2338 blockPos, class_2680 blockState, @Nullable class_2586 blockEntity) {
        if (blockEntity == null) {
            return true;
        }
        class_2625 signBlock = ShopUtil.getSignIfQualifiesAsShop(blockEntity);
        if (signBlock == null) {
            return true;
        }
        DatabaseService ds = DatabaseService.getInstance();
        ShopModel shop = ds.getShopByPosition(new ShopPosition(world, blockPos));
        if (shop == null) {
            return true;
        }
        if (shop.getOwner().equals(playerEntity.method_5667())) {
            ds.softDeleteShopById(shop.getId());
            playerEntity.method_7353((class_2561)TextService.addPrefix((class_2561)TextService.successFormat("Shop has been removed!")), true);
            return true;
        }
        return false;
    }
}

