/*
 * Decompiled with CFR 0.152.
 */
package com.lukeonuke.service;

import com.lukeonuke.SignShop;
import com.lukeonuke.model.MessageModel;
import com.lukeonuke.model.ShopCreationModel;
import com.lukeonuke.model.ShopModel;
import com.lukeonuke.service.DatabaseService;
import com.lukeonuke.service.InventoryUtil;
import com.lukeonuke.service.ShopPosition;
import com.lukeonuke.service.TextService;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ShopCreationService {
    private final HashMap<class_1657, ShopCreationModel> storage = new HashMap();
    private static ShopCreationService instance = null;

    private ShopCreationService() {
    }

    public static ShopCreationService getInstance() {
        if (instance == null) {
            instance = new ShopCreationService();
        }
        return instance;
    }

    private void insureEntryExists(class_1657 pe) {
        this.storage.computeIfAbsent(pe, playerEntity -> new ShopCreationModel());
    }

    public void setShopCreationModel(class_1657 pe, @Nullable ShopPosition itemPos, @Nullable ShopPosition pricePos, @Nullable ShopPosition signPos) {
        this.insureEntryExists(pe);
        ShopCreationModel model = this.storage.get(pe);
        if (itemPos != null) {
            model.setItemPos(itemPos);
        }
        if (pricePos != null) {
            model.setPricePos(pricePos);
        }
        if (signPos != null) {
            model.setSignPos(signPos);
        }
        this.storage.put(pe, model);
    }

    public void setItemPos(class_1657 pe, ShopPosition itemPos) {
        this.setShopCreationModel(pe, itemPos, null, null);
    }

    public void setPricePos(class_1657 pe, ShopPosition pricePos) {
        this.setShopCreationModel(pe, null, pricePos, null);
    }

    public void setSignPos(class_1657 pe, ShopPosition signPos) {
        this.setShopCreationModel(pe, null, null, signPos);
        pe.method_7353(class_2561.method_30163((String)"Set sign pos"), true);
    }

    public ShopCreationModel getShopCreationModel(class_1657 pe) {
        this.insureEntryExists(pe);
        return this.storage.get(pe);
    }

    public void setStorage(class_1657 pe, ShopPosition pos) {
        ShopCreationModel model = this.getShopCreationModel(pe);
        if (model.getItemPos() == null) {
            model.setItemPos(pos);
            pe.method_7353((class_2561)TextService.addPrefix("Set item storage position."), true);
        } else if (model.getPricePos() == null) {
            model.setPricePos(pos);
            pe.method_7353((class_2561)TextService.addPrefix("Set price storage position."), true);
        }
    }

    public void reset(class_1657 pe) {
        this.storage.remove(pe);
        this.insureEntryExists(pe);
    }

    public MessageModel createShop(class_1657 pe) {
        ShopCreationModel shopCreation = this.getShopCreationModel(pe);
        if (!shopCreation.isValid()) {
            return new MessageModel("Shop not built!", false);
        }
        ShopModel databaseModel = new ShopModel();
        databaseModel.setStorageItemPos(shopCreation.getItemPos().toString());
        databaseModel.setStoragePricePos(shopCreation.getPricePos().toString());
        databaseModel.setPosition(shopCreation.getSignPos().toString());
        databaseModel.setOwner(pe.method_5667());
        MinecraftServer server = pe.method_5682();
        if (server == null) {
            SignShop.LOGGER.error("Server was null whilst creating shop!");
            return new MessageModel("Internal server error! ShopCreationService#createShop server==null", false);
        }
        ShopPosition itemPos = shopCreation.getItemPos();
        ShopPosition pricePos = shopCreation.getPricePos();
        MessageModel returnedMessage = this.setItemOrPrice(databaseModel, itemPos, server, true);
        if (!returnedMessage.isSuccess()) {
            return returnedMessage;
        }
        returnedMessage = this.setItemOrPrice(databaseModel, pricePos, server, false);
        if (!returnedMessage.isSuccess()) {
            return returnedMessage;
        }
        DatabaseService.getInstance().insertShop(databaseModel);
        return new MessageModel("Shop created!", true);
    }

    private MessageModel setItemOrPrice(ShopModel reference, ShopPosition itemPos, MinecraftServer server, boolean isItem) {
        String loggingPrefix = "Price";
        if (isItem) {
            loggingPrefix = "Item";
        }
        if (itemPos == null) {
            SignShop.LOGGER.error("{} pos was null whilst creating shop!", (Object)loggingPrefix);
            return new MessageModel("Internal server error! item/pricePos==null", false);
        }
        class_3218 itemWorld = server.method_3847(itemPos.getWorldAsRegistryKey());
        if (itemWorld == null) {
            SignShop.LOGGER.error("World was null whilst creating shop!");
            return new MessageModel("Internal server error! itemWorld==null", false);
        }
        Optional chestOptional = itemWorld.method_35230(itemPos.getBlockPos(), class_2591.field_11914);
        if (chestOptional.isEmpty()) {
            return new MessageModel("Chest doesn't exist!", false);
        }
        class_2595 chest = (class_2595)chestOptional.get();
        class_1799 item = InventoryUtil.getFirstItem((class_1263)chest);
        if (item == null) {
            return new MessageModel(loggingPrefix + " storage is empty! Can't read what the item is if it doesnt exist.", false);
        }
        int itemAmount = InventoryUtil.countItems((class_1263)chest, item);
        if (itemAmount <= 0) {
            return new MessageModel(loggingPrefix + " cant be 0 or negative!", false);
        }
        String itemNBT = InventoryUtil.itemToNbt(item, (class_1937)itemWorld);
        if (itemNBT == null) {
            return new MessageModel("Internal server error! ItemNBT cant be null!", false);
        }
        if (itemNBT.length() > 1024) {
            return new MessageModel("Item contains too much data!", false);
        }
        if (isItem) {
            reference.setItem(itemNBT);
            reference.setItemAmount(itemAmount);
        } else {
            reference.setPrice(itemNBT);
            reference.setPriceAmount(itemAmount);
        }
        return new MessageModel("Set values!", true);
    }
}

