/*
 * Decompiled with CFR 0.152.
 */
package com.lukeonuke.service;

import com.lukeonuke.model.MessageModel;
import com.lukeonuke.model.ShopModel;
import com.lukeonuke.model.TransactionModel;
import com.lukeonuke.service.DatabaseService;
import com.lukeonuke.service.InventoryUtil;
import com.lukeonuke.service.ShopPosition;
import com.lukeonuke.service.TextService;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2625;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8242;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ShopUtil {
    public static boolean qualifiesAsPossibleShop(class_2586 block) {
        return ShopUtil.getSignIfQualifiesAsShop(block) != null;
    }

    @Nullable
    public static class_2625 getSignIfQualifiesAsShop(class_2586 block) {
        if (!(block instanceof class_2625)) {
            return null;
        }
        class_2625 sign = (class_2625)block;
        class_8242 signText = sign.method_49843(true);
        if (signText.method_49859(0, true).getString().equals("[trade]")) {
            return sign;
        }
        return null;
    }

    @Nullable
    public static class_2625 getSignIfQualifiesAsShop(class_1937 world, class_2338 blockPos) {
        class_2586 block = world.method_8321(blockPos);
        return ShopUtil.getSignIfQualifiesAsShop(block);
    }

    public static MessageModel beginTransaction(ShopModel shop, class_1657 player, class_2625 sign) {
        class_1661 playerInventory = player.method_31548();
        class_1937 world = player.method_37908();
        class_1799 item = shop.getItemAsItemStack(world);
        class_1799 price = shop.getPriceAsItemStack(world);
        int availablePrice = InventoryUtil.countItems((class_1263)playerInventory, price);
        if (availablePrice < shop.getPriceAmount()) {
            return new MessageModel("You cant afford this!", false);
        }
        if (!InventoryUtil.canStore((class_1263)playerInventory, item.method_7909(), shop.getItemAmount())) {
            return new MessageModel("Not enough inventory space to buy!", false);
        }
        ShopPosition storagePricePos = ShopPosition.fromString(shop.getStoragePricePos());
        ShopPosition storageItemPos = ShopPosition.fromString(shop.getStorageItemPos());
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return new MessageModel("Internal server error! server==null", false);
        }
        if (storagePricePos == null || storageItemPos == null) {
            return new MessageModel("Internal server error! Shop is corrupted! Cant read storage pos.", false);
        }
        class_2595 storagePrice = ShopUtil.getChest(storagePricePos, server);
        if (storagePrice == null) {
            return new MessageModel("Price chest is missing!", false);
        }
        class_2595 storageItem = ShopUtil.getChest(storageItemPos, server);
        if (storageItem == null) {
            return new MessageModel("Item chest is missing!", false);
        }
        if (!InventoryUtil.canStore((class_1263)storagePrice, price.method_7909(), shop.getPriceAmount())) {
            return new MessageModel("Shops currency storage is full!", false);
        }
        if (InventoryUtil.countItems((class_1263)storageItem, item) < shop.getItemAmount()) {
            return new MessageModel("Shop doesn't have the stock!", false);
        }
        InventoryUtil.removeItems((class_1263)playerInventory, price, shop.getPriceAmount());
        InventoryUtil.removeItems((class_1263)storageItem, item, shop.getItemAmount());
        InventoryUtil.addItems((class_1263)storagePrice, price, shop.getPriceAmount());
        InventoryUtil.addItems((class_1263)playerInventory, item, shop.getItemAmount());
        TransactionModel transactionModel = new TransactionModel();
        transactionModel.setBuyer(player.method_5667());
        transactionModel.setShop(shop);
        new Thread(() -> DatabaseService.getInstance().insertTransaction(transactionModel)).start();
        ShopUtil.sendTransactionNotification(shop, server, player);
        ShopUtil.formatShop(sign, ShopUtil.shopHasStock(shop, storageItem, storagePrice, item, price));
        return new MessageModel("Bought " + shop.getItemAmount() + "x " + item.method_7964().getString() + " for " + shop.getPriceAmount() + "x " + price.method_7964().getString(), true);
    }

    private static class_2595 getChest(ShopPosition pos, MinecraftServer server) {
        class_3218 world = server.method_3847(pos.getWorldAsRegistryKey());
        if (world == null) {
            return null;
        }
        return world.method_35230(pos.getBlockPos(), class_2591.field_11914).orElse(null);
    }

    public static void formatShop(class_2625 sign, boolean isValid) {
        class_8242 old = sign.method_49853();
        class_2561[] texts = sign.method_49853().method_49877(true);
        class_124 formatting = class_124.field_1061;
        if (isValid) {
            formatting = class_124.field_1060;
        }
        texts[0] = class_2561.method_43470((String)texts[0].getString()).method_27695(new class_124[]{formatting, class_124.field_1067});
        sign.method_49840(new class_8242(texts, old.method_49877(true), old.method_49872(), old.method_49856()), true);
        sign.method_5431();
    }

    public static void sendTransactionNotification(ShopModel shop, MinecraftServer server, class_1657 purchaser) {
        UUID ownerUUID = shop.getOwner();
        class_3222 player = server.method_3760().method_14602(ownerUUID);
        if (player == null) {
            return;
        }
        player.method_64398((class_2561)TextService.addPrefix((class_2561)class_2561.method_43473().method_10852(purchaser.method_5476()).method_27693(" bought ").method_10852((class_2561)TextService.formatShopOffer(shop, (class_1937)server.method_30002()))));
    }

    public static boolean shopHasStock(ShopModel shop, class_2595 storageItem, class_2595 storagePrice, class_1799 item, class_1799 price) {
        if (!InventoryUtil.canStore((class_1263)storagePrice, price.method_7909(), shop.getPriceAmount())) {
            return false;
        }
        return InventoryUtil.countItems((class_1263)storageItem, item) >= shop.getItemAmount();
    }
}

