/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.Timeout;
import org.hibernate.Incubating;

@Incubating
public interface Timeouts {
    public static final Timeout ONE_SECOND;
    public static final int NO_WAIT_MILLI = 0;
    public static final int WAIT_FOREVER_MILLI = -1;
    public static final int SKIP_LOCKED_MILLI = -2;
    public static final Timeout NO_WAIT;
    public static final Timeout WAIT_FOREVER;
    public static final Timeout SKIP_LOCKED;

    public static Timeout interpretMilliSeconds(int timeoutInMilliseconds) {
        return switch (timeoutInMilliseconds) {
            case 0 -> NO_WAIT;
            case -1 -> WAIT_FOREVER;
            case -2 -> SKIP_LOCKED;
            default -> Timeout.milliseconds(timeoutInMilliseconds);
        };
    }

    public static boolean isMagicValue(Timeout timeout) {
        return !Timeouts.isRealTimeout(timeout);
    }

    public static boolean isMagicValue(int millis) {
        return !Timeouts.isRealTimeout(millis);
    }

    public static boolean isRealTimeout(Timeout timeout) {
        return Timeouts.isRealTimeout(timeout.milliseconds());
    }

    public static boolean isRealTimeout(int timeoutInMilliseconds) {
        return timeoutInMilliseconds > 0;
    }

    public static int getTimeoutInSeconds(Timeout timeout) {
        return Timeouts.getTimeoutInSeconds(timeout.milliseconds());
    }

    public static int getTimeoutInSeconds(int timeoutInMilliseconds) {
        if (!1.$assertionsDisabled && timeoutInMilliseconds < 0) {
            throw new AssertionError();
        }
        return timeoutInMilliseconds == 0 ? 0 : Math.max(1, Math.round((float)timeoutInMilliseconds / 1000.0f));
    }

    public static int fromHint(Object factoryHint) {
        if (factoryHint instanceof Timeout) {
            Timeout timeout = (Timeout)factoryHint;
            return timeout.milliseconds();
        }
        if (factoryHint instanceof Integer) {
            Integer number = (Integer)factoryHint;
            return number;
        }
        return Integer.parseInt(factoryHint.toString());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        ONE_SECOND = Timeout.seconds(1);
        NO_WAIT = Timeout.milliseconds(0);
        WAIT_FOREVER = Timeout.milliseconds(-1);
        SKIP_LOCKED = Timeout.milliseconds(-2);
    }
}

