/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.archive.scan.internal;

import java.lang.invoke.MethodHandles;
import java.net.URL;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.boot.scan", description="Logging related to scanning")
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=60000, max=60100)
public interface ScannerLogger
extends BasicLogger {
    public static final String NAME = "org.hibernate.orm.boot.scan";
    public static final ScannerLogger SCANNER_LOGGER = Logger.getMessageLogger(MethodHandles.lookup(), ScannerLogger.class, "org.hibernate.orm.boot.scan");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=60001, value="Multiple ScannerFactory services available; using '%s'")
    public void multipleScannerFactoriesAvailable(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=60002, value="No ScannerFactory available; to enable scanning add 'hibernate-scan-jandex' dependency or supply a custom ScannerFactory")
    public void noScannerFactoryAvailable();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=60003, value="Unable to resolve class [%s] named in persistence unit [%s]")
    public void unableToResolveClass(String var1, URL var2);
}

