/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.function.Function;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.UnknownEntityTypeException;
import org.hibernate.annotations.NamedEntityGraph;
import org.hibernate.boot.model.NamedGraphCreator;
import org.hibernate.grammars.graph.GraphLanguageLexer;
import org.hibernate.grammars.graph.GraphLanguageParser;
import org.hibernate.graph.InvalidGraphException;
import org.hibernate.graph.internal.parse.EntityNameResolver;
import org.hibernate.graph.internal.parse.GraphParsing;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.domain.EntityDomainType;

class NamedGraphCreatorParsed
implements NamedGraphCreator {
    private final @Nullable String name;
    private final @Nullable Class<?> entityType;
    private final NamedEntityGraph annotation;

    NamedGraphCreatorParsed(NamedEntityGraph annotation) {
        this(null, annotation);
    }

    NamedGraphCreatorParsed(@Nullable Class<?> entityType, NamedEntityGraph annotation) {
        this.name = StringHelper.nullIfEmpty(annotation.name());
        this.entityType = entityType;
        this.annotation = annotation;
    }

    @Override
    public <T> RootGraphImplementor<T> createEntityGraph(Function<Class<T>, EntityDomainType<?>> entityDomainClassResolver, final Function<String, EntityDomainType<?>> entityDomainNameResolver) {
        GraphLanguageLexer lexer = new GraphLanguageLexer(CharStreams.fromString(this.annotation.graph()));
        GraphLanguageParser parser = new GraphLanguageParser(new CommonTokenStream(lexer));
        GraphLanguageParser.GraphContext graphContext = parser.graph();
        EntityNameResolver entityNameResolver = new EntityNameResolver(){

            @Override
            public <T> EntityDomainType<T> resolveEntityName(String entityName) {
                EntityDomainType entityDomainType = (EntityDomainType)entityDomainNameResolver.apply(entityName);
                if (entityDomainType != null) {
                    return entityDomainType;
                }
                throw new UnknownEntityTypeException(entityName);
            }
        };
        if (this.entityType == null) {
            if (graphContext.typeIndicator() == null) {
                throw new InvalidGraphException("Expecting graph text to include an entity name : " + this.annotation.graph());
            }
            String jpaEntityName = graphContext.typeIndicator().TYPE_NAME().toString();
            EntityDomainType<?> entityDomainType = entityDomainNameResolver.apply(jpaEntityName);
            String name = this.name == null ? jpaEntityName : this.name;
            return GraphParsing.parse(name, entityDomainType, graphContext.attributeList(), entityNameResolver);
        }
        if (graphContext.typeIndicator() != null) {
            throw new InvalidGraphException("Expecting graph text to not include an entity name : " + this.annotation.graph());
        }
        EntityDomainType<?> entityDomainType = entityDomainClassResolver.apply(this.entityType);
        String name = this.name == null ? entityDomainType.getName() : this.name;
        return GraphParsing.parse(name, entityDomainType, graphContext.attributeList(), entityNameResolver);
    }
}

