/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.XmlAnnotations;
import org.hibernate.boot.models.annotations.internal.TargetXmlAnnotation;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class EmbeddedAttributeProcessing {
    public static MutableMemberDetails processEmbeddedAttribute(JaxbEmbeddedImpl jaxbEmbedded, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbEmbedded.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbEmbedded.getName(), accessType, declarer);
        memberDetails.applyAnnotationUsage(JpaAnnotations.EMBEDDED, xmlDocumentContext.getModelBuildingContext());
        if (StringHelper.isNotEmpty(jaxbEmbedded.getTarget())) {
            TargetXmlAnnotation targetAnn = (TargetXmlAnnotation)memberDetails.applyAnnotationUsage(XmlAnnotations.TARGET, xmlDocumentContext.getModelBuildingContext());
            targetAnn.value(XmlAnnotationHelper.determineTargetName(jaxbEmbedded.getTarget(), xmlDocumentContext));
        }
        CommonAttributeProcessing.applyAccess(accessType, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeAccessor(jaxbEmbedded, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyOptimisticLock(jaxbEmbedded, memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyAttributeOverrides(jaxbEmbedded.getAttributeOverrides(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyAssociationOverrides(jaxbEmbedded.getAssociationOverrides(), memberDetails, xmlDocumentContext);
        return memberDetails;
    }
}

