/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralAnyMappingImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.annotations.internal.ManyToAnyAnnotation;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.AnyMappingAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.CommonPluralAttributeProcessing;
import org.hibernate.boot.models.xml.internal.db.TableProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class PluralAnyMappingAttributeProcessing {
    public static MutableMemberDetails processPluralAnyMappingAttributes(JaxbPluralAnyMappingImpl jaxbHbmManyToAny, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbHbmManyToAny.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbHbmManyToAny.getName(), accessType, declarer);
        ManyToAnyAnnotation manyToAnyAnn = (ManyToAnyAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.MANY_TO_ANY, xmlDocumentContext.getModelBuildingContext());
        CommonAttributeProcessing.applyAccess(accessType, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeAccessor(jaxbHbmManyToAny, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyFetching(jaxbHbmManyToAny, memberDetails, manyToAnyAnn, xmlDocumentContext);
        CommonAttributeProcessing.applyOptimisticLock(jaxbHbmManyToAny, memberDetails, xmlDocumentContext);
        AnyMappingAttributeProcessing.applyDiscriminator(memberDetails, jaxbHbmManyToAny, xmlDocumentContext);
        AnyMappingAttributeProcessing.applyKey(memberDetails, jaxbHbmManyToAny, xmlDocumentContext);
        XmlAnnotationHelper.applyCascading(jaxbHbmManyToAny.getCascade(), memberDetails, xmlDocumentContext);
        CommonPluralAttributeProcessing.applyPluralAttributeStructure(jaxbHbmManyToAny, memberDetails, xmlDocumentContext);
        TableProcessing.transformJoinTable(jaxbHbmManyToAny.getJoinTable(), memberDetails, xmlDocumentContext);
        return memberDetails;
    }
}

