/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.LockOptions;
import org.hibernate.ReplicationMode;
import org.hibernate.TransientPropertyValueException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.DeleteContext;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.MergeContext;
import org.hibernate.event.spi.PersistContext;
import org.hibernate.event.spi.RefreshContext;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class CascadingActions {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(MethodHandles.lookup(), CoreMessageLogger.class, CascadingAction.class.getName());
    public static final CascadingAction<DeleteContext> REMOVE = new BaseCascadingAction<DeleteContext>(){

        @Override
        public void cascade(EventSource session, Object child, String childEntityName, String parentEntityName, String propertyName, List<String> attributePath, DeleteContext context, boolean isCascadeDeleteEnabled) {
            LOG.tracev("Cascading to delete: {0}", (Object)childEntityName);
            session.delete(childEntityName, child, isCascadeDeleteEnabled, context);
        }

        @Override
        public Iterator<?> getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingActions.getAllElementsIterator(collectionType, collection);
        }

        @Override
        public boolean deleteOrphans() {
            return true;
        }

        @Override
        public boolean anythingToCascade(EntityPersister persister) {
            return persister.hasCascadeDelete();
        }

        @Override
        public ForeignKeyDirection directionAffectedByCascadeDelete() {
            return ForeignKeyDirection.FROM_PARENT;
        }

        public String toString() {
            return "ACTION_DELETE";
        }
    };
    @Deprecated(since="6.6", forRemoval=true)
    public static final CascadingAction<DeleteContext> DELETE = REMOVE;
    @Deprecated(since="7", forRemoval=true)
    public static final CascadingAction<LockOptions> LOCK = new BaseCascadingAction<LockOptions>(){

        @Override
        public void cascade(EventSource session, Object child, String childEntityName, String parentEntityName, String propertyName, List<String> attributePath, LockOptions lockOptions, boolean isCascadeDeleteEnabled) {
            LOG.tracev("Cascading to lock: {0}", (Object)childEntityName);
            session.lock(childEntityName, child, lockOptions);
        }

        @Override
        public Iterator<?> getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingActions.getLoadedElementsIterator(collectionType, collection);
        }

        @Override
        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_LOCK";
        }
    };
    public static final CascadingAction<RefreshContext> REFRESH = new BaseCascadingAction<RefreshContext>(){

        @Override
        public void cascade(EventSource session, Object child, String childEntityName, String parentEntityName, String propertyName, List<String> attributePath, RefreshContext context, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to refresh: {0}", (Object)childEntityName);
            session.refresh(childEntityName, child, context);
        }

        @Override
        public Iterator<?> getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingActions.getLoadedElementsIterator(collectionType, collection);
        }

        @Override
        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_REFRESH";
        }
    };
    public static final CascadingAction<Void> EVICT = new BaseCascadingAction<Void>(){

        @Override
        public void cascade(EventSource session, Object child, String childEntityName, String parentEntityName, String propertyName, List<String> attributePath, Void nothing, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to evict: {0}", (Object)childEntityName);
            session.evict(child);
        }

        @Override
        public Iterator<?> getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingActions.getLoadedElementsIterator(collectionType, collection);
        }

        @Override
        public boolean deleteOrphans() {
            return false;
        }

        @Override
        public boolean performOnLazyProperty() {
            return false;
        }

        public String toString() {
            return "ACTION_EVICT";
        }
    };
    public static final CascadingAction<MergeContext> MERGE = new BaseCascadingAction<MergeContext>(){

        @Override
        public void cascade(EventSource session, Object child, String childEntityName, String parentEntityName, String propertyName, List<String> attributePath, MergeContext context, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to merge: {0}", (Object)childEntityName);
            session.merge(childEntityName, child, context);
        }

        @Override
        public Iterator<?> getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingActions.getLoadedElementsIterator(collectionType, collection);
        }

        @Override
        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_MERGE";
        }
    };
    public static final CascadingAction<PersistContext> PERSIST = new BaseCascadingAction<PersistContext>(){

        @Override
        public void cascade(EventSource session, Object child, String childEntityName, String parentEntityName, String propertyName, List<String> attributePath, PersistContext context, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to persist: {0}", (Object)childEntityName);
            session.persist(childEntityName, child, context);
        }

        @Override
        public Iterator<?> getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingActions.getLoadedElementsIterator(collectionType, collection);
        }

        @Override
        public boolean deleteOrphans() {
            return false;
        }

        @Override
        public boolean performOnLazyProperty() {
            return false;
        }

        @Override
        public boolean anythingToCascade(EntityPersister persister) {
            return persister.hasCascadePersist();
        }

        public String toString() {
            return "ACTION_PERSIST";
        }
    };
    public static final CascadingAction<PersistContext> PERSIST_ON_FLUSH = new BaseCascadingAction<PersistContext>(){

        @Override
        public void cascade(EventSource session, Object child, String childEntityName, String parentEntityName, String propertyName, List<String> attributePath, PersistContext context, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to persist on flush: {0}", (Object)childEntityName);
            session.persistOnFlush(childEntityName, child, context);
        }

        @Override
        public Iterator<?> getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingActions.getLoadedElementsIterator(collectionType, collection);
        }

        @Override
        public boolean deleteOrphans() {
            return true;
        }

        @Override
        public boolean performOnLazyProperty() {
            return false;
        }

        @Override
        public boolean anythingToCascade(EntityPersister persister) {
            return persister.hasCascadePersist();
        }

        public String toString() {
            return "ACTION_PERSIST_ON_FLUSH";
        }
    };
    @Internal
    public static final CascadingAction<Void> CHECK_ON_FLUSH = new BaseCascadingAction<Void>(){

        @Override
        public void cascade(EventSource session, Object child, String childEntityName, String parentEntityName, String propertyName, List<String> attributePath, Void nothing, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (child != null && CascadingActions.isChildTransient(session, child, childEntityName, isCascadeDeleteEnabled)) {
                throw new TransientPropertyValueException("Persistent instance of '" + parentEntityName + "' references an unsaved transient instance of '" + childEntityName + "' (persist the transient instance before flushing)", childEntityName, parentEntityName, (String)(attributePath == null ? propertyName : StringHelper.join(".", attributePath) + "." + propertyName));
            }
        }

        @Override
        public Iterator<?> getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            if (collectionType.isInverse(session.getSessionFactory())) {
                return Collections.emptyIterator();
            }
            return CascadingActions.getLoadedElementsIterator(collectionType, collection);
        }

        @Override
        public boolean anythingToCascade(EntityPersister persister) {
            return persister.hasToOnes() || persister.hasOwnedCollections() || persister.hasCollections() && persister.getFactory().getSessionFactoryOptions().isUnownedAssociationTransientCheck();
        }

        @Override
        public boolean appliesTo(Type type, CascadeStyle style) {
            return super.appliesTo(type, style) && (type.isComponentType() || type.isAssociationType());
        }

        @Override
        public boolean cascadeNow(CascadePoint cascadePoint, AssociationType associationType, SessionFactoryImplementor factory) {
            return super.cascadeNow(cascadePoint, associationType, factory) && (factory.getSessionFactoryOptions().isUnownedAssociationTransientCheck() || !8.isUnownedAssociation(associationType, factory));
        }

        private static boolean isUnownedAssociation(AssociationType associationType, SessionFactoryImplementor factory) {
            if (associationType instanceof ManyToOneType) {
                ManyToOneType manyToOne = (ManyToOneType)associationType;
                return manyToOne.isLogicalOneToOne() && manyToOne.getRHSUniqueKeyPropertyName() != null;
            }
            if (associationType instanceof OneToOneType) {
                OneToOneType oneToOne = (OneToOneType)associationType;
                return oneToOne.isNullable() && oneToOne.getRHSUniqueKeyPropertyName() != null;
            }
            if (associationType instanceof CollectionType) {
                CollectionType collectionType = (CollectionType)associationType;
                return collectionType.isInverse(factory);
            }
            return false;
        }

        @Override
        public boolean deleteOrphans() {
            return false;
        }

        @Override
        public boolean performOnLazyProperty() {
            return false;
        }

        @Override
        public ForeignKeyDirection directionAffectedByCascadeDelete() {
            return ForeignKeyDirection.TO_PARENT;
        }

        public String toString() {
            return "ACTION_CHECK_ON_FLUSH";
        }
    };
    public static final CascadingAction<ReplicationMode> REPLICATE = new BaseCascadingAction<ReplicationMode>(){

        @Override
        public void cascade(EventSource session, Object child, String childEntityName, String parentEntityName, String propertyName, List<String> attributePath, ReplicationMode mode, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to replicate: {0}", (Object)childEntityName);
            session.replicate(childEntityName, child, mode);
        }

        @Override
        public Iterator<?> getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingActions.getLoadedElementsIterator(collectionType, collection);
        }

        @Override
        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_REPLICATE";
        }
    };

    private CascadingActions() {
    }

    private static boolean isChildTransient(EventSource session, Object child, String entityName, boolean isCascadeDeleteEnabled) {
        if (ManagedTypeHelper.isHibernateProxy(child)) {
            return false;
        }
        EntityEntry entry = session.getPersistenceContextInternal().getEntry(child);
        if (entry != null) {
            return entry.getStatus().isDeletedOrGone() && !isCascadeDeleteEnabled;
        }
        return ForeignKeys.isTransient(entityName, child, null, session);
    }

    public static Iterator<?> getAllElementsIterator(CollectionType collectionType, Object collection) {
        return collectionType.getElementsIterator(collection);
    }

    public static Iterator<?> getLoadedElementsIterator(CollectionType collectionType, Object collection) {
        PersistentCollection persistentCollection;
        if (collection instanceof PersistentCollection && !(persistentCollection = (PersistentCollection)collection).wasInitialized()) {
            return persistentCollection.queuedAdditionIterator();
        }
        return collectionType.getElementsIterator(collection);
    }

    @Deprecated(forRemoval=true, since="7.0")
    public static Iterator<?> getAllElementsIterator(EventSource session, CollectionType collectionType, Object collection) {
        return CascadingActions.getAllElementsIterator(collectionType, collection);
    }

    @Deprecated(forRemoval=true, since="7.0")
    public static Iterator<?> getLoadedElementsIterator(SharedSessionContractImplementor session, CollectionType collectionType, Object collection) {
        return CascadingActions.getLoadedElementsIterator(collectionType, collection);
    }

    public static abstract class BaseCascadingAction<T>
    implements CascadingAction<T> {
        @Override
        public boolean performOnLazyProperty() {
            return true;
        }

        @Override
        public boolean anythingToCascade(EntityPersister persister) {
            return persister.hasCascades();
        }

        @Override
        public boolean appliesTo(Type type, CascadeStyle style) {
            return style.doCascade(this);
        }

        @Override
        public boolean cascadeNow(CascadePoint cascadePoint, AssociationType associationType, SessionFactoryImplementor factory) {
            return associationType.getForeignKeyDirection().cascadeNow(cascadePoint);
        }

        @Override
        public @Nullable ForeignKeyDirection directionAffectedByCascadeDelete() {
            return null;
        }
    }
}

