/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.graph.internal;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.graph.AttributeNode;
import org.hibernate.graph.CannotBecomeEntityGraphException;
import org.hibernate.graph.SubGraph;
import org.hibernate.graph.internal.AbstractGraphNode;
import org.hibernate.graph.internal.AttributeNodeImpl;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.graph.internal.SubGraphImpl;
import org.hibernate.graph.spi.AttributeNodeImplementor;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.sqm.SqmPathSource;

public abstract class GraphImpl<J>
extends AbstractGraphNode<J>
implements GraphImplementor<J> {
    private final ManagedDomainType<J> managedType;
    private Map<Class<? extends J>, SubGraphImplementor<? extends J>> treatedSubgraphs;
    private Map<PersistentAttribute<? super J, ?>, AttributeNodeImplementor<?, ?, ?>> attributeNodes;

    public GraphImpl(ManagedDomainType<J> managedType, boolean mutable) {
        super(mutable);
        this.managedType = managedType;
    }

    protected GraphImpl(ManagedDomainType<J> managedType, GraphImplementor<J> graph, boolean mutable) {
        super(mutable);
        this.managedType = managedType;
        Map<PersistentAttribute<J, ?>, AttributeNodeImplementor<?, ?, ?>> attributeNodesByAttribute = graph.getNodes();
        Map<Class<J>, SubGraphImplementor<J>> subGraphMap = graph.getTreatedSubgraphs();
        this.attributeNodes = attributeNodesByAttribute.isEmpty() ? null : new HashMap(attributeNodesByAttribute.size());
        this.treatedSubgraphs = subGraphMap.isEmpty() ? null : new HashMap(subGraphMap.size());
        this.mergeInternal(graph);
    }

    protected GraphImpl(GraphImplementor<J> graph, boolean mutable) {
        this(graph.getGraphedType(), graph, mutable);
    }

    @Override
    public final ManagedDomainType<J> getGraphedType() {
        return this.managedType;
    }

    private <S extends J> SubGraphImplementor<S> getTreatedSubgraph(Class<S> javaType) {
        return this.treatedSubgraphs == null ? null : this.treatedSubgraphs.get(javaType);
    }

    private <T> AttributeNodeImplementor<T, ?, ?> getNode(PersistentAttribute<?, ? extends T> attribute) {
        return this.attributeNodes == null ? null : this.attributeNodes.get(attribute);
    }

    private <T, E> AttributeNodeImplementor<T, E, ?> getNode(PluralPersistentAttribute<?, T, E> attribute) {
        return this.attributeNodes == null ? null : this.attributeNodes.get(attribute);
    }

    private <K, V> AttributeNodeImplementor<Map<K, V>, V, K> getNode(MapPersistentAttribute<?, K, V> attribute) {
        return this.attributeNodes == null ? null : this.attributeNodes.get(attribute);
    }

    private <S extends J> SubGraphImplementor<S> getTreatedSubgraphForPut(Class<S> javaType) {
        if (this.treatedSubgraphs == null) {
            this.treatedSubgraphs = new HashMap<Class<? extends J>, SubGraphImplementor<? extends J>>(1);
            return null;
        }
        return this.getTreatedSubgraph(javaType);
    }

    private <AJ> AttributeNodeImplementor<AJ, ?, ?> getNodeForPut(PersistentAttribute<?, AJ> attribute) {
        if (this.attributeNodes == null) {
            this.attributeNodes = new HashMap();
            return null;
        }
        return this.getNode(attribute);
    }

    private <C, E> AttributeNodeImplementor<C, E, ?> getNodeForPut(PluralPersistentAttribute<?, C, E> attribute) {
        if (this.attributeNodes == null) {
            this.attributeNodes = new HashMap();
            return null;
        }
        return this.getNode(attribute);
    }

    private <V, K> AttributeNodeImplementor<Map<K, V>, V, K> getNodeForPut(MapPersistentAttribute<?, K, V> attribute) {
        if (this.attributeNodes == null) {
            this.attributeNodes = new HashMap();
            return null;
        }
        return this.getNode(attribute);
    }

    @Override
    @Deprecated(forRemoval=true)
    public RootGraphImplementor<J> makeRootGraph(String name, boolean mutable) {
        if (this.getGraphedType() instanceof EntityDomainType) {
            return new RootGraphImpl(name, this, mutable);
        }
        throw new CannotBecomeEntityGraphException("Graph cannot be a root graph because '" + String.valueOf(this.getGraphedType()) + "' is not an entity type");
    }

    @Override
    public void merge(GraphImplementor<J> graph) {
        if (graph != null) {
            this.verifyMutability();
            this.mergeInternal(graph);
        }
    }

    @Override
    public void mergeInternal(GraphImplementor<J> graph) {
        graph.getNodes().forEach(this::mergeNode);
        graph.getTreatedSubgraphs().values().forEach(this::mergeGraph);
    }

    private void mergeNode(PersistentAttribute<? super J, ?> attribute, AttributeNodeImplementor<?, ?, ?> node) {
        AttributeNodeImplementor<?, ? super J, ? super J> existingNode = this.getNodeForPut(attribute);
        if (existingNode == null) {
            this.attributeNodes.put((PersistentAttribute<J, ?>)attribute, (AttributeNodeImplementor<?, ?, ?>)node.makeCopy(this.isMutable()));
        } else {
            GraphImpl.mergeNode(node, existingNode);
        }
    }

    private <T extends J> void mergeGraph(SubGraphImplementor<T> subgraph) {
        Class javaType = subgraph.getClassType();
        SubGraphImplementor<T> existing = this.getTreatedSubgraphForPut(javaType);
        if (existing == null) {
            this.treatedSubgraphs.put(javaType, (SubGraphImplementor<J>)subgraph.makeCopy(this.isMutable()));
        } else {
            existing.mergeInternal(subgraph);
        }
    }

    private static <T, E, K> void mergeNode(AttributeNodeImplementor<?, ?, ?> node, AttributeNodeImplementor<T, E, K> existingNode) {
        if (existingNode.getAttributeDescriptor() != node.getAttributeDescriptor()) {
            throw new AssertionFailure("Attributes should have been identical");
        }
        AttributeNodeImplementor<?, ?, ?> castNode = node;
        existingNode.merge(castNode);
    }

    @Override
    public List<AttributeNodeImplementor<?, ?, ?>> getAttributeNodeList() {
        return this.attributeNodes == null ? Collections.emptyList() : new ArrayList(this.attributeNodes.values());
    }

    @Override
    public <AJ> AttributeNodeImplementor<AJ, ?, ?> findAttributeNode(String attributeName) {
        AttributeNode node;
        PersistentAttribute<?, ?> attribute;
        PersistentAttribute<?, ?> persistentAttribute = attribute = this.findAttributeInSupertypes(attributeName);
        AttributeNode attributeNode = node = attribute == null ? null : this.findAttributeNode(persistentAttribute);
        if (node == null && this.treatedSubgraphs != null) {
            for (SubGraphImplementor<J> subgraph : this.treatedSubgraphs.values()) {
                AttributeNode subgraphNode = subgraph.findAttributeNode(attributeName);
                if (subgraphNode == null) continue;
                return subgraphNode;
            }
            return null;
        }
        return node;
    }

    @Override
    public <Y> AttributeNodeImplementor<Y, ?, ?> getAttributeNode(String attributeName) {
        return this.findAttributeNode(attributeName);
    }

    @Override
    public <AJ> AttributeNodeImplementor<AJ, ?, ?> findAttributeNode(PersistentAttribute<? super J, AJ> attribute) {
        return this.getNode(attribute);
    }

    @Override
    public <Y> AttributeNodeImplementor<Y, ?, ?> getAttributeNode(Attribute<? super J, Y> attribute) {
        return this.getNode((PersistentAttribute)attribute);
    }

    @Override
    public List<jakarta.persistence.AttributeNode<?>> getAttributeNodes() {
        return this.attributeNodes == null ? Collections.emptyList() : new ArrayList(this.attributeNodes.values());
    }

    @Override
    public Map<PersistentAttribute<? super J, ?>, AttributeNodeImplementor<?, ?, ?>> getNodes() {
        return this.attributeNodes == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.attributeNodes);
    }

    public <AJ> AttributeNodeImplementor<AJ, ?, ?> addAttributeNode(String attributeName) {
        return this.findOrCreateAttributeNode(attributeName);
    }

    @Override
    public <AJ> AttributeNodeImplementor<AJ, ?, ?> addAttributeNode(PersistentAttribute<? super J, AJ> attribute) {
        return this.findOrCreateAttributeNode(attribute);
    }

    @Override
    public <Y> AttributeNodeImplementor<Y, ?, ?> addAttributeNode(Attribute<? super J, Y> attribute) {
        return this.addAttributeNode((PersistentAttribute)attribute);
    }

    @Override
    public void addAttributeNodes(String ... attributeNames) {
        for (String attributeName : attributeNames) {
            this.addAttributeNode(attributeName);
        }
    }

    @Override
    @SafeVarargs
    public final void addAttributeNodes(Attribute<? super J, ?> ... attributes) {
        for (Attribute<? super J, ?> attribute : attributes) {
            this.addAttributeNode(attribute);
        }
    }

    @Override
    public void removeAttributeNode(String attributeName) {
        this.verifyMutability();
        this.attributeNodes.remove(this.managedType.findAttribute(attributeName));
    }

    @Override
    public void removeAttributeNode(Attribute<? super J, ?> attribute) {
        this.verifyMutability();
        this.attributeNodes.remove((PersistentAttribute)attribute);
    }

    @Override
    public void removeAttributeNodes(Attribute.PersistentAttributeType nodeType) {
        this.verifyMutability();
        this.attributeNodes.keySet().removeIf(entry -> entry.getPersistentAttributeType() == nodeType);
    }

    @Override
    public <AJ> AttributeNodeImplementor<AJ, ?, ?> findOrCreateAttributeNode(PersistentAttribute<? super J, AJ> attribute) {
        this.verifyMutability();
        AttributeNodeImplementor<AJ, ? super J, ? super J> node = this.getNodeForPut(attribute);
        if (node == null) {
            AttributeNodeImpl<AJ, ? super J, ? super J> newAttrNode = AttributeNodeImpl.create(attribute, this.isMutable());
            this.attributeNodes.put(attribute, newAttrNode);
            return newAttrNode;
        }
        return node;
    }

    private <C, E> AttributeNodeImplementor<C, E, ?> findOrCreateAttributeNode(PluralPersistentAttribute<? super J, C, E> attribute) {
        this.verifyMutability();
        AttributeNodeImplementor<C, E, ? super J> node = this.getNodeForPut(attribute);
        if (node == null) {
            AttributeNodeImpl<C, E, ? super J> newAttrNode = AttributeNodeImpl.create(attribute, this.isMutable());
            this.attributeNodes.put(attribute, newAttrNode);
            return newAttrNode;
        }
        return node;
    }

    private <K, V> AttributeNodeImplementor<Map<K, V>, V, K> findOrCreateAttributeNode(MapPersistentAttribute<? super J, K, V> attribute) {
        this.verifyMutability();
        AttributeNodeImplementor<Map<K, V>, V, K> node = this.getNodeForPut(attribute);
        if (node == null) {
            AttributeNodeImpl<Map<K, V>, V, K> newAttrNode = AttributeNodeImpl.create(attribute, this.isMutable());
            this.attributeNodes.put(attribute, newAttrNode);
            return newAttrNode;
        }
        return node;
    }

    @Override
    public <AJ> AttributeNodeImplementor<AJ, ?, ?> findOrCreateAttributeNode(String attributeName) {
        PersistentAttribute<?, ?> attribute;
        PersistentAttribute<?, ?> persistentAttribute = attribute = this.getAttribute(attributeName);
        return this.findOrCreateAttributeNode(persistentAttribute);
    }

    private PersistentAttribute<? super J, ?> findAttributeInSupertypes(String attributeName) {
        SqmPathSource sqmPathSource;
        PersistentAttribute<?, ?> attribute = this.managedType.findAttributeInSuperTypes(attributeName);
        return attribute instanceof SqmPathSource && (sqmPathSource = (SqmPathSource)((Object)attribute)).isGeneric() ? this.managedType.findConcreteGenericAttribute(attributeName) : attribute;
    }

    private PersistentAttribute<? super J, ?> getAttribute(String attributeName) {
        SqmPathSource sqmPathSource;
        PersistentAttribute<?, ?> attribute = this.managedType.getAttribute(attributeName);
        return attribute instanceof SqmPathSource && (sqmPathSource = (SqmPathSource)((Object)attribute)).isGeneric() ? this.managedType.findConcreteGenericAttribute(attributeName) : attribute;
    }

    @Override
    public <X> SubGraphImplementor<X> addSubgraph(String attributeName) {
        return this.findOrCreateAttributeNode(attributeName).addValueSubgraph();
    }

    @Override
    public <X> SubGraphImplementor<X> addSubgraph(String attributeName, Class<X> type) {
        return this.addSubgraph(attributeName).addTreatedSubgraph(type);
    }

    @Override
    public <X> SubGraphImplementor<X> addSubgraph(Attribute<? super J, X> attribute) {
        return this.findOrCreateAttributeNode((PersistentAttribute)attribute).addSingularSubgraph();
    }

    @Override
    public <AJ> SubGraphImplementor<AJ> addSubGraph(String attributeName) {
        return this.addSubgraph(attributeName);
    }

    @Override
    public <AJ> SubGraphImplementor<AJ> addSubGraph(String attributeName, Class<AJ> subtype) {
        return this.addSubGraph(attributeName).addTreatedSubgraph(subtype);
    }

    @Override
    public <AJ> SubGraphImplementor<AJ> addSubGraph(PersistentAttribute<? super J, AJ> attribute) {
        return this.addSubgraph(attribute);
    }

    @Override
    public <AJ> SubGraphImplementor<AJ> addSubGraph(PersistentAttribute<? super J, ? super AJ> attribute, Class<AJ> subtype) {
        return this.addTreatedSubgraph((Attribute)attribute, subtype);
    }

    @Override
    public <AJ> SubGraphImplementor<AJ> addTreatedSubgraph(Attribute<? super J, ? super AJ> attribute, ManagedType<AJ> type) {
        return this.addSubgraph(attribute).addTreatedSubgraph(type);
    }

    @Override
    public <X> SubGraphImplementor<X> addElementSubgraph(String attributeName) {
        return this.findOrCreateAttributeNode(attributeName).addElementSubgraph();
    }

    @Override
    public <X> SubGraphImplementor<X> addElementSubgraph(String attributeName, Class<X> type) {
        return this.addElementSubgraph(attributeName).addTreatedSubgraph(type);
    }

    @Override
    public <E> SubGraphImplementor<E> addElementSubgraph(PluralAttribute<? super J, ?, E> attribute) {
        return this.findOrCreateAttributeNode((PluralPersistentAttribute)attribute).addElementSubgraph();
    }

    @Override
    public <E> SubGraphImplementor<E> addTreatedElementSubgraph(PluralAttribute<? super J, ?, ? super E> attribute, Class<E> type) {
        return this.addElementSubgraph(attribute).addTreatedSubgraph(type);
    }

    @Override
    public <AJ> SubGraph<AJ> addTreatedElementSubgraph(PluralAttribute<? super J, ?, ? super AJ> attribute, ManagedType<AJ> type) {
        return this.addElementSubgraph(attribute).addTreatedSubgraph(type);
    }

    @Override
    public <X> SubGraphImplementor<X> addKeySubgraph(String attributeName) {
        return this.findOrCreateAttributeNode(attributeName).addKeySubgraph();
    }

    @Override
    public <X> SubGraphImplementor<X> addKeySubgraph(String attributeName, Class<X> type) {
        return this.addKeySubgraph(attributeName).addTreatedSubgraph(type);
    }

    @Override
    public <AJ> SubGraphImplementor<AJ> addKeySubGraph(String attributeName) {
        return this.addKeySubgraph(attributeName);
    }

    @Override
    public <AJ> SubGraphImplementor<AJ> addKeySubGraph(String attributeName, Class<AJ> subtype) {
        return this.addKeySubGraph(attributeName).addTreatedSubgraph(subtype);
    }

    @Override
    public <K> SubGraphImplementor<K> addMapKeySubgraph(MapAttribute<? super J, K, ?> attribute) {
        return this.findOrCreateAttributeNode((MapPersistentAttribute)attribute).addKeySubgraph();
    }

    @Override
    public <AJ> SubGraphImplementor<AJ> addKeySubGraph(MapPersistentAttribute<? super J, ? super AJ, ?> attribute, Class<AJ> subtype) {
        return this.addTreatedMapKeySubgraph((MapAttribute)attribute, subtype);
    }

    @Override
    public <AJ> SubGraphImplementor<AJ> addTreatedMapKeySubgraph(MapAttribute<? super J, ? super AJ, ?> attribute, ManagedType<AJ> type) {
        return this.addMapKeySubgraph(attribute).addTreatedSubgraph(type);
    }

    @Override
    public <K> SubGraphImplementor<K> addTreatedMapKeySubgraph(MapAttribute<? super J, ? super K, ?> attribute, Class<K> type) {
        return this.addMapKeySubgraph(attribute).addTreatedSubgraph(type);
    }

    @Override
    public <Y> SubGraphImplementor<Y> addTreatedSubgraph(Attribute<? super J, ? super Y> attribute, Class<Y> type) {
        return this.addSubgraph(attribute).addTreatedSubgraph((Class)type);
    }

    @Override
    public <S extends J> SubGraphImplementor<S> addTreatedSubgraph(ManagedType<S> type) {
        this.verifyMutability();
        if (this.getGraphedType().equals(type)) {
            return (SubGraphImplementor)((Object)this);
        }
        Class javaType = type.getJavaType();
        SubGraphImplementor castSubgraph = this.getTreatedSubgraphForPut(javaType);
        if (castSubgraph == null) {
            SubGraphImpl subgraph = new SubGraphImpl((ManagedDomainType)type, true);
            this.treatedSubgraphs.put(javaType, subgraph);
            return subgraph;
        }
        return castSubgraph;
    }

    @Override
    public <S extends J> SubGraphImplementor<S> addTreatedSubgraph(Class<S> type) {
        return this.addTreatedSubgraph(this.getGraphedType().getMetamodel().managedType(type));
    }

    @Override
    public Map<Class<? extends J>, SubGraphImplementor<? extends J>> getTreatedSubgraphs() {
        return this.treatedSubgraphs == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.treatedSubgraphs);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Graph[").append(this.managedType.getTypeName());
        if (this.attributeNodes != null) {
            builder.append(", nodes=").append(this.attributeNodes.values().stream().map(node -> node.getAttributeDescriptor().getName()).toList());
        }
        if (this.treatedSubgraphs != null) {
            builder.append(", subgraphs=").append(this.treatedSubgraphs.values().stream().map(subgraph -> subgraph.getGraphedType().getTypeName()).toList());
        }
        return builder.append(']').toString();
    }
}

