/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.NoResultException;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.RollbackException;
import java.io.Serializable;
import java.sql.SQLException;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockOptions;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.PersistentObjectException;
import org.hibernate.PessimisticLockException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.dialect.lock.LockingStrategyException;
import org.hibernate.dialect.lock.OptimisticEntityLockException;
import org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.SnapshotIsolationException;
import org.hibernate.exception.TransactionSerializationException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.MultipleBagFetchException;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.SemanticException;
import org.hibernate.query.SyntaxException;

public class ExceptionConverterImpl
implements ExceptionConverter {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(ExceptionConverterImpl.class);
    private final SharedSessionContractImplementor session;
    private final boolean isJpaBootstrap;

    public ExceptionConverterImpl(SharedSessionContractImplementor session) {
        this.session = session;
        this.isJpaBootstrap = session.getFactory().getSessionFactoryOptions().isJpaBootstrap();
    }

    @Override
    public RuntimeException convertCommitException(RuntimeException exception) {
        if (this.isJpaBootstrap) {
            RuntimeException runtimeException;
            try {
                this.session.getTransaction().rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            String string = "Error while committing the transaction [" + exception.getMessage() + "]";
            if (exception instanceof HibernateException) {
                HibernateException hibernateException = (HibernateException)exception;
                runtimeException = this.convert(hibernateException);
            } else {
                runtimeException = exception;
            }
            return new RollbackException(string, runtimeException);
        }
        return exception;
    }

    @Override
    public RuntimeException convert(HibernateException exception, LockOptions lockOptions) {
        if (exception instanceof StaleStateException) {
            StaleStateException staleStateException = (StaleStateException)exception;
            PersistenceException converted = this.wrapStaleStateException(staleStateException);
            this.rollbackIfNecessary(converted);
            return converted;
        }
        if (exception instanceof PessimisticLockException) {
            PessimisticLockException pessimisticLockException = (PessimisticLockException)exception;
            PersistenceException converted = this.wrapLockException(pessimisticLockException, lockOptions);
            this.rollbackIfNecessary(converted);
            return converted;
        }
        if (exception instanceof LockingStrategyException) {
            LockingStrategyException lockingStrategyException = (LockingStrategyException)exception;
            PersistenceException converted = this.wrapLockException(lockingStrategyException, lockOptions);
            this.rollbackIfNecessary(converted);
            return converted;
        }
        if (exception instanceof SnapshotIsolationException) {
            return new OptimisticLockException(exception.getMessage(), exception);
        }
        if (exception instanceof QueryTimeoutException) {
            jakarta.persistence.QueryTimeoutException converted = new jakarta.persistence.QueryTimeoutException(exception.getMessage(), exception);
            this.rollbackIfNecessary(converted);
            return converted;
        }
        if (exception instanceof ObjectNotFoundException) {
            EntityNotFoundException converted = new EntityNotFoundException(exception.getMessage(), exception);
            this.rollbackIfNecessary(converted);
            return converted;
        }
        if (exception instanceof NonUniqueObjectException || exception instanceof PersistentObjectException) {
            EntityExistsException converted = new EntityExistsException(exception.getMessage(), exception);
            this.rollbackIfNecessary(converted);
            return converted;
        }
        if (exception instanceof NonUniqueResultException) {
            jakarta.persistence.NonUniqueResultException converted = new jakarta.persistence.NonUniqueResultException(exception.getMessage(), exception);
            this.rollbackIfNecessary(converted);
            return converted;
        }
        if (exception instanceof UnresolvableObjectException) {
            EntityNotFoundException converted = new EntityNotFoundException(exception.getMessage(), exception);
            this.rollbackIfNecessary(converted);
            return converted;
        }
        if (exception instanceof SyntaxException || exception instanceof SemanticException || exception instanceof IllegalQueryOperationException) {
            return new IllegalArgumentException(exception);
        }
        if (exception instanceof MultipleBagFetchException) {
            return new IllegalArgumentException(exception);
        }
        if (exception instanceof TransientObjectException) {
            try {
                this.session.markForRollbackOnly();
            }
            catch (Exception ne) {
                log.unableToMarkForRollbackOnTransientObjectException(ne);
            }
            return new IllegalStateException(exception);
        }
        if (exception instanceof TransactionSerializationException) {
            RollbackException converted = new RollbackException(exception.getMessage(), exception);
            this.rollbackIfNecessary(converted);
            return converted;
        }
        this.rollbackIfNecessary(exception);
        return exception;
    }

    @Override
    public RuntimeException convert(HibernateException exception) {
        return this.convert(exception, null);
    }

    @Override
    public RuntimeException convert(RuntimeException exception) {
        if (exception instanceof HibernateException) {
            HibernateException hibernateException = (HibernateException)exception;
            return this.convert(hibernateException);
        }
        this.session.markForRollbackOnly();
        return exception;
    }

    @Override
    public RuntimeException convert(RuntimeException exception, LockOptions lockOptions) {
        if (exception instanceof HibernateException) {
            HibernateException hibernateException = (HibernateException)exception;
            return this.convert(hibernateException, lockOptions);
        }
        this.session.markForRollbackOnly();
        return exception;
    }

    @Override
    public JDBCException convert(SQLException e, String message) {
        return this.session.getJdbcServices().getSqlExceptionHelper().convert(e, message);
    }

    protected PersistenceException wrapStaleStateException(StaleStateException exception) {
        if (exception instanceof StaleObjectStateException) {
            StaleObjectStateException staleStateException = (StaleObjectStateException)exception;
            Object identifier = staleStateException.getIdentifier();
            String entityName = staleStateException.getEntityName();
            if (identifier != null) {
                try {
                    Object entity = this.session.internalLoad(entityName, identifier, false, true);
                    if (entity instanceof Serializable) {
                        return new OptimisticLockException(exception.getMessage(), exception, entity);
                    }
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    // empty catch block
                }
            }
        }
        return new OptimisticLockException(exception.getMessage(), exception);
    }

    protected PersistenceException wrapLockException(LockingStrategyException exception, LockOptions lockOptions) {
        if (exception instanceof OptimisticEntityLockException) {
            OptimisticEntityLockException lockException = (OptimisticEntityLockException)exception;
            return new OptimisticLockException(lockException.getMessage(), lockException, lockException.getEntity());
        }
        if (exception instanceof PessimisticEntityLockException) {
            PessimisticEntityLockException lockException = (PessimisticEntityLockException)exception;
            return lockOptions != null && lockOptions.getTimeout().milliseconds() > -1 ? new jakarta.persistence.LockTimeoutException(lockException.getMessage(), lockException, lockException.getEntity()) : new jakarta.persistence.PessimisticLockException(lockException.getMessage(), lockException, lockException.getEntity());
        }
        throw new AssertionFailure("Unrecognized exception type");
    }

    protected PersistenceException wrapLockException(PessimisticLockException exception, LockOptions lockOptions) {
        if (exception instanceof LockTimeoutException) {
            return new jakarta.persistence.LockTimeoutException(exception.getMessage(), exception);
        }
        return lockOptions != null && lockOptions.getTimeout().milliseconds() > -1 ? new jakarta.persistence.LockTimeoutException(exception.getMessage(), exception) : new jakarta.persistence.PessimisticLockException(exception.getMessage(), exception);
    }

    private void rollbackIfNecessary(PersistenceException persistenceException) {
        if (!ExceptionConverterImpl.isNonRollbackException(persistenceException)) {
            try {
                this.session.markForRollbackOnly();
            }
            catch (Exception ne) {
                log.unableToMarkForRollbackOnPersistenceException(ne);
            }
        }
    }

    private static boolean isNonRollbackException(PersistenceException persistenceException) {
        return persistenceException instanceof NoResultException || persistenceException instanceof jakarta.persistence.NonUniqueResultException || persistenceException instanceof jakarta.persistence.LockTimeoutException || persistenceException instanceof jakarta.persistence.QueryTimeoutException;
    }
}

