/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import jakarta.persistence.metamodel.PluralAttribute;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.TransientObjectException;
import org.hibernate.annotations.CacheLayout;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.entry.CacheEntryStructure;
import org.hibernate.cache.spi.entry.StructuredCollectionCacheEntry;
import org.hibernate.cache.spi.entry.StructuredMapCacheEntry;
import org.hibernate.cache.spi.entry.UnstructuredCacheEntry;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.internal.MutationQueryOptions;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.profile.internal.FetchProfileAffectee;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.Generator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.FilterHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.loader.ast.internal.CollectionElementLoaderByIndex;
import org.hibernate.loader.ast.internal.CollectionLoaderNamedQuery;
import org.hibernate.loader.ast.internal.CollectionLoaderSingleKey;
import org.hibernate.loader.ast.internal.CollectionLoaderSubSelectFetch;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.loader.ast.spi.BatchLoaderFactory;
import org.hibernate.loader.ast.spi.CollectionLoader;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.DiscriminatorMapping;
import org.hibernate.metamodel.mapping.DiscriminatorValueDetails;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.InFlightCollectionMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.PluralAttributeMappingImpl;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.CollectionTableMapping;
import org.hibernate.persister.collection.mutation.RemoveCoordinator;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.internal.SqlFragmentPredicate;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.Alias;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.sql.Template;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.spi.SqlAliasBaseConstant;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.AliasedExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.ColumnValueParameter;
import org.hibernate.sql.model.ast.ColumnValueParameterList;
import org.hibernate.sql.model.ast.ColumnWriteFragment;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.RestrictedTableMutation;
import org.hibernate.sql.model.internal.TableDeleteStandard;
import org.hibernate.sql.model.jdbc.JdbcDeleteMutation;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.AnyType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.spi.TypeConfiguration;

@Internal
public abstract class AbstractCollectionPersister
implements CollectionPersister,
InFlightCollectionMapping,
CollectionMutationTarget,
PluralAttributeMappingImpl.Aware,
FetchProfileAffectee,
Joinable {
    private final NavigableRole navigableRole;
    private final CollectionSemantics<?, ?> collectionSemantics;
    private final EntityPersister ownerPersister;
    private final SessionFactoryImplementor factory;
    protected final String qualifiedTableName;
    private final CollectionTableMapping tableMapping;
    private String sqlSelectSizeString;
    private String sqlDetectRowByIndexString;
    private String sqlDetectRowByElementString;
    protected boolean hasWhere;
    protected String sqlWhereString;
    private String sqlWhereStringTemplate;
    private final boolean hasOrder;
    private final boolean hasManyToManyOrder;
    private final String mappedByProperty;
    protected final boolean indexContainsFormula;
    protected final boolean elementIsPureFormula;
    protected final String[] keyColumnNames;
    protected final String[] indexColumnNames;
    protected final String[] indexFormulaTemplates;
    protected final String[] indexFormulas;
    protected final boolean[] indexColumnIsGettable;
    protected final boolean[] indexColumnIsSettable;
    protected final String[] elementColumnNames;
    protected final String[] elementColumnWriters;
    protected final String[] elementColumnReaders;
    protected final String[] elementColumnReaderTemplates;
    protected final String[] elementFormulaTemplates;
    protected final String[] elementFormulas;
    protected final boolean[] elementColumnIsGettable;
    protected final boolean[] elementColumnIsSettable;
    protected final String identifierColumnName;
    private final String queryLoaderName;
    private final boolean isPrimitiveArray;
    private final boolean isLazy;
    private final boolean isExtraLazy;
    protected final boolean isInverse;
    private final boolean keyIsUpdateable;
    private final boolean isMutable;
    private final boolean isVersioned;
    protected final int batchSize;
    private final boolean hasOrphanDelete;
    private final boolean subselectLoadable;
    private final boolean cascadeDeleteEnabled;
    private final Class<?> elementClass;
    private final Dialect dialect;
    protected final SqlExceptionHelper sqlExceptionHelper;
    private final BeforeExecutionGenerator identifierGenerator;
    private final EntityPersister elementPersister;
    private final @Nullable CollectionDataAccess cacheAccessStrategy;
    private final CacheEntryStructure cacheEntryStructure;
    private final boolean useShallowQueryCacheLayout;
    private final FilterHelper filterHelper;
    private final FilterHelper manyToManyFilterHelper;
    private final String manyToManyWhereString;
    private final String manyToManyWhereTemplate;
    private final String[] spaces;
    private final Comparator<?> comparator;
    private CollectionLoader collectionLoader;
    private CollectionElementLoaderByIndex collectionElementLoaderByIndex;
    private PluralAttributeMapping attributeMapping;
    private volatile Set<String> affectingFetchProfiles;
    private Collection collectionBootDescriptor;
    @Deprecated
    private final CollectionType collectionType;
    @Deprecated
    private final Type keyType;
    @Deprecated
    private final Type identifierType;
    @Deprecated
    private final Type indexType;
    @Deprecated
    protected final Type elementType;
    @Deprecated
    protected final String[] keyColumnAliases;
    @Deprecated
    private final String identifierColumnAlias;
    @Deprecated
    protected final String[] indexColumnAliases;
    @Deprecated
    protected final String[] elementColumnAliases;
    @Deprecated
    private final Map<String, String[]> collectionPropertyColumnAliases = new HashMap<String, String[]>();

    public AbstractCollectionPersister(Collection collectionBootDescriptor, @Nullable CollectionDataAccess cacheAccessStrategy, RuntimeModelCreationContext creationContext) throws MappingException, CacheException {
        Class<?> clazz;
        this.collectionBootDescriptor = collectionBootDescriptor;
        this.factory = creationContext.getSessionFactory();
        this.collectionSemantics = creationContext.getBootstrapContext().getMetadataBuildingOptions().getPersistentCollectionRepresentationResolver().resolveRepresentation(collectionBootDescriptor);
        this.cacheAccessStrategy = cacheAccessStrategy;
        this.cacheEntryStructure = creationContext.getSessionFactoryOptions().isStructuredCacheEntriesEnabled() ? (collectionBootDescriptor.isMap() ? StructuredMapCacheEntry.INSTANCE : StructuredCollectionCacheEntry.INSTANCE) : UnstructuredCacheEntry.INSTANCE;
        this.useShallowQueryCacheLayout = this.shouldUseShallowCacheLayout(collectionBootDescriptor.getQueryCacheLayout(), creationContext.getSessionFactoryOptions());
        this.dialect = creationContext.getDialect();
        this.sqlExceptionHelper = creationContext.getJdbcServices().getSqlExceptionHelper();
        this.collectionType = collectionBootDescriptor.getCollectionType();
        this.navigableRole = new NavigableRole(collectionBootDescriptor.getRole());
        this.ownerPersister = creationContext.getDomainModel().getEntityDescriptor(collectionBootDescriptor.getOwnerEntityName());
        this.queryLoaderName = collectionBootDescriptor.getLoaderName();
        this.isMutable = collectionBootDescriptor.isMutable();
        this.mappedByProperty = collectionBootDescriptor.getMappedByProperty();
        Value elementBootDescriptor = collectionBootDescriptor.getElement();
        Table table = collectionBootDescriptor.getCollectionTable();
        this.elementType = elementBootDescriptor.getType();
        this.isPrimitiveArray = collectionBootDescriptor.isPrimitiveArray();
        this.subselectLoadable = collectionBootDescriptor.isSubselectLoadable();
        this.qualifiedTableName = this.determineTableName(table);
        int spacesSize = 1 + collectionBootDescriptor.getSynchronizedTables().size();
        this.spaces = new String[spacesSize];
        Iterator<String> tables = collectionBootDescriptor.getSynchronizedTables().iterator();
        for (int i = 1; i < spacesSize; ++i) {
            this.spaces[i] = tables.next();
        }
        this.hasOrphanDelete = collectionBootDescriptor.hasOrphanDelete();
        this.batchSize = collectionBootDescriptor.getBatchSize() < 0 ? this.factory.getSessionFactoryOptions().getDefaultBatchFetchSize() : collectionBootDescriptor.getBatchSize();
        this.isVersioned = collectionBootDescriptor.isOptimisticLocked();
        this.keyType = collectionBootDescriptor.getKey().getType();
        int keySpan = collectionBootDescriptor.getKey().getColumnSpan();
        this.keyColumnNames = new String[keySpan];
        this.keyColumnAliases = new String[keySpan];
        int k = 0;
        for (Selectable selectable : collectionBootDescriptor.getKey().getSelectables()) {
            this.keyColumnAliases[k] = selectable.getAlias(this.dialect, table);
            if (!(selectable instanceof Column)) {
                throw new MappingException("Collection keys may not contain formulas: " + this.navigableRole.getFullPath());
            }
            Column column = (Column)selectable;
            this.keyColumnNames[k] = column.getQuotedName(this.dialect);
            ++k;
        }
        Type type = this.elementType;
        if (type instanceof EntityType) {
            EntityType entityType = (EntityType)type;
            String string = entityType.getAssociatedEntityName();
            this.elementPersister = creationContext.getDomainModel().getEntityDescriptor(string);
        } else {
            this.elementPersister = null;
        }
        this.spaces[0] = this.getTableName();
        TypeConfiguration typeConfiguration = creationContext.getTypeConfiguration();
        int n = elementBootDescriptor.getColumnSpan();
        this.elementColumnAliases = new String[n];
        this.elementColumnNames = new String[n];
        this.elementColumnWriters = new String[n];
        this.elementColumnReaders = new String[n];
        this.elementColumnReaderTemplates = new String[n];
        this.elementFormulaTemplates = new String[n];
        this.elementFormulas = new String[n];
        this.elementColumnIsSettable = new boolean[n];
        this.elementColumnIsGettable = new boolean[n];
        boolean isPureFormula = true;
        boolean oneToMany = collectionBootDescriptor.isOneToMany();
        boolean[] columnInsertability = null;
        if (!oneToMany) {
            columnInsertability = elementBootDescriptor.getColumnInsertability();
        }
        int j = 0;
        for (Selectable selectable3 : elementBootDescriptor.getSelectables()) {
            this.elementColumnAliases[j] = selectable3.getAlias(this.dialect, table);
            if (selectable3.isFormula()) {
                Formula form = (Formula)selectable3;
                this.elementFormulaTemplates[j] = form.getTemplate(this.dialect, typeConfiguration);
                this.elementFormulas[j] = form.getFormula();
            } else {
                Column col = (Column)selectable3;
                this.elementColumnNames[j] = col.getQuotedName(this.dialect);
                this.elementColumnWriters[j] = col.getWriteExpr(elementBootDescriptor.getSelectableType(this.factory.getRuntimeMetamodels(), j), this.dialect);
                this.elementColumnReaders[j] = col.getReadExpr(this.dialect);
                this.elementColumnReaderTemplates[j] = col.getTemplate(this.dialect, typeConfiguration);
                this.elementColumnIsGettable[j] = true;
                this.elementColumnIsSettable[j] = this.elementType instanceof ComponentType || this.elementType instanceof AnyType ? columnInsertability[j] : true;
                isPureFormula = false;
            }
            ++j;
        }
        this.elementIsPureFormula = isPureFormula;
        if (collectionBootDescriptor instanceof IndexedCollection) {
            IndexedCollection indexedCollection = (IndexedCollection)collectionBootDescriptor;
            assert (collectionBootDescriptor.isIndexed());
            Value index = indexedCollection.getIndex();
            this.indexType = index.getType();
            int indexSpan = index.getColumnSpan();
            boolean[] indexColumnInsertability = index.getColumnInsertability();
            boolean[] indexColumnUpdatability = index.getColumnUpdateability();
            this.indexColumnNames = new String[indexSpan];
            this.indexFormulaTemplates = new String[indexSpan];
            this.indexFormulas = new String[indexSpan];
            this.indexColumnIsGettable = new boolean[indexSpan];
            this.indexColumnIsSettable = new boolean[indexSpan];
            this.indexColumnAliases = new String[indexSpan];
            int i = 0;
            boolean hasFormula = false;
            for (Selectable selectable4 : index.getSelectables()) {
                this.indexColumnAliases[i] = selectable4.getAlias(this.dialect);
                if (selectable4.isFormula()) {
                    Formula indexForm = (Formula)selectable4;
                    this.indexFormulaTemplates[i] = indexForm.getTemplate(this.dialect, typeConfiguration);
                    this.indexFormulas[i] = indexForm.getFormula();
                    hasFormula = true;
                } else {
                    if (indexedCollection.hasMapKeyProperty()) {
                        indexColumnInsertability[i] = false;
                        indexColumnUpdatability[i] = false;
                        hasFormula = true;
                    }
                    Column indexCol = (Column)selectable4;
                    this.indexColumnNames[i] = indexCol.getQuotedName(this.dialect);
                    this.indexColumnIsGettable[i] = true;
                    this.indexColumnIsSettable[i] = indexColumnInsertability[i] || indexColumnUpdatability[i];
                }
                ++i;
            }
            this.indexContainsFormula = hasFormula;
        } else {
            this.indexContainsFormula = false;
            this.indexColumnIsGettable = null;
            this.indexColumnIsSettable = null;
            this.indexFormulaTemplates = null;
            this.indexFormulas = null;
            this.indexType = null;
            this.indexColumnNames = null;
            this.indexColumnAliases = null;
        }
        boolean hasIdentifier = collectionBootDescriptor.isIdentified();
        if (hasIdentifier) {
            if (collectionBootDescriptor.isOneToMany()) {
                throw new MappingException("one-to-many collections with identifiers are not supported");
            }
            IdentifierCollection idColl = (IdentifierCollection)collectionBootDescriptor;
            this.identifierType = idColl.getIdentifier().getType();
            Column col = idColl.getIdentifier().getColumns().get(0);
            this.identifierColumnName = col.getQuotedName(this.dialect);
            this.identifierColumnAlias = col.getAlias(this.dialect);
            this.identifierGenerator = this.createGenerator(creationContext, idColl);
        } else {
            this.identifierType = null;
            this.identifierColumnName = null;
            this.identifierColumnAlias = null;
            this.identifierGenerator = null;
        }
        this.isLazy = collectionBootDescriptor.isLazy();
        this.isExtraLazy = collectionBootDescriptor.isExtraLazy();
        this.isInverse = collectionBootDescriptor.isInverse();
        this.keyIsUpdateable = collectionBootDescriptor.getKey().isUpdateable();
        if (collectionBootDescriptor instanceof Array) {
            Array arrayDescriptor = (Array)collectionBootDescriptor;
            clazz = arrayDescriptor.getElementClass();
        } else {
            clazz = null;
        }
        this.elementClass = clazz;
        this.hasOrder = collectionBootDescriptor.getOrderBy() != null;
        boolean bl = this.hasManyToManyOrder = collectionBootDescriptor.getManyToManyOrdering() != null;
        if (collectionBootDescriptor.getFilters().isEmpty()) {
            this.filterHelper = null;
        } else {
            Map<String, String> entityNameByTableNameMap = this.elementPersister == null ? null : AbstractEntityPersister.getEntityNameByTableNameMap(creationContext.getBootModel().getEntityBinding(this.elementPersister.getEntityName()), this.factory.getSqlStringGenerationContext());
            this.filterHelper = new FilterHelper(collectionBootDescriptor.getFilters(), entityNameByTableNameMap, this.factory);
        }
        FilterHelper filterHelper = this.manyToManyFilterHelper = collectionBootDescriptor.getManyToManyFilters().isEmpty() ? null : new FilterHelper(collectionBootDescriptor.getManyToManyFilters(), this.factory);
        if (StringHelper.isEmpty(collectionBootDescriptor.getManyToManyWhere())) {
            this.manyToManyWhereString = null;
            this.manyToManyWhereTemplate = null;
        } else {
            this.manyToManyWhereString = "( " + collectionBootDescriptor.getManyToManyWhere() + ")";
            this.manyToManyWhereTemplate = Template.renderWhereStringTemplate(this.manyToManyWhereString, creationContext.getDialect(), typeConfiguration);
        }
        this.comparator = collectionBootDescriptor.getComparator();
        this.initCollectionPropertyMap();
        if (this.hasNamedQueryLoader()) {
            this.getNamedQueryMemento(collectionBootDescriptor.getMetadata());
        }
        this.tableMapping = AbstractCollectionPersister.buildCollectionTableMapping(collectionBootDescriptor, this.getTableName(), this.getCollectionSpaces());
        this.cascadeDeleteEnabled = collectionBootDescriptor.getKey().isCascadeDeleteEnabled() && creationContext.getDialect().supportsCascadeDelete();
    }

    @Override
    public void prepareMappingModel(MappingModelCreationProcess creationProcess) {
        Type type;
        if (this.mappedByProperty != null && (type = this.elementType) instanceof EntityType) {
            EntityType entityType = (EntityType)type;
            String entityName = entityType.getAssociatedEntityName();
            PersistentClass persistentClass = creationProcess.getCreationContext().getBootModel().getEntityBinding(entityName);
            if (persistentClass.getRecursiveProperty(this.mappedByProperty).getValue() instanceof Any) {
                creationProcess.registerInitializationCallback("Where-fragment handling for ANY inverse mapping : " + String.valueOf(this.navigableRole), () -> {
                    EntityPersister entityPersister = creationProcess.getEntityPersister(entityName);
                    this.delayedWhereFragmentProcessing(entityPersister, this.mappedByProperty, this.collectionBootDescriptor, creationProcess);
                    this.buildStaticWhereFragmentSensitiveSql();
                    this.collectionBootDescriptor = null;
                    return true;
                });
                return;
            }
        }
        if (StringHelper.isNotEmpty(this.collectionBootDescriptor.getWhere())) {
            this.hasWhere = true;
            this.sqlWhereString = "(" + this.collectionBootDescriptor.getWhere() + ")";
            this.sqlWhereStringTemplate = Template.renderWhereStringTemplate(this.sqlWhereString, this.dialect, creationProcess.getCreationContext().getTypeConfiguration());
        }
        this.buildStaticWhereFragmentSensitiveSql();
        this.collectionBootDescriptor = null;
    }

    private void delayedWhereFragmentProcessing(EntityPersister entityPersister, String mappedByProperty, Collection collectionBootDescriptor, MappingModelCreationProcess creationProcess) {
        String where;
        AttributeMapping mappedByAttribute = AbstractCollectionPersister.resolveMappedBy(entityPersister, mappedByProperty);
        RuntimeModelCreationContext creationContext = creationProcess.getCreationContext();
        if (mappedByAttribute instanceof DiscriminatedAssociationAttributeMapping) {
            DiscriminatedAssociationAttributeMapping anyMapping = (DiscriminatedAssociationAttributeMapping)mappedByAttribute;
            DiscriminatorMapping discriminatorMapping = anyMapping.getDiscriminatorMapping();
            DiscriminatorValueDetails discriminatorValueDetails = discriminatorMapping.getValueConverter().getDetailsForEntityName(this.ownerPersister.getEntityName());
            String discriminatorLiteral = discriminatorMapping.getUnderlyingJdbcMapping().getJdbcLiteralFormatter().toJdbcLiteral(discriminatorValueDetails.getValue(), creationContext.getDialect(), creationContext.getSessionFactory().getWrapperOptions());
            where = StringHelper.getNonEmptyOrConjunctionIfBothNonEmpty(collectionBootDescriptor.getWhere(), discriminatorMapping.getSelectableName() + "=" + discriminatorLiteral);
        } else {
            where = collectionBootDescriptor.getWhere();
        }
        if (StringHelper.isNotEmpty(where)) {
            this.hasWhere = true;
            this.sqlWhereString = "(" + where + ")";
            this.sqlWhereStringTemplate = Template.renderWhereStringTemplate(this.sqlWhereString, this.dialect, creationContext.getTypeConfiguration());
        }
    }

    private void buildStaticWhereFragmentSensitiveSql() {
        this.sqlSelectSizeString = this.generateSelectSizeString(this.hasIndex() && !this.isMap());
        this.sqlDetectRowByIndexString = this.generateDetectRowByIndexString();
        this.sqlDetectRowByElementString = this.generateDetectRowByElementString();
    }

    private boolean isMap() {
        return this.collectionSemantics.getCollectionClassification().toJpaClassification() == PluralAttribute.CollectionType.MAP;
    }

    private static AttributeMapping resolveMappedBy(EntityPersister entityPersister, String mappedByProperty) {
        StringTokenizer propertyPathParts = new StringTokenizer(mappedByProperty, ".", false);
        assert (propertyPathParts.countTokens() > 0);
        if (propertyPathParts.countTokens() == 1) {
            return entityPersister.findAttributeMapping(propertyPathParts.nextToken());
        }
        ManagedMappingType source = entityPersister;
        while (propertyPathParts.hasMoreTokens()) {
            String partName = propertyPathParts.nextToken();
            AttributeMapping namedPart = source.findAttributeMapping(partName);
            if (!propertyPathParts.hasMoreTokens()) {
                return namedPart;
            }
            source = (ManagedMappingType)namedPart.getPartMappingType();
        }
        throw new MappingException(String.format(Locale.ROOT, "Unable to resolve mapped-by path : (%s) %s", entityPersister.getEntityName(), mappedByProperty));
    }

    private BeforeExecutionGenerator createGenerator(RuntimeModelCreationContext context, IdentifierCollection collection) {
        Generator generator = collection.getIdentifier().createGenerator(context.getDialect(), null, null, context.getGeneratorSettings());
        if (generator.generatedOnExecution()) {
            throw new MappingException("must be an BeforeExecutionGenerator");
        }
        return (BeforeExecutionGenerator)generator;
    }

    private boolean shouldUseShallowCacheLayout(CacheLayout collectionQueryCacheLayout, SessionFactoryOptions options) {
        CacheLayout queryCacheLayout = collectionQueryCacheLayout == null ? options.getQueryCacheLayout() : collectionQueryCacheLayout;
        return queryCacheLayout == CacheLayout.SHALLOW || queryCacheLayout == CacheLayout.AUTO && this.cacheAccessStrategy != null;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public Comparator<?> getSortingComparator() {
        return this.comparator;
    }

    protected String determineTableName(Table table) {
        return MappingModelCreationHelper.getTableIdentifierExpression(table, this.factory);
    }

    @Override
    public void postInstantiate() throws MappingException {
        CollectionLoader collectionLoader = this.collectionLoader = this.hasNamedQueryLoader() ? this.createNamedQueryCollectionLoader(this, this.getNamedQueryMemento(null)) : this.createCollectionLoader(new LoadQueryInfluencers(this.factory));
        if (this.attributeMapping.getIndexDescriptor() != null) {
            this.collectionElementLoaderByIndex = new CollectionElementLoaderByIndex(this.attributeMapping, new LoadQueryInfluencers(this.factory), this.factory);
        }
        this.logStaticSQL();
    }

    private NamedQueryMemento<?> getNamedQueryMemento(MetadataImplementor bootModel) {
        NamedQueryMemento<?> memento = this.factory.getQueryEngine().getNamedObjectRepository().resolve(this.factory, bootModel, this.queryLoaderName);
        if (memento == null) {
            throw new IllegalArgumentException("Could not resolve named query '" + this.queryLoaderName + "' for loading collection '" + this.getRole() + "'");
        }
        return memento;
    }

    protected void logStaticSQL() {
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isTraceEnabled()) {
            String deleteAllSql;
            JdbcMutationOperation deleteRowOperation;
            String deleteRowSql;
            JdbcMutationOperation updateRowOperation;
            String updateRowSql;
            String insertRowSql;
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Static SQL for collection: %s", (Object)this.getRole());
            JdbcMutationOperation insertRowOperation = this.getRowMutationOperations().getInsertRowOperation();
            String string = insertRowSql = insertRowOperation != null ? insertRowOperation.getSqlString() : null;
            if (insertRowSql != null) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef(" Row insert: %s", (Object)insertRowSql);
            }
            String string2 = updateRowSql = (updateRowOperation = this.getRowMutationOperations().getUpdateRowOperation()) != null ? updateRowOperation.getSqlString() : null;
            if (updateRowSql != null) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef(" Row update: %s", (Object)updateRowSql);
            }
            String string3 = deleteRowSql = (deleteRowOperation = this.getRowMutationOperations().getDeleteRowOperation()) != null ? deleteRowOperation.getSqlString() : null;
            if (deleteRowSql != null) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef(" Row delete: %s", (Object)deleteRowSql);
            }
            if ((deleteAllSql = this.getRemoveCoordinator().getSqlString()) != null) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef(" One-shot delete: %s", (Object)deleteAllSql);
            }
        }
    }

    @Override
    public void initialize(Object key, SharedSessionContractImplementor session) throws HibernateException {
        this.determineLoaderToUse(key, session).load(key, session);
    }

    private boolean hasNamedQueryLoader() {
        return this.queryLoaderName != null;
    }

    public CollectionLoader getCollectionLoader() {
        return this.collectionLoader;
    }

    protected CollectionLoader determineLoaderToUse(Object key, SharedSessionContractImplementor session) {
        CollectionLoader subSelectLoader;
        if (this.hasNamedQueryLoader()) {
            return this.getCollectionLoader();
        }
        LoadQueryInfluencers influencers = session.getLoadQueryInfluencers();
        if (influencers.effectiveSubselectFetchEnabled(this) && (subSelectLoader = this.resolveSubSelectLoader(key, session)) != null) {
            return subSelectLoader;
        }
        return this.attributeMapping.isAffectedByInfluencers(influencers, true) ? this.createCollectionLoader(influencers) : this.getCollectionLoader();
    }

    private CollectionLoader resolveSubSelectLoader(Object key, SharedSessionContractImplementor session) {
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        SubselectFetch subselect = persistenceContext.getBatchFetchQueue().getSubselect(session.generateEntityKey(key, this.getOwnerEntityPersister()));
        if (subselect == null) {
            return null;
        }
        subselect.getResultingEntityKeys().removeIf(entityKey -> !persistenceContext.containsEntity((EntityKey)entityKey));
        return this.createSubSelectLoader(subselect, session);
    }

    protected CollectionLoader createSubSelectLoader(SubselectFetch subselect, SharedSessionContractImplementor session) {
        return new CollectionLoaderSubSelectFetch(this.attributeMapping, null, subselect, session);
    }

    private CollectionLoader createCollectionLoader(LoadQueryInfluencers loadQueryInfluencers) {
        if (loadQueryInfluencers.effectivelyBatchLoadable(this)) {
            int batchSize = loadQueryInfluencers.effectiveBatchSize(this);
            return this.factory.getServiceRegistry().requireService(BatchLoaderFactory.class).createCollectionBatchLoader(batchSize, loadQueryInfluencers, this.attributeMapping, this.factory);
        }
        return this.createSingleKeyCollectionLoader(loadQueryInfluencers);
    }

    protected CollectionLoader createNamedQueryCollectionLoader(CollectionPersister persister, NamedQueryMemento<?> namedQueryMemento) {
        return new CollectionLoaderNamedQuery(persister, namedQueryMemento);
    }

    protected CollectionLoader createSingleKeyCollectionLoader(LoadQueryInfluencers loadQueryInfluencers) {
        return new CollectionLoaderSingleKey(this.attributeMapping, loadQueryInfluencers, this.factory);
    }

    @Override
    public CollectionDataAccess getCacheAccessStrategy() {
        return this.cacheAccessStrategy;
    }

    @Override
    public boolean hasCache() {
        return this.cacheAccessStrategy != null;
    }

    @Override
    public boolean useShallowQueryCacheLayout() {
        return this.useShallowQueryCacheLayout;
    }

    protected abstract RowMutationOperations getRowMutationOperations();

    protected abstract RemoveCoordinator getRemoveCoordinator();

    @Override
    public boolean hasOrdering() {
        return this.hasOrder;
    }

    @Override
    public boolean hasManyToManyOrdering() {
        return this.isManyToMany() && this.hasManyToManyOrder;
    }

    @Override
    public Class<?> getElementClass() {
        return this.elementClass;
    }

    protected Object incrementIndexByBase(Object index) {
        int baseIndex = this.attributeMapping.getIndexMetadata().getListIndexBase();
        return baseIndex > 0 ? Integer.valueOf(baseIndex + (Integer)index) : index;
    }

    @Override
    public boolean isPrimitiveArray() {
        return this.isPrimitiveArray;
    }

    @Override
    public boolean isArray() {
        return this.collectionSemantics.getCollectionClassification() == CollectionClassification.ARRAY;
    }

    @Override
    public String getIdentifierColumnName() {
        return this.hasId() ? this.identifierColumnName : null;
    }

    @Override
    public String selectFragment(String alias, String columnSuffix) {
        PluralAttributeMapping attributeMapping = this.getAttributeMapping();
        QuerySpec rootQuerySpec = new QuerySpec(true);
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), new LockOptions(), (fetchParent, creationState) -> ImmutableFetchList.EMPTY, true, new LoadQueryInfluencers(this.factory), this.factory.getSqlTranslationEngine());
        NavigablePath entityPath = new NavigablePath(attributeMapping.getRootPathName());
        TableGroup rootTableGroup = attributeMapping.createRootTableGroup(true, entityPath, null, new SqlAliasBaseConstant(alias), () -> p -> {}, sqlAstCreationState);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(entityPath, rootTableGroup);
        attributeMapping.createDomainResult(entityPath, rootTableGroup, null, sqlAstCreationState);
        SelectClause selectClause = rootQuerySpec.getSelectClause();
        List<SqlSelection> sqlSelections = selectClause.getSqlSelections();
        int i = 0;
        for (String keyAlias : this.keyColumnAliases) {
            sqlSelections.set(i, new SqlSelectionImpl(i, new AliasedExpression(sqlSelections.get(i).getExpression(), keyAlias + columnSuffix)));
            ++i;
        }
        if (this.hasIndex()) {
            for (String indexAlias : this.indexColumnAliases) {
                sqlSelections.set(i, new SqlSelectionImpl(i, new AliasedExpression(sqlSelections.get(i).getExpression(), indexAlias + columnSuffix)));
                ++i;
            }
        }
        if (this.hasId()) {
            sqlSelections.set(i, new SqlSelectionImpl(i, new AliasedExpression(sqlSelections.get(i).getExpression(), this.identifierColumnAlias + columnSuffix)));
            ++i;
        }
        int columnIndex = 0;
        while (i < sqlSelections.size()) {
            SqlSelection sqlSelection = sqlSelections.get(i);
            sqlSelections.set(i, new SqlSelectionImpl(sqlSelection.getValuesArrayPosition(), new AliasedExpression(sqlSelection.getExpression(), this.elementColumnAliases[columnIndex] + columnSuffix)));
            ++i;
            ++columnIndex;
        }
        String sql = this.getFactory().getJdbcServices().getDialect().getSqlAstTranslatorFactory().buildSelectTranslator(this.getFactory(), new SelectStatement(rootQuerySpec)).translate(null, QueryOptions.NONE).getSqlString();
        int fromIndex = sql.lastIndexOf(" from");
        return fromIndex != -1 ? sql.substring("select ".length(), fromIndex) : sql.substring("select ".length());
    }

    protected String generateSelectSizeString(boolean isIntegerIndexed) {
        String selectValue = isIntegerIndexed ? "max(" + this.getIndexColumnNames()[0] + ") + 1" : "count(" + this.getElementColumnNames()[0] + ")";
        return new SimpleSelect(this.getFactory()).setTableName(this.getTableName()).addRestriction(this.getKeyColumnNames()).addWhereToken(this.sqlWhereString).addColumn(selectValue).toStatementString();
    }

    protected String generateDetectRowByIndexString() {
        if (!this.hasIndex()) {
            return null;
        }
        return new SimpleSelect(this.getFactory()).setTableName(this.getTableName()).addRestriction(this.getKeyColumnNames()).addRestriction(this.getIndexColumnNames()).addRestriction(this.indexFormulas).addWhereToken(this.sqlWhereString).addColumn("1").toStatementString();
    }

    protected String generateDetectRowByElementString() {
        return new SimpleSelect(this.getFactory()).setTableName(this.getTableName()).addRestriction(this.getKeyColumnNames()).addRestriction(this.getElementColumnNames()).addRestriction(this.elementFormulas).addWhereToken(this.sqlWhereString).addColumn("1").toStatementString();
    }

    public String[] getIndexColumnNames() {
        return this.indexColumnNames;
    }

    public String[] getElementColumnNames() {
        return this.elementColumnNames;
    }

    public String[] getKeyColumnNames() {
        return this.keyColumnNames;
    }

    @Override
    public boolean hasIndex() {
        return this.collectionSemantics.getCollectionClassification().isIndexed();
    }

    private boolean hasId() {
        return this.collectionSemantics.getCollectionClassification() == CollectionClassification.ID_BAG;
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public boolean isInverse() {
        return this.isInverse;
    }

    @Override
    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    @Override
    public String getTableName() {
        return this.qualifiedTableName;
    }

    @Override
    public void remove(Object id, SharedSessionContractImplementor session) throws HibernateException {
        this.getRemoveCoordinator().deleteAllRows(id, session);
    }

    protected boolean isRowDeleteEnabled() {
        return this.keyIsUpdateable;
    }

    @Override
    public boolean needsRemove() {
        return !this.isInverse() && this.isRowDeleteEnabled();
    }

    protected boolean isRowInsertEnabled() {
        return this.keyIsUpdateable;
    }

    public String getOwnerEntityName() {
        return this.ownerPersister.getEntityName();
    }

    @Override
    public EntityPersister getOwnerEntityPersister() {
        return this.ownerPersister;
    }

    @Override
    @Deprecated
    public IdentifierGenerator getIdentifierGenerator() {
        return (IdentifierGenerator)this.identifierGenerator;
    }

    @Override
    public BeforeExecutionGenerator getGenerator() {
        return this.identifierGenerator;
    }

    @Override
    public boolean hasOrphanDelete() {
        return this.hasOrphanDelete;
    }

    @Override
    public void applyBaseRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, Map<String, Filter> enabledFilters, Set<String> treatAsDeclarations, SqlAstCreationState creationState) {
        this.applyBaseRestrictions(predicateConsumer, tableGroup, useQualifier, enabledFilters, false, treatAsDeclarations, creationState);
    }

    @Override
    public void applyBaseRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, Map<String, Filter> enabledFilters, boolean onlyApplyLoadByKeyFilters, Set<String> treatAsDeclarations, SqlAstCreationState creationState) {
        this.applyFilterRestrictions(predicateConsumer, tableGroup, useQualifier, enabledFilters, onlyApplyLoadByKeyFilters, creationState);
        this.applyWhereRestrictions(predicateConsumer, tableGroup, useQualifier, creationState);
    }

    @Override
    public boolean hasWhereRestrictions() {
        return this.hasWhere || this.manyToManyWhereTemplate != null;
    }

    @Override
    public void applyWhereRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, SqlAstCreationState creationState) {
        TableReference tableReference = this.isManyToMany() ? tableGroup.getPrimaryTableReference() : (this.elementPersister != null ? tableGroup.getTableReference(tableGroup.getNavigablePath(), this.elementPersister.getTableName()) : tableGroup.getTableReference(tableGroup.getNavigablePath(), this.qualifiedTableName));
        String alias = tableReference == null ? null : (useQualifier && tableReference.getIdentificationVariable() != null ? tableReference.getIdentificationVariable() : tableReference.getTableId());
        this.applyWhereFragments(predicateConsumer, alias, tableGroup, creationState);
    }

    protected void applyWhereFragments(Consumer<Predicate> predicateConsumer, String alias, TableGroup tableGroup, SqlAstCreationState astCreationState) {
        AbstractCollectionPersister.applyWhereFragments(predicateConsumer, alias, this.sqlWhereStringTemplate);
    }

    private static void applyWhereFragments(Consumer<Predicate> predicateConsumer, String alias, String template) {
        if (template == null) {
            return;
        }
        String fragment = StringHelper.replace(template, "{@}", alias);
        if (StringHelper.isEmpty(fragment)) {
            return;
        }
        predicateConsumer.accept(new SqlFragmentPredicate(fragment));
    }

    @Override
    public void applyFilterRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, Map<String, Filter> enabledFilters, boolean onlyApplyLoadByKeyFilters, SqlAstCreationState creationState) {
        if (this.filterHelper != null) {
            this.filterHelper.applyEnabledFilters(predicateConsumer, this.getFilterAliasGenerator(tableGroup), enabledFilters, onlyApplyLoadByKeyFilters, tableGroup, creationState);
        }
    }

    @Override
    public abstract boolean isManyToMany();

    @Override
    public void applyBaseManyToManyRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, Map<String, Filter> enabledFilters, Set<String> treatAsDeclarations, SqlAstCreationState creationState) {
        if (this.manyToManyFilterHelper == null && this.manyToManyWhereTemplate == null) {
            return;
        }
        if (this.manyToManyFilterHelper != null) {
            FilterAliasGenerator aliasGenerator = this.elementPersister.getFilterAliasGenerator(tableGroup);
            this.manyToManyFilterHelper.applyEnabledFilters(predicateConsumer, aliasGenerator, enabledFilters, false, tableGroup, creationState);
        }
        if (this.manyToManyWhereString != null) {
            TableReference tableReference = tableGroup.resolveTableReference(this.elementPersister.getTableName());
            String alias = tableReference == null ? null : (useQualifier && tableReference.getIdentificationVariable() != null ? tableReference.getIdentificationVariable() : tableReference.getTableId());
            AbstractCollectionPersister.applyWhereFragments(predicateConsumer, alias, this.manyToManyWhereTemplate);
        }
    }

    @Override
    public String getManyToManyFilterFragment(TableGroup tableGroup, Map<String, Filter> enabledFilters) {
        StringBuilder fragment = new StringBuilder();
        if (this.manyToManyFilterHelper != null) {
            this.manyToManyFilterHelper.render(fragment, this.elementPersister.getFilterAliasGenerator(tableGroup), enabledFilters);
        }
        if (this.manyToManyWhereString != null) {
            if (!fragment.isEmpty()) {
                fragment.append(" and ");
            }
            assert (this.elementPersister != null);
            fragment.append(StringHelper.replace(this.manyToManyWhereTemplate, "{@}", tableGroup.resolveTableReference(this.elementPersister.getTableName()).getIdentificationVariable()));
        }
        return fragment.toString();
    }

    @Override
    public EntityPersister getElementPersister() {
        if (this.elementPersister == null) {
            throw new AssertionFailure("not an association");
        }
        return this.elementPersister;
    }

    protected EntityPersister getElementPersisterInternal() {
        return this.elementPersister;
    }

    @Override
    public String[] getCollectionSpaces() {
        return this.spaces;
    }

    @Override
    public void processQueuedOps(PersistentCollection<?> collection, Object key, SharedSessionContractImplementor session) {
        if (collection.hasQueuedOperations()) {
            this.doProcessQueuedOps(collection, key, session);
        }
    }

    protected abstract void doProcessQueuedOps(PersistentCollection<?> var1, Object var2, SharedSessionContractImplementor var3) throws HibernateException;

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + "(" + this.navigableRole.getFullPath() + ")";
    }

    @Override
    public boolean isVersioned() {
        return this.isVersioned && this.getOwnerEntityPersister().isVersioned();
    }

    protected SqlExceptionHelper getSQLExceptionHelper() {
        return this.sqlExceptionHelper;
    }

    @Override
    public CacheEntryStructure getCacheEntryStructure() {
        return this.cacheEntryStructure;
    }

    @Override
    public boolean isAffectedByEnabledFilters(SharedSessionContractImplementor session) {
        return this.isAffectedByEnabledFilters(session.getLoadQueryInfluencers());
    }

    @Override
    public boolean isSubselectLoadable() {
        return this.subselectLoadable;
    }

    @Override
    public boolean isMutable() {
        return this.isMutable;
    }

    @Override
    public String[] getCollectionPropertyColumnAliases(String propertyName, String suffix) {
        String[] rawAliases = this.collectionPropertyColumnAliases.get(propertyName);
        if (rawAliases == null) {
            return null;
        }
        String[] result = new String[rawAliases.length];
        Alias alias = new Alias(suffix);
        for (int i = 0; i < rawAliases.length; ++i) {
            result[i] = alias.toUnquotedAliasString(rawAliases[i]);
        }
        return result;
    }

    public void initCollectionPropertyMap() {
        this.initCollectionPropertyMap("key", this.keyType, this.keyColumnAliases);
        this.initCollectionPropertyMap("element", this.elementType, this.elementColumnAliases);
        if (this.hasIndex()) {
            this.initCollectionPropertyMap("index", this.indexType, this.indexColumnAliases);
        }
        if (this.hasId()) {
            this.initCollectionPropertyMap("id", this.identifierType, new String[]{this.identifierColumnAlias});
        }
    }

    private void initCollectionPropertyMap(String aliasName, Type type, String[] columnAliases) {
        this.collectionPropertyColumnAliases.put(aliasName, columnAliases);
        if (type instanceof ComponentType || type instanceof AnyType) {
            CompositeType ct = (CompositeType)type;
            String[] propertyNames = ct.getPropertyNames();
            for (int i = 0; i < propertyNames.length; ++i) {
                String name = propertyNames[i];
                this.collectionPropertyColumnAliases.put(aliasName + "." + name, new String[]{columnAliases[i]});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getSize(Object key, SharedSessionContractImplementor session) {
        try {
            JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
            PreparedStatement st = jdbcCoordinator.getStatementPreparer().prepareStatement(this.sqlSelectSizeString);
            try {
                this.getKeyType().nullSafeSet(st, key, 1, session);
                ResultSet rs = jdbcCoordinator.getResultSetReturn().extract(st, this.sqlSelectSizeString);
                try {
                    int baseIndex = Math.max(this.attributeMapping.getIndexMetadata().getListIndexBase(), 0);
                    int n = rs.next() ? rs.getInt(1) - baseIndex : 0;
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                    return n;
                }
                catch (Throwable throwable) {
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                    throw throwable;
                }
            }
            finally {
                jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
                jdbcCoordinator.afterStatementExecution();
            }
        }
        catch (SQLException sqle) {
            throw this.getSQLExceptionHelper().convert(sqle, "could not retrieve collection size: " + MessageHelper.collectionInfoString((CollectionPersister)this, key, this.getFactory()), this.sqlSelectSizeString);
        }
    }

    @Override
    public boolean indexExists(Object key, Object index, SharedSessionContractImplementor session) {
        return this.exists(key, this.incrementIndexByBase(index), this.getIndexType(), this.sqlDetectRowByIndexString, session);
    }

    @Override
    public boolean elementExists(Object key, Object element, SharedSessionContractImplementor session) {
        return this.exists(key, element, this.getElementType(), this.sqlDetectRowByElementString, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean exists(Object key, Object indexOrElement, Type indexOrElementType, String sql, SharedSessionContractImplementor session) {
        try {
            JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
            PreparedStatement st = jdbcCoordinator.getStatementPreparer().prepareStatement(sql);
            try {
                this.getKeyType().nullSafeSet(st, key, 1, session);
                indexOrElementType.nullSafeSet(st, indexOrElement, this.keyColumnNames.length + 1, session);
                ResultSet rs = jdbcCoordinator.getResultSetReturn().extract(st, sql);
                try {
                    boolean bl = rs.next();
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                        throw throwable;
                    }
                    catch (TransientObjectException e) {
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            finally {
                jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
                jdbcCoordinator.afterStatementExecution();
            }
        }
        catch (SQLException sqle) {
            throw this.getSQLExceptionHelper().convert(sqle, "could not check row existence: " + MessageHelper.collectionInfoString((CollectionPersister)this, key, this.getFactory()), this.sqlSelectSizeString);
        }
    }

    @Override
    public Object getElementByIndex(Object key, Object index, SharedSessionContractImplementor session, Object owner) {
        LoadQueryInfluencers influencers = session.getLoadQueryInfluencers();
        if (this.isAffectedByFilters(new HashSet<ManagedMappingType>(), this.attributeMapping.getElementDescriptor(), influencers, true)) {
            return new CollectionElementLoaderByIndex(this.attributeMapping, influencers, this.factory).load(key, index, session);
        }
        return this.collectionElementLoaderByIndex.load(key, index, session);
    }

    @Override
    public boolean isExtraLazy() {
        return this.isExtraLazy;
    }

    protected Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public String getMappedByProperty() {
        return this.mappedByProperty;
    }

    public abstract FilterAliasGenerator getFilterAliasGenerator(String var1);

    public abstract FilterAliasGenerator getFilterAliasGenerator(TableGroup var1);

    @Override
    public void injectAttributeMapping(PluralAttributeMapping attributeMapping) {
        this.attributeMapping = attributeMapping;
    }

    @Override
    public PluralAttributeMapping getAttributeMapping() {
        return this.attributeMapping;
    }

    @Override
    public void registerAffectingFetchProfile(String fetchProfileName) {
        if (this.affectingFetchProfiles == null) {
            this.affectingFetchProfiles = new HashSet<String>();
        }
        this.affectingFetchProfiles.add(fetchProfileName);
    }

    @Override
    public boolean isAffectedByEnabledFetchProfiles(LoadQueryInfluencers influencers) {
        if (this.affectingFetchProfiles != null && influencers.hasEnabledFetchProfiles()) {
            for (String profileName : this.affectingFetchProfiles) {
                if (!influencers.isFetchProfileEnabled(profileName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAffectedByEnabledFilters(LoadQueryInfluencers influencers) {
        return this.isAffectedByEnabledFilters(influencers, false);
    }

    @Override
    public boolean isAffectedByEnabledFilters(LoadQueryInfluencers influencers, boolean onlyApplyForLoadByKeyFilters) {
        if (influencers.hasEnabledFilters()) {
            Map<String, Filter> enabledFilters = influencers.getEnabledFilters();
            return this.filterHelper != null && this.filterHelper.isAffectedBy(enabledFilters) || this.manyToManyFilterHelper != null && this.manyToManyFilterHelper.isAffectedBy(enabledFilters) || this.isKeyOrElementAffectedByFilters(new HashSet<ManagedMappingType>(), influencers, onlyApplyForLoadByKeyFilters);
        }
        return false;
    }

    @Override
    public boolean isAffectedByEnabledFilters(Set<ManagedMappingType> visitedTypes, LoadQueryInfluencers influencers, boolean onlyApplyForLoadByKeyFilters) {
        if (influencers.hasEnabledFilters()) {
            Map<String, Filter> enabledFilters = influencers.getEnabledFilters();
            return this.filterHelper != null && this.filterHelper.isAffectedBy(enabledFilters) || this.manyToManyFilterHelper != null && this.manyToManyFilterHelper.isAffectedBy(enabledFilters) || this.isKeyOrElementAffectedByFilters(visitedTypes, influencers, onlyApplyForLoadByKeyFilters);
        }
        return false;
    }

    private boolean isKeyOrElementAffectedByFilters(Set<ManagedMappingType> visitedTypes, LoadQueryInfluencers influencers, boolean onlyApplyForLoadByKey) {
        return this.isAffectedByFilters(visitedTypes, this.attributeMapping.getIndexDescriptor(), influencers, onlyApplyForLoadByKey) || this.isAffectedByFilters(visitedTypes, this.attributeMapping.getElementDescriptor(), influencers, onlyApplyForLoadByKey);
    }

    private boolean isAffectedByFilters(Set<ManagedMappingType> visitedTypes, CollectionPart collectionPart, LoadQueryInfluencers influencers, boolean onlyApplyForLoadByKey) {
        if (collectionPart instanceof EntityCollectionPart) {
            EntityCollectionPart entityCollectionPart = (EntityCollectionPart)collectionPart;
            return entityCollectionPart.getEntityMappingType().isAffectedByEnabledFilters(visitedTypes, influencers, onlyApplyForLoadByKey);
        }
        if (collectionPart instanceof EmbeddedCollectionPart) {
            EmbeddedCollectionPart embeddedCollectionPart = (EmbeddedCollectionPart)collectionPart;
            EmbeddableMappingType type = embeddedCollectionPart.getEmbeddableTypeDescriptor();
            return type.isAffectedByEnabledFilters(visitedTypes, influencers, onlyApplyForLoadByKey);
        }
        return false;
    }

    @Override
    public boolean isAffectedByEntityGraph(LoadQueryInfluencers influencers) {
        return false;
    }

    @Override
    public CollectionSemantics<?, ?> getCollectionSemantics() {
        return this.collectionSemantics;
    }

    @Override
    public PluralAttributeMapping getTargetPart() {
        return this.attributeMapping;
    }

    @Override
    public String getIdentifierTableName() {
        return this.tableMapping.getTableName();
    }

    @Override
    public CollectionTableMapping getCollectionTableMapping() {
        return this.tableMapping;
    }

    @Override
    public boolean hasPhysicalIndexColumn() {
        return this.hasIndex() && !this.indexContainsFormula;
    }

    @Override
    public void forEachMutableTable(Consumer<CollectionTableMapping> consumer) {
        consumer.accept(this.tableMapping);
    }

    @Override
    public void forEachMutableTableReverse(Consumer<CollectionTableMapping> consumer) {
        consumer.accept(this.tableMapping);
    }

    private static CollectionTableMapping buildCollectionTableMapping(Collection collectionBootDescriptor, String qualifiedTableName, String[] spaces) {
        return new CollectionTableMapping(qualifiedTableName, spaces, !collectionBootDescriptor.isOneToMany(), collectionBootDescriptor.isInverse(), new TableMapping.MutationDetails(MutationType.INSERT, Expectations.createExpectation(collectionBootDescriptor.getInsertExpectation(), collectionBootDescriptor.isCustomInsertCallable()), collectionBootDescriptor.getCustomSQLInsert(), collectionBootDescriptor.isCustomInsertCallable()), new TableMapping.MutationDetails(MutationType.UPDATE, Expectations.createExpectation(collectionBootDescriptor.getUpdateExpectation(), collectionBootDescriptor.isCustomUpdateCallable()), collectionBootDescriptor.getCustomSQLUpdate(), collectionBootDescriptor.isCustomUpdateCallable()), collectionBootDescriptor.getKey().isCascadeDeleteEnabled(), new TableMapping.MutationDetails(MutationType.DELETE, collectionBootDescriptor.isCustomDeleteAllCallable() || collectionBootDescriptor.getDeleteAllExpectation() != null ? Expectations.createExpectation(collectionBootDescriptor.getDeleteAllExpectation(), collectionBootDescriptor.isCustomDeleteAllCallable()) : new Expectation.None(), collectionBootDescriptor.getCustomSQLDeleteAll(), collectionBootDescriptor.isCustomDeleteAllCallable()), new TableMapping.MutationDetails(MutationType.DELETE, Expectations.createExpectation(collectionBootDescriptor.getDeleteExpectation(), collectionBootDescriptor.isCustomDeleteCallable()), collectionBootDescriptor.getCustomSQLDelete(), collectionBootDescriptor.isCustomDeleteCallable()));
    }

    protected JdbcMutationOperation buildDeleteAllOperation(MutatingTableReference tableReference) {
        return this.tableMapping.getDeleteDetails().getCustomSql() != null ? this.buildCustomSqlDeleteAllOperation(tableReference) : this.buildGeneratedDeleteAllOperation(tableReference);
    }

    private JdbcDeleteMutation buildCustomSqlDeleteAllOperation(MutatingTableReference tableReference) {
        PluralAttributeMapping attributeMapping = this.getAttributeMapping();
        ForeignKeyDescriptor keyDescriptor = attributeMapping.getKeyDescriptor();
        ColumnValueParameterList parameterBinders = new ColumnValueParameterList(tableReference, ParameterUsage.RESTRICT, keyDescriptor.getJdbcTypeCount());
        keyDescriptor.getKeyPart().forEachSelectable(parameterBinders);
        TableMapping tableMapping = tableReference.getTableMapping();
        return new JdbcDeleteMutation(tableMapping, this, tableMapping.getDeleteDetails().getCustomSql(), tableMapping.getDeleteDetails().isCallable(), tableMapping.getDeleteDetails().getExpectation(), parameterBinders);
    }

    private JdbcMutationOperation buildGeneratedDeleteAllOperation(MutatingTableReference tableReference) {
        return this.getFactory().getJdbcServices().getDialect().getSqlAstTranslatorFactory().buildModelMutationTranslator(this.generateDeleteAllAst(tableReference), this.getFactory()).translate(null, MutationQueryOptions.INSTANCE);
    }

    public RestrictedTableMutation<JdbcMutationOperation> generateDeleteAllAst(MutatingTableReference tableReference) {
        assert (this.getAttributeMapping() != null);
        ForeignKeyDescriptor fkDescriptor = this.getAttributeMapping().getKeyDescriptor();
        assert (fkDescriptor != null);
        int keyColumnCount = fkDescriptor.getJdbcTypeCount();
        ColumnValueParameterList parameterBinders = new ColumnValueParameterList(tableReference, ParameterUsage.RESTRICT, keyColumnCount);
        ArrayList<ColumnValueBinding> restrictionBindings = CollectionHelper.arrayList(keyColumnCount);
        this.applyKeyRestrictions(tableReference, parameterBinders, restrictionBindings);
        return new TableDeleteStandard(tableReference, this, "one-shot delete for " + this.getRolePath(), restrictionBindings, Collections.emptyList(), parameterBinders, this.sqlWhereString);
    }

    protected void applyKeyRestrictions(MutatingTableReference tableReference, ColumnValueParameterList parameterList, List<ColumnValueBinding> restrictionBindings) {
        ForeignKeyDescriptor fkDescriptor = this.getAttributeMapping().getKeyDescriptor();
        assert (fkDescriptor != null);
        fkDescriptor.getKeyPart().forEachSelectable(parameterList);
        for (ColumnValueParameter columnValueParameter : parameterList) {
            ColumnReference columnReference = columnValueParameter.getColumnReference();
            restrictionBindings.add(new ColumnValueBinding(columnReference, new ColumnWriteFragment("?", columnValueParameter, columnReference.getJdbcMapping())));
        }
    }

    @Override
    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    @Override
    public Type getKeyType() {
        return this.keyType;
    }

    @Override
    public Type getIdentifierType() {
        return this.identifierType;
    }

    @Override
    public Type getIndexType() {
        return this.indexType;
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public String[] getKeyColumnAliases(String suffix) {
        return new Alias(suffix).toAliasStrings(this.keyColumnAliases);
    }

    @Override
    public String[] getElementColumnAliases(String suffix) {
        return new Alias(suffix).toAliasStrings(this.elementColumnAliases);
    }

    @Override
    public String[] getIndexColumnAliases(String suffix) {
        return this.hasIndex() ? new Alias(suffix).toAliasStrings(this.indexColumnAliases) : null;
    }

    @Override
    public String getIdentifierColumnAlias(String suffix) {
        return this.hasId() ? new Alias(suffix).toAliasString(this.identifierColumnAlias) : null;
    }
}

