/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.Remove;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.type.AnyType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MappingContext;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.SpecialOneToOneType;
import org.hibernate.type.Type;

@Deprecated(since="6", forRemoval=true)
@Remove
class EntityPropertyMapping {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EntityPropertyMapping.class);
    private final Map<String, Type> typesByPropertyPath = new HashMap<String, Type>();
    private final AbstractEntityPersister persister;
    private Set<String> duplicateIncompatiblePaths = null;
    private final Map<String, String[]> columnsByPropertyPath = new HashMap<String, String[]>();
    private final Map<String, String[]> columnReadersByPropertyPath = new HashMap<String, String[]>();
    private final Map<String, String[]> columnReaderTemplatesByPropertyPath = new HashMap<String, String[]>();

    public EntityPropertyMapping(AbstractEntityPersister persister) {
        this.persister = persister;
    }

    public String[] getIdentifierColumnNames() {
        return this.persister.getIdentifierColumnNames();
    }

    public String[] getIdentifierColumnReaders() {
        return this.persister.getIdentifierColumnReaders();
    }

    public String[] getIdentifierColumnReaderTemplates() {
        return this.persister.getIdentifierColumnReaderTemplates();
    }

    protected String getEntityName() {
        return this.persister.getEntityName();
    }

    public Type toType(String propertyName) throws QueryException {
        Type type = this.typesByPropertyPath.get(propertyName);
        if (type == null) {
            throw this.propertyException(propertyName);
        }
        return type;
    }

    protected final QueryException propertyException(String propertyName) throws QueryException {
        return new QueryException("Could not resolve property: " + propertyName + " of: " + this.getEntityName());
    }

    public String[] getColumnNames(String propertyName) {
        String[] cols = this.columnsByPropertyPath.get(propertyName);
        if (cols == null) {
            throw new MappingException("Unknown property: " + propertyName);
        }
        return cols;
    }

    private void logDuplicateRegistration(String path, Type existingType, Type type) {
    }

    private void logIncompatibleRegistration(String path, Type existingType, Type type) {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Skipped adding attribute [{1}] to base type [{0}] as more than one subtype defined the attribute using incompatible types (strictly speaking the attributes are not inherited); existing type = [{2}], incoming type = [{3}]", this.getEntityName(), path, existingType, type);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void addPropertyPath(String path, Type type, String[] columns, String[] columnReaders, String[] columnReaderTemplates, Metadata factory) {
        block9: {
            block7: {
                block12: {
                    block11: {
                        block10: {
                            block8: {
                                existingType = this.typesByPropertyPath.get(path);
                                if (existingType == null && (this.duplicateIncompatiblePaths == null || !this.duplicateIncompatiblePaths.contains(path))) break block7;
                                if (type != existingType && existingType != null && type instanceof AssociationType) break block8;
                                this.logDuplicateRegistration(path, existingType, type);
                                break block9;
                            }
                            if (existingType instanceof AssociationType) break block10;
                            this.logDuplicateRegistration(path, existingType, type);
                            break block9;
                        }
                        if (type instanceof AnyType && existingType instanceof AnyType) break block9;
                        commonType = null;
                        metadata = (MetadataImplementor)factory;
                        if (!(type instanceof CollectionType) || !(existingType instanceof CollectionType)) break block11;
                        thisCollection = metadata.getCollectionBinding(((CollectionType)existingType).getRole());
                        if (thisCollection.isSame(otherCollection = metadata.getCollectionBinding(((CollectionType)type).getRole()))) {
                            this.logDuplicateRegistration(path, existingType, type);
                            return;
                        }
                        this.logIncompatibleRegistration(path, existingType, type);
                        break block12;
                    }
                    if (!(type instanceof EntityType)) ** GOTO lbl-1000
                    entityType2 = (EntityType)type;
                    if (existingType instanceof EntityType) {
                        entityType1 = (EntityType)existingType;
                        if (entityType1.getAssociatedEntityName().equals(entityType2.getAssociatedEntityName())) {
                            this.logDuplicateRegistration(path, existingType, type);
                            return;
                        }
                        commonType = this.getCommonType(metadata, entityType1, entityType2);
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.logIncompatibleRegistration(path, existingType, type);
                    }
                }
                if (commonType == null) {
                    if (this.duplicateIncompatiblePaths == null) {
                        this.duplicateIncompatiblePaths = new HashSet<String>();
                    }
                    this.duplicateIncompatiblePaths.add(path);
                    this.typesByPropertyPath.remove(path);
                    empty = ArrayHelper.EMPTY_STRING_ARRAY;
                    this.columnsByPropertyPath.put(path, empty);
                    this.columnReadersByPropertyPath.put(path, empty);
                    this.columnReaderTemplatesByPropertyPath.put(path, empty);
                } else {
                    this.typesByPropertyPath.put(path, commonType);
                }
                break block9;
            }
            this.typesByPropertyPath.put(path, type);
            this.columnsByPropertyPath.put(path, columns);
            this.columnReadersByPropertyPath.put(path, columnReaders);
            this.columnReaderTemplatesByPropertyPath.put(path, columnReaderTemplates);
        }
    }

    private Type getCommonType(MetadataImplementor metadata, EntityType entityType1, EntityType entityType2) {
        PersistentClass otherClass;
        PersistentClass thisClass = metadata.getEntityBinding(entityType1.getAssociatedEntityName());
        PersistentClass commonClass = this.getCommonPersistentClass(thisClass, otherClass = metadata.getEntityBinding(entityType2.getAssociatedEntityName()));
        if (commonClass == null) {
            return null;
        }
        if (entityType1 instanceof ManyToOneType) {
            ManyToOneType manyToOneType = (ManyToOneType)entityType1;
            return new ManyToOneType(manyToOneType, commonClass.getEntityName());
        }
        if (entityType1 instanceof SpecialOneToOneType) {
            SpecialOneToOneType specialOneToOneType = (SpecialOneToOneType)entityType1;
            return new SpecialOneToOneType(specialOneToOneType, commonClass.getEntityName());
        }
        if (entityType1 instanceof OneToOneType) {
            OneToOneType oneToOneType = (OneToOneType)entityType1;
            return new OneToOneType(oneToOneType, commonClass.getEntityName());
        }
        throw new IllegalStateException("Unexpected entity type: " + String.valueOf(entityType1));
    }

    private PersistentClass getCommonPersistentClass(PersistentClass clazz1, PersistentClass clazz2) {
        while (clazz2 != null && clazz2.getMappedClass() != null && clazz1.getMappedClass() != null && !clazz2.getMappedClass().isAssignableFrom(clazz1.getMappedClass())) {
            clazz2 = clazz2.getSuperclass();
        }
        return clazz2;
    }

    protected void initPropertyPaths(String path, Type type, String[] columns, String[] columnReaders, String[] columnReaderTemplates, String[] formulaTemplates, Metadata factory) throws MappingException {
        AssociationType actype;
        assert (columns != null) : "Incoming columns should not be null : " + path;
        assert (type != null) : "Incoming type should not be null : " + path;
        if (columns.length != type.getColumnSpan(factory)) {
            throw new MappingException("broken column mapping for: " + path + " of: " + this.getEntityName());
        }
        if (type instanceof AnyType || type instanceof CollectionType || type instanceof EntityType) {
            actype = (AssociationType)type;
            if (actype.useLHSPrimaryKey()) {
                columns = this.getIdentifierColumnNames();
                columnReaders = this.getIdentifierColumnReaders();
                columnReaderTemplates = this.getIdentifierColumnReaderTemplates();
            } else {
                String foreignKeyProperty = actype.getLHSPropertyName();
                if (foreignKeyProperty != null && !path.equals(foreignKeyProperty)) {
                    columns = this.columnsByPropertyPath.get(foreignKeyProperty);
                    if (columns == null) {
                        return;
                    }
                    columnReaders = this.columnReadersByPropertyPath.get(foreignKeyProperty);
                    columnReaderTemplates = this.columnReaderTemplatesByPropertyPath.get(foreignKeyProperty);
                }
            }
        }
        if (path != null) {
            this.addPropertyPath(path, type, columns, columnReaders, columnReaderTemplates, factory);
        }
        if (type instanceof AnyType) {
            actype = (AnyType)type;
            this.initComponentPropertyPaths(path, (CompositeType)((Object)actype), columns, columnReaders, columnReaderTemplates, formulaTemplates, factory);
        } else if (type instanceof ComponentType) {
            ComponentType actype2 = (ComponentType)type;
            this.initComponentPropertyPaths(path, actype2, columns, columnReaders, columnReaderTemplates, formulaTemplates, factory);
            if (actype2.isEmbedded()) {
                this.initComponentPropertyPaths(path == null ? null : StringHelper.qualifier(path), actype2, columns, columnReaders, columnReaderTemplates, formulaTemplates, factory);
            }
        } else if (type instanceof EntityType) {
            this.initIdentifierPropertyPaths(path, (EntityType)type, columns, columnReaders, columnReaderTemplates, formulaTemplates != null && formulaTemplates.length > 0 ? formulaTemplates : null, factory);
        }
    }

    protected void initIdentifierPropertyPaths(String path, EntityType etype, String[] columns, String[] columnReaders, String[] columnReaderTemplates, String[] formulaTemplates, Metadata factory) throws MappingException {
        Type idtype = etype.getIdentifierOrUniqueKeyType(factory);
        String idPropName = etype.getIdentifierOrUniqueKeyPropertyName(factory);
        boolean hasNonIdentifierPropertyNamedId = this.hasNonIdentifierPropertyNamedId(etype, factory);
        if (etype.isReferenceToPrimaryKey() && !hasNonIdentifierPropertyNamedId) {
            String idpath1 = EntityPropertyMapping.extendPath(path, "id");
            this.addPropertyPath(idpath1, idtype, columns, columnReaders, columnReaderTemplates, factory);
            this.initPropertyPaths(idpath1, idtype, columns, columnReaders, columnReaderTemplates, formulaTemplates, factory);
        }
        if (!etype.isNullable() && idPropName != null) {
            String idpath2 = EntityPropertyMapping.extendPath(path, idPropName);
            this.addPropertyPath(idpath2, idtype, columns, columnReaders, columnReaderTemplates, factory);
            this.initPropertyPaths(idpath2, idtype, columns, columnReaders, columnReaderTemplates, formulaTemplates, factory);
        }
    }

    private boolean hasNonIdentifierPropertyNamedId(EntityType entityType, MappingContext factory) {
        try {
            return factory.getReferencedPropertyType(entityType.getAssociatedEntityName(), "id") != null;
        }
        catch (MappingException e) {
            return false;
        }
    }

    protected void initComponentPropertyPaths(String path, CompositeType type, String[] columns, String[] columnReaders, String[] columnReaderTemplates, String[] formulaTemplates, Metadata factory) throws MappingException {
        Type[] types = type.getSubtypes();
        String[] properties = type.getPropertyNames();
        int begin = 0;
        for (int i = 0; i < properties.length; ++i) {
            String subpath = EntityPropertyMapping.extendPath(path, properties[i]);
            try {
                int length = types[i].getColumnSpan(factory);
                String[] columnSlice = ArrayHelper.slice(columns, begin, length);
                String[] columnReaderSlice = ArrayHelper.slice(columnReaders, begin, length);
                String[] columnReaderTemplateSlice = ArrayHelper.slice(columnReaderTemplates, begin, length);
                String[] formulaSlice = formulaTemplates == null ? null : ArrayHelper.slice(formulaTemplates, begin, length);
                this.initPropertyPaths(subpath, types[i], columnSlice, columnReaderSlice, columnReaderTemplateSlice, formulaSlice, factory);
                begin += length;
                continue;
            }
            catch (Exception e) {
                throw new MappingException("bug in initComponentPropertyPaths", e);
            }
        }
    }

    private static String extendPath(String path, String property) {
        return StringHelper.isEmpty(path) ? property : StringHelper.qualify(path, property);
    }
}

