/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmEntityDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmPluralPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmSingularPersistentAttribute;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmPolymorphicRootDescriptor<T>
implements SqmEntityDomainType<T> {
    private final Set<EntityDomainType<? extends T>> implementors;
    private final Map<String, SqmPersistentAttribute<? super T, ?>> commonAttributes;
    private final JavaType<T> polymorphicJavaType;
    private final JpaMetamodel jpaMetamodel;

    public SqmPolymorphicRootDescriptor(JavaType<T> polymorphicJavaType, Set<EntityDomainType<? extends T>> implementors, JpaMetamodel jpaMetamodel) {
        this.polymorphicJavaType = polymorphicJavaType;
        this.jpaMetamodel = jpaMetamodel;
        this.implementors = new TreeSet<EntityDomainType>(Comparator.comparing(ManagedDomainType::getTypeName));
        this.implementors.addAll(implementors);
        this.commonAttributes = Collections.unmodifiableMap(this.inferCommonAttributes(implementors));
    }

    @Override
    public JpaMetamodel getMetamodel() {
        return this.jpaMetamodel;
    }

    private Map<String, SqmPersistentAttribute<? super T, ?>> inferCommonAttributes(Set<EntityDomainType<? extends T>> implementors) {
        HashMap workMap = new HashMap();
        ArrayList<EntityDomainType<T>> implementorsList = new ArrayList<EntityDomainType<T>>(implementors);
        EntityDomainType<T> firstImplementor = implementorsList.get(0);
        if (implementorsList.size() == 1) {
            firstImplementor.visitAttributes((? super PersistentAttribute<? super J, ?> attribute) -> workMap.put(attribute.getName(), this.promote((PersistentAttribute<?, ?>)attribute)));
        } else {
            List<EntityDomainType<? extends T>> subList = implementorsList.subList(1, implementors.size() - 1);
            firstImplementor.visitAttributes((? super PersistentAttribute<? super J, ?> attribute) -> {
                if (SqmPolymorphicRootDescriptor.isACommonAttribute(subList, attribute)) {
                    workMap.put(attribute.getName(), this.promote((PersistentAttribute<?, ?>)attribute));
                }
            });
        }
        return workMap;
    }

    private SqmPersistentAttribute<? super T, ?> promote(PersistentAttribute<?, ?> attribute) {
        return (SqmPersistentAttribute)attribute;
    }

    private static boolean isACommonAttribute(List<EntityDomainType<?>> subList, PersistentAttribute<?, ?> attribute) {
        for (EntityDomainType<?> navigable : subList) {
            if (navigable.findAttribute(attribute.getName()) != null) continue;
            return false;
        }
        return true;
    }

    public Set<EntityDomainType<? extends T>> getImplementors() {
        return this.implementors;
    }

    @Override
    public Class<T> getBindableJavaType() {
        return this.polymorphicJavaType.getJavaTypeClass();
    }

    @Override
    public String getName() {
        return this.polymorphicJavaType.getTypeName();
    }

    @Override
    public String getHibernateEntityName() {
        return this.getName();
    }

    @Override
    public String getTypeName() {
        return this.getName();
    }

    @Override
    public String getPathName() {
        return this.getName();
    }

    @Override
    public SqmDomainType<T> getPathType() {
        return this;
    }

    @Override
    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.ENTITY_TYPE;
    }

    @Override
    public Class<T> getJavaType() {
        return this.polymorphicJavaType.getJavaTypeClass();
    }

    @Override
    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.ENTITY;
    }

    @Override
    public JavaType<T> getExpressibleJavaType() {
        return this.polymorphicJavaType;
    }

    @Override
    public SqmPersistentAttribute<? super T, ?> findAttribute(String name) {
        return this.commonAttributes.get(name);
    }

    @Override
    public SqmPersistentAttribute<?, ?> findSubTypesAttribute(String name) {
        return this.commonAttributes.get(name);
    }

    @Override
    public void visitAttributes(Consumer<? super PersistentAttribute<? super T, ?>> action) {
        this.commonAttributes.values().forEach(action);
    }

    @Override
    public void visitDeclaredAttributes(Consumer<? super PersistentAttribute<T, ?>> action) {
    }

    @Override
    public SqmPersistentAttribute<? super T, ?> getAttribute(String name) {
        PersistentAttribute attribute = this.findAttribute(name);
        if (attribute == null) {
            throw new IllegalArgumentException();
        }
        return attribute;
    }

    @Override
    public SqmPersistentAttribute<T, ?> getDeclaredAttribute(String name) {
        throw new IllegalArgumentException();
    }

    @Override
    public SqmSingularPersistentAttribute<? super T, ?> findSingularAttribute(String name) {
        return (SqmSingularPersistentAttribute)this.findAttribute(name);
    }

    @Override
    public SqmPluralPersistentAttribute<? super T, ?, ?> findPluralAttribute(String name) {
        return (SqmPluralPersistentAttribute)this.findAttribute(name);
    }

    @Override
    public SqmPersistentAttribute<? super T, ?> findConcreteGenericAttribute(String name) {
        return null;
    }

    @Override
    public SqmPersistentAttribute<T, ?> findDeclaredAttribute(String name) {
        return null;
    }

    @Override
    public SqmSingularPersistentAttribute<T, ?> findDeclaredSingularAttribute(String name) {
        return null;
    }

    @Override
    public SqmPluralPersistentAttribute<T, ?, ?> findDeclaredPluralAttribute(String name) {
        return null;
    }

    @Override
    public SqmPersistentAttribute<T, ?> findDeclaredConcreteGenericAttribute(String name) {
        return null;
    }

    @Override
    public Set<Attribute<? super T, ?>> getAttributes() {
        return new HashSet(this.commonAttributes.values());
    }

    @Override
    public Set<Attribute<T, ?>> getDeclaredAttributes() {
        return Collections.emptySet();
    }

    @Override
    public <Y> SingularAttribute<? super T, Y> getSingularAttribute(String name, Class<Y> type) {
        return (SingularAttribute)((Object)this.getAttribute(name));
    }

    @Override
    public <Y> SingularAttribute<T, Y> getDeclaredSingularAttribute(String name, Class<Y> type) {
        return (SingularAttribute)((Object)this.getDeclaredAttribute(name));
    }

    @Override
    public Set<SingularAttribute<? super T, ?>> getSingularAttributes() {
        HashSet singularAttributes = new HashSet();
        for (PersistentAttribute persistentAttribute : this.commonAttributes.values()) {
            if (!(persistentAttribute instanceof SingularAttribute)) continue;
            singularAttributes.add((SingularPersistentAttribute)persistentAttribute);
        }
        return singularAttributes;
    }

    @Override
    public Set<SingularAttribute<T, ?>> getDeclaredSingularAttributes() {
        return Collections.emptySet();
    }

    @Override
    public <E> CollectionAttribute<? super T, E> getCollection(String name, Class<E> elementType) {
        return (CollectionAttribute)((Object)this.getAttribute(name));
    }

    @Override
    public <E> CollectionAttribute<T, E> getDeclaredCollection(String name, Class<E> elementType) {
        throw new IllegalArgumentException();
    }

    @Override
    public <E> SetAttribute<? super T, E> getSet(String name, Class<E> elementType) {
        return (SetAttribute)((Object)this.getAttribute(name));
    }

    @Override
    public <E> SetAttribute<T, E> getDeclaredSet(String name, Class<E> elementType) {
        throw new IllegalArgumentException();
    }

    @Override
    public <E> ListAttribute<? super T, E> getList(String name, Class<E> elementType) {
        return (ListAttribute)((Object)this.getAttribute(name));
    }

    @Override
    public <E> ListAttribute<T, E> getDeclaredList(String name, Class<E> elementType) {
        throw new IllegalArgumentException();
    }

    @Override
    public <K, V> MapAttribute<? super T, K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        return (MapAttribute)((Object)this.getAttribute(name));
    }

    @Override
    public <K, V> MapAttribute<T, K, V> getDeclaredMap(String name, Class<K> keyType, Class<V> valueType) {
        throw new IllegalArgumentException();
    }

    @Override
    public Set<PluralAttribute<? super T, ?, ?>> getPluralAttributes() {
        HashSet pluralAttributes = new HashSet();
        for (PersistentAttribute persistentAttribute : this.commonAttributes.values()) {
            if (!(persistentAttribute instanceof PluralAttribute)) continue;
            pluralAttributes.add((PluralPersistentAttribute)persistentAttribute);
        }
        return pluralAttributes;
    }

    @Override
    public Set<PluralAttribute<T, ?, ?>> getDeclaredPluralAttributes() {
        return Collections.emptySet();
    }

    @Override
    public SingularAttribute<? super T, ?> getSingularAttribute(String name) {
        return (SqmSingularPersistentAttribute)this.getAttribute(name);
    }

    @Override
    public SingularAttribute<T, ?> getDeclaredSingularAttribute(String name) {
        throw new IllegalArgumentException();
    }

    @Override
    public CollectionAttribute<? super T, ?> getCollection(String name) {
        return (CollectionAttribute)((Object)this.getAttribute(name));
    }

    @Override
    public CollectionAttribute<T, ?> getDeclaredCollection(String name) {
        throw new IllegalArgumentException();
    }

    @Override
    public SetAttribute<? super T, ?> getSet(String name) {
        return (SetAttribute)((Object)this.getAttribute(name));
    }

    @Override
    public SetAttribute<T, ?> getDeclaredSet(String name) {
        throw new IllegalArgumentException();
    }

    @Override
    public ListAttribute<? super T, ?> getList(String name) {
        return (ListAttribute)((Object)this.getAttribute(name));
    }

    @Override
    public ListAttribute<T, ?> getDeclaredList(String name) {
        throw new IllegalArgumentException();
    }

    @Override
    public MapAttribute<? super T, ?, ?> getMap(String name) {
        return (MapAttribute)((Object)this.getAttribute(name));
    }

    @Override
    public MapAttribute<T, ?, ?> getDeclaredMap(String name) {
        throw new IllegalArgumentException();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        return (SqmPathSource)((Object)this.findAttribute(name));
    }

    @Override
    public SqmPath<T> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RepresentationMode getRepresentationMode() {
        return RepresentationMode.POJO;
    }

    @Override
    public SqmPathSource<?> getIdentifierDescriptor() {
        return null;
    }

    @Override
    public <Y> SingularPersistentAttribute<? super T, Y> getId(Class<Y> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Y> SingularPersistentAttribute<T, Y> getDeclaredId(Class<Y> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Y> SingularPersistentAttribute<? super T, Y> getVersion(Class<Y> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Y> SingularPersistentAttribute<T, Y> getDeclaredVersion(Class<Y> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<SingularAttribute<? super T, ?>> getIdClassAttributes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SimpleDomainType<?> getIdType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IdentifiableDomainType<? super T> getSupertype() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasIdClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SingularPersistentAttribute<? super T, ?> findIdAttribute() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitIdClassAttributes(Consumer<SingularPersistentAttribute<? super T, ?>> action) {
    }

    @Override
    public SingularPersistentAttribute<? super T, ?> findVersionAttribute() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends SingularPersistentAttribute<? super T, ?>> findNaturalIdAttributes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasSingleIdAttribute() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasVersionAttribute() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ManagedDomainType<? super T> getSuperType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<? extends EntityDomainType<? extends T>> getSubTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSubType(ManagedDomainType<? extends T> subType) {
        throw new UnsupportedOperationException();
    }
}

