/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.criteria.JpaXmlElementExpression;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmXmlAttributesExpression;

@Incubating
public class SqmXmlElementExpression
extends SelfRenderingSqmFunction<String>
implements JpaXmlElementExpression {
    public SqmXmlElementExpression(SqmFunctionDescriptor descriptor, FunctionRenderer renderer, List<? extends SqmTypedNode<?>> arguments, @Nullable ReturnableType<String> impliedResultType, @Nullable ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
        super(descriptor, renderer, arguments, impliedResultType, argumentsValidator, returnTypeResolver, nodeBuilder, name);
    }

    @Override
    public SqmXmlElementExpression attribute(String attributeName, Expression<?> expression) {
        SqmTypedNode<?> sqmTypedNode;
        List<SqmTypedNode<?>> arguments = this.getArguments();
        if (arguments.size() > 1 && (sqmTypedNode = arguments.get(1)) instanceof SqmXmlAttributesExpression) {
            SqmXmlAttributesExpression attributesExpression = (SqmXmlAttributesExpression)sqmTypedNode;
            attributesExpression.attribute(attributeName, expression);
        } else {
            arguments.add(1, new SqmXmlAttributesExpression(attributeName, expression));
        }
        return this;
    }

    @Override
    public SqmXmlElementExpression content(Expression<?> ... expressions) {
        return this.content(Arrays.asList(expressions));
    }

    @Override
    public SqmXmlElementExpression content(List<? extends Expression<?>> expressions) {
        List<SqmTypedNode<?>> arguments = this.getArguments();
        int contentIndex = 1;
        if (arguments.size() > contentIndex) {
            if (arguments.get(contentIndex) instanceof SqmXmlAttributesExpression) {
                ++contentIndex;
            }
            while (contentIndex < arguments.size()) {
                arguments.remove(arguments.size() - 1);
            }
        }
        for (Expression<?> expression : expressions) {
            arguments.add((SqmTypedNode)((Object)expression));
        }
        return this;
    }

    @Override
    public SqmXmlElementExpression copy(SqmCopyContext context) {
        SqmXmlElementExpression existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList<SqmNode> arguments = new ArrayList<SqmNode>(this.getArguments().size());
        for (SqmTypedNode<?> argument : this.getArguments()) {
            arguments.add(argument.copy(context));
        }
        return context.registerCopy(this, new SqmXmlElementExpression(this.getFunctionDescriptor(), this.getFunctionRenderer(), (List<? extends SqmTypedNode<?>>)arguments, this.getImpliedResultType(), this.getArgumentsValidator(), this.getReturnTypeResolver(), (NodeBuilder)this.nodeBuilder(), this.getFunctionName()));
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        List<SqmTypedNode<?>> arguments = this.getArguments();
        hql.append("xmlelement(name ");
        arguments.get(0).appendHqlString(hql, context);
        for (int i = 1; i < arguments.size(); ++i) {
            hql.append(',');
            arguments.get(i).appendHqlString(hql, context);
        }
        hql.append(')');
    }
}

