/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tuple.internal;

import jakarta.persistence.metamodel.Bindable;
import org.hibernate.Incubating;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.internal.PathHelper;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.type.descriptor.java.JavaType;

@Incubating
public class AnonymousTupleSqmPathSourceNew<J>
implements SqmPathSource<J> {
    private final String localPathName;
    private final SqmPathSource<J> pathSource;
    private final SqmDomainType<J> sqmPathType;

    public AnonymousTupleSqmPathSourceNew(String localPathName, SqmPathSource<J> pathSource, SqmDomainType<J> sqmPathType) {
        this.localPathName = localPathName;
        this.pathSource = pathSource;
        this.sqmPathType = sqmPathType;
    }

    @Override
    public Class<J> getBindableJavaType() {
        return this.pathSource.getExpressibleJavaType().getJavaTypeClass();
    }

    @Override
    public String getPathName() {
        return this.localPathName;
    }

    @Override
    public SqmDomainType<J> getPathType() {
        return this.sqmPathType;
    }

    @Override
    public Bindable.BindableType getBindableType() {
        return this.pathSource.getBindableType();
    }

    @Override
    public JavaType<J> getExpressibleJavaType() {
        return this.pathSource.getExpressibleJavaType();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        return this.pathSource.findSubPathSource(name);
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        if (this.sqmPathType instanceof BasicDomainType) {
            return new SqmBasicValuedSimplePath(PathHelper.append(lhs, this, intermediatePathSource), this, lhs, lhs.nodeBuilder());
        }
        if (this.sqmPathType instanceof EmbeddableDomainType) {
            return new SqmEmbeddedValuedSimplePath(PathHelper.append(lhs, this, intermediatePathSource), this, lhs, lhs.nodeBuilder());
        }
        if (this.sqmPathType instanceof EntityDomainType) {
            return new SqmEntityValuedSimplePath(PathHelper.append(lhs, this, intermediatePathSource), this, lhs, lhs.nodeBuilder());
        }
        throw new UnsupportedOperationException("Unsupported path source: " + String.valueOf(this.sqmPathType));
    }
}

