/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.transaction.backend.jta.internal;

import java.lang.invoke.MethodHandles;
import org.hibernate.Internal;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.jta", description="Logging related to JTA transaction management")
@Internal
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=90007001, max=90008000)
public interface JtaLogging
extends BasicLogger {
    public static final String LOGGER_NAME = "org.hibernate.orm.jta";
    public static final JtaLogging JTA_LOGGER = Logger.getMessageLogger(MethodHandles.lookup(), JtaLogging.class, "org.hibernate.orm.jta");
    public static final int NAMESPACE = 90007000;

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Calling TransactionManager.begin() to start a new JTA transaction", id=90007001)
    public void callingTransactionManagerBegin();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Successfully called TransactionManager.begin()", id=90007002)
    public void calledTransactionManagerBegin();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Skipping TransactionManager.begin() since there is an active transaction", id=90007003)
    public void skippingTransactionManagerBegin();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Calling TransactionManager.commit() to commit the JTA transaction", id=90007004)
    public void callingTransactionManagerCommit();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Successfully called TransactionManager.commit()", id=0x55D65DD)
    public void calledTransactionManagerCommit();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Skipping TransactionManager.commit() since the transaction was not initiated here", id=90007006)
    public void skippingTransactionManagerCommit();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Calling TransactionManager.rollback() to roll back the JTA transaction", id=90007007)
    public void callingTransactionManagerRollback();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Successfully called TransactionManager.rollback()", id=90007008)
    public void calledTransactionManagerRollback();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Calling UserTransaction.begin() to start a new JTA transaction", id=90007009)
    public void callingUserTransactionBegin();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Successfully called UserTransaction.begin()", id=90007010)
    public void calledUserTransactionBegin();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Calling UserTransaction.commit() to commit the JTA transaction", id=90007011)
    public void callingUserTransactionCommit();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Successfully called UserTransaction.commit()", id=90007012)
    public void calledUserTransactionCommit();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Calling UserTransaction.rollback() to roll back the JTA transaction", id=90007013)
    public void callingUserTransactionRollback();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Successfully called UserTransaction.rollback()", id=90007014)
    public void calledUserTransactionRollback();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Surrounding JTA transaction suspended [%s]", id=90007015)
    public void transactionSuspended(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Surrounding JTA transaction resumed [%s]", id=90007016)
    public void transactionResumed(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unable to roll back isolated transaction on error [%s]", id=90007017)
    public void unableToRollBackIsolatedTransaction(Exception var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unable to release isolated connection", id=90007018)
    public void unableToReleaseIsolatedConnection(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90007020, value="Transaction afterCompletion called by a background thread; delaying afterCompletion processing until the original thread can handle it. [status=%s]")
    public void rollbackFromBackgroundThread(int var1);
}

