/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.exec.SqlExecLogger;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.internal.ResultsHelper;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerTupleTransformerAdapter;
import org.hibernate.sql.results.jdbc.internal.AbstractJdbcValues;
import org.hibernate.sql.results.jdbc.internal.CachedJdbcValuesMetadata;
import org.hibernate.sql.results.jdbc.internal.DeferredResultSetAccess;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesCacheHit;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesResultSetImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.ResultSetAccess;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class JdbcSelectExecutorStandardImpl
implements JdbcSelectExecutor {
    public static final JdbcSelectExecutorStandardImpl INSTANCE = new JdbcSelectExecutorStandardImpl();

    @Override
    public <T, R> T executeQuery(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Class<R> domainResultType, JdbcSelectExecutor.StatementCreator statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        return this.executeQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, domainResultType, -1, statementCreator, resultsConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, R> T executeQuery(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Class<R> domainResultType, int resultCountEstimate, JdbcSelectExecutor.StatementCreator statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        PersistenceContext persistenceContext = executionContext.getSession().getPersistenceContext();
        boolean defaultReadOnlyOrig = persistenceContext.isDefaultReadOnly();
        Boolean readOnly = executionContext.getQueryOptions().isReadOnly();
        if (readOnly != null) {
            persistenceContext.setDefaultReadOnly(readOnly);
        }
        try {
            T t = this.doExecuteQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, domainResultType, resultCountEstimate, statementCreator, resultsConsumer);
            return t;
        }
        finally {
            if (readOnly != null) {
                persistenceContext.setDefaultReadOnly(defaultReadOnlyOrig);
            }
        }
    }

    private <T, R> T doExecuteQuery(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, final ExecutionContext executionContext, RowTransformer<R> rowTransformer, Class<R> domainResultType, int resultCountEstimate, JdbcSelectExecutor.StatementCreator statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        boolean stats;
        DeferredResultSetAccess deferredResultSetAccess = new DeferredResultSetAccess(jdbcSelect, jdbcParameterBindings, executionContext, statementCreator, resultCountEstimate);
        JdbcValues jdbcValues = this.resolveJdbcValuesSource(executionContext.getQueryIdentifier(deferredResultSetAccess.getFinalSql()), jdbcSelect, resultsConsumer.canResultsBeCached(), executionContext, deferredResultSetAccess);
        if (rowTransformer == null) {
            rowTransformer = JdbcSelectExecutorStandardImpl.getRowTransformer(executionContext, jdbcValues);
        }
        SharedSessionContractImplementor session = executionContext.getSession();
        long startTime = 0L;
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (executionContext.hasQueryExecutionToBeAddedToStatistics() && jdbcValues instanceof JdbcValuesResultSetImpl) {
            stats = statistics.isStatisticsEnabled();
            if (stats) {
                startTime = System.nanoTime();
            }
        } else {
            stats = false;
        }
        JdbcValuesSourceProcessingOptions processingOptions = new JdbcValuesSourceProcessingOptions(){

            @Override
            public Object getEffectiveOptionalObject() {
                return executionContext.getEntityInstance();
            }

            @Override
            public String getEffectiveOptionalEntityName() {
                return null;
            }

            @Override
            public Object getEffectiveOptionalId() {
                return executionContext.getEntityId();
            }

            @Override
            public boolean shouldReturnProxies() {
                return true;
            }
        };
        JdbcValuesSourceProcessingStateStandardImpl valuesProcessingState = new JdbcValuesSourceProcessingStateStandardImpl(executionContext, processingOptions);
        RowReader<R> rowReader = ResultsHelper.createRowReader(session.getFactory(), rowTransformer, domainResultType, jdbcValues);
        RowProcessingStateStandardImpl rowProcessingState = new RowProcessingStateStandardImpl(valuesProcessingState, executionContext, rowReader, jdbcValues);
        T result = resultsConsumer.consume(jdbcValues, session, processingOptions, valuesProcessingState, rowProcessingState, rowReader);
        if (stats) {
            long endTime = System.nanoTime();
            long milliseconds = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
            statistics.queryExecuted(executionContext.getQueryIdentifier(jdbcSelect.getSqlString()), this.getResultSize(result), milliseconds);
        }
        return result;
    }

    private static <R> RowTransformer<R> getRowTransformer(ExecutionContext executionContext, JdbcValues jdbcValues) {
        TupleTransformer<?> tupleTransformer = executionContext.getQueryOptions().getTupleTransformer();
        if (tupleTransformer == null) {
            return RowTransformerStandardImpl.instance();
        }
        List<DomainResult<?>> domainResults = jdbcValues.getValuesMapping().getDomainResults();
        String[] aliases = new String[domainResults.size()];
        for (int i = 0; i < domainResults.size(); ++i) {
            aliases[i] = domainResults.get(i).getResultVariable();
        }
        return new RowTransformerTupleTransformerAdapter(aliases, tupleTransformer);
    }

    private <T> int getResultSize(T result) {
        int n;
        if (result instanceof List) {
            List list = (List)result;
            n = list.size();
        } else {
            n = -1;
        }
        return n;
    }

    private JdbcValues resolveJdbcValuesSource(String queryIdentifier, JdbcOperationQuerySelect jdbcSelect, boolean canBeCached, ExecutionContext executionContext, DeferredResultSetAccess resultSetAccess) {
        List<?> cachedResults;
        QueryKey queryResultsCacheKey;
        boolean cacheable;
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        boolean queryCacheEnabled = factory.getSessionFactoryOptions().isQueryCacheEnabled();
        CacheMode cacheMode = JdbcSelectExecutorStandardImpl.resolveCacheMode(executionContext);
        JdbcValuesMappingProducer mappingProducer = jdbcSelect.getJdbcValuesMappingProducer();
        QueryOptions queryOptions = executionContext.getQueryOptions();
        boolean bl = cacheable = queryCacheEnabled && canBeCached && queryOptions.isResultCachingEnabled() == Boolean.TRUE;
        if (cacheable && cacheMode.isGetEnabled()) {
            SqlExecLogger.SQL_EXEC_LOGGER.tracef("Reading query result cache data [%s]", (Object)cacheMode.name());
            Set<String> querySpaces = jdbcSelect.getAffectedTableNames();
            if (querySpaces == null || querySpaces.isEmpty()) {
                SqlExecLogger.SQL_EXEC_LOGGER.tracef("Affected query spaces unexpectedly empty", new Object[0]);
            } else {
                SqlExecLogger.SQL_EXEC_LOGGER.tracef("Affected query spaces %s", (Object)querySpaces);
            }
            QueryResultsCache queryCache = factory.getCache().getQueryResultsCache(queryOptions.getResultCacheRegionName());
            queryResultsCacheKey = QueryKey.from(jdbcSelect.getSqlString(), queryOptions.getLimit(), executionContext.getQueryParameterBindings(), session);
            cachedResults = queryCache.get(queryResultsCacheKey, querySpaces, session);
            StatisticsImplementor statistics = factory.getStatistics();
            if (statistics.isStatisticsEnabled()) {
                if (cachedResults == null) {
                    statistics.queryCacheMiss(queryIdentifier, queryCache.getRegion().getName());
                } else {
                    statistics.queryCacheHit(queryIdentifier, queryCache.getRegion().getName());
                }
            }
        } else {
            SqlExecLogger.SQL_EXEC_LOGGER.tracef("Skipping reading query result cache data (query cache %s, cache mode %s)", (Object)(queryCacheEnabled ? "enabled" : "disabled"), (Object)cacheMode.name());
            cachedResults = null;
            queryResultsCacheKey = cacheable && cacheMode.isPutEnabled() ? QueryKey.from(jdbcSelect.getSqlString(), queryOptions.getLimit(), executionContext.getQueryParameterBindings(), session) : null;
        }
        return JdbcSelectExecutorStandardImpl.resolveJdbcValues(queryIdentifier, executionContext, resultSetAccess, cachedResults, queryResultsCacheKey, mappingProducer, session, factory);
    }

    private static AbstractJdbcValues resolveJdbcValues(String queryIdentifier, ExecutionContext executionContext, DeferredResultSetAccess resultSetAccess, List<?> cachedResults, QueryKey queryResultsCacheKey, JdbcValuesMappingProducer mappingProducer, SharedSessionContractImplementor session, SessionFactoryImplementor factory) {
        JdbcValuesMetadata jdbcValuesMetadata;
        Object obj;
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        if (cachedResults == null) {
            CachedJdbcValuesMetadata metadataForCache;
            JdbcValuesMapping jdbcValuesMapping;
            if (queryResultsCacheKey == null) {
                jdbcValuesMapping = mappingProducer.resolve(resultSetAccess, loadQueryInfluencers, factory);
                metadataForCache = null;
            } else {
                CapturingJdbcValuesMetadata capturingMetadata = new CapturingJdbcValuesMetadata(resultSetAccess);
                jdbcValuesMapping = mappingProducer.resolve(capturingMetadata, loadQueryInfluencers, factory);
                metadataForCache = capturingMetadata.resolveMetadataForCache();
            }
            return new JdbcValuesResultSetImpl(resultSetAccess, queryResultsCacheKey, queryIdentifier, executionContext.getQueryOptions(), resultSetAccess.usesFollowOnLocking(), jdbcValuesMapping, metadataForCache, executionContext);
        }
        if (!cachedResults.isEmpty() && (obj = cachedResults.get(0)) instanceof JdbcValuesMetadata) {
            JdbcValuesMetadata jdbcValuesMetadata2 = (JdbcValuesMetadata)obj;
            jdbcValuesMetadata = jdbcValuesMetadata2;
        } else {
            jdbcValuesMetadata = resultSetAccess;
        }
        DeferredResultSetAccess valuesMetadata = jdbcValuesMetadata;
        return new JdbcValuesCacheHit(cachedResults, mappingProducer.resolve(valuesMetadata, loadQueryInfluencers, factory));
    }

    private static CacheMode resolveCacheMode(ExecutionContext executionContext) {
        QueryOptions queryOptions = executionContext.getQueryOptions();
        SharedSessionContractImplementor session = executionContext.getSession();
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> queryOptions == null ? null : queryOptions.getCacheMode();
        supplierArray[1] = session::getCacheMode;
        supplierArray[2] = () -> CacheMode.NORMAL;
        return (CacheMode)NullnessHelper.coalesceSuppliedValues(supplierArray);
    }

    static class CapturingJdbcValuesMetadata
    implements JdbcValuesMetadata {
        private final ResultSetAccess resultSetAccess;
        private String[] columnNames;
        private BasicType<?>[] types;

        public CapturingJdbcValuesMetadata(ResultSetAccess resultSetAccess) {
            this.resultSetAccess = resultSetAccess;
        }

        private void initializeArrays() {
            int columnCount = this.resultSetAccess.getColumnCount();
            this.columnNames = new String[columnCount];
            this.types = new BasicType[columnCount];
        }

        @Override
        public int getColumnCount() {
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            return this.columnNames.length;
        }

        @Override
        public int resolveColumnPosition(String columnName) {
            int position;
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            if (this.columnNames == null) {
                position = this.resultSetAccess.resolveColumnPosition(columnName);
                this.columnNames[position - 1] = columnName;
            } else {
                position = ArrayHelper.indexOf(this.columnNames, columnName) + 1;
                if (position == 0) {
                    position = this.resultSetAccess.resolveColumnPosition(columnName);
                    this.columnNames[position - 1] = columnName;
                }
            }
            return position;
        }

        @Override
        public String resolveColumnName(int position) {
            String name;
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            if (this.columnNames == null) {
                this.columnNames[position - 1] = name = this.resultSetAccess.resolveColumnName(position);
            } else {
                name = this.columnNames[position - 1];
                if (name == null) {
                    this.columnNames[position - 1] = name = this.resultSetAccess.resolveColumnName(position);
                }
            }
            return name;
        }

        @Override
        public <J> BasicType<J> resolveType(int position, JavaType<J> explicitJavaType, TypeConfiguration typeConfiguration) {
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            BasicType<J> basicType = this.resultSetAccess.resolveType(position, explicitJavaType, typeConfiguration);
            this.types[position - 1] = basicType;
            return basicType;
        }

        public CachedJdbcValuesMetadata resolveMetadataForCache() {
            return this.columnNames == null ? null : new CachedJdbcValuesMetadata(this.columnNames, this.types);
        }
    }
}

