/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import jakarta.persistence.AttributeConverter;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.type.AbstractType;
import org.hibernate.type.ConvertedBasicType;
import org.hibernate.type.MappingContext;
import org.hibernate.type.ProcedureParameterExtractionAware;
import org.hibernate.type.ProcedureParameterNamedBinder;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.converter.internal.ConverterHelper;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.UserTypeJavaTypeWrapper;
import org.hibernate.type.internal.UserTypeJdbcTypeAdapter;
import org.hibernate.type.internal.UserTypeVersionJavaTypeWrapper;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.LoggableUserType;
import org.hibernate.usertype.UserType;
import org.hibernate.usertype.UserVersionType;

public class CustomType<J>
extends AbstractType
implements ConvertedBasicType<J>,
ProcedureParameterNamedBinder<J>,
ProcedureParameterExtractionAware<J> {
    private final UserType<J> userType;
    private final String[] registrationKeys;
    private final String name;
    private final JavaType<J> mappedJavaType;
    private final JavaType<?> jdbcJavaType;
    private final JdbcType jdbcType;
    private final ValueExtractor<J> valueExtractor;
    private final ValueBinder<J> valueBinder;
    private final JdbcLiteralFormatter<J> jdbcLiteralFormatter;
    private final BasicValueConverter<J, ?> converter;

    public CustomType(UserType<J> userType, TypeConfiguration typeConfiguration) throws MappingException {
        this(userType, ArrayHelper.EMPTY_STRING_ARRAY, typeConfiguration);
    }

    public CustomType(UserType<J> userType, String[] registrationKeys, TypeConfiguration typeConfiguration) {
        this.userType = userType;
        this.registrationKeys = registrationKeys;
        this.name = userType.getClass().getName();
        this.mappedJavaType = this.getMappedJavaType(userType);
        AttributeConverter<J, ?> valueConverter = userType.getValueConverter();
        if (valueConverter != null) {
            this.converter = ConverterHelper.createValueConverter(valueConverter, typeConfiguration.getJavaTypeRegistry());
            this.jdbcType = typeConfiguration.getJdbcTypeRegistry().getDescriptor(userType.getSqlType());
            this.jdbcJavaType = this.converter.getRelationalJavaType();
            this.valueExtractor = this.jdbcType.getExtractor(this.jdbcJavaType);
            this.valueBinder = this.jdbcType.getBinder(this.jdbcJavaType);
            this.jdbcLiteralFormatter = this.jdbcType.getJdbcLiteralFormatter(this.jdbcJavaType);
        } else {
            this.jdbcType = new UserTypeJdbcTypeAdapter<J>(userType, this.mappedJavaType);
            this.jdbcJavaType = this.jdbcType.getJdbcRecommendedJavaTypeMapping(null, null, typeConfiguration);
            this.valueExtractor = this.jdbcType.getExtractor(this.mappedJavaType);
            this.valueBinder = this.jdbcType.getBinder(this.mappedJavaType);
            this.jdbcLiteralFormatter = userType instanceof EnhancedUserType ? this.jdbcType.getJdbcLiteralFormatter(this.mappedJavaType) : null;
            this.converter = null;
        }
    }

    private JavaType<J> getMappedJavaType(UserType<J> userType) {
        UserTypeJavaTypeWrapper<J> userTypeJavaTypeWrapper;
        if (userType instanceof UserVersionType) {
            UserVersionType userVersionType = (UserVersionType)userType;
            userTypeJavaTypeWrapper = new UserTypeVersionJavaTypeWrapper(userVersionType, this);
        } else {
            userTypeJavaTypeWrapper = new UserTypeJavaTypeWrapper<J>(userType, this);
        }
        return userTypeJavaTypeWrapper;
    }

    public UserType<J> getUserType() {
        return this.userType;
    }

    @Override
    public ValueExtractor<J> getJdbcValueExtractor() {
        return this.valueExtractor;
    }

    @Override
    public ValueBinder<J> getJdbcValueBinder() {
        return this.valueBinder;
    }

    @Override
    public JdbcLiteralFormatter<J> getJdbcLiteralFormatter() {
        return this.jdbcLiteralFormatter;
    }

    @Override
    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    @Override
    public int[] getSqlTypeCodes(MappingContext mappingContext) {
        return new int[]{this.jdbcType.getDdlTypeCode()};
    }

    @Override
    public String[] getRegistrationKeys() {
        return this.registrationKeys;
    }

    @Override
    public int getColumnSpan(MappingContext session) {
        return 1;
    }

    public Class<J> getReturnedClass() {
        return this.getUserType().returnedClass();
    }

    @Override
    public boolean isEqual(Object x, Object y) throws HibernateException {
        return this.getUserType().equals(x, y);
    }

    @Override
    public int getHashCode(Object x) {
        return this.getUserType().hashCode(x);
    }

    @Override
    public Object assemble(Serializable cached, SharedSessionContractImplementor session, Object owner) {
        J assembled = this.getUserType().assemble(cached, owner);
        return assembled == null && cached != null ? this.convertToDomainValue(cached) : assembled;
    }

    @Override
    public Serializable disassemble(Object value, SharedSessionContractImplementor session, Object owner) {
        return this.disassembleForCache(value);
    }

    @Override
    public Serializable disassemble(Object value, SessionFactoryImplementor sessionFactory) {
        return this.disassembleForCache(value);
    }

    private Serializable disassembleForCache(Object value) {
        Serializable disassembled = this.getUserType().disassemble(value);
        return disassembled == null ? (Serializable)this.convertToRelationalValue(value) : disassembled;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.convertToRelationalValue(value);
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        Serializable disassembled = this.getUserType().disassemble(value);
        if (disassembled == null) {
            CacheHelper.addBasicValueToCacheKey(cacheKey, value, this, session);
        } else {
            cacheKey.addValue(disassembled);
            cacheKey.addHashCode(value == null ? 0 : this.getUserType().hashCode(value));
        }
    }

    @Override
    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache) {
        return this.getUserType().replace(original, target, owner);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SharedSessionContractImplementor session) throws SQLException {
        if (settable[0]) {
            this.getUserType().nullSafeSet(st, value, index, session);
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws SQLException {
        this.getUserType().nullSafeSet(st, value, index, session);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object deepCopy(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return this.getUserType().deepCopy(value);
    }

    @Override
    public boolean isMutable() {
        return this.getUserType().isMutable();
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) {
        if (value == null) {
            return "null";
        }
        UserType<J> userType = this.userType;
        if (userType instanceof LoggableUserType) {
            LoggableUserType loggableUserType = (LoggableUserType)((Object)userType);
            return loggableUserType.toLoggableString(value, factory);
        }
        if (this.userType instanceof EnhancedUserType) {
            return ((EnhancedUserType)this.userType).toString(value);
        }
        return value.toString();
    }

    @Override
    public boolean[] toColumnNullness(Object value, MappingContext mapping) {
        boolean[] result = new boolean[this.getColumnSpan(mapping)];
        if (value != null) {
            Arrays.fill(result, true);
        }
        return result;
    }

    @Override
    public boolean isDirty(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) throws HibernateException {
        return checkable[0] && this.isDirty(old, current, session);
    }

    @Override
    public boolean canDoSetting() {
        ProcedureParameterNamedBinder procedureParameterNamedBinder;
        UserType<J> userType = this.getUserType();
        return userType instanceof ProcedureParameterNamedBinder && (procedureParameterNamedBinder = (ProcedureParameterNamedBinder)((Object)userType)).canDoSetting();
    }

    @Override
    public void nullSafeSet(CallableStatement statement, J value, String name, SharedSessionContractImplementor session) throws SQLException {
        if (!this.canDoSetting()) {
            throw new UnsupportedOperationException("Type [" + String.valueOf(this.getUserType()) + "] does support parameter binding by name");
        }
        ((ProcedureParameterNamedBinder)((Object)this.getUserType())).nullSafeSet(statement, value, name, session);
    }

    @Override
    public boolean canDoExtraction() {
        ProcedureParameterExtractionAware procedureParameterExtractionAware;
        UserType<J> userType = this.getUserType();
        return userType instanceof ProcedureParameterExtractionAware && (procedureParameterExtractionAware = (ProcedureParameterExtractionAware)((Object)userType)).canDoExtraction();
    }

    @Override
    public J extract(CallableStatement statement, int startIndex, SharedSessionContractImplementor session) throws SQLException {
        if (this.canDoExtraction()) {
            return ((ProcedureParameterExtractionAware)((Object)this.getUserType())).extract(statement, startIndex, session);
        }
        throw new UnsupportedOperationException("Type [" + String.valueOf(this.getUserType()) + "] does support parameter value extraction");
    }

    @Override
    public J extract(CallableStatement statement, String paramName, SharedSessionContractImplementor session) throws SQLException {
        if (this.canDoExtraction()) {
            return ((ProcedureParameterExtractionAware)((Object)this.getUserType())).extract(statement, paramName, session);
        }
        throw new UnsupportedOperationException("Type [" + String.valueOf(this.getUserType()) + "] does support parameter value extraction");
    }

    public int hashCode() {
        return this.getUserType().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof CustomType)) return false;
        CustomType customType = (CustomType)obj;
        if (!this.getUserType().equals(customType.getUserType())) return false;
        return true;
    }

    @Override
    public Class<J> getJavaType() {
        return this.mappedJavaType.getJavaTypeClass();
    }

    @Override
    public JavaType<J> getMappedJavaType() {
        return this.mappedJavaType;
    }

    @Override
    public JavaType<J> getExpressibleJavaType() {
        return this.getMappedJavaType();
    }

    @Override
    public JavaType<J> getJavaTypeDescriptor() {
        return this.getMappedJavaType();
    }

    @Override
    public JavaType<?> getJdbcJavaType() {
        return this.jdbcJavaType;
    }

    @Override
    public BasicValueConverter<J, ?> getValueConverter() {
        return this.converter;
    }
}

