/*
 * Decompiled with CFR 0.152.
 */
package com.lukeonuke.service;

import com.lukeonuke.SignShop;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ConfigurationService {
    private final Properties properties;
    private final File configurationFile;
    private static ConfigurationService instance = null;

    private ConfigurationService() {
        block15: {
            this.properties = new Properties();
            this.configurationFile = FabricLoader.getInstance().getConfigDir().resolve("signshop").resolve("config.properties").toFile();
            if (this.configurationFile.exists()) {
                try (FileReader reader = new FileReader(this.configurationFile);){
                    this.properties.load(reader);
                    break block15;
                }
                catch (IOException e) {
                    throw new RuntimeException("Cant read properties!");
                }
            }
            SignShop.LOGGER.info("          Generating config dir and file!");
            this.properties.setProperty("database.user", "user");
            this.properties.setProperty("database.password", "password");
            this.properties.setProperty("database.url", "jdbc:mysql://localhost:3306/signshop");
            this.properties.setProperty("prefix", "\u00a72\u00a7lsignshop\u00a7r >> ");
            this.configurationFile.getParentFile().mkdirs();
            try (FileWriter fw = new FileWriter(this.configurationFile);){
                this.properties.store(fw, "SignShop configuration, check out documentation at https://github.com/lukeonuke/signshop \nThis program requires a database connection!");
            }
            catch (IOException e) {
                throw new RuntimeException("Can't write default properties!");
            }
        }
    }

    public static ConfigurationService getInstance() {
        if (instance == null) {
            instance = new ConfigurationService();
        }
        return instance;
    }

    public String getDBUser() {
        return this.properties.getProperty("database.user");
    }

    public String getDBPassword() {
        return this.properties.getProperty("database.password");
    }

    public String getDBUrl() {
        return this.properties.getProperty("database.url");
    }

    public String getPrefix() {
        return this.properties.getProperty("prefix");
    }

    public class_5250 getPrefixAsText() {
        return class_2561.method_43470((String)this.getPrefix());
    }

    public static class ConfigurationKey {
        public static final String DB_USER = "database.user";
        public static final String DB_PASSWORD = "database.password";
        public static final String DB_URL = "database.url";
        public static final String PREFIX = "prefix";
    }
}

