/*
 * Decompiled with CFR 0.152.
 */
package com.lukeonuke.service;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.lukeonuke.SignShop;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import org.jetbrains.annotations.Nullable;

public class InventoryUtil {
    public static int countItems(class_1263 inventory, class_1799 item) {
        int count = 0;
        int size = InventoryUtil.getInventorySize(inventory);
        for (int i = 0; i < size; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!class_1799.method_31577((class_1799)stack, (class_1799)item)) continue;
            count += stack.method_7947();
        }
        return count;
    }

    @Nullable
    public static class_1799 getFirstItem(class_1263 inventory) {
        int size = InventoryUtil.getInventorySize(inventory);
        for (int i = 0; i < size; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            return stack.method_46651(1);
        }
        return null;
    }

    public static boolean canStore(class_1263 inventory, class_1792 item, int count) {
        int size = InventoryUtil.getInventorySize(inventory);
        int remaining = count;
        for (int i = 0; i < size; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) {
                remaining -= item.method_7882();
                continue;
            }
            if (!stack.method_31574(item)) continue;
            remaining -= stack.method_7914() - stack.method_7947();
        }
        return remaining <= 0;
    }

    public static void addItems(class_1263 inventory, class_1799 item, int count) {
        int remaining = count;
        int size = InventoryUtil.getInventorySize(inventory);
        for (int i = 0; i < size; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) {
                int stackAmount = Math.min(remaining, item.method_7914());
                inventory.method_5447(i, item.method_46651(stackAmount));
                remaining -= stackAmount;
                continue;
            }
            int space = item.method_7914() - stack.method_7947();
            if (class_1799.method_31577((class_1799)stack, (class_1799)item) && space > 0) {
                int stackAmount = Math.min(space, remaining);
                inventory.method_5447(i, item.method_46651(stackAmount + stack.method_7947()));
                remaining -= stackAmount;
            }
            if (remaining <= 0) break;
        }
        inventory.method_5431();
    }

    public static void removeItems(class_1263 inventory, class_1799 item, int count) {
        int remaining = count;
        int size = InventoryUtil.getInventorySize(inventory);
        for (int i = 0; i < size; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)item)) continue;
            if (remaining >= stack.method_7914()) {
                inventory.method_5447(i, class_1799.field_8037);
                remaining -= stack.method_7914();
                continue;
            }
            stack.method_7939(stack.method_7947() - remaining);
            remaining = 0;
        }
        inventory.method_5431();
    }

    public static int getInventorySize(class_1263 inventory) {
        if (inventory instanceof class_1661) {
            return 36;
        }
        return inventory.method_5439();
    }

    @Nullable
    public static String itemToNbt(class_1799 stack, class_1937 world) {
        Gson gson = new Gson();
        try {
            class_5455 registries = world.method_30349();
            class_6903 ops = registries.method_57093((DynamicOps)JsonOps.INSTANCE);
            JsonElement json = (JsonElement)class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)stack).getOrThrow();
            return gson.toJson(json);
        }
        catch (Exception e) {
            SignShop.LOGGER.error("Couldn't serialise item: {} {}", e.getClass(), (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    public static class_1799 fromJson(String jsonString, class_1937 world) {
        try {
            class_5455 registries = world.method_30349();
            class_6903 ops = registries.method_57093((DynamicOps)JsonOps.INSTANCE);
            JsonElement element = JsonParser.parseString((String)jsonString);
            return (class_1799)class_1799.field_24671.parse((DynamicOps)ops, (Object)element).getOrThrow();
        }
        catch (Exception e) {
            SignShop.LOGGER.error("Couldn't deserialize item: {} {}", e.getClass(), (Object)e.getMessage());
            return null;
        }
    }

    public static boolean isHoldingRedstone(class_1657 player) {
        class_1799 stack = player.method_6047();
        return !stack.method_7960() && stack.method_7909() == class_1802.field_8725;
    }
}

