/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.Timeout;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hibernate.LockMode;
import org.hibernate.Locking;
import org.hibernate.Timeouts;

@Deprecated(since="7", forRemoval=true)
public class LockOptions
implements Serializable {
    private final boolean immutable;
    private LockMode lockMode;
    private int timeout;
    private Locking.Scope scope;
    private Locking.FollowOn followOnStrategy;
    @Deprecated(since="7", forRemoval=true)
    public static final LockOptions NONE = new LockOptions(true, LockMode.NONE);
    @Deprecated(since="7", forRemoval=true)
    public static final LockOptions READ = new LockOptions(true, LockMode.READ);
    @Deprecated(since="7", forRemoval=true)
    static final LockOptions OPTIMISTIC = new LockOptions(true, LockMode.OPTIMISTIC);
    @Deprecated(since="7", forRemoval=true)
    static final LockOptions OPTIMISTIC_FORCE_INCREMENT = new LockOptions(true, LockMode.OPTIMISTIC_FORCE_INCREMENT);
    @Deprecated(since="7", forRemoval=true)
    static final LockOptions PESSIMISTIC_READ = new LockOptions(true, LockMode.PESSIMISTIC_READ);
    @Deprecated(since="7", forRemoval=true)
    static final LockOptions PESSIMISTIC_WRITE = new LockOptions(true, LockMode.PESSIMISTIC_WRITE);
    @Deprecated(since="7", forRemoval=true)
    static final LockOptions PESSIMISTIC_FORCE_INCREMENT = new LockOptions(true, LockMode.PESSIMISTIC_FORCE_INCREMENT);
    @Deprecated(since="7", forRemoval=true)
    static final LockOptions UPGRADE_NOWAIT = new LockOptions(true, LockMode.UPGRADE_NOWAIT);
    @Deprecated(since="7", forRemoval=true)
    static final LockOptions UPGRADE_SKIPLOCKED = new LockOptions(true, LockMode.UPGRADE_SKIPLOCKED);
    @Deprecated(since="7", forRemoval=true)
    public static final LockOptions UPGRADE = PESSIMISTIC_WRITE;
    @Deprecated(since="7", forRemoval=true)
    public static final int NO_WAIT = 0;
    @Deprecated(since="7", forRemoval=true)
    public static final int WAIT_FOREVER = -1;
    @Deprecated(since="6.2", forRemoval=true)
    public static final int SKIP_LOCKED = -2;

    public LockOptions() {
        this.immutable = false;
        this.lockMode = LockMode.NONE;
        this.timeout = -1;
        this.scope = Locking.Scope.ROOT_ONLY;
        this.followOnStrategy = Locking.FollowOn.ALLOW;
    }

    public LockOptions(LockMode lockMode) {
        this.immutable = false;
        this.lockMode = lockMode;
        this.timeout = -1;
        this.scope = Locking.Scope.ROOT_ONLY;
        this.followOnStrategy = Locking.FollowOn.ALLOW;
    }

    public LockOptions(LockMode lockMode, Timeout timeout) {
        this.immutable = false;
        this.lockMode = lockMode;
        this.timeout = timeout.milliseconds();
        this.scope = Locking.Scope.ROOT_ONLY;
        this.followOnStrategy = Locking.FollowOn.ALLOW;
    }

    public LockOptions(LockMode lockMode, Timeout timeout, PessimisticLockScope jpaScope) {
        this.immutable = false;
        this.lockMode = lockMode;
        this.timeout = timeout.milliseconds();
        this.scope = Locking.Scope.fromJpaScope(jpaScope);
        this.followOnStrategy = Locking.FollowOn.ALLOW;
    }

    protected LockOptions(boolean immutable, LockMode lockMode) {
        this.immutable = immutable;
        this.lockMode = lockMode;
        this.timeout = -1;
        this.scope = Locking.Scope.ROOT_ONLY;
        this.followOnStrategy = Locking.FollowOn.ALLOW;
    }

    public LockOptions(LockMode lockMode, int timeout, Locking.Scope scope, Locking.FollowOn followOnStrategy) {
        this.immutable = false;
        this.lockMode = lockMode;
        this.timeout = timeout;
        this.scope = scope;
        this.followOnStrategy = followOnStrategy;
    }

    public boolean isEmpty() {
        return this.lockMode == LockMode.NONE;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public LockOptions setLockMode(LockMode lockMode) {
        if (this.immutable) {
            throw new UnsupportedOperationException("immutable global instance of LockOptions");
        }
        if (lockMode == LockMode.UPGRADE_NOWAIT) {
            this.timeout = 0;
        } else if (lockMode == LockMode.UPGRADE_SKIPLOCKED) {
            this.timeout = -2;
        }
        this.lockMode = lockMode;
        return this;
    }

    public Timeout getTimeout() {
        return Timeout.milliseconds(this.getTimeOut());
    }

    public LockOptions setTimeout(Timeout timeout) {
        return this.setTimeOut(timeout.milliseconds());
    }

    public int getTimeOut() {
        return this.timeout;
    }

    public LockOptions setTimeOut(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public Locking.Scope getScope() {
        return this.scope;
    }

    public LockOptions setScope(Locking.Scope scope) {
        this.scope = scope;
        return this;
    }

    public Locking.FollowOn getFollowOnStrategy() {
        return this.followOnStrategy;
    }

    public LockOptions setFollowOnStrategy(Locking.FollowOn followOnStrategy) {
        assert (followOnStrategy != null);
        this.followOnStrategy = followOnStrategy;
        return this;
    }

    public boolean hasNonDefaultOptions() {
        return this.timeout != -1 || this.scope != Locking.Scope.ROOT_ONLY || this.followOnStrategy != Locking.FollowOn.ALLOW;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LockOptions)) {
            return false;
        }
        LockOptions that = (LockOptions)object;
        return this.timeout == that.timeout && this.scope == that.scope && this.lockMode == that.lockMode && Objects.equals(this.followOnStrategy, that.followOnStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.lockMode, this.timeout, this.followOnStrategy, this.scope);
    }

    @Deprecated(since="7.0")
    public LockOptions(LockMode lockMode, int timeout) {
        this(lockMode, Timeouts.interpretMilliSeconds(timeout));
    }

    @Deprecated(since="7.0")
    public LockOptions(LockMode lockMode, int timeout, PessimisticLockScope scope) {
        this(lockMode, Timeouts.interpretMilliSeconds(timeout), scope);
    }

    @Deprecated(since="7", forRemoval=true)
    public PessimisticLockScope getLockScope() {
        return this.scope.getCorrespondingJpaScope();
    }

    @Deprecated(since="7", forRemoval=true)
    public LockOptions setLockScope(PessimisticLockScope jpaScope) {
        return this.setScope(Locking.Scope.fromJpaScope(jpaScope));
    }

    @Deprecated(since="7.1")
    public Boolean getFollowOnLocking() {
        assert (this.followOnStrategy != null);
        return this.followOnStrategy.asLegacyValue();
    }

    @Deprecated(since="7.1")
    public LockOptions setFollowOnLocking(Boolean followOnLocking) {
        this.followOnStrategy = Locking.FollowOn.fromLegacyValue(followOnLocking);
        return this;
    }

    @Deprecated(since="7", forRemoval=true)
    public Set<Map.Entry<String, LockMode>> getAliasSpecificLocks() {
        return Collections.emptySet();
    }

    @Deprecated(since="7", forRemoval=true)
    public LockOptions setAliasSpecificLockMode(String alias, LockMode lockMode) {
        if (this.immutable) {
            throw new UnsupportedOperationException("immutable global instance of LockOptions");
        }
        if (lockMode.greaterThan(this.lockMode)) {
            this.lockMode = lockMode;
        }
        return this;
    }

    @Deprecated(since="7", forRemoval=true)
    public int getAliasLockCount() {
        return 0;
    }

    @Deprecated(since="7", forRemoval=true)
    public boolean hasAliasSpecificLockModes() {
        return false;
    }

    @Deprecated(since="7", forRemoval=true)
    public LockMode getAliasSpecificLockMode(String alias) {
        return this.lockMode;
    }

    @Deprecated(since="7", forRemoval=true)
    public Iterator<Map.Entry<String, LockMode>> getAliasLockIterator() {
        return Collections.emptyIterator();
    }

    @Deprecated(since="7", forRemoval=true)
    public LockMode getEffectiveLockMode(String alias) {
        return this.lockMode;
    }

    @Deprecated(since="7", forRemoval=true)
    public LockMode findGreatestLockMode() {
        return this.getLockMode();
    }

    @Deprecated(since="7", forRemoval=true)
    public LockOptions makeCopy() {
        LockOptions copy = new LockOptions();
        LockOptions.copy(this, copy);
        return copy;
    }

    @Deprecated(since="7", forRemoval=true)
    public LockOptions makeDefensiveCopy() {
        if (this.immutable) {
            return this;
        }
        LockOptions copy = new LockOptions();
        LockOptions.copy(this, copy);
        return copy;
    }

    @Deprecated(since="7", forRemoval=true)
    public void overlay(LockOptions lockOptions) {
        LockOptions.copy(lockOptions, this);
    }

    @Deprecated(since="7", forRemoval=true)
    public static LockOptions copy(LockOptions source, LockOptions destination) {
        destination.setLockMode(source.getLockMode());
        destination.setScope(source.getScope());
        destination.setTimeOut(source.getTimeOut());
        destination.setFollowOnStrategy(source.getFollowOnStrategy());
        return destination;
    }
}

