/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.StringHelper;

public class PropertyAccessException
extends HibernateException {
    private final Class<?> persistentClass;
    private final String propertyName;
    private final boolean wasSetter;

    public PropertyAccessException(@Nullable Throwable cause, String message, boolean wasSetter, Class<?> persistentClass, String propertyName) {
        super(message, cause);
        this.persistentClass = persistentClass;
        this.wasSetter = wasSetter;
        this.propertyName = propertyName;
    }

    public Class<?> getPersistentClass() {
        return this.persistentClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    protected String originalMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        return this.originalMessage() + ": '" + StringHelper.qualify(this.persistentClass.getName(), this.propertyName) + "'" + (this.wasSetter ? " (setter)" : " (getter)");
    }
}

