/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import org.hibernate.StaleStateException;
import org.hibernate.pretty.MessageHelper;

public class StaleObjectStateException
extends StaleStateException {
    private final String entityName;
    private final Object identifier;

    public StaleObjectStateException(String entityName, Object identifier) {
        this(entityName, identifier, "Row was already updated or deleted by another transaction");
    }

    public StaleObjectStateException(String entityName, Object identifier, String message) {
        super(message);
        this.entityName = entityName;
        this.identifier = identifier;
    }

    public StaleObjectStateException(String entityName, Object identifier, StaleStateException cause) {
        super(cause.getMessage(), cause);
        this.entityName = entityName;
        this.identifier = identifier;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + " for entity " + MessageHelper.infoString(this.entityName, this.identifier);
    }
}

