/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.EntityTransaction;
import jakarta.transaction.Synchronization;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.resource.transaction.backend.jta.internal.StatusTranslator;
import org.hibernate.resource.transaction.spi.TransactionStatus;

public interface Transaction
extends EntityTransaction {
    public TransactionStatus getStatus();

    @Override
    default public boolean isActive() {
        return switch (this.getStatus()) {
            case TransactionStatus.ACTIVE, TransactionStatus.MARKED_ROLLBACK -> true;
            default -> false;
        };
    }

    @Incubating
    default public boolean isInCompletionProcess() {
        return switch (this.getStatus()) {
            case TransactionStatus.COMMITTING, TransactionStatus.ROLLING_BACK -> true;
            default -> false;
        };
    }

    @Incubating
    default public boolean isComplete() {
        return switch (this.getStatus()) {
            case TransactionStatus.COMMITTED, TransactionStatus.ROLLED_BACK, TransactionStatus.FAILED_COMMIT, TransactionStatus.FAILED_ROLLBACK -> true;
            default -> false;
        };
    }

    @Incubating
    default public boolean wasStarted() {
        return this.getStatus() != TransactionStatus.NOT_ACTIVE;
    }

    @Incubating
    default public boolean wasSuccessful() {
        return this.getStatus() == TransactionStatus.COMMITTED;
    }

    @Incubating
    default public boolean wasFailure() {
        return switch (this.getStatus()) {
            case TransactionStatus.ROLLED_BACK, TransactionStatus.FAILED_COMMIT, TransactionStatus.FAILED_ROLLBACK -> true;
            default -> false;
        };
    }

    @Incubating
    default public void runBeforeCompletion(final Runnable action) {
        this.registerSynchronization(new Synchronization(){

            @Override
            public void beforeCompletion() {
                action.run();
            }

            @Override
            public void afterCompletion(int status) {
            }
        });
    }

    @Incubating
    default public void runAfterCompletion(final Consumer<TransactionStatus> action) {
        this.registerSynchronization(new Synchronization(){

            @Override
            public void beforeCompletion() {
            }

            @Override
            public void afterCompletion(int status) {
                action.accept(StatusTranslator.translate(status));
            }
        });
    }

    public void registerSynchronization(Synchronization var1);

    public void setTimeout(int var1);

    @Override
    public @Nullable Integer getTimeout();

    public void markRollbackOnly();
}

