/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.spi.MetadataBuildingContext;

public class AnnotatedDiscriminatorColumn
extends AnnotatedColumn {
    public static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "DTYPE";
    public static final String DEFAULT_DISCRIMINATOR_TYPE = "string";
    private static final long DEFAULT_DISCRIMINATOR_LENGTH = 31L;
    private String discriminatorTypeName;

    public AnnotatedDiscriminatorColumn(String defaultColumnName) {
        this.setLogicalColumnName(defaultColumnName);
        this.setNullable(false);
        this.setDiscriminatorTypeName(DEFAULT_DISCRIMINATOR_TYPE);
        this.setLength(31L);
    }

    public String getDiscriminatorTypeName() {
        return this.discriminatorTypeName;
    }

    public void setDiscriminatorTypeName(String discriminatorTypeName) {
        this.discriminatorTypeName = discriminatorTypeName;
    }

    public static AnnotatedDiscriminatorColumn buildDiscriminatorColumn(DiscriminatorColumn discriminatorColumn, DiscriminatorFormula discriminatorFormula, Column columnOverride, String defaultColumnName, MetadataBuildingContext context) {
        DiscriminatorType discriminatorType;
        AnnotatedColumns parent = new AnnotatedColumns();
        parent.setBuildingContext(context);
        AnnotatedDiscriminatorColumn column = new AnnotatedDiscriminatorColumn(defaultColumnName);
        if (discriminatorFormula != null) {
            DiscriminatorType type = discriminatorFormula.discriminatorType();
            discriminatorType = type == DiscriminatorType.STRING ? (discriminatorColumn == null ? type : discriminatorColumn.discriminatorType()) : type;
            column.setImplicit(false);
            column.setFormula(discriminatorFormula.value());
        } else if (discriminatorColumn != null) {
            discriminatorType = discriminatorColumn.discriminatorType();
            column.setImplicit(false);
            if (!discriminatorColumn.columnDefinition().isBlank()) {
                column.setSqlType(discriminatorColumn.columnDefinition());
            }
            if (!discriminatorColumn.name().isBlank()) {
                column.setLogicalColumnName(discriminatorColumn.name());
            }
            column.setNullable(false);
            column.setOptions(discriminatorColumn.options());
        } else {
            discriminatorType = DiscriminatorType.STRING;
            column.setImplicit(true);
        }
        if (columnOverride != null) {
            column.setLogicalColumnName(columnOverride.name());
            String columnDefinition = columnOverride.columnDefinition();
            if (!columnDefinition.isBlank()) {
                column.setSqlType(columnDefinition);
            }
        }
        AnnotatedDiscriminatorColumn.setDiscriminatorType(discriminatorType, discriminatorColumn, columnOverride, column);
        column.setParent(parent);
        column.bind();
        return column;
    }

    private static void setDiscriminatorType(DiscriminatorType type, DiscriminatorColumn discriminatorColumn, Column columnOverride, AnnotatedDiscriminatorColumn column) {
        if (type == null) {
            column.setDiscriminatorTypeName(DEFAULT_DISCRIMINATOR_TYPE);
        } else {
            switch (type) {
                case CHAR: {
                    column.setDiscriminatorTypeName("character");
                    column.setImplicit(false);
                    column.setLength(1L);
                    break;
                }
                case INTEGER: {
                    column.setDiscriminatorTypeName("integer");
                    column.setImplicit(false);
                    break;
                }
                case STRING: {
                    column.setDiscriminatorTypeName(DEFAULT_DISCRIMINATOR_TYPE);
                    if (columnOverride != null) {
                        column.setLength(Long.valueOf(columnOverride.length()));
                        break;
                    }
                    if (discriminatorColumn == null) break;
                    column.setLength(Long.valueOf(discriminatorColumn.length()));
                    break;
                }
                default: {
                    throw new AssertionFailure("Unknown discriminator type: " + String.valueOf((Object)type));
                }
            }
        }
    }
}

