/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Convert;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.annotations.EmbeddableInstantiator;
import org.hibernate.annotations.EmbeddedColumnNaming;
import org.hibernate.annotations.Instantiator;
import org.hibernate.annotations.TypeBinderType;
import org.hibernate.binder.TypeBinder;
import org.hibernate.boot.model.internal.AggregateComponentBinder;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedDiscriminatorColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.ComponentPropertyHolder;
import org.hibernate.boot.model.internal.DialectOverridesAnnotationHelper;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.FkSecondPass;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyContainer;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.PropertyHolderBuilder;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Value;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.property.access.internal.PropertyAccessStrategyCompositeUserTypeImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyGetterImpl;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.type.BasicType;
import org.hibernate.usertype.CompositeUserType;

public class EmbeddableBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EmbeddableBinder.class);

    static PropertyBinder createCompositeBinder(PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, MemberDetails property, AnnotatedColumns columns, ClassDetails returnedClass, boolean isId, boolean isOverridden, PropertyData mapsIdProperty, Class<? extends CompositeUserType<?>> compositeUserType) {
        return EmbeddableBinder.createEmbeddedProperty(inferredData, propertyHolder, entityBinder, context, isComponentEmbedded, isId, inheritanceStatePerClass, EmbeddableBinder.createEmbeddable(propertyHolder, inferredData, entityBinder, isIdentifierMapper, isComponentEmbedded, context, inheritanceStatePerClass, property, columns, returnedClass, isId, isOverridden, mapsIdProperty, compositeUserType));
    }

    private static Component createEmbeddable(PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, MemberDetails property, AnnotatedColumns columns, ClassDetails returnedClass, boolean isId, boolean isOverridden, PropertyData mapsIdProperty, Class<? extends CompositeUserType<?>> compositeUserType) {
        if (isOverridden) {
            if (compositeUserType != null) {
                throw new AssertionFailure("CompositeUserType not allowed with @MapsId");
            }
            return EmbeddableBinder.bindOverriddenEmbeddable(propertyHolder, inferredData, isIdentifierMapper, isComponentEmbedded, context, inheritanceStatePerClass, property, columns, returnedClass, isId, mapsIdProperty);
        }
        return EmbeddableBinder.bindEmbeddable(inferredData, propertyHolder, entityBinder.getPropertyAccessor(property), entityBinder, isIdentifierMapper, context, isComponentEmbedded, isId, inheritanceStatePerClass, EmbeddableBinder.determineCustomInstantiator(property, returnedClass, context), compositeUserType, columns);
    }

    private static Component bindOverriddenEmbeddable(PropertyHolder propertyHolder, PropertyData inferredData, boolean isIdentifierMapper, boolean isComponentEmbedded, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, MemberDetails property, AnnotatedColumns columns, ClassDetails returnedClass, boolean isId, PropertyData mapsIdProperty) {
        String propertyName = mapsIdProperty.getPropertyName();
        AnnotatedJoinColumns actualColumns = new AnnotatedJoinColumns();
        actualColumns.setBuildingContext(context);
        actualColumns.setPropertyHolder(propertyHolder);
        actualColumns.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
        for (AnnotatedColumn column : columns.getColumns()) {
            column.setParent(actualColumns);
        }
        return EmbeddableBinder.bindOverriddenEmbeddable(inferredData, propertyHolder, isIdentifierMapper, context, isComponentEmbedded, isId, inheritanceStatePerClass, mapsIdProperty.getClassOrElementName(), propertyName, EmbeddableBinder.determineCustomInstantiator(property, returnedClass, context), actualColumns);
    }

    static boolean isEmbedded(MemberDetails property, ClassDetails returnedClass) {
        return property.hasDirectAnnotationUsage(Embedded.class) || property.hasDirectAnnotationUsage(EmbeddedId.class) || returnedClass.hasDirectAnnotationUsage(Embeddable.class) && !property.hasDirectAnnotationUsage(Convert.class);
    }

    static boolean isEmbedded(MemberDetails property, TypeDetails returnedClass) {
        if (property.hasDirectAnnotationUsage(Embedded.class) || property.hasDirectAnnotationUsage(EmbeddedId.class)) {
            return true;
        }
        ClassDetails returnClassDetails = returnedClass.determineRawClass();
        return returnClassDetails.hasDirectAnnotationUsage(Embeddable.class) && !property.hasDirectAnnotationUsage(Convert.class);
    }

    private static Component bindOverriddenEmbeddable(PropertyData inferredData, PropertyHolder propertyHolder, boolean isIdentifierMapper, MetadataBuildingContext context, boolean isComponentEmbedded, boolean isId, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, String referencedEntityName, String propertyName, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, AnnotatedJoinColumns annotatedJoinColumns) {
        Component component = EmbeddableBinder.createEmbeddable(propertyHolder, inferredData, isComponentEmbedded, isIdentifierMapper, customInstantiatorImpl, context);
        context.getMetadataCollector().addSecondPass(new CopyIdentifierComponentSecondPass(component, referencedEntityName, propertyName, annotatedJoinColumns, context));
        if (isId) {
            component.setKey(true);
            EmbeddableBinder.checkEmbeddedId(inferredData, propertyHolder, referencedEntityName, component);
        }
        EmbeddableBinder.callTypeBinders(component, context, inferredData.getPropertyType());
        return component;
    }

    static Component bindEmbeddable(PropertyData inferredData, PropertyHolder propertyHolder, AccessType propertyAccessor, EntityBinder entityBinder, boolean isIdentifierMapper, MetadataBuildingContext context, boolean isComponentEmbedded, boolean isId, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedColumns annotatedColumns) {
        Component component = EmbeddableBinder.fillEmbeddable(propertyHolder, inferredData, propertyAccessor, !isId, entityBinder, isComponentEmbedded, isIdentifierMapper, context.getMetadataCollector().isInSecondPass(), customInstantiatorImpl, compositeUserTypeClass, annotatedColumns, context, inheritanceStatePerClass);
        if (isId) {
            component.setKey(true);
            EmbeddableBinder.checkEmbeddedId(inferredData, propertyHolder, null, component);
        }
        EmbeddableBinder.callTypeBinders(component, context, inferredData.getPropertyType());
        return component;
    }

    private static void callTypeBinders(Component component, MetadataBuildingContext context, TypeDetails annotatedClass) {
        ModelsContext modelsContext = context.getBootstrapContext().getModelsContext();
        List<Annotation> metaAnnotatedAnnotations = annotatedClass.determineRawClass().getMetaAnnotated(TypeBinderType.class, modelsContext);
        if (CollectionHelper.isEmpty(metaAnnotatedAnnotations)) {
            return;
        }
        for (Annotation metaAnnotated : metaAnnotatedAnnotations) {
            TypeBinderType binderType = metaAnnotated.annotationType().getAnnotation(TypeBinderType.class);
            try {
                Class<TypeBinder<?>> binderImpl = binderType.binder();
                TypeBinder<?> binder = binderImpl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                binder.bind(metaAnnotated, context, component);
            }
            catch (Exception e) {
                throw new AnnotationException("error processing @TypeBinderType annotation '" + String.valueOf(metaAnnotated) + "'", e);
            }
        }
    }

    private static PropertyBinder createEmbeddedProperty(PropertyData inferredData, PropertyHolder propertyHolder, EntityBinder entityBinder, MetadataBuildingContext context, boolean isComponentEmbedded, boolean isId, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, Component component) {
        PropertyBinder binder = new PropertyBinder();
        binder.setDeclaringClass(inferredData.getDeclaringClass());
        binder.setName(inferredData.getPropertyName());
        binder.setValue(component);
        binder.setMemberDetails(inferredData.getAttributeMember());
        binder.setAccessType(inferredData.getDefaultAccess());
        binder.setEmbedded(isComponentEmbedded);
        binder.setHolder(propertyHolder);
        binder.setId(isId);
        binder.setEntityBinder(entityBinder);
        binder.setInheritanceStatePerClass(inheritanceStatePerClass);
        binder.setBuildingContext(context);
        binder.makePropertyAndBind();
        return binder;
    }

    private static void checkEmbeddedId(PropertyData inferredData, PropertyHolder propertyHolder, String referencedEntityName, Component component) {
        if (propertyHolder.getPersistentClass().getIdentifier() != null) {
            throw new AnnotationException("Embeddable class '" + component.getComponentClassName() + "' may not have a property annotated '@Id' since it is used by '" + BinderHelper.getPath(propertyHolder, inferredData) + "' as an '@EmbeddedId'");
        }
        if (referencedEntityName == null && component.getPropertySpan() == 0) {
            throw new AnnotationException("Embeddable class '" + component.getComponentClassName() + "' may not be used as an '@EmbeddedId' by '" + BinderHelper.getPath(propertyHolder, inferredData) + "' because it has no properties");
        }
    }

    static Component fillEmbeddable(PropertyHolder propertyHolder, PropertyData inferredData, AccessType propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedColumns columns, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass) {
        return EmbeddableBinder.fillEmbeddable(propertyHolder, inferredData, null, propertyAccessor, null, isNullable, entityBinder, isComponentEmbedded, isIdentifierMapper, inSecondPass, customInstantiatorImpl, compositeUserTypeClass, columns, context, inheritanceStatePerClass, false);
    }

    static Component fillEmbeddable(PropertyHolder propertyHolder, PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, ClassDetails entityAtStake, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedColumns columns, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, boolean isIdClass) {
        List<PropertyData> baseClassElements;
        ClassDetails returnedClassOrElement;
        CompositeUserType<?> compositeUserType;
        Component component = EmbeddableBinder.createEmbeddable(propertyHolder, inferredData, isComponentEmbedded, isIdentifierMapper, customInstantiatorImpl, context);
        String subpath = BinderHelper.getPath(propertyHolder, inferredData);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Binding embeddable with path: " + subpath);
        }
        PropertyHolder subholder = PropertyHolderBuilder.buildPropertyHolder(component, subpath, inferredData, propertyHolder, context, inheritanceStatePerClass);
        propertyHolder.startingProperty(inferredData.getAttributeMember());
        if (compositeUserTypeClass == null) {
            compositeUserType = null;
            returnedClassOrElement = inferredData.getClassOrElementType().determineRawClass();
        } else {
            compositeUserType = EmbeddableBinder.compositeUserType(compositeUserTypeClass, context);
            component.setTypeName(compositeUserTypeClass.getName());
            returnedClassOrElement = context.getBootstrapContext().getModelsContext().getClassDetailsRegistry().resolveClassDetails(compositeUserType.embeddable().getName());
        }
        AggregateComponentBinder.processAggregate(component, propertyHolder, inferredData, returnedClassOrElement, columns, context);
        InheritanceState inheritanceState = inheritanceStatePerClass.get(returnedClassOrElement);
        if (inheritanceState != null) {
            inheritanceState.postProcess(component);
            EmbeddableBinder.bindDiscriminator(component, returnedClassOrElement, propertyHolder, subholder, inferredData, inheritanceState, context);
        }
        HashMap<String, String> subclassToSuperclass = component.isPolymorphic() ? new HashMap<String, String>() : null;
        TypeDetails annotatedType = inferredData.getPropertyType();
        List<PropertyData> classElements = EmbeddableBinder.collectClassElements(propertyAccessor, context, returnedClassOrElement, annotatedType, isIdClass, subclassToSuperclass);
        if (component.isPolymorphic()) {
            EmbeddableBinder.validateInheritanceIsSupported(subholder, compositeUserType);
            BasicType discriminatorType = (BasicType)component.getDiscriminator().getType();
            LinkedHashMap<Object, String> discriminatorValues = new LinkedHashMap<Object, String>();
            EmbeddableBinder.collectDiscriminatorValue(returnedClassOrElement, discriminatorType, discriminatorValues);
            EmbeddableBinder.collectSubclassElements(propertyAccessor, context, returnedClassOrElement, classElements, discriminatorType, discriminatorValues, subclassToSuperclass);
            component.setDiscriminatorValues(discriminatorValues);
            component.setSubclassToSuperclass(subclassToSuperclass);
        }
        if ((baseClassElements = EmbeddableBinder.collectBaseClassElements(baseInferredData, propertyAccessor, context, entityAtStake)) != null && !EmbeddableBinder.hasAnnotationsOnIdClass(annotatedType)) {
            EmbeddableBinder.processIdClassElements(propertyHolder, baseInferredData, classElements, baseClassElements);
        }
        for (PropertyData propertyAnnotatedElement : classElements) {
            PropertyBinder.processElementAnnotations(subholder, entityBinder.getPersistentClass() instanceof SingleTableSubclass ? Nullability.FORCED_NULL : (isNullable ? Nullability.NO_CONSTRAINT : Nullability.FORCED_NOT_NULL), propertyAnnotatedElement, entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, context, inheritanceStatePerClass);
            MemberDetails member = propertyAnnotatedElement.getAttributeMember();
            if (isIdClass || subholder.isOrWithinEmbeddedId()) {
                Property property = EmbeddableBinder.findProperty(component, member.getName());
                if (property == null) continue;
                SimpleValue value = (SimpleValue)property.getValue();
                GeneratorBinder.createIdGeneratorsFromGeneratorAnnotations(subholder, propertyAnnotatedElement, value, context);
                continue;
            }
            if (!member.hasDirectAnnotationUsage(GeneratedValue.class)) continue;
            throw new AnnotationException("Property '" + member.getName() + "' of '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is annotated '@GeneratedValue' but is not part of an identifier");
        }
        if (compositeUserType != null) {
            EmbeddableBinder.processCompositeUserType(component, compositeUserType);
        }
        return component;
    }

    private static Property findProperty(Component component, String name) {
        for (Property property : component.getProperties()) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    private static CompositeUserType<?> compositeUserType(Class<? extends CompositeUserType<?>> compositeUserTypeClass, MetadataBuildingContext context) {
        if (!context.getBuildingOptions().isAllowExtensionsInCdi()) {
            FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(compositeUserTypeClass);
        }
        return context.getBootstrapContext().getManagedBeanRegistry().getBean(compositeUserTypeClass).getBeanInstance();
    }

    private static void bindDiscriminator(Component component, ClassDetails componentClass, PropertyHolder parentHolder, PropertyHolder holder, PropertyData propertyData, InheritanceState inheritanceState, MetadataBuildingContext context) {
        if (inheritanceState == null) {
            return;
        }
        AnnotatedDiscriminatorColumn discriminatorColumn = EmbeddableBinder.processEmbeddableDiscriminatorProperties(componentClass, propertyData, parentHolder, holder, inheritanceState, context);
        if (discriminatorColumn != null) {
            EmbeddableBinder.bindDiscriminatorColumnToComponent(component, discriminatorColumn, holder, context);
        }
    }

    private static AnnotatedDiscriminatorColumn processEmbeddableDiscriminatorProperties(ClassDetails annotatedClass, PropertyData propertyData, PropertyHolder parentHolder, PropertyHolder holder, InheritanceState inheritanceState, MetadataBuildingContext context) {
        DiscriminatorColumn discriminatorColumn = annotatedClass.getDirectAnnotationUsage(DiscriminatorColumn.class);
        DiscriminatorFormula discriminatorFormula = DialectOverridesAnnotationHelper.getOverridableAnnotation(annotatedClass, DiscriminatorFormula.class, context);
        if (!inheritanceState.hasParents()) {
            if (inheritanceState.hasSiblings()) {
                jakarta.persistence.Column[] overrides;
                String columnPrefix;
                String path = StringHelper.qualify(holder.getPath(), "{discriminator}");
                if (holder.isWithinElementCollection()) {
                    columnPrefix = StringHelper.unqualify(parentHolder.getPath());
                    overrides = parentHolder.getOverriddenColumn(path);
                } else {
                    columnPrefix = propertyData.getPropertyName();
                    overrides = holder.getOverriddenColumn(path);
                }
                return AnnotatedDiscriminatorColumn.buildDiscriminatorColumn(discriminatorColumn, discriminatorFormula, overrides == null ? null : overrides[0], columnPrefix + "_DTYPE", context);
            }
        } else {
            if (discriminatorColumn != null) {
                throw new AnnotationException(String.format("Embeddable class '%s' is annotated '@DiscriminatorColumn' but it is not the root of the inheritance hierarchy", annotatedClass.getName()));
            }
            if (discriminatorFormula != null) {
                throw new AnnotationException(String.format("Embeddable class '%s' is annotated '@DiscriminatorFormula' but it is not the root of the inheritance hierarchy", annotatedClass.getName()));
            }
        }
        return null;
    }

    private static void bindDiscriminatorColumnToComponent(Component component, AnnotatedDiscriminatorColumn discriminatorColumn, PropertyHolder holder, MetadataBuildingContext context) {
        assert (component.getDiscriminator() == null);
        AnnotatedColumns columns = new AnnotatedColumns();
        columns.setPropertyHolder(holder);
        columns.setBuildingContext(context);
        discriminatorColumn.setParent(columns);
        BasicValue discriminatorColumnBinding = new BasicValue(context, component.getTable());
        discriminatorColumnBinding.setAggregateColumn(component.getAggregateColumn());
        component.setDiscriminator(discriminatorColumnBinding);
        discriminatorColumn.linkWithValue(discriminatorColumnBinding);
        discriminatorColumnBinding.setTypeName(discriminatorColumn.getDiscriminatorTypeName());
    }

    private static void validateInheritanceIsSupported(PropertyHolder holder, CompositeUserType<?> compositeUserType) {
        if (holder.isOrWithinEmbeddedId()) {
            throw new AnnotationException(String.format("Embeddable class '%s' defines an inheritance hierarchy and cannot be used in an '@EmbeddedId'", holder.getClassName()));
        }
        if (holder.isInIdClass()) {
            throw new AnnotationException(String.format("Embeddable class '%s' defines an inheritance hierarchy and cannot be used in an '@IdClass'", holder.getClassName()));
        }
        if (compositeUserType != null) {
            throw new AnnotationException(String.format("Embeddable class '%s' defines an inheritance hierarchy and cannot be used with a custom '@CompositeType'", holder.getClassName()));
        }
    }

    private static List<PropertyData> collectClassElements(AccessType propertyAccessor, MetadataBuildingContext context, ClassDetails returnedClassOrElement, TypeDetails annotatedClass, boolean isIdClass, Map<String, String> subclassToSuperclass) {
        ClassDetails superClass;
        ArrayList<PropertyData> classElements = new ArrayList<PropertyData>();
        PropertyContainer container = new PropertyContainer(returnedClassOrElement, annotatedClass, propertyAccessor);
        PropertyBinder.addElementsOfClass(classElements, container, context, 0);
        ClassDetails subclass = returnedClassOrElement;
        while (EmbeddableBinder.isValidSuperclass(superClass = subclass.getSuperClass(), isIdClass)) {
            PropertyContainer superContainer = new PropertyContainer(superClass, annotatedClass, propertyAccessor);
            PropertyBinder.addElementsOfClass(classElements, superContainer, context, 0);
            if (subclassToSuperclass != null) {
                subclassToSuperclass.put(subclass.getName(), superClass.getName());
            }
            subclass = superClass;
        }
        return classElements;
    }

    private static void collectSubclassElements(AccessType propertyAccessor, MetadataBuildingContext context, ClassDetails superclass, List<PropertyData> classElements, BasicType<?> discriminatorType, Map<Object, String> discriminatorValues, Map<String, String> subclassToSuperclass) {
        for (ClassDetails subclass : context.getMetadataCollector().getEmbeddableSubclasses(superclass)) {
            String old = EmbeddableBinder.collectDiscriminatorValue(subclass, discriminatorType, discriminatorValues);
            if (old != null) {
                throw new AnnotationException(String.format("Embeddable subclass '%s' defines the same discriminator value as '%s", subclass.getName(), old));
            }
            String put = subclassToSuperclass.put(subclass.getName().intern(), superclass.getName().intern());
            assert (put == null);
            PropertyContainer superContainer = new PropertyContainer(subclass, superclass, propertyAccessor);
            PropertyBinder.addElementsOfClass(classElements, superContainer, context, 0);
            EmbeddableBinder.collectSubclassElements(propertyAccessor, context, subclass, classElements, discriminatorType, discriminatorValues, subclassToSuperclass);
        }
    }

    private static String collectDiscriminatorValue(ClassDetails annotatedClass, BasicType<?> discriminatorType, Map<Object, String> discriminatorValues) {
        String discriminatorValue;
        String explicitValue;
        String string = explicitValue = annotatedClass.hasDirectAnnotationUsage(DiscriminatorValue.class) ? annotatedClass.getDirectAnnotationUsage(DiscriminatorValue.class).value() : null;
        if (StringHelper.isBlank(explicitValue)) {
            String name = StringHelper.unqualify(annotatedClass.getName());
            if ("character".equals(discriminatorType.getName())) {
                throw new AnnotationException(String.format("Embeddable '%s' has a discriminator of character type and must specify its '@DiscriminatorValue'", name));
            }
            discriminatorValue = "integer".equals(discriminatorType.getName()) ? String.valueOf(name.hashCode()) : name;
        } else {
            discriminatorValue = explicitValue;
        }
        return discriminatorValues.put(discriminatorType.getJavaTypeDescriptor().fromString(discriminatorValue), annotatedClass.getName().intern());
    }

    private static boolean isValidSuperclass(ClassDetails superClass, boolean isIdClass) {
        if (superClass == null) {
            return false;
        }
        return superClass.hasDirectAnnotationUsage(MappedSuperclass.class) || isIdClass && !superClass.getName().equals(Object.class.getName()) && !superClass.getName().equals("java.lang.Record");
    }

    private static List<PropertyData> collectBaseClassElements(PropertyData baseInferredData, AccessType propertyAccessor, MetadataBuildingContext context, ClassDetails entityAtStake) {
        if (baseInferredData != null) {
            ArrayList<PropertyData> baseClassElements = new ArrayList<PropertyData>();
            TypeDetails baseReturnedClassOrElement = baseInferredData.getClassOrElementType();
            while (!Object.class.getName().equals(baseReturnedClassOrElement.getName())) {
                PropertyContainer container = new PropertyContainer(baseReturnedClassOrElement.determineRawClass(), entityAtStake, propertyAccessor);
                PropertyBinder.addElementsOfClass(baseClassElements, container, context, 0);
                baseReturnedClassOrElement = baseReturnedClassOrElement.determineRawClass().getGenericSuperType();
            }
            return baseClassElements;
        }
        return null;
    }

    private static void processCompositeUserType(Component component, CompositeUserType<?> compositeUserType) {
        component.sortProperties();
        ArrayList<String> sortedPropertyNames = new ArrayList<String>(component.getPropertySpan());
        ArrayList<Type> sortedPropertyTypes = new ArrayList<Type>(component.getPropertySpan());
        PropertyAccessStrategyCompositeUserTypeImpl strategy = new PropertyAccessStrategyCompositeUserTypeImpl(compositeUserType, sortedPropertyNames, sortedPropertyTypes);
        for (Property property : component.getProperties()) {
            sortedPropertyNames.add(property.getName());
            sortedPropertyTypes.add(PropertyAccessStrategyGetterImpl.INSTANCE.buildPropertyAccess(compositeUserType.embeddable(), property.getName(), false).getGetter().getReturnType());
            property.setPropertyAccessStrategy(strategy);
        }
    }

    private static boolean hasAnnotationsOnIdClass(TypeDetails idClassType) {
        return EmbeddableBinder.hasAnnotationsOnIdClass(idClassType.determineRawClass());
    }

    private static boolean hasAnnotationsOnIdClass(ClassDetails idClass) {
        for (FieldDetails field : idClass.getFields()) {
            if (!EmbeddableBinder.hasTriggeringAnnotation(field)) continue;
            return true;
        }
        for (MethodDetails method : idClass.getMethods()) {
            if (!EmbeddableBinder.hasTriggeringAnnotation(method)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTriggeringAnnotation(MemberDetails property) {
        return property.hasDirectAnnotationUsage(jakarta.persistence.Column.class) || property.hasDirectAnnotationUsage(OneToMany.class) || property.hasDirectAnnotationUsage(ManyToOne.class) || property.hasDirectAnnotationUsage(Id.class) || property.hasDirectAnnotationUsage(GeneratedValue.class) || property.hasDirectAnnotationUsage(OneToOne.class) || property.hasDirectAnnotationUsage(ManyToMany.class);
    }

    private static void processIdClassElements(PropertyHolder propertyHolder, PropertyData baseInferredData, List<PropertyData> classElements, List<PropertyData> baseClassElements) {
        HashMap<String, PropertyData> baseClassElementsByName = new HashMap<String, PropertyData>();
        for (PropertyData element : baseClassElements) {
            baseClassElementsByName.put(element.getPropertyName(), element);
        }
        for (int i = 0; i < classElements.size(); ++i) {
            PropertyData idClassPropertyData = classElements.get(i);
            String propertyName = idClassPropertyData.getPropertyName();
            PropertyData entityPropertyData = (PropertyData)baseClassElementsByName.get(propertyName);
            if (propertyHolder.isInIdClass()) {
                if (entityPropertyData == null) {
                    throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, idClassPropertyData) + "' belongs to an '@IdClass' but has no matching property in entity class '" + baseInferredData.getPropertyType().getName() + "' (every property of the '@IdClass' must have a corresponding persistent property in the '@Entity' class)");
                }
                if (BinderHelper.hasToOneAnnotation(entityPropertyData.getAttributeMember()) && !entityPropertyData.getClassOrElementType().equals(idClassPropertyData.getClassOrElementType())) continue;
                if (!EmbeddableBinder.hasCompatibleType(idClassPropertyData.getTypeName(), entityPropertyData.getTypeName())) {
                    throw new AnnotationException("Property '" + propertyName + "' in @IdClass '" + idClassPropertyData.getDeclaringClass().getName() + "' doesn't match type in entity class '" + baseInferredData.getPropertyType().getName() + "' (expected '" + entityPropertyData.getTypeName() + "' but was '" + idClassPropertyData.getTypeName() + "')");
                }
            }
            classElements.set(i, entityPropertyData);
        }
    }

    private static boolean hasCompatibleType(String typeNameInIdClass, String typeNameInEntityClass) {
        return typeNameInIdClass.equals(typeNameInEntityClass) || EmbeddableBinder.canonicalize(typeNameInIdClass).equals(typeNameInEntityClass) || typeNameInIdClass.equals(EmbeddableBinder.canonicalize(typeNameInEntityClass));
    }

    private static String canonicalize(String typeName) {
        return switch (typeName) {
            case "boolean" -> Boolean.class.getName();
            case "char" -> Character.class.getName();
            case "int" -> Integer.class.getName();
            case "long" -> Long.class.getName();
            case "short" -> Short.class.getName();
            case "byte" -> Byte.class.getName();
            case "float" -> Float.class.getName();
            case "double" -> Double.class.getName();
            default -> typeName;
        };
    }

    static Component createEmbeddable(PropertyHolder propertyHolder, PropertyData inferredData, boolean isComponentEmbedded, boolean isIdentifierMapper, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, MetadataBuildingContext context) {
        Component component = new Component(context, propertyHolder.getPersistentClass());
        component.setEmbedded(isComponentEmbedded);
        component.setTable(propertyHolder.getTable());
        if (isIdentifierMapper || isComponentEmbedded && inferredData.getPropertyName() == null) {
            component.setComponentClassName(component.getOwner().getClassName());
        } else {
            TypeDetails type = inferredData.getClassOrElementType();
            component.setComponentClassName(type.getName());
            EmbeddableBinder.checkEmbeddableRecursiveHierarchy(type, inferredData, propertyHolder);
        }
        component.setCustomInstantiator(customInstantiatorImpl);
        Constructor<?> constructor = EmbeddableBinder.resolveInstantiator(inferredData.getClassOrElementType());
        if (constructor != null) {
            component.setInstantiator(constructor, constructor.getAnnotation(Instantiator.class).value());
        }
        if (propertyHolder.isComponent()) {
            ComponentPropertyHolder componentPropertyHolder = (ComponentPropertyHolder)propertyHolder;
            component.setParentAggregateColumn(componentPropertyHolder.getAggregateColumn());
        }
        EmbeddableBinder.applyColumnNamingPattern(component, inferredData);
        return component;
    }

    private static void checkEmbeddableRecursiveHierarchy(TypeDetails type, PropertyData propertyData, PropertyHolder propertyHolder) {
        ClassDetails embeddableClass = type.determineRawClass();
        while (propertyHolder.isComponent()) {
            ComponentPropertyHolder componentHolder = (ComponentPropertyHolder)propertyHolder;
            for (ClassDetails classDetails = embeddableClass; classDetails != null; classDetails = classDetails.getSuperClass()) {
                if (!propertyHolder.getClassName().equals(classDetails.getClassName())) continue;
                throw new MappingException(String.format(Locale.ROOT, "Recursive embeddable mapping detected for property '%s' for type [%s]", BinderHelper.getPath(propertyHolder, propertyData), propertyHolder.getClassName()));
            }
            propertyHolder = componentHolder.parent;
        }
    }

    private static void applyColumnNamingPattern(Component component, PropertyData inferredData) {
        Class<?> componentClass = component.getComponentClass();
        if (componentClass == null || Map.class.equals(componentClass)) {
            return;
        }
        if (inferredData.getAttributeMember() == null) {
            return;
        }
        EmbeddedColumnNaming columnNaming = inferredData.getAttributeMember().getDirectAnnotationUsage(EmbeddedColumnNaming.class);
        if (columnNaming == null) {
            return;
        }
        String columnNamingPattern = NullnessHelper.coalesce(columnNaming.value(), inferredData.getPropertyName() + "_%s");
        int markerCount = StringHelper.count(columnNamingPattern, '%');
        if (markerCount != 1) {
            throw new MappingException(String.format(Locale.ROOT, "@EmbeddedColumnNaming expects pattern with exactly 1 format maker, but found %s - `%s` (%s#%s)", markerCount, columnNamingPattern, inferredData.getAttributeMember().getDeclaringType().getName(), inferredData.getAttributeMember().getName()));
        }
        component.setColumnNamingPattern(columnNamingPattern);
    }

    private static Constructor<?> resolveInstantiator(TypeDetails embeddableClass) {
        return embeddableClass == null ? null : EmbeddableBinder.resolveInstantiator(embeddableClass.determineRawClass());
    }

    private static Constructor<?> resolveInstantiator(ClassDetails embeddableClass) {
        if (embeddableClass != null) {
            Constructor<?>[] declaredConstructors = embeddableClass.toJavaClass().getDeclaredConstructors();
            Constructor<?> constructor = null;
            for (Constructor<?> declaredConstructor : declaredConstructors) {
                if (!declaredConstructor.isAnnotationPresent(Instantiator.class)) continue;
                if (constructor != null) {
                    throw new AnnotationException("Multiple constructors of '" + embeddableClass.getName() + "' are annotated '@Instantiator' but only one constructor can be the canonical constructor");
                }
                constructor = declaredConstructor;
            }
            return constructor;
        }
        return null;
    }

    public static Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> determineCustomInstantiator(MemberDetails property, ClassDetails returnedClass, MetadataBuildingContext context) {
        if (property.hasDirectAnnotationUsage(EmbeddedId.class)) {
            return null;
        }
        EmbeddableInstantiator propertyAnnotation = property.getDirectAnnotationUsage(EmbeddableInstantiator.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.value();
        }
        EmbeddableInstantiator classAnnotation = returnedClass.getDirectAnnotationUsage(EmbeddableInstantiator.class);
        if (classAnnotation != null) {
            return classAnnotation.value();
        }
        if (returnedClass.getClassName() != null) {
            return context.getMetadataCollector().findRegisteredEmbeddableInstantiator(returnedClass.toJavaClass());
        }
        return null;
    }

    private static class CopyIdentifierComponentSecondPass
    implements FkSecondPass {
        private final String referencedEntityName;
        private final String propertyName;
        private final Component component;
        private final MetadataBuildingContext buildingContext;
        private final AnnotatedJoinColumns joinColumns;

        private CopyIdentifierComponentSecondPass(Component component, String referencedEntityName, String propertyName, AnnotatedJoinColumns joinColumns, MetadataBuildingContext buildingContext) {
            this.component = component;
            this.referencedEntityName = referencedEntityName;
            this.propertyName = propertyName;
            this.buildingContext = buildingContext;
            this.joinColumns = joinColumns;
        }

        @Override
        public Value getValue() {
            return this.component;
        }

        @Override
        public String getReferencedEntityName() {
            return this.referencedEntityName;
        }

        @Override
        public boolean isInPrimaryKey() {
            return true;
        }

        @Override
        public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
            PersistentClass referencedPersistentClass = persistentClasses.get(this.referencedEntityName);
            Component referencedComponent = this.getReferencedComponent(referencedPersistentClass);
            boolean isExplicitReference = true;
            List<AnnotatedJoinColumn> columns = this.joinColumns.getJoinColumns();
            HashMap<String, AnnotatedJoinColumn> columnByReferencedName = CollectionHelper.mapOfSize(columns.size());
            for (AnnotatedJoinColumn joinColumn : columns) {
                if (joinColumn.isReferenceImplicit()) continue;
                columnByReferencedName.put(joinColumn.getReferencedColumn().toLowerCase(Locale.ROOT), joinColumn);
            }
            if (columnByReferencedName.isEmpty()) {
                isExplicitReference = false;
                for (int i = 0; i < columns.size(); ++i) {
                    columnByReferencedName.put(String.valueOf(i), columns.get(i));
                }
            }
            MutableInteger index = new MutableInteger();
            for (Property referencedProperty : referencedComponent.getProperties()) {
                Property property = referencedProperty.isComposite() ? this.createComponentProperty(isExplicitReference, columnByReferencedName, index, referencedProperty) : this.createSimpleProperty(referencedPersistentClass, isExplicitReference, columnByReferencedName, index, referencedProperty);
                this.component.addProperty(property);
            }
        }

        private Component getReferencedComponent(PersistentClass referencedPersistentClass) {
            if (referencedPersistentClass == null) {
                throw new AnnotationException("Unknown entity name '" + this.referencedEntityName + "'");
            }
            KeyValue keyValue = referencedPersistentClass.getIdentifier();
            if (keyValue instanceof Component) {
                Component id = (Component)keyValue;
                return id;
            }
            throw new AnnotationException("Missing 'value' in '@MapsId' annotation of association '" + this.propertyName + "' of entity '" + this.component.getOwner().getEntityName() + "' with composite identifier type ('@MapsId' must specify a property of the '@EmbeddedId' class which has the foreign key of '" + this.referencedEntityName + "')");
        }

        private Property createComponentProperty(boolean isExplicitReference, Map<String, AnnotatedJoinColumn> columnByReferencedName, MutableInteger index, Property referencedProperty) {
            Property property = new Property();
            property.setName(referencedProperty.getName());
            property.setPersistentClass(this.component.getOwner());
            property.setPropertyAccessorName(referencedProperty.getPropertyAccessorName());
            Component value = new Component(this.buildingContext, this.component.getOwner());
            property.setValue(value);
            Component referencedValue = (Component)referencedProperty.getValue();
            value.setTypeName(referencedValue.getTypeName());
            value.setTypeParameters(referencedValue.getTypeParameters());
            value.setComponentClassName(referencedValue.getComponentClassName());
            for (Property referencedComponentProperty : referencedValue.getProperties()) {
                if (referencedComponentProperty.isComposite()) {
                    value.addProperty(this.createComponentProperty(isExplicitReference, columnByReferencedName, index, referencedComponentProperty));
                    continue;
                }
                value.addProperty(this.createSimpleProperty(referencedValue.getOwner(), isExplicitReference, columnByReferencedName, index, referencedComponentProperty));
            }
            return property;
        }

        private Property createSimpleProperty(PersistentClass referencedPersistentClass, boolean isExplicitReference, Map<String, AnnotatedJoinColumn> columnByReferencedName, MutableInteger index, Property referencedProperty) {
            Property property = new Property();
            property.setName(referencedProperty.getName());
            property.setPersistentClass(this.component.getOwner());
            property.setPropertyAccessorName(referencedProperty.getPropertyAccessorName());
            BasicValue value = new BasicValue(this.buildingContext, this.component.getTable());
            property.setValue(value);
            SimpleValue referencedValue = (SimpleValue)referencedProperty.getValue();
            ((SimpleValue)value).copyTypeFrom(referencedValue);
            AnnotatedJoinColumn firstColumn = this.joinColumns.getJoinColumns().get(0);
            if (firstColumn.isNameDeferred()) {
                firstColumn.copyReferencedStructureAndCreateDefaultJoinColumns(referencedPersistentClass, referencedValue, value);
            } else {
                for (Selectable selectable : referencedValue.getSelectables()) {
                    AnnotatedJoinColumn joinColumn;
                    String logicalColumnName;
                    if (!(selectable instanceof Column)) continue;
                    Column column = (Column)selectable;
                    if (isExplicitReference) {
                        logicalColumnName = column.getName();
                        joinColumn = columnByReferencedName.get(logicalColumnName.toLowerCase(Locale.ROOT));
                    } else {
                        logicalColumnName = null;
                        joinColumn = columnByReferencedName.get(String.valueOf(index.get()));
                        index.getAndIncrement();
                    }
                    if (joinColumn == null && !firstColumn.isNameDeferred()) {
                        throw new AnnotationException("Property '" + this.propertyName + "' of entity '" + this.component.getOwner().getEntityName() + "' must have a '@JoinColumn' which references the foreign key column '" + logicalColumnName + "'");
                    }
                    Object columnName = joinColumn == null || joinColumn.isNameDeferred() ? "tata_" + column.getName() : joinColumn.getName();
                    Database database = this.buildingContext.getMetadataCollector().getDatabase();
                    String physicalName = this.buildingContext.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalColumnName(database.toIdentifier((String)columnName), database.getJdbcEnvironment()).render(database.getDialect());
                    ((SimpleValue)value).addColumn(new Column(physicalName));
                    if (joinColumn != null) {
                        this.applyComponentColumnSizeValueToJoinColumn(column, joinColumn);
                        joinColumn.linkWithValue(value);
                    }
                    column.setValue(value);
                }
            }
            return property;
        }

        private void applyComponentColumnSizeValueToJoinColumn(Column column, AnnotatedJoinColumn joinColumn) {
            Column mappingColumn = joinColumn.getMappingColumn();
            mappingColumn.setLength(column.getLength());
            mappingColumn.setPrecision(column.getPrecision());
            mappingColumn.setScale(column.getScale());
            mappingColumn.setArrayLength(column.getArrayLength());
        }
    }
}

