/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Basic;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKey;
import jakarta.persistence.MapKeyClass;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.MapKeyEnumerated;
import jakarta.persistence.MapKeyJoinColumn;
import jakarta.persistence.MapKeyJoinColumns;
import jakarta.persistence.MapKeyTemporal;
import jakarta.persistence.MapsId;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderBy;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Temporal;
import jakarta.persistence.Version;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AttributeBinderType;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.CompositeType;
import org.hibernate.annotations.EmbeddableInstantiator;
import org.hibernate.annotations.IdGeneratorType;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.LazyGroup;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Parent;
import org.hibernate.binder.AttributeBinder;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.AnyBinder;
import org.hibernate.boot.model.internal.BasicValueBinder;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.CannotForceNonNullableException;
import org.hibernate.boot.model.internal.ClassPropertyHolder;
import org.hibernate.boot.model.internal.CollectionBinder;
import org.hibernate.boot.model.internal.ColumnsBuilder;
import org.hibernate.boot.model.internal.EmbeddableBinder;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.NaturalIdBinder;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.OptionalDeterminationSecondPass;
import org.hibernate.boot.model.internal.PropertyContainer;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.PropertyInferredData;
import org.hibernate.boot.model.internal.PropertyPreloadedData;
import org.hibernate.boot.model.internal.TimeZoneStorageHelper;
import org.hibernate.boot.model.internal.ToOneBinder;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.EventTypeSets;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.ArrayTypeDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;
import org.hibernate.usertype.CompositeUserType;

public class PropertyBinder {
    private MetadataBuildingContext buildingContext;
    private String name;
    private String returnedClassName;
    private boolean lazy;
    private String lazyGroup;
    private AccessType accessType;
    private AnnotatedColumns columns;
    private PropertyHolder holder;
    private Value value;
    private Component componentElement;
    private boolean insertable = true;
    private boolean updatable = true;
    private EnumSet<CascadeType> cascadeTypes;
    private BasicValueBinder basicValueBinder;
    private ClassDetails declaringClass;
    private boolean declaringClassSet;
    private boolean embedded;
    private EntityBinder entityBinder;
    private boolean toMany;
    private String referencedEntityName;
    private MemberDetails memberDetails;
    private TypeDetails returnedClass;
    private boolean isId;
    private Map<ClassDetails, InheritanceState> inheritanceStatePerClass;

    protected ModelsContext getSourceModelContext() {
        return this.buildingContext.getBootstrapContext().getModelsContext();
    }

    private void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public void setEntityBinder(EntityBinder entityBinder) {
        this.entityBinder = entityBinder;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setName(String name) {
        this.name = name;
    }

    private void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setLazyGroup(String lazyGroup) {
        this.lazyGroup = lazyGroup;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public void setColumns(AnnotatedColumns columns) {
        this.columns = columns;
    }

    public void setHolder(PropertyHolder holder) {
        this.holder = holder;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    private void setComponentElement(Component componentElement) {
        this.componentElement = componentElement;
    }

    public void setCascade(EnumSet<CascadeType> cascadeTypes) {
        this.cascadeTypes = cascadeTypes;
    }

    public void setBuildingContext(MetadataBuildingContext buildingContext) {
        this.buildingContext = buildingContext;
    }

    public void setDeclaringClass(ClassDetails declaringClassDetails) {
        this.declaringClass = declaringClassDetails;
        this.declaringClassSet = true;
    }

    private boolean isToOneValue(Value value) {
        return value instanceof ToOne;
    }

    public void setMemberDetails(MemberDetails memberDetails) {
        this.memberDetails = memberDetails;
    }

    private void setReturnedClass(TypeDetails returnedClass) {
        this.returnedClass = returnedClass;
    }

    private BasicValueBinder getBasicValueBinder() {
        return this.basicValueBinder;
    }

    private Value getValue() {
        return this.value;
    }

    public void setId(boolean id) {
        this.isId = id;
    }

    public boolean isId() {
        return this.isId;
    }

    public void setInheritanceStatePerClass(Map<ClassDetails, InheritanceState> inheritanceStatePerClass) {
        this.inheritanceStatePerClass = inheritanceStatePerClass;
    }

    private void validateBind() {
        if (!this.declaringClassSet) {
            throw new AssertionFailure("declaringClass has not been set before a bind");
        }
    }

    private void validateMake() {
    }

    private Property makePropertyAndValue() {
        this.validateBind();
        String containerClassName = this.holder.getClassName();
        this.holder.startingProperty(this.memberDetails);
        this.basicValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ATTRIBUTE, this.buildingContext);
        this.basicValueBinder.setReturnedClassName(this.returnedClassName);
        this.basicValueBinder.setColumns(this.columns);
        this.basicValueBinder.setPersistentClassName(containerClassName);
        this.basicValueBinder.setType(this.memberDetails, this.returnedClass, containerClassName, this.holder.resolveAttributeConverterDescriptor(this.memberDetails, this.autoApplyConverters()));
        this.basicValueBinder.setReferencedEntityName(this.referencedEntityName);
        this.basicValueBinder.setAccessType(this.accessType);
        this.value = this.basicValueBinder.make();
        return this.makeProperty();
    }

    private boolean autoApplyConverters() {
        return !this.isId && !PropertyBinder.isVersion(this.memberDetails) && !this.memberDetails.hasDirectAnnotationUsage(Enumerated.class) && !this.memberDetails.hasDirectAnnotationUsage(Temporal.class);
    }

    private void callAttributeBinders(Property property, Map<String, PersistentClass> persistentClasses) {
        List<Annotation> metaAnnotatedTargets = this.memberDetails.getMetaAnnotated(AttributeBinderType.class, this.getSourceModelContext());
        if (!CollectionHelper.isEmpty(metaAnnotatedTargets)) {
            AnnotationDescriptorRegistry descriptorRegistry = this.getSourceModelContext().getAnnotationDescriptorRegistry();
            for (int i = 0; i < metaAnnotatedTargets.size(); ++i) {
                Annotation metaAnnotatedTarget = metaAnnotatedTargets.get(i);
                AnnotationDescriptor<? extends Annotation> metaAnnotatedDescriptor = descriptorRegistry.getDescriptor(metaAnnotatedTarget.annotationType());
                AttributeBinderType binderTypeAnn = metaAnnotatedDescriptor.getDirectAnnotationUsage(AttributeBinderType.class);
                try {
                    AttributeBinder<?> binder = binderTypeAnn.binder().getConstructor(new Class[0]).newInstance(new Object[0]);
                    PersistentClass persistentClass = this.entityBinder != null ? this.entityBinder.getPersistentClass() : persistentClasses.get(this.holder.getEntityName());
                    binder.bind(metaAnnotatedTarget, this.buildingContext, persistentClass, property);
                    continue;
                }
                catch (Exception e) {
                    throw new AnnotationException("error processing @AttributeBinderType annotation '" + metaAnnotatedDescriptor.getAnnotationType().getName() + "' for property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "'", e);
                }
            }
        }
    }

    public Property makePropertyAndBind() {
        return this.bind(this.makeProperty());
    }

    private Property makePropertyValueAndBind() {
        return this.bind(this.makePropertyAndValue());
    }

    public void setToMany(boolean toMany) {
        this.toMany = toMany;
    }

    private Property bind(Property property) {
        if (this.isId) {
            this.bindId(property);
        } else {
            this.holder.addProperty(property, this.memberDetails, this.columns, this.declaringClass);
        }
        this.callAttributeBindersInSecondPass(property);
        return property;
    }

    void callAttributeBindersInSecondPass(Property property) {
        InFlightMetadataCollector metadataCollector = this.buildingContext.getMetadataCollector();
        if (metadataCollector.isInSecondPass()) {
            this.callAttributeBinders(property, metadataCollector.getEntityBindingMap());
        } else {
            metadataCollector.addSecondPass(persistentClasses -> this.callAttributeBinders(property, persistentClasses));
        }
    }

    private void bindId(Property property) {
        RootClass rootClass = (RootClass)this.holder.getPersistentClass();
        if (this.toMany || this.entityBinder.wrapIdsInEmbeddedComponents()) {
            this.getOrCreateCompositeId(rootClass).addProperty(property);
        } else {
            rootClass.setIdentifier((KeyValue)this.getValue());
            if (this.embedded) {
                rootClass.setEmbeddedIdentifier(true);
            } else {
                rootClass.setIdentifierProperty(property);
                MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(this.declaringClass, this.inheritanceStatePerClass, this.buildingContext);
                this.setDeclaredIdentifier(rootClass, superclass, property);
            }
        }
    }

    private void setDeclaredIdentifier(RootClass rootClass, MappedSuperclass superclass, Property prop) {
        ClassPropertyHolder.handleGenericComponentProperty(prop, this.memberDetails, this.buildingContext);
        if (superclass == null) {
            rootClass.setDeclaredIdentifierProperty(prop);
        } else {
            ClassPropertyHolder.prepareActualProperty(prop, this.memberDetails, false, this.buildingContext, superclass::setDeclaredIdentifierProperty);
        }
    }

    private Component getOrCreateCompositeId(RootClass rootClass) {
        Component id = (Component)rootClass.getIdentifier();
        if (id == null) {
            Component identifier = EmbeddableBinder.createEmbeddable(this.holder, new PropertyPreloadedData(), true, false, this.resolveCustomInstantiator(this.memberDetails, this.returnedClass.determineRawClass()), this.buildingContext);
            rootClass.setIdentifier(identifier);
            identifier.setNullValueUndefined();
            rootClass.setEmbeddedIdentifier(true);
            rootClass.setIdentifierMapper(identifier);
            return identifier;
        }
        return id;
    }

    private Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> resolveCustomInstantiator(MemberDetails property, ClassDetails embeddableClass) {
        EmbeddableInstantiator onEmbedded = property.getDirectAnnotationUsage(EmbeddableInstantiator.class);
        if (onEmbedded != null) {
            return onEmbedded.value();
        }
        EmbeddableInstantiator onEmbeddable = embeddableClass.getDirectAnnotationUsage(EmbeddableInstantiator.class);
        if (onEmbeddable != null) {
            return onEmbeddable.value();
        }
        return null;
    }

    public Property makeProperty() {
        this.validateMake();
        this.validateAnnotationsAgainstType();
        Property property = new Property();
        property.setName(this.name);
        property.setValue(this.value);
        property.setLazy(this.lazy);
        property.setLazyGroup(this.lazyGroup);
        property.setCascade(this.cascadeTypes);
        property.setPropertyAccessorName(this.accessType.getType());
        property.setReturnedClassName(this.returnedClassName);
        this.handleValueGeneration(property);
        this.handleNaturalId(property);
        this.handleLob(property);
        this.handleMutability(property);
        this.handleOptional(property);
        this.inferOptimisticLocking(property);
        return property;
    }

    private void handleValueGeneration(Property property) {
        if (this.memberDetails != null) {
            property.setValueGeneratorCreator(GeneratorBinder.createValueGeneratorFromAnnotations(this.holder, this.name, this.value, this.memberDetails, this.buildingContext));
        }
    }

    private void handleLob(Property property) {
        if (this.memberDetails != null) {
            property.setLob(this.memberDetails.hasDirectAnnotationUsage(Lob.class));
        }
    }

    private void handleMutability(Property property) {
        if (this.memberDetails != null && this.memberDetails.hasDirectAnnotationUsage(Immutable.class)) {
            this.updatable = false;
        }
        property.setInsertable(this.insertable);
        property.setUpdatable(this.updatable);
    }

    private void handleOptional(Property property) {
        if (this.memberDetails != null) {
            property.setOptional(!this.isId && PropertyBinder.isOptional(this.memberDetails, this.holder));
            if (property.isOptional()) {
                OptionalDeterminationSecondPass secondPass = persistentClasses -> {
                    if (property.getPersistentClass() != null) {
                        for (Join join : property.getPersistentClass().getJoins()) {
                            if (!join.getProperties().contains(property)) continue;
                            return;
                        }
                    }
                    if (!property.getValue().isNullable()) {
                        property.setOptional(false);
                    }
                };
                this.buildingContext.getMetadataCollector().addSecondPass(secondPass);
            }
        }
    }

    private void handleNaturalId(Property property) {
        NaturalId naturalId;
        if (this.memberDetails != null && this.entityBinder != null && (naturalId = this.memberDetails.getDirectAnnotationUsage(NaturalId.class)) != null) {
            if (!this.entityBinder.isRootEntity()) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' belongs to an entity subclass and may not be annotated '@NaturalId' (only a property of a root '@Entity' or a '@MappedSuperclass' may be a '@NaturalId')");
            }
            if (!naturalId.mutable()) {
                this.updatable = false;
            }
            property.setNaturalIdentifier(true);
        }
    }

    private void inferOptimisticLocking(Property property) {
        Value value = this.value;
        if (value instanceof org.hibernate.mapping.Collection) {
            org.hibernate.mapping.Collection collection = (org.hibernate.mapping.Collection)value;
            property.setOptimisticLocked(collection.isOptimisticLocked());
        } else if (this.memberDetails != null && this.memberDetails.hasDirectAnnotationUsage(OptimisticLock.class)) {
            OptimisticLock optimisticLock = this.memberDetails.getDirectAnnotationUsage(OptimisticLock.class);
            boolean excluded = optimisticLock.excluded();
            this.validateOptimisticLock(excluded);
            property.setOptimisticLocked(!excluded);
        } else {
            property.setOptimisticLocked(!this.isToOneValue(this.value) || this.insertable);
        }
    }

    private void validateAnnotationsAgainstType() {
        if (this.memberDetails != null) {
            TypeDetails type = this.memberDetails.getType();
            if (!(type instanceof ArrayTypeDetails)) {
                this.checkAnnotation(OrderColumn.class, List.class);
                if (this.memberDetails.hasDirectAnnotationUsage(OrderBy.class) && !type.isImplementor(Collection.class) && !type.isImplementor(Map.class)) {
                    throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' is annotated '@OrderBy' but is not of type 'Collection' or 'Map'");
                }
            }
            this.checkAnnotation(MapKey.class, Map.class);
            this.checkAnnotation(MapKeyColumn.class, Map.class);
            this.checkAnnotation(MapKeyClass.class, Map.class);
            this.checkAnnotation(MapKeyEnumerated.class, Map.class);
            this.checkAnnotation(MapKeyTemporal.class, Map.class);
            this.checkAnnotation(MapKeyColumn.class, Map.class);
            this.checkAnnotation(MapKeyJoinColumn.class, Map.class);
            this.checkAnnotation(MapKeyJoinColumns.class, Map.class);
        }
    }

    private void checkAnnotation(Class<? extends Annotation> annotationClass, Class<?> propertyType) {
        if (this.memberDetails.hasDirectAnnotationUsage(annotationClass) && !this.memberDetails.getType().isImplementor(propertyType)) {
            throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' is annotated '@" + annotationClass.getSimpleName() + "' but is not of type '" + propertyType.getTypeName() + "'");
        }
    }

    private void validateOptimisticLock(boolean excluded) {
        if (excluded) {
            if (this.memberDetails.hasDirectAnnotationUsage(Version.class)) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' is annotated '@OptimisticLock(excluded=true)' and '@Version'");
            }
            if (this.memberDetails.hasDirectAnnotationUsage(Id.class)) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' is annotated '@OptimisticLock(excluded=true)' and '@Id'");
            }
            if (this.memberDetails.hasDirectAnnotationUsage(EmbeddedId.class)) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' is annotated '@OptimisticLock(excluded=true)' and '@EmbeddedId'");
            }
        }
    }

    static int addElementsOfClass(List<PropertyData> elements, PropertyContainer propertyContainer, MetadataBuildingContext context, int idPropertyCounter) {
        for (MemberDetails property : propertyContainer.propertyIterator()) {
            idPropertyCounter = PropertyBinder.addProperty(propertyContainer, property, elements, context, idPropertyCounter);
        }
        return idPropertyCounter;
    }

    private static int addProperty(PropertyContainer propertyContainer, MemberDetails property, List<PropertyData> inFlightPropertyDataList, MetadataBuildingContext context, int idPropertyCounter) {
        InFlightMetadataCollector collector = context.getMetadataCollector();
        for (PropertyData propertyData : inFlightPropertyDataList) {
            if (!propertyData.getPropertyName().equals(property.resolveAttributeName())) continue;
            PropertyBinder.checkIdProperty(property, propertyData, context.getBootstrapContext().getModelsContext());
            return idPropertyCounter;
        }
        TypeVariableScope ownerType = propertyContainer.getTypeAtStake();
        PropertyInferredData propertyAnnotatedElement = new PropertyInferredData(propertyContainer.getDeclaringClass(), ownerType, property, propertyContainer.getClassLevelAccessType().getType(), context);
        MemberDetails element = propertyAnnotatedElement.getAttributeMember();
        if (PropertyBinder.hasIdAnnotation(element)) {
            inFlightPropertyDataList.add(idPropertyCounter, propertyAnnotatedElement);
            if (BinderHelper.hasToOneAnnotation(element)) {
                collector.addToOneAndIdProperty(ownerType.determineRawClass(), propertyAnnotatedElement);
            }
            ++idPropertyCounter;
        } else {
            inFlightPropertyDataList.add(propertyAnnotatedElement);
        }
        if (element.hasDirectAnnotationUsage(MapsId.class)) {
            collector.addPropertyAnnotatedWithMapsId(ownerType.determineRawClass(), propertyAnnotatedElement);
        }
        return idPropertyCounter;
    }

    private static void checkIdProperty(MemberDetails property, PropertyData propertyData, ModelsContext context) {
        boolean incomingIdProperty = PropertyBinder.hasIdAnnotation(property);
        MemberDetails attributeMember = propertyData.getAttributeMember();
        boolean existingIdProperty = PropertyBinder.hasIdAnnotation(attributeMember);
        if (incomingIdProperty) {
            if (existingIdProperty) {
                if (property.hasDirectAnnotationUsage(GeneratedValue.class) || !property.getMetaAnnotated(IdGeneratorType.class, context).isEmpty()) {
                    throw new AnnotationException("Attribute '" + attributeMember.getName() + "' is declared as an '@Id' or '@EmbeddedId' property by '" + attributeMember.getDeclaringType().getName() + "' and so '" + property.getDeclaringType().getName() + "' may not respecify the generation strategy");
                }
            } else {
                throw new AnnotationException("Attribute '" + attributeMember.getName() + "' is declared by '" + attributeMember.getDeclaringType().getName() + "' and may not be redeclared as an '@Id' or '@EmbeddedId' by '" + property.getDeclaringType().getName() + "'");
            }
        }
    }

    static boolean hasIdAnnotation(MemberDetails element) {
        return element.hasDirectAnnotationUsage(Id.class) || element.hasDirectAnnotationUsage(EmbeddedId.class);
    }

    public static void processElementAnnotations(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass) throws MappingException {
        if (!PropertyBinder.alreadyProcessedBySuper(propertyHolder, inferredData, entityBinder)) {
            MemberDetails property = inferredData.getAttributeMember();
            if (property.hasDirectAnnotationUsage(Parent.class)) {
                PropertyBinder.handleParentProperty(propertyHolder, inferredData, property);
            } else {
                PropertyBinder.buildProperty(propertyHolder, nullability, inferredData, entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, context, inheritanceStatePerClass);
            }
        }
    }

    private static boolean alreadyProcessedBySuper(PropertyHolder holder, PropertyData data, EntityBinder binder) {
        return !holder.isComponent() && binder.isPropertyDefinedInSuperHierarchy(data.getPropertyName());
    }

    private static void handleParentProperty(PropertyHolder holder, PropertyData data, MemberDetails property) {
        if (!holder.isComponent()) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(holder, data) + "' is annotated '@Parent' but is not a member of an embeddable class");
        }
        holder.setParentProperty(property.resolveAttributeName());
    }

    private static void buildProperty(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass) {
        MemberDetails property = inferredData.getAttributeMember();
        if (PropertyBinder.isPropertyOfRegularEmbeddable(propertyHolder, isComponentEmbedded) && property.hasDirectAnnotationUsage(Id.class)) {
            throw new AnnotationException("Member '" + property.getName() + "' of embeddable class " + propertyHolder.getClassName() + " is annotated '@Id'");
        }
        TypeDetails attributeTypeDetails = inferredData.getAttributeMember().isPlural() ? inferredData.getAttributeMember().getType() : inferredData.getClassOrElementType();
        PropertyBinder propertyBinder = PropertyBinder.propertyBinder(propertyHolder, inferredData, entityBinder, isIdentifierMapper, context, inheritanceStatePerClass, attributeTypeDetails);
        LazyGroup lazyGroupAnnotation = property.getDirectAnnotationUsage(LazyGroup.class);
        if (lazyGroupAnnotation != null) {
            propertyBinder.setLazyGroup(lazyGroupAnnotation.value());
        }
        ColumnsBuilder columnsBuilder = new ColumnsBuilder(propertyHolder, nullability, property, inferredData, entityBinder, context).extractMetadata();
        AnnotatedJoinColumns joinColumns = columnsBuilder.getJoinColumns();
        AnnotatedColumns columns = propertyBinder.bindProperty(propertyHolder, nullability, inferredData, entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, attributeTypeDetails.determineRawClass(), columnsBuilder);
        NaturalIdBinder.addNaturalIds(inSecondPass, property, columns, joinColumns, context);
    }

    private static PropertyBinder propertyBinder(PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, TypeDetails attributeTypeDetails) {
        MemberDetails property = inferredData.getAttributeMember();
        PropertyBinder propertyBinder = new PropertyBinder();
        propertyBinder.setName(inferredData.getPropertyName());
        propertyBinder.setReturnedClassName(inferredData.getTypeName());
        propertyBinder.setAccessType(inferredData.getDefaultAccess());
        propertyBinder.setHolder(propertyHolder);
        propertyBinder.setMemberDetails(property);
        propertyBinder.setReturnedClass(attributeTypeDetails);
        propertyBinder.setBuildingContext(context);
        if (isIdentifierMapper) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        }
        propertyBinder.setDeclaringClass(inferredData.getDeclaringClass());
        propertyBinder.setEntityBinder(entityBinder);
        propertyBinder.setInheritanceStatePerClass(inheritanceStatePerClass);
        propertyBinder.setId(!entityBinder.isIgnoreIdAnnotations() && PropertyBinder.hasIdAnnotation(property));
        return propertyBinder;
    }

    private static boolean isPropertyOfRegularEmbeddable(PropertyHolder propertyHolder, boolean isComponentEmbedded) {
        return propertyHolder.isComponent() && !propertyHolder.isInIdClass() && !isComponentEmbedded;
    }

    private AnnotatedColumns bindProperty(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, ClassDetails returnedClass, ColumnsBuilder columnsBuilder) {
        MemberDetails property = inferredData.getAttributeMember();
        if (PropertyBinder.isVersion(property)) {
            this.bindVersionProperty(propertyHolder, inferredData, isIdentifierMapper, columnsBuilder.getColumns());
        } else if (PropertyBinder.isManyToOne(property)) {
            ToOneBinder.bindManyToOne(propertyHolder, nullability, inferredData, isIdentifierMapper, inSecondPass, this.buildingContext, columnsBuilder.getJoinColumns(), this);
        } else if (PropertyBinder.isOneToOne(property)) {
            ToOneBinder.bindOneToOne(propertyHolder, nullability, inferredData, isIdentifierMapper, inSecondPass, this.buildingContext, columnsBuilder.getJoinColumns(), this);
        } else if (PropertyBinder.isAny(property)) {
            AnyBinder.bindAny(propertyHolder, nullability, inferredData, entityBinder, isIdentifierMapper, this.buildingContext, columnsBuilder.getJoinColumns());
        } else if (PropertyBinder.isCollection(property)) {
            CollectionBinder.bindCollection(propertyHolder, nullability, inferredData, entityBinder, isIdentifierMapper, this.buildingContext, this.inheritanceStatePerClass, columnsBuilder.getJoinColumns());
        } else if (!this.isId() || !entityBinder.isIgnoreIdAnnotations()) {
            return this.bindBasicOrComposite(propertyHolder, nullability, inferredData, entityBinder, isIdentifierMapper, isComponentEmbedded, columnsBuilder, columnsBuilder.getColumns(), returnedClass);
        }
        return columnsBuilder.getColumns();
    }

    private static boolean isVersion(MemberDetails property) {
        return property.hasDirectAnnotationUsage(Version.class);
    }

    private static boolean isOneToOne(MemberDetails property) {
        return property.hasDirectAnnotationUsage(OneToOne.class);
    }

    private static boolean isManyToOne(MemberDetails property) {
        return property.hasDirectAnnotationUsage(ManyToOne.class);
    }

    private static boolean isAny(MemberDetails property) {
        return property.hasDirectAnnotationUsage(Any.class);
    }

    private static boolean isCollection(MemberDetails property) {
        return property.hasDirectAnnotationUsage(OneToMany.class) || property.hasDirectAnnotationUsage(ManyToMany.class) || property.hasDirectAnnotationUsage(ElementCollection.class) || property.hasDirectAnnotationUsage(ManyToAny.class);
    }

    private void bindVersionProperty(PropertyHolder propertyHolder, PropertyData inferredData, boolean isIdentifierMapper, AnnotatedColumns columns) {
        PropertyBinder.checkVersionProperty(propertyHolder, isIdentifierMapper);
        RootClass rootClass = (RootClass)propertyHolder.getPersistentClass();
        this.setColumns(columns);
        Property property = this.makePropertyValueAndBind();
        this.getBasicValueBinder().setVersion(true);
        rootClass.setVersion(property);
        ClassDetails declaringClass = inferredData.getDeclaringClass();
        MappedSuperclass mappedSuperclass = BinderHelper.getMappedSuperclassOrNull(declaringClass, this.inheritanceStatePerClass, this.buildingContext);
        if (mappedSuperclass != null) {
            if (mappedSuperclass.getDeclaredVersion() == null) {
                mappedSuperclass.setDeclaredVersion(property);
            }
        } else {
            rootClass.setDeclaredVersion(property);
        }
        rootClass.setOptimisticLockStyle(OptimisticLockStyle.VERSION);
    }

    private static void checkVersionProperty(PropertyHolder propertyHolder, boolean isIdentifierMapper) {
        if (isIdentifierMapper) {
            throw new AnnotationException("Class '" + propertyHolder.getEntityName() + "' is annotated '@IdClass' and may not have a property annotated '@Version'");
        }
        if (!(propertyHolder.getPersistentClass() instanceof RootClass)) {
            throw new AnnotationException("Entity '" + propertyHolder.getEntityName() + "' is a subclass in an entity class hierarchy and may not have a property annotated '@Version'");
        }
        if (!propertyHolder.isEntity()) {
            throw new AnnotationException("Embedded class '" + propertyHolder.getEntityName() + "' may not have a property annotated '@Version'");
        }
    }

    private AnnotatedColumns bindBasicOrComposite(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, ColumnsBuilder columnsBuilder, AnnotatedColumns columns, ClassDetails returnedClass) {
        boolean isComposite;
        AnnotatedColumns actualColumns;
        MemberDetails property = inferredData.getAttributeMember();
        PropertyData overridingProperty = this.overridingProperty(propertyHolder, isIdentifierMapper, property);
        if (overridingProperty != null) {
            this.setReferencedEntityName(overridingProperty.getClassOrElementName());
            actualColumns = columnsBuilder.overrideColumnFromMapperOrMapsIdProperty(overridingProperty);
            isComposite = this.isComposite(property, returnedClass, overridingProperty);
        } else {
            actualColumns = columns;
            isComposite = EmbeddableBinder.isEmbedded(property, returnedClass);
        }
        PropertyBinder propertyBinder = this.propertyBinder(propertyHolder, nullability, inferredData, entityBinder, isComposite, isIdentifierMapper, isComponentEmbedded, columns, returnedClass, actualColumns, overridingProperty);
        propertyBinder.handleGenerators(propertyHolder, inferredData, isIdentifierMapper, overridingProperty != null, overridingProperty);
        return actualColumns;
    }

    private PropertyData overridingProperty(PropertyHolder propertyHolder, boolean isIdentifierMapper, MemberDetails property) {
        if (isIdentifierMapper || this.isId || propertyHolder.isOrWithinEmbeddedId() || propertyHolder.isInIdClass()) {
            return PropertyBinder.getPropertyOverriddenByMapperOrMapsId(this.isId, propertyHolder, property.resolveAttributeName(), this.buildingContext);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PropertyBinder propertyBinder(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, EntityBinder entityBinder, boolean isComposite, boolean isIdentifierMapper, boolean isComponentEmbedded, AnnotatedColumns columns, ClassDetails returnedClass, AnnotatedColumns actualColumns, PropertyData overridingProperty) {
        Class<? extends CompositeUserType<?>> compositeUserType = PropertyBinder.resolveCompositeUserType(inferredData, this.buildingContext);
        MemberDetails property = inferredData.getAttributeMember();
        if (isComposite || compositeUserType != null) {
            if (!property.isArray() || property.getElementType() == null || !EmbeddableBinder.isEmbedded(property, property.getElementType())) return EmbeddableBinder.createCompositeBinder(propertyHolder, inferredData, entityBinder, isIdentifierMapper, isComponentEmbedded, this.buildingContext, this.inheritanceStatePerClass, property, actualColumns, returnedClass, this.isId(), overridingProperty != null, overridingProperty, compositeUserType);
            this.aggregateBinder(propertyHolder, inferredData, entityBinder, isIdentifierMapper, isComponentEmbedded, property, columns, returnedClass, compositeUserType, actualColumns);
            return this;
        } else if (property.isPlural() && property.getElementType() != null && EmbeddableBinder.isEmbedded(property, property.getElementType())) {
            this.aggregateBinder(propertyHolder, inferredData, entityBinder, isIdentifierMapper, isComponentEmbedded, property, columns, property.getElementType().determineRawClass(), null, actualColumns);
            return this;
        } else {
            this.basicBinder(propertyHolder, inferredData, nullability, property, actualColumns);
        }
        return this;
    }

    private void handleGenerators(PropertyHolder propertyHolder, PropertyData inferredData, boolean isIdentifierMapper, boolean isOverridden, PropertyData overridingProperty) {
        if (isOverridden) {
            this.handleGeneratorsForOverriddenId(propertyHolder, overridingProperty);
        } else if (this.isId()) {
            if (isIdentifierMapper) {
                throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' belongs to an '@IdClass' and may not be annotated '@Id' or '@EmbeddedId'");
            }
            GeneratorBinder.createIdGeneratorsFromGeneratorAnnotations(propertyHolder, inferredData, (SimpleValue)this.getValue(), this.buildingContext);
        }
    }

    private void aggregateBinder(PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, MemberDetails property, AnnotatedColumns columns, ClassDetails returnedClass, Class<? extends CompositeUserType<?>> compositeUserType, AnnotatedColumns actualColumns) {
        this.setComponentElement(EmbeddableBinder.bindEmbeddable(inferredData, propertyHolder, entityBinder.getPropertyAccessor(property), entityBinder, isIdentifierMapper, this.buildingContext, isComponentEmbedded, this.isId(), this.inheritanceStatePerClass, EmbeddableBinder.determineCustomInstantiator(property, returnedClass, this.buildingContext), compositeUserType, columns));
        this.setColumns(actualColumns);
        this.makePropertyValueAndBind();
    }

    private boolean isComposite(MemberDetails property, ClassDetails returnedClass, PropertyData overridingProperty) {
        InheritanceState state = this.inheritanceStatePerClass.get(overridingProperty.getClassOrElementType().determineRawClass());
        return state != null ? state.hasIdClassOrEmbeddedId() : EmbeddableBinder.isEmbedded(property, returnedClass);
    }

    private void handleGeneratorsForOverriddenId(PropertyHolder propertyHolder, PropertyData mapsIdProperty) {
        SimpleValue idValue = (SimpleValue)this.getValue();
        RootClass rootClass = propertyHolder.getPersistentClass().getRootClass();
        final String propertyName = mapsIdProperty.getPropertyName();
        final String entityName = rootClass.getEntityName();
        idValue.setCustomIdGeneratorCreator(creationContext -> new BeforeExecutionGenerator(){

            @Override
            public Object generate(SharedSessionContractImplementor session, Object owner, Object currentValue, EventType eventType) {
                return IdentifierGeneratorHelper.getForeignId(entityName, propertyName, session, owner);
            }

            @Override
            public EnumSet<EventType> getEventTypes() {
                return EventTypeSets.INSERT_ONLY;
            }

            @Override
            public boolean allowAssignedIdentifiers() {
                return true;
            }
        });
    }

    private void basicBinder(PropertyHolder propertyHolder, PropertyData inferredData, Nullability nullability, MemberDetails property, AnnotatedColumns columns) {
        if (this.shouldForceNotNull(nullability, PropertyBinder.isExplicitlyOptional(property))) {
            this.forceColumnsNotNull(propertyHolder, inferredData, columns);
        }
        this.setLazy(PropertyBinder.isLazy(property));
        this.setColumns(columns);
        this.makePropertyValueAndBind();
    }

    private void forceColumnsNotNull(PropertyHolder holder, PropertyData data, AnnotatedColumns columns) {
        for (AnnotatedColumn column : columns.getColumns()) {
            if (this.isId() && column.isFormula()) {
                throw new CannotForceNonNullableException("Identifier property '" + BinderHelper.getPath(holder, data) + "' cannot map to a '@Formula'");
            }
            column.forceNotNull();
        }
    }

    private boolean shouldForceNotNull(Nullability nullability, boolean optional) {
        return this.isId() || !optional && nullability != Nullability.FORCED_NULL;
    }

    private static boolean isExplicitlyOptional(MemberDetails attributeMember) {
        Basic basic = attributeMember.getDirectAnnotationUsage(Basic.class);
        return basic == null || basic.optional();
    }

    public static boolean isOptional(MemberDetails attributeMember, PropertyHolder propertyHolder) {
        Basic basic = attributeMember.getDirectAnnotationUsage(Basic.class);
        if (basic != null) {
            return basic.optional() && attributeMember.getType().getTypeKind() != TypeDetails.Kind.PRIMITIVE;
        }
        if (attributeMember.isArray()) {
            return true;
        }
        if (propertyHolder != null && propertyHolder.isComponent()) {
            return true;
        }
        if (attributeMember.isPlural()) {
            return attributeMember.getElementType().getTypeKind() != TypeDetails.Kind.PRIMITIVE;
        }
        return attributeMember.getType().getTypeKind() != TypeDetails.Kind.PRIMITIVE;
    }

    private static boolean isLazy(MemberDetails property) {
        Basic annotationUsage = property.getDirectAnnotationUsage(Basic.class);
        return annotationUsage != null && annotationUsage.fetch() == FetchType.LAZY;
    }

    private static Class<? extends CompositeUserType<?>> resolveCompositeUserType(PropertyData inferredData, MetadataBuildingContext buildingContext) {
        Class embeddableClass;
        ModelsContext modelsContext = buildingContext.getBootstrapContext().getModelsContext();
        MemberDetails attributeMember = inferredData.getAttributeMember();
        TypeDetails classOrElementType = inferredData.getClassOrElementType();
        ClassDetails returnedClass = classOrElementType.determineRawClass();
        if (attributeMember != null) {
            CompositeType compositeType = attributeMember.locateAnnotationUsage(CompositeType.class, modelsContext);
            if (compositeType != null) {
                return compositeType.value();
            }
            Class<? extends CompositeUserType<?>> compositeUserType = TimeZoneStorageHelper.resolveTimeZoneStorageCompositeUserType(attributeMember, returnedClass, buildingContext);
            if (compositeUserType != null) {
                return compositeUserType;
            }
        }
        if (returnedClass != null && (embeddableClass = returnedClass.toJavaClass()) != null) {
            return buildingContext.getMetadataCollector().findRegisteredCompositeUserType(embeddableClass);
        }
        return null;
    }

    private static PropertyData getPropertyOverriddenByMapperOrMapsId(boolean isId, PropertyHolder propertyHolder, String propertyName, MetadataBuildingContext buildingContext) {
        ClassDetailsRegistry classDetailsRegistry = buildingContext.getBootstrapContext().getModelsContext().getClassDetailsRegistry();
        PersistentClass persistentClass = propertyHolder.getPersistentClass();
        String name = StringHelper.isEmpty(persistentClass.getClassName()) ? persistentClass.getEntityName() : persistentClass.getClassName();
        ClassDetails classDetails = classDetailsRegistry.resolveClassDetails(name);
        InFlightMetadataCollector metadataCollector = buildingContext.getMetadataCollector();
        if (propertyHolder.isInIdClass()) {
            PropertyData data = metadataCollector.getPropertyAnnotatedWithIdAndToOne(classDetails, propertyName);
            if (data != null) {
                return data;
            }
            return metadataCollector.getPropertyAnnotatedWithMapsId(classDetails, propertyName);
        }
        return metadataCollector.getPropertyAnnotatedWithMapsId(classDetails, isId ? "" : propertyName);
    }
}

