/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.source.internal.hbm;

import jakarta.persistence.SharedCacheMode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.SourceType;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNamedNativeQueryType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNamedQueryType;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.JavaTypeDescriptor;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.internal.FkSecondPass;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitBasicColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitCollectionTableNameSource;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.ImplicitIdentifierColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitIndexColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitMapKeyColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitUniqueKeyNameSource;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.source.internal.ImplicitColumnNamingSecondPass;
import org.hibernate.boot.model.source.internal.hbm.AbstractEntitySourceImpl;
import org.hibernate.boot.model.source.internal.hbm.EntityHierarchySourceImpl;
import org.hibernate.boot.model.source.internal.hbm.EntityNamingSourceImpl;
import org.hibernate.boot.model.source.internal.hbm.Helper;
import org.hibernate.boot.model.source.internal.hbm.HibernateTypeSourceImpl;
import org.hibernate.boot.model.source.internal.hbm.IndexedPluralAttributeSource;
import org.hibernate.boot.model.source.internal.hbm.JoinedSubclassEntitySourceImpl;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.model.source.internal.hbm.NamedQueryBinder;
import org.hibernate.boot.model.source.internal.hbm.PluralAttributeSourceArrayImpl;
import org.hibernate.boot.model.source.internal.hbm.PluralAttributeSourceBagImpl;
import org.hibernate.boot.model.source.internal.hbm.PluralAttributeSourceIdBagImpl;
import org.hibernate.boot.model.source.internal.hbm.PluralAttributeSourceListImpl;
import org.hibernate.boot.model.source.internal.hbm.PluralAttributeSourceMapImpl;
import org.hibernate.boot.model.source.internal.hbm.PluralAttributeSourcePrimitiveArrayImpl;
import org.hibernate.boot.model.source.internal.hbm.PluralAttributeSourceSetImpl;
import org.hibernate.boot.model.source.internal.hbm.RelationalObjectBinder;
import org.hibernate.boot.model.source.internal.hbm.RootEntitySourceImpl;
import org.hibernate.boot.model.source.internal.hbm.SubclassEntitySourceImpl;
import org.hibernate.boot.model.source.spi.AnyMappingSource;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.model.source.spi.AttributeRole;
import org.hibernate.boot.model.source.spi.AttributeSource;
import org.hibernate.boot.model.source.spi.Caching;
import org.hibernate.boot.model.source.spi.CascadeStyleSource;
import org.hibernate.boot.model.source.spi.CollectionIdSource;
import org.hibernate.boot.model.source.spi.ColumnSource;
import org.hibernate.boot.model.source.spi.CompositeIdentifierSource;
import org.hibernate.boot.model.source.spi.DiscriminatorSource;
import org.hibernate.boot.model.source.spi.EmbeddableSource;
import org.hibernate.boot.model.source.spi.EntityNamingSource;
import org.hibernate.boot.model.source.spi.EntitySource;
import org.hibernate.boot.model.source.spi.FetchCharacteristics;
import org.hibernate.boot.model.source.spi.FetchCharacteristicsSingularAssociation;
import org.hibernate.boot.model.source.spi.FilterSource;
import org.hibernate.boot.model.source.spi.HibernateTypeSource;
import org.hibernate.boot.model.source.spi.IdentifiableTypeSource;
import org.hibernate.boot.model.source.spi.IdentifierSourceAggregatedComposite;
import org.hibernate.boot.model.source.spi.IdentifierSourceNonAggregatedComposite;
import org.hibernate.boot.model.source.spi.IdentifierSourceSimple;
import org.hibernate.boot.model.source.spi.InLineViewSource;
import org.hibernate.boot.model.source.spi.LocalMetadataBuildingContext;
import org.hibernate.boot.model.source.spi.NaturalIdMutability;
import org.hibernate.boot.model.source.spi.Orderable;
import org.hibernate.boot.model.source.spi.PluralAttributeElementSource;
import org.hibernate.boot.model.source.spi.PluralAttributeElementSourceBasic;
import org.hibernate.boot.model.source.spi.PluralAttributeElementSourceEmbedded;
import org.hibernate.boot.model.source.spi.PluralAttributeElementSourceManyToAny;
import org.hibernate.boot.model.source.spi.PluralAttributeElementSourceManyToMany;
import org.hibernate.boot.model.source.spi.PluralAttributeElementSourceOneToMany;
import org.hibernate.boot.model.source.spi.PluralAttributeIndexSource;
import org.hibernate.boot.model.source.spi.PluralAttributeKeySource;
import org.hibernate.boot.model.source.spi.PluralAttributeMapKeyManyToAnySource;
import org.hibernate.boot.model.source.spi.PluralAttributeMapKeyManyToManySource;
import org.hibernate.boot.model.source.spi.PluralAttributeMapKeySourceBasic;
import org.hibernate.boot.model.source.spi.PluralAttributeMapKeySourceEmbedded;
import org.hibernate.boot.model.source.spi.PluralAttributeSequentialIndexSource;
import org.hibernate.boot.model.source.spi.PluralAttributeSource;
import org.hibernate.boot.model.source.spi.RelationalValueSource;
import org.hibernate.boot.model.source.spi.RelationalValueSourceContainer;
import org.hibernate.boot.model.source.spi.SecondaryTableSource;
import org.hibernate.boot.model.source.spi.SingularAttributeSource;
import org.hibernate.boot.model.source.spi.SingularAttributeSourceAny;
import org.hibernate.boot.model.source.spi.SingularAttributeSourceBasic;
import org.hibernate.boot.model.source.spi.SingularAttributeSourceEmbedded;
import org.hibernate.boot.model.source.spi.SingularAttributeSourceManyToOne;
import org.hibernate.boot.model.source.spi.SingularAttributeSourceOneToOne;
import org.hibernate.boot.model.source.spi.Sortable;
import org.hibernate.boot.model.source.spi.TableSource;
import org.hibernate.boot.model.source.spi.TableSpecificationSource;
import org.hibernate.boot.model.source.spi.VersionAttributeSource;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.NaturalIdUniqueKeyBinder;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.generator.internal.GeneratedGeneration;
import org.hibernate.generator.internal.SourceGeneration;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.AttributeContainer;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DenormalizedTable;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.List;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.SortableValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.Value;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.tuple.GenerationTiming;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public class ModelBinder {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(ModelBinder.class);
    private final MetadataBuildingContext metadataBuildingContext;
    private final Database database;
    private final ImplicitNamingStrategy implicitNamingStrategy;
    private final RelationalObjectBinder relationalObjectBinder;
    private static final String ID_MAPPER_PATH_PART = "<_identifierMapper>";

    public static ModelBinder prepare(MetadataBuildingContext context) {
        return new ModelBinder(context);
    }

    public ModelBinder(MetadataBuildingContext context) {
        this.metadataBuildingContext = context;
        this.database = context.getMetadataCollector().getDatabase();
        this.implicitNamingStrategy = context.getBuildingOptions().getImplicitNamingStrategy();
        this.relationalObjectBinder = new RelationalObjectBinder(context);
    }

    public void bindEntityHierarchy(EntityHierarchySourceImpl hierarchySource) {
        RootClass rootEntityDescriptor = new RootClass(hierarchySource.getRootEntityMappingDocument());
        this.bindRootEntity(hierarchySource, rootEntityDescriptor);
        RootEntitySourceImpl root = hierarchySource.getRoot();
        root.getLocalMetadataBuildingContext().getMetadataCollector().addEntityBinding(rootEntityDescriptor);
        switch (hierarchySource.getHierarchyInheritanceType()) {
            case NO_INHERITANCE: {
                break;
            }
            case DISCRIMINATED: {
                this.bindDiscriminatorSubclassEntities(root, rootEntityDescriptor);
                break;
            }
            case JOINED: {
                this.bindJoinedSubclassEntities(root, rootEntityDescriptor);
                break;
            }
            case UNION: {
                this.bindUnionSubclassEntities(root, rootEntityDescriptor);
            }
        }
    }

    private void bindRootEntity(EntityHierarchySourceImpl hierarchySource, RootClass rootEntityDescriptor) {
        RootEntitySourceImpl root = hierarchySource.getRoot();
        MappingDocument mappingDocument = root.sourceMappingDocument();
        this.bindBasicEntityValues(mappingDocument, root, rootEntityDescriptor);
        Table primaryTable = this.bindEntityTableSpecification(mappingDocument, root.getPrimaryTable(), null, root, rootEntityDescriptor);
        rootEntityDescriptor.setTable(primaryTable);
        if (log.isTraceEnabled()) {
            log.tracef("Mapping class: %s -> %s", (Object)rootEntityDescriptor.getEntityName(), (Object)primaryTable.getName());
        }
        rootEntityDescriptor.setOptimisticLockStyle(hierarchySource.getOptimisticLockStyle());
        rootEntityDescriptor.setMutable(hierarchySource.isMutable());
        rootEntityDescriptor.setWhere(hierarchySource.getWhere());
        if (hierarchySource.isExplicitPolymorphism()) {
            DeprecationLogger.DEPRECATION_LOGGER.warn("Implicit/explicit polymorphism no longer supported");
        }
        this.bindEntityIdentifier(mappingDocument, hierarchySource, rootEntityDescriptor);
        if (hierarchySource.getVersionAttributeSource() != null) {
            this.bindEntityVersion(mappingDocument, hierarchySource, rootEntityDescriptor);
        }
        if (hierarchySource.getDiscriminatorSource() != null) {
            this.bindEntityDiscriminator(mappingDocument, hierarchySource, rootEntityDescriptor);
        }
        this.applyCaching(mappingDocument, hierarchySource.getCaching(), rootEntityDescriptor);
        KeyValue keyValue = rootEntityDescriptor.getIdentifier();
        if (keyValue instanceof SortableValue) {
            SortableValue sortableValue = (SortableValue)((Object)keyValue);
            sortableValue.sortProperties();
        }
        rootEntityDescriptor.createPrimaryKey();
        this.bindAllEntityAttributes(mappingDocument, root, rootEntityDescriptor);
        Caching naturalIdCaching = hierarchySource.getNaturalIdCaching();
        if (naturalIdCaching != null && naturalIdCaching.isRequested()) {
            rootEntityDescriptor.setNaturalIdCacheRegionName(naturalIdCaching.getRegion());
        }
    }

    private void applyCaching(MappingDocument mappingDocument, Caching caching, RootClass rootEntityDescriptor) {
        if (ModelBinder.isCacheEnabled(mappingDocument, caching)) {
            rootEntityDescriptor.setCacheConcurrencyStrategy(ModelBinder.getConcurrencyStrategy(mappingDocument, caching).getExternalName());
            rootEntityDescriptor.setCacheRegionName(caching == null ? null : caching.getRegion());
            rootEntityDescriptor.setLazyPropertiesCacheable(caching == null || caching.isCacheLazyProperties());
            rootEntityDescriptor.setCached(true);
        }
    }

    private static AccessType getConcurrencyStrategy(MappingDocument mappingDocument, Caching caching) {
        return caching == null || caching.getAccessType() == null ? mappingDocument.getBuildingOptions().getImplicitCacheAccessType() : caching.getAccessType();
    }

    private static boolean isCacheEnabled(MappingDocument mappingDocument, Caching caching) {
        return switch (mappingDocument.getBuildingOptions().getSharedCacheMode()) {
            default -> throw new IncompatibleClassChangeError();
            case SharedCacheMode.UNSPECIFIED, SharedCacheMode.ENABLE_SELECTIVE -> {
                if (caching != null && caching.isRequested(false)) {
                    yield true;
                }
                yield false;
            }
            case SharedCacheMode.NONE -> false;
            case SharedCacheMode.ALL -> true;
            case SharedCacheMode.DISABLE_SELECTIVE -> caching == null || caching.isRequested(true);
        };
    }

    private void bindEntityIdentifier(MappingDocument mappingDocument, EntityHierarchySourceImpl hierarchySource, RootClass rootEntityDescriptor) {
        switch (hierarchySource.getIdentifierSource().getNature()) {
            case SIMPLE: {
                this.bindSimpleEntityIdentifier(mappingDocument, hierarchySource, rootEntityDescriptor);
                break;
            }
            case AGGREGATED_COMPOSITE: {
                this.bindAggregatedCompositeEntityIdentifier(mappingDocument, hierarchySource, rootEntityDescriptor);
                break;
            }
            case NON_AGGREGATED_COMPOSITE: {
                this.bindNonAggregatedCompositeEntityIdentifier(mappingDocument, hierarchySource, rootEntityDescriptor);
                break;
            }
            default: {
                throw new MappingException(String.format(Locale.ENGLISH, "Unexpected entity identifier nature [%s] for entity %s", new Object[]{hierarchySource.getIdentifierSource().getNature(), hierarchySource.getRoot().getEntityNamingSource().getEntityName()}), mappingDocument.getOrigin());
            }
        }
    }

    private void bindBasicEntityValues(MappingDocument sourceDocument, AbstractEntitySourceImpl entitySource, PersistentClass entityDescriptor) {
        String discriminatorMatchValue;
        EntityNamingSource entityNamingSource = entitySource.getEntityNamingSource();
        String entityName = entityNamingSource.getEntityName();
        entityDescriptor.setEntityName(entityName);
        entityDescriptor.setJpaEntityName(entityNamingSource.getJpaEntityName());
        entityDescriptor.setClassName(entityNamingSource.getClassName());
        String jpaEntityName = entityDescriptor.getJpaEntityName();
        String className = entityDescriptor.getClassName();
        if (jpaEntityName != null && className != null) {
            this.metadataBuildingContext.getMetadataCollector().addImport(jpaEntityName, className);
        }
        entityDescriptor.setDiscriminatorValue((discriminatorMatchValue = entitySource.getDiscriminatorMatchValue()) == null ? entityDescriptor.getEntityName() : discriminatorMatchValue);
        ModelBinder.setupProxying(sourceDocument, entitySource, entityDescriptor);
        entityDescriptor.setAbstract(entitySource.isAbstract());
        ModelBinder.setupImports(sourceDocument, entityName);
        entityDescriptor.setDynamicInsert(entitySource.isDynamicInsert());
        entityDescriptor.setDynamicUpdate(entitySource.isDynamicUpdate());
        entityDescriptor.setBatchSize(entitySource.getBatchSize());
        entityDescriptor.setSelectBeforeUpdate(entitySource.isSelectBeforeUpdate());
        ModelBinder.bindCustomSql(entitySource, entityDescriptor);
        for (String tableName : entitySource.getSynchronizedTableNames()) {
            entityDescriptor.addSynchronizedTable(this.physicalTableName(sourceDocument, tableName));
        }
        for (FilterSource filterSource : entitySource.getFilterSources()) {
            entityDescriptor.addFilter(filterSource.getName(), ModelBinder.filterCondition(filterSource, sourceDocument), filterSource.shouldAutoInjectAliases(), filterSource.getAliasToTableMap(), filterSource.getAliasToEntityMap());
        }
        for (JaxbHbmNamedQueryType namedQuery : entitySource.getNamedQueries()) {
            NamedQueryBinder.processNamedQuery(sourceDocument, namedQuery, entityName + ".");
        }
        for (JaxbHbmNamedNativeQueryType namedQuery : entitySource.getNamedNativeQueries()) {
            NamedQueryBinder.processNamedNativeQuery(sourceDocument, namedQuery, entityName + ".");
        }
        entityDescriptor.setMetaAttributes(entitySource.getToolingHintContext().getMetaAttributeMap());
    }

    private static void setupImports(MappingDocument sourceDocument, String entityName) {
        InFlightMetadataCollector metadataCollector = sourceDocument.getMetadataCollector();
        metadataCollector.addImport(entityName, entityName);
        if (sourceDocument.getEffectiveDefaults().isDefaultAutoImport() && entityName.indexOf(46) > 0) {
            metadataCollector.addImport(StringHelper.unqualify(entityName), entityName);
        }
    }

    private static void setupProxying(MappingDocument sourceDocument, AbstractEntitySourceImpl entitySource, PersistentClass entityDescriptor) {
        if (StringHelper.isNotEmpty(entitySource.getProxy())) {
            entityDescriptor.setProxyInterfaceName(sourceDocument.qualifyClassName(entitySource.getProxy()));
            entityDescriptor.setLazy(true);
        } else if (entitySource.isLazy()) {
            entityDescriptor.setProxyInterfaceName(entityDescriptor.getClassName());
            entityDescriptor.setLazy(true);
        } else {
            entityDescriptor.setProxyInterfaceName(null);
            entityDescriptor.setLazy(false);
        }
    }

    private static String filterCondition(FilterSource filterSource, MappingDocument sourceDocument) {
        String condition = filterSource.getCondition();
        if (condition == null) {
            FilterDefinition filterDefinition = sourceDocument.getMetadataCollector().getFilterDefinition(filterSource.getName());
            if (filterDefinition != null) {
                return filterDefinition.getDefaultFilterCondition();
            }
            return null;
        }
        return condition;
    }

    private String physicalTableName(MappingDocument sourceDocument, String tableName) {
        JdbcEnvironment jdbcEnvironment = sourceDocument.getMetadataCollector().getDatabase().getJdbcEnvironment();
        return sourceDocument.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(jdbcEnvironment.getIdentifierHelper().toIdentifier(tableName), jdbcEnvironment).render(jdbcEnvironment.getDialect());
    }

    private void bindDiscriminatorSubclassEntities(AbstractEntitySourceImpl entitySource, PersistentClass superEntityDescriptor) {
        for (IdentifiableTypeSource subType : entitySource.getSubTypes()) {
            SingleTableSubclass subEntityDescriptor = new SingleTableSubclass(superEntityDescriptor, this.metadataBuildingContext);
            subEntityDescriptor.setCached(superEntityDescriptor.isCached());
            this.bindDiscriminatorSubclassEntity((SubclassEntitySourceImpl)subType, subEntityDescriptor);
            superEntityDescriptor.addSubclass(subEntityDescriptor);
            entitySource.getLocalMetadataBuildingContext().getMetadataCollector().addEntityBinding(subEntityDescriptor);
        }
    }

    private void bindDiscriminatorSubclassEntity(SubclassEntitySourceImpl entitySource, SingleTableSubclass entityDescriptor) {
        MappingDocument sourceDocument = entitySource.sourceMappingDocument();
        InFlightMetadataCollector localMetadataCollector = entitySource.getLocalMetadataBuildingContext().getMetadataCollector();
        this.bindBasicEntityValues(sourceDocument, entitySource, entityDescriptor);
        InFlightMetadataCollector.EntityTableXref superEntityTableXref = ModelBinder.superEntityTableXref(sourceDocument, entitySource, entityDescriptor, localMetadataCollector);
        localMetadataCollector.addEntityTableXref(entitySource.getEntityNamingSource().getEntityName(), this.database.toIdentifier(localMetadataCollector.getLogicalTableName(entityDescriptor.getTable())), entityDescriptor.getTable(), superEntityTableXref);
        this.bindAllEntityAttributes(sourceDocument, entitySource, entityDescriptor);
        this.bindDiscriminatorSubclassEntities(entitySource, entityDescriptor);
    }

    private void bindJoinedSubclassEntities(AbstractEntitySourceImpl entitySource, PersistentClass superEntityDescriptor) {
        for (IdentifiableTypeSource subType : entitySource.getSubTypes()) {
            JoinedSubclass subEntityDescriptor = new JoinedSubclass(superEntityDescriptor, this.metadataBuildingContext);
            subEntityDescriptor.setCached(superEntityDescriptor.isCached());
            this.bindJoinedSubclassEntity((JoinedSubclassEntitySourceImpl)subType, subEntityDescriptor);
            superEntityDescriptor.addSubclass(subEntityDescriptor);
            entitySource.getLocalMetadataBuildingContext().getMetadataCollector().addEntityBinding(subEntityDescriptor);
        }
    }

    private void bindJoinedSubclassEntity(JoinedSubclassEntitySourceImpl entitySource, JoinedSubclass entityDescriptor) {
        MappingDocument mappingDocument = entitySource.sourceMappingDocument();
        this.bindBasicEntityValues(mappingDocument, entitySource, entityDescriptor);
        final Table primaryTable = this.bindEntityTableSpecification(mappingDocument, entitySource.getPrimaryTable(), null, entitySource, entityDescriptor);
        entityDescriptor.setTable(primaryTable);
        if (log.isTraceEnabled()) {
            log.tracef("Mapping joined-subclass: %s -> %s", (Object)entityDescriptor.getEntityName(), (Object)primaryTable.getName());
        }
        DependantValue keyBinding = new DependantValue(mappingDocument, primaryTable, entityDescriptor.getIdentifier());
        if (mappingDocument.getBuildingOptions().useNationalizedCharacterData()) {
            keyBinding.makeNationalized();
        }
        entityDescriptor.setKey(keyBinding);
        keyBinding.setOnDeleteAction(ModelBinder.getOnDeleteAction(entitySource.isCascadeDeleteEnabled()));
        this.relationalObjectBinder.bindColumns(mappingDocument, entitySource.getPrimaryKeyColumnSources(), keyBinding, false, new RelationalObjectBinder.ColumnNamingDelegate(){
            int count = 0;

            @Override
            public Identifier determineImplicitName(LocalMetadataBuildingContext context) {
                return primaryTable.getPrimaryKey().getColumn(this.count++).getNameIdentifier(ModelBinder.this.metadataBuildingContext);
            }
        });
        keyBinding.sortProperties();
        ModelBinder.setForeignKeyName(keyBinding, entitySource.getExplicitForeignKeyName());
        entityDescriptor.createPrimaryKey();
        entityDescriptor.createForeignKey();
        this.bindAllEntityAttributes(mappingDocument, entitySource, entityDescriptor);
        this.bindJoinedSubclassEntities(entitySource, entityDescriptor);
    }

    private void bindUnionSubclassEntities(EntitySource entitySource, PersistentClass superEntityDescriptor) {
        for (IdentifiableTypeSource subType : entitySource.getSubTypes()) {
            UnionSubclass subEntityDescriptor = new UnionSubclass(superEntityDescriptor, this.metadataBuildingContext);
            subEntityDescriptor.setCached(superEntityDescriptor.isCached());
            this.bindUnionSubclassEntity((SubclassEntitySourceImpl)subType, subEntityDescriptor);
            superEntityDescriptor.addSubclass(subEntityDescriptor);
            entitySource.getLocalMetadataBuildingContext().getMetadataCollector().addEntityBinding(subEntityDescriptor);
        }
    }

    private void bindUnionSubclassEntity(SubclassEntitySourceImpl entitySource, UnionSubclass entityDescriptor) {
        MappingDocument mappingDocument = entitySource.sourceMappingDocument();
        this.bindBasicEntityValues(mappingDocument, entitySource, entityDescriptor);
        Table primaryTable = this.bindEntityTableSpecification(mappingDocument, entitySource.getPrimaryTable(), entityDescriptor.getSuperclass().getTable(), entitySource, entityDescriptor);
        entityDescriptor.setTable(primaryTable);
        if (log.isTraceEnabled()) {
            log.tracef("Mapping union-subclass: %s -> %s", (Object)entityDescriptor.getEntityName(), (Object)primaryTable.getName());
        }
        this.bindAllEntityAttributes(entitySource.sourceMappingDocument(), entitySource, entityDescriptor);
        this.bindUnionSubclassEntities(entitySource, entityDescriptor);
    }

    private void bindSimpleEntityIdentifier(MappingDocument sourceDocument, final EntityHierarchySourceImpl hierarchySource, RootClass rootEntityDescriptor) {
        final IdentifierSourceSimple idSource = (IdentifierSourceSimple)hierarchySource.getIdentifierSource();
        BasicValue idValue = new BasicValue(sourceDocument, rootEntityDescriptor.getTable());
        rootEntityDescriptor.setIdentifier(idValue);
        ModelBinder.bindSimpleValueType(sourceDocument, idSource.getIdentifierAttributeSource().getTypeInformation(), idValue);
        String propertyName = idSource.getIdentifierAttributeSource().getName();
        if (propertyName == null || !rootEntityDescriptor.hasPojoRepresentation()) {
            if (!idValue.isTypeSpecified()) {
                throw new MappingException("must specify an identifier type: " + rootEntityDescriptor.getEntityName(), sourceDocument.getOrigin());
            }
        } else {
            idValue.setTypeUsingReflection(rootEntityDescriptor.getClassName(), propertyName);
        }
        this.relationalObjectBinder.bindColumnsAndFormulas(sourceDocument, ((RelationalValueSourceContainer)((Object)idSource.getIdentifierAttributeSource())).getRelationalValueSources(), idValue, false, context -> {
            context.getBuildingOptions().getImplicitNamingStrategy().determineIdentifierColumnName(new ImplicitIdentifierColumnNameSource(){

                @Override
                public EntityNaming getEntityNaming() {
                    return hierarchySource.getRoot().getEntityNamingSource();
                }

                @Override
                public AttributePath getIdentifierAttributePath() {
                    return idSource.getIdentifierAttributeSource().getAttributePath();
                }

                @Override
                public MetadataBuildingContext getBuildingContext() {
                    return context;
                }
            });
            return this.database.toIdentifier(propertyName);
        });
        if (propertyName != null) {
            Property property = new Property();
            property.setValue(idValue);
            this.bindProperty(sourceDocument, idSource.getIdentifierAttributeSource(), property);
            rootEntityDescriptor.setIdentifierProperty(property);
            rootEntityDescriptor.setDeclaredIdentifierProperty(property);
        }
        GeneratorBinder.makeIdGenerator(sourceDocument, idSource.getIdentifierGeneratorDescriptor(), idValue, this.metadataBuildingContext);
        if (StringHelper.isNotEmpty(idSource.getUnsavedValue())) {
            idValue.setNullValue(idSource.getUnsavedValue());
        }
    }

    private void bindAggregatedCompositeEntityIdentifier(MappingDocument mappingDocument, EntityHierarchySourceImpl hierarchySource, RootClass rootEntityDescriptor) {
        IdentifierSourceAggregatedComposite identifierSource = (IdentifierSourceAggregatedComposite)hierarchySource.getIdentifierSource();
        Component cid = new Component((MetadataBuildingContext)mappingDocument, rootEntityDescriptor);
        cid.setKey(true);
        rootEntityDescriptor.setIdentifier(cid);
        String idClassName = this.extractIdClassName(identifierSource);
        String idPropertyName = identifierSource.getIdentifierAttributeSource().getName();
        String pathPart = idPropertyName == null ? "<id>" : idPropertyName;
        this.bindComponent(mappingDocument, hierarchySource.getRoot().getAttributeRoleBase().append(pathPart).getFullPath(), identifierSource.getEmbeddableSource(), cid, idClassName, rootEntityDescriptor.getClassName(), idPropertyName, idPropertyName == null, idClassName == null && idPropertyName == null, identifierSource.getEmbeddableSource().isDynamic());
        this.finishBindingCompositeIdentifier(mappingDocument, rootEntityDescriptor, identifierSource, cid, idPropertyName);
    }

    private String extractIdClassName(IdentifierSourceAggregatedComposite identifierSource) {
        JavaTypeDescriptor typeDescriptor = identifierSource.getEmbeddableSource().getTypeDescriptor();
        return typeDescriptor == null ? null : typeDescriptor.getName();
    }

    private void bindNonAggregatedCompositeEntityIdentifier(MappingDocument mappingDocument, EntityHierarchySourceImpl hierarchySource, RootClass rootEntityDescriptor) {
        IdentifierSourceNonAggregatedComposite identifierSource = (IdentifierSourceNonAggregatedComposite)hierarchySource.getIdentifierSource();
        Component cid = new Component((MetadataBuildingContext)mappingDocument, rootEntityDescriptor);
        cid.setKey(true);
        rootEntityDescriptor.setIdentifier(cid);
        String idClassName = this.extractIdClassName(identifierSource);
        AttributeRole attributeRoleBase = hierarchySource.getRoot().getAttributeRoleBase();
        String className = rootEntityDescriptor.getClassName();
        this.bindComponent(mappingDocument, attributeRoleBase.append("<id>").getFullPath(), identifierSource.getEmbeddableSource(), cid, idClassName, className, null, true, idClassName == null, false);
        if (idClassName != null) {
            Component mapper = new Component((MetadataBuildingContext)mappingDocument, rootEntityDescriptor);
            this.bindComponent(mappingDocument, attributeRoleBase.append(ID_MAPPER_PATH_PART).getFullPath(), identifierSource.getEmbeddableSource(), mapper, className, null, null, true, true, false);
            rootEntityDescriptor.setIdentifierMapper(mapper);
            rootEntityDescriptor.setDeclaredIdentifierMapper(mapper);
            Property property = new Property();
            property.setName("_identifierMapper");
            property.setUpdatable(false);
            property.setInsertable(false);
            property.setValue(mapper);
            property.setPropertyAccessorName(BuiltInPropertyAccessStrategies.EMBEDDED.getExternalName());
            rootEntityDescriptor.addProperty(property);
        }
        this.finishBindingCompositeIdentifier(mappingDocument, rootEntityDescriptor, identifierSource, cid, null);
    }

    private String extractIdClassName(IdentifierSourceNonAggregatedComposite identifierSource) {
        EmbeddableSource idClassSource = identifierSource.getIdClassSource();
        if (idClassSource == null) {
            return null;
        }
        JavaTypeDescriptor typeDescriptor = idClassSource.getTypeDescriptor();
        return typeDescriptor == null ? null : typeDescriptor.getName();
    }

    private void finishBindingCompositeIdentifier(MappingDocument sourceDocument, RootClass rootEntityDescriptor, CompositeIdentifierSource identifierSource, Component cid, String propertyName) {
        if (propertyName == null) {
            rootEntityDescriptor.setEmbeddedIdentifier(cid.isEmbedded());
            if (cid.isEmbedded()) {
                cid.setDynamic(!rootEntityDescriptor.hasPojoRepresentation());
            }
        } else {
            Property property = new Property();
            property.setValue(cid);
            this.bindProperty(sourceDocument, ((IdentifierSourceAggregatedComposite)identifierSource).getIdentifierAttributeSource(), property);
            rootEntityDescriptor.setIdentifierProperty(property);
            rootEntityDescriptor.setDeclaredIdentifierProperty(property);
        }
        GeneratorBinder.makeIdGenerator(sourceDocument, identifierSource.getIdentifierGeneratorDescriptor(), cid, this.metadataBuildingContext);
    }

    private void bindEntityVersion(MappingDocument sourceDocument, EntityHierarchySourceImpl hierarchySource, RootClass rootEntityDescriptor) {
        VersionAttributeSource versionAttributeSource = hierarchySource.getVersionAttributeSource();
        BasicValue versionValue = new BasicValue(sourceDocument, rootEntityDescriptor.getTable());
        versionValue.makeVersion();
        ModelBinder.bindSimpleValueType(sourceDocument, versionAttributeSource.getTypeInformation(), versionValue);
        this.relationalObjectBinder.bindColumnsAndFormulas(sourceDocument, versionAttributeSource.getRelationalValueSources(), versionValue, false, context -> this.implicitNamingStrategy.determineBasicColumnName(versionAttributeSource));
        Property property = new Property();
        property.setValue(versionValue);
        this.bindProperty(sourceDocument, versionAttributeSource, property);
        String unsavedValue = versionAttributeSource.getUnsavedValue();
        if (unsavedValue != null) {
            versionValue.setNullValue(unsavedValue);
        } else {
            versionValue.setNullValueUndefined();
        }
        if (versionAttributeSource.getSource().equals("db")) {
            property.setValueGeneratorCreator(context -> new SourceGeneration(SourceType.DB, property.getType().getReturnedClass(), context));
        }
        rootEntityDescriptor.setVersion(property);
        rootEntityDescriptor.setDeclaredVersion(property);
        rootEntityDescriptor.addProperty(property);
    }

    private void bindEntityDiscriminator(MappingDocument sourceDocument, EntityHierarchySourceImpl hierarchySource, RootClass rootEntityDescriptor) {
        BasicValue discriminatorValue = new BasicValue(sourceDocument, rootEntityDescriptor.getTable());
        rootEntityDescriptor.setDiscriminator(discriminatorValue);
        DiscriminatorSource discriminatorSource = hierarchySource.getDiscriminatorSource();
        String typeName = discriminatorSource.getExplicitHibernateTypeName();
        if (typeName == null) {
            typeName = "string";
        }
        ModelBinder.bindSimpleValueType(sourceDocument, new HibernateTypeSourceImpl(typeName), discriminatorValue);
        this.relationalObjectBinder.bindColumnOrFormula(sourceDocument, discriminatorSource.getDiscriminatorRelationalValueSource(), discriminatorValue, false, context -> this.implicitNamingStrategy.determineDiscriminatorColumnName(discriminatorSource));
        rootEntityDescriptor.setPolymorphic(true);
        rootEntityDescriptor.setDiscriminatorInsertable(discriminatorSource.isInserted());
        boolean force = discriminatorSource.isForced() || sourceDocument.getBuildingOptions().shouldImplicitlyForceDiscriminatorInSelect();
        rootEntityDescriptor.setForceDiscriminator(force);
    }

    private void bindAllEntityAttributes(MappingDocument mappingDocument, EntitySource entitySource, PersistentClass entityDescriptor) {
        InFlightMetadataCollector.EntityTableXref entityTableXref = mappingDocument.getMetadataCollector().getEntityTableXref(entityDescriptor.getEntityName());
        if (entityTableXref == null) {
            throw new AssertionFailure(String.format(Locale.ENGLISH, "Unable to locate EntityTableXref for entity [%s] : %s", entityDescriptor.getEntityName(), mappingDocument.getOrigin()));
        }
        for (SecondaryTableSource secondaryTableSource : entitySource.getSecondaryTableMap().values()) {
            Join secondaryTableJoin = new Join();
            secondaryTableJoin.setPersistentClass(entityDescriptor);
            this.bindSecondaryTable(mappingDocument, secondaryTableSource, secondaryTableJoin, entityTableXref);
            entityDescriptor.addJoin(secondaryTableJoin);
        }
        for (AttributeSource attributeSource : entitySource.attributeSources()) {
            Property attribute;
            AttributeContainer attributeContainer;
            Table table;
            Join secondaryTableJoin;
            Identifier tableName;
            if (attributeSource instanceof PluralAttributeSource) {
                PluralAttributeSource pluralAttributeSource = (PluralAttributeSource)attributeSource;
                Property attribute2 = this.createPluralAttribute(mappingDocument, pluralAttributeSource, entityDescriptor);
                attribute2.setOptional(true);
                entityDescriptor.addProperty(attribute2);
                continue;
            }
            if (attributeSource instanceof SingularAttributeSourceBasic) {
                SingularAttributeSourceBasic basicAttributeSource = (SingularAttributeSourceBasic)attributeSource;
                tableName = this.determineTable(mappingDocument, basicAttributeSource.getName(), basicAttributeSource);
                secondaryTableJoin = entityTableXref.locateJoin(tableName);
                if (secondaryTableJoin == null) {
                    table = entityDescriptor.getTable();
                    attributeContainer = entityDescriptor;
                } else {
                    table = secondaryTableJoin.getTable();
                    attributeContainer = secondaryTableJoin;
                }
                attribute = this.createBasicAttribute(mappingDocument, basicAttributeSource, new BasicValue(mappingDocument, table), entityDescriptor.getClassName());
                attribute.setOptional(ModelBinder.isOptional(secondaryTableJoin, attribute));
                attributeContainer.addProperty(attribute);
                this.handleNaturalIdBinding(mappingDocument, entityDescriptor, attribute, basicAttributeSource.getNaturalIdMutability());
                continue;
            }
            if (attributeSource instanceof SingularAttributeSourceEmbedded) {
                SingularAttributeSourceEmbedded embeddedAttributeSource = (SingularAttributeSourceEmbedded)attributeSource;
                tableName = this.determineTable(mappingDocument, embeddedAttributeSource);
                secondaryTableJoin = entityTableXref.locateJoin(tableName);
                if (secondaryTableJoin == null) {
                    table = entityDescriptor.getTable();
                    attributeContainer = entityDescriptor;
                } else {
                    table = secondaryTableJoin.getTable();
                    attributeContainer = secondaryTableJoin;
                }
                attribute = this.createEmbeddedAttribute(mappingDocument, embeddedAttributeSource, new Component(mappingDocument, table, entityDescriptor), entityDescriptor.getClassName());
                attribute.setOptional(ModelBinder.isOptional(secondaryTableJoin, attribute));
                attributeContainer.addProperty(attribute);
                this.handleNaturalIdBinding(mappingDocument, entityDescriptor, attribute, embeddedAttributeSource.getNaturalIdMutability());
                continue;
            }
            if (attributeSource instanceof SingularAttributeSourceManyToOne) {
                SingularAttributeSourceManyToOne manyToOneAttributeSource = (SingularAttributeSourceManyToOne)attributeSource;
                tableName = this.determineTable(mappingDocument, manyToOneAttributeSource.getName(), manyToOneAttributeSource);
                secondaryTableJoin = entityTableXref.locateJoin(tableName);
                if (secondaryTableJoin == null) {
                    table = entityDescriptor.getTable();
                    attributeContainer = entityDescriptor;
                } else {
                    table = secondaryTableJoin.getTable();
                    attributeContainer = secondaryTableJoin;
                }
                attribute = this.createManyToOneAttribute(mappingDocument, manyToOneAttributeSource, new ManyToOne(mappingDocument, table), entityDescriptor.getClassName());
                attribute.setOptional(ModelBinder.isOptional(secondaryTableJoin, attribute));
                attributeContainer.addProperty(attribute);
                this.handleNaturalIdBinding(mappingDocument, entityDescriptor, attribute, manyToOneAttributeSource.getNaturalIdMutability());
                continue;
            }
            if (attributeSource instanceof SingularAttributeSourceOneToOne) {
                SingularAttributeSourceOneToOne oneToOneAttributeSource = (SingularAttributeSourceOneToOne)attributeSource;
                Table table2 = entityDescriptor.getTable();
                Property attribute3 = this.createOneToOneAttribute(mappingDocument, oneToOneAttributeSource, new OneToOne(mappingDocument, table2, entityDescriptor), entityDescriptor.getClassName());
                attribute3.setOptional(attribute3.getValue().isNullable());
                entityDescriptor.addProperty(attribute3);
                this.handleNaturalIdBinding(mappingDocument, entityDescriptor, attribute3, oneToOneAttributeSource.getNaturalIdMutability());
                continue;
            }
            if (!(attributeSource instanceof SingularAttributeSourceAny)) continue;
            SingularAttributeSourceAny anyAttributeSource = (SingularAttributeSourceAny)attributeSource;
            tableName = this.determineTable(mappingDocument, anyAttributeSource.getName(), anyAttributeSource.getKeySource().getRelationalValueSources());
            secondaryTableJoin = entityTableXref.locateJoin(tableName);
            if (secondaryTableJoin == null) {
                table = entityDescriptor.getTable();
                attributeContainer = entityDescriptor;
            } else {
                table = secondaryTableJoin.getTable();
                attributeContainer = secondaryTableJoin;
            }
            attribute = this.createAnyAssociationAttribute(mappingDocument, anyAttributeSource, new Any(mappingDocument, table), entityDescriptor.getEntityName());
            attribute.setOptional(ModelBinder.isOptional(secondaryTableJoin, attribute));
            attributeContainer.addProperty(attribute);
            this.handleNaturalIdBinding(mappingDocument, entityDescriptor, attribute, anyAttributeSource.getNaturalIdMutability());
        }
    }

    private static boolean isOptional(Join secondaryTableJoin, Property attribute) {
        return secondaryTableJoin != null && secondaryTableJoin.isOptional() || attribute.getValue().isNullable();
    }

    private void handleNaturalIdBinding(MappingDocument mappingDocument, PersistentClass entityBinding, Property attributeBinding, NaturalIdMutability naturalIdMutability) {
        if (naturalIdMutability != NaturalIdMutability.NOT_NATURAL_ID) {
            String entityName;
            InFlightMetadataCollector metadataCollector;
            NaturalIdUniqueKeyBinder ukBinder;
            attributeBinding.setNaturalIdentifier(true);
            if (naturalIdMutability == NaturalIdMutability.IMMUTABLE) {
                attributeBinding.setUpdatable(false);
            }
            if ((ukBinder = (metadataCollector = mappingDocument.getMetadataCollector()).locateNaturalIdUniqueKeyBinder(entityName = entityBinding.getEntityName())) == null) {
                ukBinder = new NaturalIdUniqueKeyBinderImpl(mappingDocument, entityBinding);
                metadataCollector.registerNaturalIdUniqueKeyBinder(entityName, ukBinder);
            }
            ukBinder.addAttributeBinding(attributeBinding);
        }
    }

    private Property createPluralAttribute(MappingDocument sourceDocument, PluralAttributeSource attributeSource, PersistentClass entityDescriptor) {
        Collection collectionBinding;
        if (attributeSource instanceof PluralAttributeSourceListImpl) {
            PluralAttributeSourceListImpl pluralAttributeSourceList = (PluralAttributeSourceListImpl)attributeSource;
            List list = new List(sourceDocument, entityDescriptor);
            collectionBinding = list;
            this.bindCollectionMetadata(sourceDocument, attributeSource, collectionBinding);
            this.registerSecondPass(new PluralAttributeListSecondPass(sourceDocument, pluralAttributeSourceList, list), sourceDocument);
        } else if (attributeSource instanceof PluralAttributeSourceSetImpl) {
            collectionBinding = new Set(sourceDocument, entityDescriptor);
            this.bindCollectionMetadata(sourceDocument, attributeSource, collectionBinding);
            this.registerSecondPass(new PluralAttributeSetSecondPass(sourceDocument, attributeSource, collectionBinding), sourceDocument);
        } else if (attributeSource instanceof PluralAttributeSourceMapImpl) {
            PluralAttributeSourceMapImpl pluralAttributeSourceMap = (PluralAttributeSourceMapImpl)attributeSource;
            org.hibernate.mapping.Map map = new org.hibernate.mapping.Map(sourceDocument, entityDescriptor);
            collectionBinding = map;
            this.bindCollectionMetadata(sourceDocument, attributeSource, collectionBinding);
            this.registerSecondPass(new PluralAttributeMapSecondPass(sourceDocument, pluralAttributeSourceMap, map), sourceDocument);
        } else if (attributeSource instanceof PluralAttributeSourceBagImpl) {
            collectionBinding = new Bag(sourceDocument, entityDescriptor);
            this.bindCollectionMetadata(sourceDocument, attributeSource, collectionBinding);
            this.registerSecondPass(new PluralAttributeBagSecondPass(sourceDocument, attributeSource, collectionBinding), sourceDocument);
        } else if (attributeSource instanceof PluralAttributeSourceIdBagImpl) {
            collectionBinding = new IdentifierBag(sourceDocument, entityDescriptor);
            this.bindCollectionMetadata(sourceDocument, attributeSource, collectionBinding);
            this.registerSecondPass(new PluralAttributeIdBagSecondPass(sourceDocument, attributeSource, collectionBinding), sourceDocument);
        } else if (attributeSource instanceof PluralAttributeSourceArrayImpl) {
            PluralAttributeSourceArrayImpl arraySource = (PluralAttributeSourceArrayImpl)attributeSource;
            Array array = new Array(sourceDocument, entityDescriptor);
            collectionBinding = array;
            this.bindCollectionMetadata(sourceDocument, attributeSource, collectionBinding);
            array.setElementClassName(sourceDocument.qualifyClassName(arraySource.getElementClass()));
            this.registerSecondPass(new PluralAttributeArraySecondPass(sourceDocument, arraySource, array), sourceDocument);
        } else if (attributeSource instanceof PluralAttributeSourcePrimitiveArrayImpl) {
            PluralAttributeSourcePrimitiveArrayImpl pluralAttributeSourcePrimitiveArray = (PluralAttributeSourcePrimitiveArrayImpl)attributeSource;
            PrimitiveArray primitiveArray = new PrimitiveArray(sourceDocument, entityDescriptor);
            collectionBinding = primitiveArray;
            this.bindCollectionMetadata(sourceDocument, attributeSource, collectionBinding);
            this.registerSecondPass(new PluralAttributePrimitiveArraySecondPass(sourceDocument, pluralAttributeSourcePrimitiveArray, primitiveArray), sourceDocument);
        } else {
            throw new AssertionFailure("Unexpected PluralAttributeSource type : " + attributeSource.getClass().getName());
        }
        sourceDocument.getMetadataCollector().addCollectionBinding(collectionBinding);
        Property attribute = new Property();
        attribute.setValue(collectionBinding);
        this.bindProperty(sourceDocument, attributeSource, attribute);
        return attribute;
    }

    private void bindCollectionMetadata(MappingDocument mappingDocument, PluralAttributeSource source, Collection binding) {
        String cascadeStyle;
        Orderable orderable;
        binding.setRole(source.getAttributeRole().getFullPath());
        binding.setInverse(source.isInverse());
        binding.setMutable(source.isMutable());
        binding.setOptimisticLocked(source.isIncludedInOptimisticLocking());
        if (source.getCustomPersisterClassName() != null) {
            DeprecationLogger.DEPRECATION_LOGGER.debugf("Custom CollectionPersister impls are no longer supported - %s (%s)", (Object)binding.getRole(), (Object)mappingDocument.getOrigin().getName());
        }
        this.applyCaching(mappingDocument, source.getCaching(), binding);
        String typeName = source.getTypeInformation().getName();
        HashMap<String, String> typeParameters = new HashMap<String, String>();
        if (typeName != null) {
            String[] typeDef = mappingDocument.getMetadataCollector().getTypeDefinition(typeName);
            if (typeDef != null) {
                typeName = typeDef.getTypeImplementorClass().getName();
                if (typeDef.getParameters() != null) {
                    typeParameters.putAll(typeDef.getParameters());
                }
            } else {
                typeName = mappingDocument.qualifyClassName(typeName);
            }
        }
        if (source.getTypeInformation().getParameters() != null) {
            typeParameters.putAll(source.getTypeInformation().getParameters());
        }
        binding.setTypeName(typeName);
        binding.setTypeParameters(typeParameters);
        if (source.getFetchCharacteristics().getFetchTiming() == FetchTiming.DELAYED) {
            binding.setLazy(true);
            binding.setExtraLazy(source.getFetchCharacteristics().isExtraLazy());
        } else {
            binding.setLazy(false);
        }
        ModelBinder.setupFetching(source, binding);
        for (String name : source.getSynchronizedTableNames()) {
            binding.getSynchronizedTables().add(name);
        }
        binding.setLoaderName(source.getCustomLoaderName());
        ModelBinder.bindCustomSql(source, binding);
        if (source instanceof Sortable) {
            Sortable sortable = (Sortable)((Object)source);
            if (sortable.isSorted()) {
                binding.setSorted(true);
                if (!sortable.getComparatorName().equals("natural")) {
                    binding.setComparatorClassName(sortable.getComparatorName());
                }
            } else {
                binding.setSorted(false);
            }
        }
        if (source instanceof Orderable && (orderable = (Orderable)((Object)source)).isOrdered()) {
            binding.setOrderBy(orderable.getOrder());
        }
        if ((cascadeStyle = source.getCascadeStyleName()) != null && cascadeStyle.contains("delete-orphan")) {
            binding.setOrphanDelete(true);
        }
        for (FilterSource filterSource : source.getFilterSources()) {
            binding.addFilter(filterSource.getName(), ModelBinder.filterCondition(filterSource, mappingDocument), filterSource.shouldAutoInjectAliases(), filterSource.getAliasToTableMap(), filterSource.getAliasToEntityMap());
        }
    }

    private static void bindCustomSql(PluralAttributeSource source, Collection binding) {
        if (source.getCustomSqlInsert() != null) {
            binding.setCustomSQLInsert(source.getCustomSqlInsert().sql(), source.getCustomSqlInsert().callable(), source.getCustomSqlInsert().checkStyle());
        }
        if (source.getCustomSqlUpdate() != null) {
            binding.setCustomSQLUpdate(source.getCustomSqlUpdate().sql(), source.getCustomSqlUpdate().callable(), source.getCustomSqlUpdate().checkStyle());
        }
        if (source.getCustomSqlDelete() != null) {
            binding.setCustomSQLDelete(source.getCustomSqlDelete().sql(), source.getCustomSqlDelete().callable(), source.getCustomSqlDelete().checkStyle());
        }
        if (source.getCustomSqlDeleteAll() != null) {
            binding.setCustomSQLDeleteAll(source.getCustomSqlDeleteAll().sql(), source.getCustomSqlDeleteAll().callable(), source.getCustomSqlDeleteAll().checkStyle());
        }
    }

    private static void setupFetching(PluralAttributeSource source, Collection binding) {
        switch (source.getFetchCharacteristics().getFetchStyle()) {
            case SELECT: {
                binding.setFetchMode(FetchMode.SELECT);
                break;
            }
            case JOIN: {
                binding.setFetchMode(FetchMode.JOIN);
                break;
            }
            case BATCH: {
                binding.setFetchMode(FetchMode.SELECT);
                binding.setBatchSize(source.getFetchCharacteristics().getBatchSize());
                break;
            }
            case SUBSELECT: {
                binding.setFetchMode(FetchMode.SELECT);
                binding.setSubselectLoadable(true);
                binding.getOwner().setSubselectLoadableCollections(true);
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected FetchStyle : " + source.getFetchCharacteristics().getFetchStyle().name());
            }
        }
    }

    private void applyCaching(MappingDocument mappingDocument, Caching caching, Collection collection) {
        if (ModelBinder.isCacheEnabled(mappingDocument, caching)) {
            collection.setCacheConcurrencyStrategy(ModelBinder.getConcurrencyStrategy(mappingDocument, caching).getExternalName());
            collection.setCacheRegionName(caching == null ? null : caching.getRegion());
        }
    }

    private Identifier determineTable(MappingDocument sourceDocument, String attributeName, RelationalValueSourceContainer relationalValueSourceContainer) {
        return this.determineTable(sourceDocument, attributeName, relationalValueSourceContainer.getRelationalValueSources());
    }

    private Identifier determineTable(MappingDocument mappingDocument, SingularAttributeSourceEmbedded embeddedAttributeSource) {
        Identifier tableName = null;
        for (AttributeSource attributeSource : embeddedAttributeSource.getEmbeddableSource().attributeSources()) {
            Identifier determinedName;
            if (attributeSource instanceof RelationalValueSourceContainer) {
                RelationalValueSourceContainer relationalValueSourceContainer = (RelationalValueSourceContainer)((Object)attributeSource);
                determinedName = this.determineTable(mappingDocument, embeddedAttributeSource.getAttributeRole().getFullPath(), relationalValueSourceContainer);
            } else if (attributeSource instanceof SingularAttributeSourceEmbedded) {
                SingularAttributeSourceEmbedded singularAttributeSourceEmbedded = (SingularAttributeSourceEmbedded)attributeSource;
                determinedName = this.determineTable(mappingDocument, singularAttributeSourceEmbedded);
            } else {
                if (!(attributeSource instanceof SingularAttributeSourceAny)) continue;
                SingularAttributeSourceAny singularAttributeSourceAny = (SingularAttributeSourceAny)attributeSource;
                determinedName = this.determineTable(mappingDocument, attributeSource.getAttributeRole().getFullPath(), singularAttributeSourceAny.getKeySource().getRelationalValueSources());
            }
            if (Objects.equals(tableName, determinedName)) continue;
            if (tableName != null) {
                throw new MappingException(String.format(Locale.ENGLISH, "Attribute [%s] referenced columns from multiple tables: %s, %s", embeddedAttributeSource.getAttributeRole().getFullPath(), tableName, determinedName), mappingDocument.getOrigin());
            }
            tableName = determinedName;
        }
        return tableName;
    }

    private Identifier determineTable(MappingDocument mappingDocument, String attributeName, java.util.List<RelationalValueSource> relationalValueSources) {
        String tableName = null;
        for (RelationalValueSource relationalValueSource : relationalValueSources) {
            if (Objects.equals(tableName, relationalValueSource.getContainingTableName())) continue;
            if (tableName != null) {
                throw new MappingException(String.format(Locale.ENGLISH, "Attribute [%s] referenced columns from multiple tables: %s, %s", attributeName, tableName, relationalValueSource.getContainingTableName()), mappingDocument.getOrigin());
            }
            tableName = relationalValueSource.getContainingTableName();
        }
        return this.database.toIdentifier(tableName);
    }

    private void bindSecondaryTable(MappingDocument mappingDocument, SecondaryTableSource secondaryTableSource, Join secondaryTableJoin, final InFlightMetadataCollector.EntityTableXref entityTableXref) {
        Table secondaryTable;
        Identifier logicalTableName;
        PersistentClass persistentClass = secondaryTableJoin.getPersistentClass();
        Identifier catalogName = this.determineCatalogName(secondaryTableSource.getTableSource());
        Identifier schemaName = this.determineSchemaName(secondaryTableSource.getTableSource());
        Namespace namespace = this.database.locateNamespace(catalogName, schemaName);
        TableSpecificationSource tableSpecificationSource = secondaryTableSource.getTableSource();
        if (tableSpecificationSource instanceof TableSource) {
            TableSource tableSource = (TableSource)tableSpecificationSource;
            logicalTableName = this.database.toIdentifier(tableSource.getExplicitTableName());
            secondaryTable = namespace.locateTable(logicalTableName);
            if (secondaryTable == null) {
                secondaryTable = namespace.createTable(logicalTableName, identifier -> new Table(mappingDocument.getCurrentContributorName(), namespace, (Identifier)identifier, false));
            } else {
                secondaryTable.setAbstract(false);
            }
            secondaryTable.setComment(tableSource.getComment());
        } else {
            InLineViewSource inLineViewSource = (InLineViewSource)secondaryTableSource.getTableSource();
            secondaryTable = new Table(this.metadataBuildingContext.getCurrentContributorName(), namespace, inLineViewSource.getSelectStatement(), false);
            logicalTableName = Identifier.toIdentifier(inLineViewSource.getLogicalName());
        }
        secondaryTableJoin.setTable(secondaryTable);
        entityTableXref.addSecondaryTable(mappingDocument, logicalTableName, secondaryTableJoin);
        ModelBinder.bindCustomSql(secondaryTableSource, secondaryTableJoin);
        secondaryTableJoin.setInverse(secondaryTableSource.isInverse());
        secondaryTableJoin.setOptional(secondaryTableSource.isOptional());
        if (log.isTraceEnabled()) {
            log.tracef("Mapping entity secondary-table: %s -> %s", (Object)persistentClass.getEntityName(), (Object)secondaryTable.getName());
        }
        DependantValue keyBinding = new DependantValue(mappingDocument, secondaryTable, persistentClass.getIdentifier());
        if (mappingDocument.getBuildingOptions().useNationalizedCharacterData()) {
            keyBinding.makeNationalized();
        }
        secondaryTableJoin.setKey(keyBinding);
        keyBinding.setOnDeleteAction(ModelBinder.getOnDeleteAction(secondaryTableSource.isCascadeDeleteEnabled()));
        this.relationalObjectBinder.bindColumns(mappingDocument, secondaryTableSource.getPrimaryKeyColumnSources(), keyBinding, secondaryTableSource.isOptional(), new RelationalObjectBinder.ColumnNamingDelegate(){
            int count = 0;

            @Override
            public Identifier determineImplicitName(LocalMetadataBuildingContext context) {
                return entityTableXref.getPrimaryTable().getPrimaryKey().getColumn(this.count++).getNameIdentifier(ModelBinder.this.metadataBuildingContext);
            }
        });
        keyBinding.sortProperties();
        ModelBinder.setForeignKeyName(keyBinding, secondaryTableSource.getExplicitForeignKeyName());
        if (secondaryTable.getSubselect() == null) {
            secondaryTableJoin.createPrimaryKey();
            secondaryTableJoin.createForeignKey();
        }
    }

    private Property createEmbeddedAttribute(MappingDocument sourceDocument, SingularAttributeSourceEmbedded embeddedSource, Component componentBinding, String containingClassName) {
        String attributeName = embeddedSource.getName();
        this.bindComponent(sourceDocument, embeddedSource.getEmbeddableSource(), componentBinding, containingClassName, attributeName, embeddedSource.isVirtualAttribute());
        this.prepareValueTypeViaReflection(sourceDocument, componentBinding, componentBinding.getComponentClassName(), attributeName, embeddedSource.getAttributeRole());
        componentBinding.createForeignKey();
        Property attribute = new Property();
        attribute.setValue(componentBinding);
        this.bindProperty(sourceDocument, embeddedSource, attribute);
        if (embeddedSource.isVirtualAttribute()) {
            attribute.setPropertyAccessorName(BuiltInPropertyAccessStrategies.EMBEDDED.getExternalName());
        }
        return attribute;
    }

    private Property createBasicAttribute(MappingDocument sourceDocument, SingularAttributeSourceBasic attributeSource, SimpleValue value, String containingClassName) {
        String attributeName = attributeSource.getName();
        ModelBinder.bindSimpleValueType(sourceDocument, attributeSource.getTypeInformation(), value);
        this.relationalObjectBinder.bindColumnsAndFormulas(sourceDocument, attributeSource.getRelationalValueSources(), value, attributeSource.areValuesNullableByDefault(), context -> this.implicitNamingStrategy.determineBasicColumnName(attributeSource));
        this.prepareValueTypeViaReflection(sourceDocument, value, containingClassName, attributeName, attributeSource.getAttributeRole());
        this.resolveLob(attributeSource, value);
        value.createForeignKey();
        Property property = new Property();
        property.setValue(value);
        property.setLob(value.isLob());
        this.bindProperty(sourceDocument, attributeSource, property);
        return property;
    }

    private void resolveLob(SingularAttributeSourceBasic attributeSource, SimpleValue value) {
        if (!value.isLob() && value.getTypeName() != null) {
            BasicType basicType;
            String typeName = value.getTypeName();
            MetadataBuildingContext context = attributeSource.getBuildingContext();
            BasicType<Object> basicType2 = basicType = typeName.startsWith("basicType") ? context.getBootstrapContext().resolveAdHocBasicType(typeName) : context.getMetadataCollector().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(typeName);
            if (basicType instanceof AbstractSingleColumnStandardBasicType && ModelBinder.isLob(basicType.getJdbcType().getDdlTypeCode(), null)) {
                value.makeLob();
            }
        }
        if (!value.isLob()) {
            for (RelationalValueSource relationalValueSource : attributeSource.getRelationalValueSources()) {
                ColumnSource columnSource;
                if (!(relationalValueSource instanceof ColumnSource) || !ModelBinder.isLob(null, (columnSource = (ColumnSource)relationalValueSource).getSqlType())) continue;
                value.makeLob();
            }
        }
    }

    private static boolean isLob(Integer sqlType, String sqlTypeName) {
        if (sqlType != null) {
            return switch (sqlType) {
                case 2004, 2005, 2011 -> true;
                default -> false;
            };
        }
        if (sqlTypeName != null) {
            return switch (sqlTypeName.toLowerCase(Locale.ROOT)) {
                case "blob", "clob", "nclob" -> true;
                default -> false;
            };
        }
        return false;
    }

    private Property createOneToOneAttribute(MappingDocument sourceDocument, SingularAttributeSourceOneToOne oneToOneSource, OneToOne oneToOneBinding, String containingClassName) {
        this.bindOneToOne(sourceDocument, oneToOneSource, oneToOneBinding);
        this.prepareValueTypeViaReflection(sourceDocument, oneToOneBinding, containingClassName, oneToOneSource.getName(), oneToOneSource.getAttributeRole());
        String propertyRef = oneToOneBinding.getReferencedPropertyName();
        if (propertyRef != null) {
            this.handlePropertyReference(sourceDocument, oneToOneBinding.getReferencedEntityName(), propertyRef, "<one-to-one name=\"" + oneToOneSource.getName() + "\"/>");
        }
        this.metadataBuildingContext.getMetadataCollector().addSecondPass(new OneToOneFkSecondPass(oneToOneBinding));
        Property property = new Property();
        property.setValue(oneToOneBinding);
        this.bindProperty(sourceDocument, oneToOneSource, property);
        return property;
    }

    private void handlePropertyReference(MappingDocument mappingDocument, String referencedEntityName, String referencedPropertyName, String sourceElementSynopsis) {
        PersistentClass entityBinding = mappingDocument.getMetadataCollector().getEntityBinding(referencedEntityName);
        if (entityBinding == null) {
            this.registerDelayedPropertyReferenceHandler(new DelayedPropertyReferenceHandlerImpl(referencedEntityName, referencedPropertyName, true, sourceElementSynopsis, mappingDocument.getOrigin()), mappingDocument);
        } else {
            Property propertyBinding = entityBinding.getReferencedProperty(referencedPropertyName);
            if (propertyBinding == null) {
                this.registerDelayedPropertyReferenceHandler(new DelayedPropertyReferenceHandlerImpl(referencedEntityName, referencedPropertyName, true, sourceElementSynopsis, mappingDocument.getOrigin()), mappingDocument);
            } else {
                log.tracef("Property [%s.%s] referenced by property-ref [%s] was available - no need for delayed handling", (Object)referencedEntityName, (Object)referencedPropertyName, (Object)sourceElementSynopsis);
                ((SimpleValue)propertyBinding.getValue()).setAlternateUniqueKey(true);
            }
        }
    }

    private void registerDelayedPropertyReferenceHandler(DelayedPropertyReferenceHandlerImpl handler, MetadataBuildingContext buildingContext) {
        log.tracef("Property [%s.%s] referenced by property-ref [%s] was not yet available - creating delayed handler", (Object)handler.referencedEntityName, (Object)handler.referencedPropertyName, (Object)handler.sourceElementSynopsis);
        buildingContext.getMetadataCollector().addDelayedPropertyReferenceHandler(handler);
    }

    public void bindOneToOne(MappingDocument sourceDocument, SingularAttributeSourceOneToOne oneToOneSource, OneToOne oneToOneBinding) {
        oneToOneBinding.setPropertyName(oneToOneSource.getName());
        this.relationalObjectBinder.bindFormulas(sourceDocument, oneToOneSource.getFormulaSources(), oneToOneBinding);
        if (oneToOneSource.isConstrained()) {
            if (oneToOneSource.getCascadeStyleName() != null && oneToOneSource.getCascadeStyleName().contains("delete-orphan")) {
                throw new MappingException(String.format(Locale.ENGLISH, "one-to-one attribute [%s] cannot specify orphan delete cascading as it is constrained", oneToOneSource.getAttributeRole().getFullPath()), sourceDocument.getOrigin());
            }
            oneToOneBinding.setConstrained(true);
            oneToOneBinding.setForeignKeyType(ForeignKeyDirection.FROM_PARENT);
        } else {
            oneToOneBinding.setForeignKeyType(ForeignKeyDirection.TO_PARENT);
        }
        FetchCharacteristicsSingularAssociation fetchCharacteristics = oneToOneSource.getFetchCharacteristics();
        oneToOneBinding.setLazy(fetchCharacteristics.getFetchTiming() == FetchTiming.DELAYED);
        oneToOneBinding.setFetchMode(fetchCharacteristics.getFetchStyle() == FetchStyle.SELECT ? FetchMode.SELECT : FetchMode.JOIN);
        oneToOneBinding.setUnwrapProxy(fetchCharacteristics.isUnwrapProxies());
        String referencedEntityAttributeName = oneToOneSource.getReferencedEntityAttributeName();
        if (StringHelper.isNotEmpty(referencedEntityAttributeName)) {
            oneToOneBinding.setReferencedPropertyName(referencedEntityAttributeName);
            oneToOneBinding.setReferenceToPrimaryKey(false);
        } else {
            oneToOneBinding.setReferenceToPrimaryKey(true);
        }
        oneToOneBinding.setReferencedEntityName(oneToOneSource.getReferencedEntityName());
        if (oneToOneSource.isEmbedXml() == Boolean.TRUE) {
            DeprecationLogger.DEPRECATION_LOGGER.logDeprecationOfEmbedXmlSupport();
        }
        if (StringHelper.isNotEmpty(oneToOneSource.getExplicitForeignKeyName())) {
            ModelBinder.setForeignKeyName(oneToOneBinding, oneToOneSource.getExplicitForeignKeyName());
        }
        oneToOneBinding.setOnDeleteAction(ModelBinder.getOnDeleteAction(oneToOneSource.isCascadeDeleteEnabled()));
    }

    private Property createManyToOneAttribute(MappingDocument sourceDocument, SingularAttributeSourceManyToOne manyToOneSource, ManyToOne manyToOneBinding, String containingClassName) {
        String referencedEntityName;
        String attributeName = manyToOneSource.getName();
        String explicitReferencedEntityName = manyToOneSource.getReferencedEntityName();
        if (explicitReferencedEntityName != null) {
            referencedEntityName = explicitReferencedEntityName;
        } else {
            Class reflectedPropertyClass = Helper.reflectedPropertyClass((MetadataBuildingContext)sourceDocument, containingClassName, attributeName);
            if (reflectedPropertyClass != null) {
                referencedEntityName = reflectedPropertyClass.getName();
            } else {
                this.prepareValueTypeViaReflection(sourceDocument, manyToOneBinding, containingClassName, attributeName, manyToOneSource.getAttributeRole());
                referencedEntityName = manyToOneBinding.getTypeName();
            }
        }
        if (manyToOneSource.isUnique()) {
            manyToOneBinding.markAsLogicalOneToOne();
        }
        this.bindManyToOneAttribute(sourceDocument, manyToOneSource, manyToOneBinding, referencedEntityName);
        String propertyRef = manyToOneBinding.getReferencedPropertyName();
        if (propertyRef != null) {
            this.handlePropertyReference(sourceDocument, manyToOneBinding.getReferencedEntityName(), propertyRef, "<many-to-one name=\"" + manyToOneSource.getName() + "\"/>");
        }
        Property property = new Property();
        property.setValue(manyToOneBinding);
        this.bindProperty(sourceDocument, manyToOneSource, property);
        if (StringHelper.isNotEmpty(manyToOneSource.getCascadeStyleName()) && manyToOneSource.getCascadeStyleName().contains("delete-orphan") && !manyToOneBinding.isLogicalOneToOne()) {
            throw new MappingException(String.format(Locale.ENGLISH, "many-to-one attribute [%s] specified delete-orphan but is not specified as unique; remove delete-orphan cascading or specify unique=\"true\"", manyToOneSource.getAttributeRole().getFullPath()), sourceDocument.getOrigin());
        }
        return property;
    }

    private void bindManyToOneAttribute(MappingDocument sourceDocument, SingularAttributeSourceManyToOne manyToOneSource, ManyToOne manyToOneBinding, String referencedEntityName) {
        manyToOneBinding.setReferencedEntityName(referencedEntityName);
        String referencedEntityAttributeName = manyToOneSource.getReferencedEntityAttributeName();
        if (StringHelper.isNotEmpty(referencedEntityAttributeName)) {
            manyToOneBinding.setReferencedPropertyName(referencedEntityAttributeName);
            manyToOneBinding.setReferenceToPrimaryKey(false);
        } else {
            manyToOneBinding.setReferenceToPrimaryKey(true);
        }
        FetchCharacteristicsSingularAssociation fetchCharacteristics = manyToOneSource.getFetchCharacteristics();
        manyToOneBinding.setLazy(fetchCharacteristics.getFetchTiming() == FetchTiming.DELAYED);
        manyToOneBinding.setUnwrapProxy(fetchCharacteristics.isUnwrapProxies());
        manyToOneBinding.setFetchMode(fetchCharacteristics.getFetchStyle() == FetchStyle.SELECT ? FetchMode.SELECT : FetchMode.JOIN);
        if (manyToOneSource.isEmbedXml() == Boolean.TRUE) {
            DeprecationLogger.DEPRECATION_LOGGER.logDeprecationOfEmbedXmlSupport();
        }
        manyToOneBinding.setIgnoreNotFound(manyToOneSource.isIgnoreNotFound());
        ModelBinder.setForeignKeyName(manyToOneBinding, manyToOneSource.getExplicitForeignKeyName());
        ManyToOneColumnBinder columnBinder = new ManyToOneColumnBinder(sourceDocument, manyToOneSource, manyToOneBinding, referencedEntityName);
        boolean canBindColumnsImmediately = columnBinder.canProcessImmediately();
        if (canBindColumnsImmediately) {
            columnBinder.doSecondPass(null);
        } else {
            sourceDocument.getMetadataCollector().addSecondPass(columnBinder);
        }
        if (!manyToOneSource.isIgnoreNotFound()) {
            ManyToOneFkSecondPass fkSecondPass = new ManyToOneFkSecondPass(sourceDocument, manyToOneSource, manyToOneBinding, referencedEntityName);
            if (canBindColumnsImmediately && fkSecondPass.canProcessImmediately()) {
                fkSecondPass.doSecondPass(null);
            } else {
                sourceDocument.getMetadataCollector().addSecondPass(fkSecondPass);
            }
        }
        manyToOneBinding.setOnDeleteAction(ModelBinder.getOnDeleteAction(manyToOneSource.isCascadeDeleteEnabled()));
    }

    private static void setForeignKeyName(SimpleValue manyToOneBinding, String foreignKeyName) {
        if (StringHelper.isNotEmpty(foreignKeyName)) {
            if ("none".equals(foreignKeyName)) {
                manyToOneBinding.disableForeignKey();
            } else {
                manyToOneBinding.setForeignKeyName(foreignKeyName);
            }
        }
    }

    private Property createAnyAssociationAttribute(MappingDocument sourceDocument, SingularAttributeSourceAny anyMapping, Any anyBinding, String entityName) {
        AttributeRole role = anyMapping.getAttributeRole();
        this.bindAny(sourceDocument, anyMapping, anyBinding, role);
        this.prepareValueTypeViaReflection(sourceDocument, anyBinding, entityName, anyMapping.getName(), role);
        anyBinding.createForeignKey();
        Property property = new Property();
        property.setValue(anyBinding);
        this.bindProperty(sourceDocument, anyMapping, property);
        return property;
    }

    private void bindAny(MappingDocument sourceDocument, AnyMappingSource anyMapping, Any anyBinding, AttributeRole attributeRole) {
        BasicType<String> discriminatorType;
        String discriminatorTypeName;
        TypeResolution discriminatorTypeResolution;
        anyBinding.setLazy(anyMapping.isLazy());
        TypeResolution keyTypeResolution = ModelBinder.resolveType(sourceDocument, anyMapping.getKeySource().getTypeSource());
        if (keyTypeResolution != null) {
            anyBinding.setIdentifierType(keyTypeResolution.typeName);
        }
        if ((discriminatorTypeResolution = ModelBinder.resolveType(sourceDocument, anyMapping.getDiscriminatorSource().getTypeSource())) != null && discriminatorTypeResolution.typeName != null) {
            discriminatorTypeName = discriminatorTypeResolution.typeName;
            discriminatorType = this.resolveExplicitlyNamedAnyDiscriminatorType(discriminatorTypeResolution.typeName, discriminatorTypeResolution.parameters, anyBinding.getMetaMapping());
        } else {
            discriminatorTypeName = StandardBasicTypes.STRING.getName();
            discriminatorType = this.metadataBuildingContext.getBootstrapContext().getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING);
        }
        anyBinding.setMetaType(discriminatorTypeName);
        HashMap<Object, String> discriminatorValueToEntityNameMap = new HashMap<Object, String>();
        anyMapping.getDiscriminatorSource().getValueMappings().forEach((discriminatorValueString, entityName) -> {
            try {
                Object discriminatorValue = discriminatorType.getJavaTypeDescriptor().fromString((CharSequence)discriminatorValueString);
                discriminatorValueToEntityNameMap.put(discriminatorValue, (String)entityName);
            }
            catch (Exception exception) {
                throw new MappingException(String.format(Locale.ENGLISH, "Unable to interpret <meta-value value=\"%s\" class=\"%s\"/> defined as part of <any/> attribute [%s]", discriminatorValueString, entityName, attributeRole.getFullPath()), exception, sourceDocument.getOrigin());
            }
        });
        anyBinding.setMetaValues(discriminatorValueToEntityNameMap);
        this.relationalObjectBinder.bindColumnOrFormula(sourceDocument, anyMapping.getDiscriminatorSource().getRelationalValueSource(), anyBinding.getMetaMapping(), true, context -> this.implicitNamingStrategy.determineAnyDiscriminatorColumnName(anyMapping.getDiscriminatorSource()));
        this.relationalObjectBinder.bindColumnsAndFormulas(sourceDocument, anyMapping.getKeySource().getRelationalValueSources(), anyBinding.getKeyMapping(), true, context -> this.implicitNamingStrategy.determineAnyKeyColumnName(anyMapping.getKeySource()));
    }

    private BasicType<?> resolveExplicitlyNamedAnyDiscriminatorType(String typeName, Map<String, String> parameters, Any.MetaValue discriminatorMapping) {
        BasicType basicTypeByName;
        BootstrapContext bootstrapContext = this.metadataBuildingContext.getBootstrapContext();
        TypeConfiguration typeConfiguration = bootstrapContext.getTypeConfiguration();
        if (CollectionHelper.isEmpty(parameters) && (basicTypeByName = typeConfiguration.getBasicTypeRegistry().getRegisteredType(typeName)) != null) {
            return basicTypeByName;
        }
        TypeDefinition typeDefinition = this.metadataBuildingContext.getTypeDefinitionRegistry().resolve(typeName);
        if (typeDefinition != null) {
            BasicValue.Resolution<?> resolution = typeDefinition.resolve(parameters, null, this.metadataBuildingContext, typeConfiguration.getCurrentBaseSqlTypeIndicators());
            if (resolution.getCombinedTypeParameters() != null) {
                discriminatorMapping.setTypeParameters(resolution.getCombinedTypeParameters());
            }
            return resolution.getLegacyResolvedBasicType();
        }
        ClassLoaderService classLoaderService = bootstrapContext.getClassLoaderService();
        try {
            Object typeInstance = this.typeInstance(typeName, classLoaderService.classForName(typeName));
            if (typeInstance instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)typeInstance;
                if (parameters != null) {
                    Properties properties = new Properties();
                    properties.putAll(parameters);
                    parameterizedType.setParameterValues(properties);
                }
            }
            if (typeInstance instanceof UserType) {
                UserType userType = (UserType)typeInstance;
                return new CustomType(userType, typeConfiguration);
            }
            return (BasicType)typeInstance;
        }
        catch (ClassLoadingException e) {
            log.debugf("Unable to load explicit any-discriminator type name as Java Class - %s", (Object)typeName);
            throw new org.hibernate.MappingException(String.format(Locale.ROOT, "Unable to resolve explicit any-discriminator type name - %s", typeName));
        }
    }

    private Object typeInstance(String typeName, Class<?> typeJavaType) {
        if (!this.metadataBuildingContext.getBuildingOptions().isAllowExtensionsInCdi()) {
            return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(typeJavaType);
        }
        String beanName = typeName + ":" + TypeDefinition.NAME_COUNTER.getAndIncrement();
        return this.metadataBuildingContext.getBootstrapContext().getManagedBeanRegistry().getBean(beanName, typeJavaType).getBeanInstance();
    }

    private void prepareValueTypeViaReflection(MappingDocument sourceDocument, Value value, String containingClassName, String propertyName, AttributeRole attributeRole) {
        if (StringHelper.isEmpty(propertyName)) {
            throw new MappingException(String.format(Locale.ENGLISH, "Attribute mapping must define a name attribute: containingClassName=[%s], propertyName=[%s], role=[%s]", containingClassName, propertyName, attributeRole.getFullPath()), sourceDocument.getOrigin());
        }
        try {
            value.setTypeUsingReflection(containingClassName, propertyName);
        }
        catch (org.hibernate.MappingException ome) {
            throw new MappingException(String.format(Locale.ENGLISH, "Error calling Value#setTypeUsingReflection: containingClassName=[%s], propertyName=[%s], role=[%s]", containingClassName, propertyName, attributeRole.getFullPath()), ome, sourceDocument.getOrigin());
        }
    }

    private void bindProperty(MappingDocument mappingDocument, AttributeSource propertySource, Property property) {
        property.setName(propertySource.getName());
        property.setPropertyAccessorName(StringHelper.isNotEmpty(propertySource.getPropertyAccessorName()) ? propertySource.getPropertyAccessorName() : mappingDocument.getEffectiveDefaults().getDefaultAccessStrategyName());
        if (propertySource instanceof CascadeStyleSource) {
            CascadeStyleSource cascadeStyleSource = (CascadeStyleSource)((Object)propertySource);
            property.setCascade(StringHelper.isNotEmpty(cascadeStyleSource.getCascadeStyleName()) ? cascadeStyleSource.getCascadeStyleName() : this.toCascadeString(mappingDocument.getEffectiveDefaults().getDefaultCascadeTypes()));
        }
        property.setOptimisticLocked(propertySource.isIncludedInOptimisticLocking());
        if (propertySource.isSingular()) {
            SingularAttributeSource singularAttributeSource = (SingularAttributeSource)propertySource;
            property.setInsertable(singularAttributeSource.isInsertable());
            property.setUpdatable(singularAttributeSource.isUpdatable());
            property.setLazy(singularAttributeSource.isBytecodeLazy());
            ModelBinder.handleGenerationTiming(mappingDocument, propertySource, property, singularAttributeSource.getGenerationTiming());
        }
        property.setMetaAttributes(propertySource.getToolingHintContext().getMetaAttributeMap());
        if (log.isTraceEnabled()) {
            log.trace("Mapped property: " + propertySource.getName() + " -> [" + this.columns(property.getValue()) + "]");
        }
    }

    private String toCascadeString(EnumSet<CascadeType> defaultCascadeTypes) {
        if (CollectionHelper.isEmpty(defaultCascadeTypes)) {
            return "none";
        }
        boolean firstPass = true;
        StringBuilder buffer = new StringBuilder();
        for (CascadeType cascadeType : defaultCascadeTypes) {
            if (firstPass) {
                firstPass = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(cascadeType.name().toLowerCase(Locale.ROOT));
        }
        return buffer.toString();
    }

    private static void handleGenerationTiming(MappingDocument mappingDocument, AttributeSource propertySource, Property property, GenerationTiming timing) {
        if (timing != null) {
            SimpleValue simpleValue;
            Value value;
            if ((timing == GenerationTiming.INSERT || timing == GenerationTiming.UPDATE) && (value = property.getValue()) instanceof SimpleValue && (simpleValue = (SimpleValue)value).isVersion()) {
                throw new MappingException("'generated' attribute cannot be 'insert' or 'update' for version/timestamp property", mappingDocument.getOrigin());
            }
            if (timing != GenerationTiming.NEVER) {
                property.setValueGeneratorCreator(context -> new GeneratedGeneration(timing.getEventTypes()));
                if (property.isInsertable() && timing.includesInsert()) {
                    log.tracef("Property [%s] specified %s generation, setting insertable to false: %s", (Object)propertySource.getName(), (Object)timing.name(), (Object)mappingDocument.getOrigin());
                    property.setInsertable(false);
                }
                if (property.isUpdatable() && timing.includesUpdate()) {
                    log.tracef("Property [%s] specified ALWAYS generation, setting updateable to false: %s", (Object)propertySource.getName(), (Object)mappingDocument.getOrigin());
                    property.setUpdatable(false);
                }
            }
        }
    }

    private void bindComponent(MappingDocument sourceDocument, EmbeddableSource embeddableSource, Component component, String containingClassName, String propertyName, boolean isVirtual) {
        this.bindComponent(sourceDocument, embeddableSource.getAttributeRoleBase().getFullPath(), embeddableSource, component, this.extractExplicitComponentClassName(embeddableSource), containingClassName, propertyName, isVirtual, isVirtual, embeddableSource.isDynamic());
    }

    private String extractExplicitComponentClassName(EmbeddableSource embeddableSource) {
        JavaTypeDescriptor typeDescriptor = embeddableSource.getTypeDescriptor();
        return typeDescriptor == null ? null : typeDescriptor.getName();
    }

    private void bindComponent(MappingDocument sourceDocument, String role, EmbeddableSource embeddableSource, Component componentBinding, String explicitComponentClassName, String containingClassName, String propertyName, boolean isComponentEmbedded, boolean isVirtual, boolean isDynamic) {
        componentBinding.setMetaAttributes(embeddableSource.getToolingHintContext().getMetaAttributeMap());
        componentBinding.setRoleName(role);
        componentBinding.setEmbedded(isComponentEmbedded);
        if (isDynamic) {
            log.tracef("Binding dynamic component [%s]", (Object)role);
            componentBinding.setDynamic(true);
        } else if (isVirtual) {
            if (componentBinding.getOwner().hasPojoRepresentation()) {
                log.tracef("Binding virtual component [%s] to owner class [%s]", (Object)role, (Object)componentBinding.getOwner().getClassName());
                componentBinding.setComponentClassName(componentBinding.getOwner().getClassName());
            } else {
                log.tracef("Binding virtual component [%s] as dynamic", (Object)role);
                componentBinding.setDynamic(true);
            }
        } else {
            log.tracef("Binding component [%s]", (Object)role);
            if (StringHelper.isNotEmpty(explicitComponentClassName)) {
                try {
                    Class componentClass = sourceDocument.getBootstrapContext().getClassLoaderAccess().classForName(explicitComponentClassName);
                    if (CompositeUserType.class.isAssignableFrom(componentClass)) {
                        Class compositeTypeClass = componentClass;
                        componentBinding.setTypeName(explicitComponentClassName);
                        explicitComponentClassName = ModelBinder.compositeUserType(sourceDocument, compositeTypeClass).embeddable().getName();
                    }
                }
                catch (ClassLoadingException ex) {
                    log.debugf((Throwable)ex, "Could load component class [%s]", (Object)explicitComponentClassName);
                }
                log.tracef("Binding component [%s] to explicitly specified class", (Object)role, (Object)explicitComponentClassName);
                componentBinding.setComponentClassName(explicitComponentClassName);
            } else if (componentBinding.getOwner().hasPojoRepresentation()) {
                Class reflectedComponentClass;
                log.tracef("Attempting to determine component class by reflection %s", (Object)role);
                Class clazz = reflectedComponentClass = StringHelper.isNotEmpty(containingClassName) && StringHelper.isNotEmpty(propertyName) ? Helper.reflectedPropertyClass((MetadataBuildingContext)sourceDocument, containingClassName, propertyName) : null;
                if (reflectedComponentClass == null) {
                    log.debugf("Unable to determine component class name via reflection, and explicit class name not given; role=[%s]", (Object)role);
                } else {
                    componentBinding.setComponentClassName(reflectedComponentClass.getName());
                }
            } else {
                componentBinding.setDynamic(true);
            }
        }
        this.bindAllCompositeAttributes(sourceDocument, embeddableSource, componentBinding);
        String parentReferenceAttributeName = embeddableSource.getParentReferenceAttributeName();
        if (parentReferenceAttributeName != null) {
            componentBinding.setParentProperty(parentReferenceAttributeName);
        }
        if (embeddableSource.isUnique()) {
            ArrayList<Column> cols = new ArrayList<Column>();
            for (Selectable selectable : componentBinding.getSelectables()) {
                if (!(selectable instanceof Column)) continue;
                Column column = (Column)selectable;
                cols.add(column);
            }
            componentBinding.getOwner().getTable().createUniqueKey(cols, this.metadataBuildingContext);
        }
    }

    private static CompositeUserType<?> compositeUserType(MappingDocument sourceDocument, Class<? extends CompositeUserType<?>> componentClass) {
        return sourceDocument.getBuildingOptions().isAllowExtensionsInCdi() ? sourceDocument.getBootstrapContext().getManagedBeanRegistry().getBean(componentClass).getBeanInstance() : FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(componentClass);
    }

    private void bindAllCompositeAttributes(MappingDocument sourceDocument, EmbeddableSource embeddableSource, Component component) {
        for (AttributeSource attributeSource : embeddableSource.attributeSources()) {
            Property attribute;
            if (attributeSource instanceof SingularAttributeSourceBasic) {
                SingularAttributeSourceBasic singularAttributeSourceBasic = (SingularAttributeSourceBasic)attributeSource;
                attribute = this.createBasicAttribute(sourceDocument, singularAttributeSourceBasic, new BasicValue(sourceDocument, component.getTable()), component.getComponentClassName());
            } else if (attributeSource instanceof SingularAttributeSourceEmbedded) {
                SingularAttributeSourceEmbedded singularAttributeSourceEmbedded = (SingularAttributeSourceEmbedded)attributeSource;
                attribute = this.createEmbeddedAttribute(sourceDocument, singularAttributeSourceEmbedded, new Component((MetadataBuildingContext)sourceDocument, component), component.getComponentClassName());
            } else if (attributeSource instanceof SingularAttributeSourceManyToOne) {
                SingularAttributeSourceManyToOne singularAttributeSourceManyToOne = (SingularAttributeSourceManyToOne)attributeSource;
                attribute = this.createManyToOneAttribute(sourceDocument, singularAttributeSourceManyToOne, new ManyToOne(sourceDocument, component.getTable()), component.getComponentClassName());
            } else if (attributeSource instanceof SingularAttributeSourceOneToOne) {
                SingularAttributeSourceOneToOne singularAttributeSourceOneToOne = (SingularAttributeSourceOneToOne)attributeSource;
                attribute = this.createOneToOneAttribute(sourceDocument, singularAttributeSourceOneToOne, new OneToOne(sourceDocument, component.getTable(), component.getOwner()), component.getComponentClassName());
            } else if (attributeSource instanceof SingularAttributeSourceAny) {
                SingularAttributeSourceAny singularAttributeSourceAny = (SingularAttributeSourceAny)attributeSource;
                attribute = this.createAnyAssociationAttribute(sourceDocument, singularAttributeSourceAny, new Any(sourceDocument, component.getTable()), component.getComponentClassName());
            } else if (attributeSource instanceof PluralAttributeSource) {
                PluralAttributeSource pluralAttributeSource = (PluralAttributeSource)attributeSource;
                attribute = this.createPluralAttribute(sourceDocument, pluralAttributeSource, component.getOwner());
            } else {
                throw new AssertionFailure(String.format(Locale.ENGLISH, "Unexpected AttributeSource subtype [%s] as part of composite [%s]", attributeSource.getClass().getName(), attributeSource.getAttributeRole().getFullPath()));
            }
            attribute.setOptional(attribute.getValue().isNullable());
            component.addProperty(attribute);
        }
    }

    private static void bindSimpleValueType(MappingDocument mappingDocument, HibernateTypeSource typeSource, SimpleValue simpleValue) {
        TypeResolution typeResolution;
        if (mappingDocument.getBuildingOptions().useNationalizedCharacterData()) {
            simpleValue.makeNationalized();
        }
        if ((typeResolution = ModelBinder.resolveType(mappingDocument, typeSource)) != null) {
            if (CollectionHelper.isNotEmpty(typeResolution.parameters)) {
                simpleValue.setTypeParameters(typeResolution.parameters);
                if (simpleValue instanceof BasicValue) {
                    BasicValue basicValue = (BasicValue)simpleValue;
                    basicValue.setExplicitTypeParams(typeResolution.parameters);
                }
            }
            if (typeResolution.typeName != null) {
                simpleValue.setTypeName(typeResolution.typeName);
            }
        }
    }

    private static TypeResolution resolveType(MappingDocument sourceDocument, HibernateTypeSource typeSource) {
        String typeName;
        if (StringHelper.isEmpty(typeSource.getName())) {
            return null;
        }
        TypeDefinition typeDefinition = sourceDocument.getMetadataCollector().getTypeDefinition(typeSource.getName());
        HashMap<String, String> typeParameters = new HashMap<String, String>();
        if (typeDefinition == null) {
            typeName = typeSource.getName();
        } else {
            typeName = typeDefinition.getTypeImplementorClass().getName();
            if (typeDefinition.getParameters() != null) {
                typeParameters.putAll(typeDefinition.getParameters());
            }
        }
        Map<String, String> parameters = typeSource.getParameters();
        if (parameters != null) {
            typeParameters.putAll(parameters);
        }
        return new TypeResolution(typeName, typeParameters);
    }

    private Table bindEntityTableSpecification(final MappingDocument mappingDocument, TableSpecificationSource tableSpecSource, Table denormalizedSuperTable, final EntitySource entitySource, PersistentClass entityDescriptor) {
        Table table;
        Identifier logicalTableName;
        boolean isAbstract;
        Namespace namespace = this.database.locateNamespace(this.determineCatalogName(tableSpecSource), this.determineSchemaName(tableSpecSource));
        String contributorName = mappingDocument.getCurrentContributorName();
        boolean isTable = tableSpecSource instanceof TableSource;
        boolean bl = isAbstract = entityDescriptor.isAbstract() != null && entityDescriptor.isAbstract() != false;
        if (isTable) {
            TableSource tableSource = (TableSource)tableSpecSource;
            if (StringHelper.isNotEmpty(tableSource.getExplicitTableName())) {
                logicalTableName = this.database.toIdentifier(tableSource.getExplicitTableName());
            } else {
                ImplicitEntityNameSource implicitNamingSource = new ImplicitEntityNameSource(){

                    @Override
                    public EntityNaming getEntityNaming() {
                        return entitySource.getEntityNamingSource();
                    }

                    @Override
                    public MetadataBuildingContext getBuildingContext() {
                        return mappingDocument;
                    }
                };
                logicalTableName = mappingDocument.getBuildingOptions().getImplicitNamingStrategy().determinePrimaryTableName(implicitNamingSource);
            }
            table = denormalizedSuperTable == null ? namespace.createTable(logicalTableName, identifier -> new Table(contributorName, namespace, (Identifier)identifier, isAbstract)) : namespace.createDenormalizedTable(logicalTableName, physicalTableName -> new DenormalizedTable(contributorName, namespace, (Identifier)physicalTableName, isAbstract, denormalizedSuperTable));
        } else {
            InLineViewSource inLineViewSource = (InLineViewSource)tableSpecSource;
            String subselect = inLineViewSource.getSelectStatement();
            logicalTableName = this.database.toIdentifier(inLineViewSource.getLogicalName());
            table = denormalizedSuperTable == null ? new Table(contributorName, namespace, subselect, isAbstract) : new DenormalizedTable(contributorName, namespace, subselect, isAbstract, denormalizedSuperTable);
            table.setName(logicalTableName.render());
        }
        InFlightMetadataCollector metadataCollector = mappingDocument.getMetadataCollector();
        metadataCollector.addEntityTableXref(entitySource.getEntityNamingSource().getEntityName(), logicalTableName, table, ModelBinder.superEntityTableXref(mappingDocument, entitySource, entityDescriptor, metadataCollector));
        if (isTable) {
            TableSource tableSource = (TableSource)tableSpecSource;
            table.setRowId(tableSource.getRowId());
            if (StringHelper.isNotEmpty(tableSource.getCheckConstraint())) {
                table.addCheckConstraint(tableSource.getCheckConstraint());
            }
        }
        table.setComment(tableSpecSource.getComment());
        metadataCollector.addTableNameBinding(logicalTableName, table);
        return table;
    }

    private static InFlightMetadataCollector.EntityTableXref superEntityTableXref(MappingDocument mappingDocument, EntitySource entitySource, PersistentClass entityDescriptor, InFlightMetadataCollector metadataCollector) {
        if (entitySource.getSuperType() != null) {
            EntitySource supertype = (EntitySource)entitySource.getSuperType();
            String superEntityName = supertype.getEntityNamingSource().getEntityName();
            InFlightMetadataCollector.EntityTableXref superEntityTableXref = metadataCollector.getEntityTableXref(superEntityName);
            if (superEntityTableXref == null) {
                throw new MappingException(String.format(Locale.ENGLISH, "Unable to locate entity table xref for entity [%s] super-type [%s]", entityDescriptor.getEntityName(), superEntityName), mappingDocument.getOrigin());
            }
            return superEntityTableXref;
        }
        return null;
    }

    private Identifier determineCatalogName(TableSpecificationSource tableSpecSource) {
        return StringHelper.isNotEmpty(tableSpecSource.getExplicitCatalogName()) ? this.database.toIdentifier(tableSpecSource.getExplicitCatalogName()) : null;
    }

    private Identifier determineSchemaName(TableSpecificationSource tableSpecSource) {
        return StringHelper.isNotEmpty(tableSpecSource.getExplicitSchemaName()) ? this.database.toIdentifier(tableSpecSource.getExplicitSchemaName()) : null;
    }

    private static void bindCustomSql(EntitySource entitySource, PersistentClass entityDescriptor) {
        if (entitySource.getCustomSqlInsert() != null) {
            entityDescriptor.setCustomSQLInsert(entitySource.getCustomSqlInsert().sql(), entitySource.getCustomSqlInsert().callable(), entitySource.getCustomSqlInsert().checkStyle());
        }
        if (entitySource.getCustomSqlUpdate() != null) {
            entityDescriptor.setCustomSQLUpdate(entitySource.getCustomSqlUpdate().sql(), entitySource.getCustomSqlUpdate().callable(), entitySource.getCustomSqlUpdate().checkStyle());
        }
        if (entitySource.getCustomSqlDelete() != null) {
            entityDescriptor.setCustomSQLDelete(entitySource.getCustomSqlDelete().sql(), entitySource.getCustomSqlDelete().callable(), entitySource.getCustomSqlDelete().checkStyle());
        }
        entityDescriptor.setLoaderName(entitySource.getCustomLoaderName());
    }

    private static void bindCustomSql(SecondaryTableSource secondaryTableSource, Join secondaryTable) {
        if (secondaryTableSource.getCustomSqlInsert() != null) {
            secondaryTable.setCustomSQLInsert(secondaryTableSource.getCustomSqlInsert().sql(), secondaryTableSource.getCustomSqlInsert().callable(), secondaryTableSource.getCustomSqlInsert().checkStyle());
        }
        if (secondaryTableSource.getCustomSqlUpdate() != null) {
            secondaryTable.setCustomSQLUpdate(secondaryTableSource.getCustomSqlUpdate().sql(), secondaryTableSource.getCustomSqlUpdate().callable(), secondaryTableSource.getCustomSqlUpdate().checkStyle());
        }
        if (secondaryTableSource.getCustomSqlDelete() != null) {
            secondaryTable.setCustomSQLDelete(secondaryTableSource.getCustomSqlDelete().sql(), secondaryTableSource.getCustomSqlDelete().callable(), secondaryTableSource.getCustomSqlDelete().checkStyle());
        }
    }

    private void registerSecondPass(SecondPass secondPass, MetadataBuildingContext context) {
        context.getMetadataCollector().addSecondPass(secondPass);
    }

    private void createIndexBackRef(MappingDocument mappingDocument, IndexedPluralAttributeSource pluralAttributeSource, IndexedCollection collectionBinding) {
        if (collectionBinding.isOneToMany() && !collectionBinding.getKey().isNullable() && !collectionBinding.isInverse()) {
            OneToMany oneToMany = (OneToMany)collectionBinding.getElement();
            String entityName = oneToMany.getReferencedEntityName();
            PersistentClass referenced = mappingDocument.getMetadataCollector().getEntityBinding(entityName);
            IndexBackref backref = new IndexBackref();
            backref.setName("_" + collectionBinding.getOwnerEntityName() + "." + pluralAttributeSource.getName() + "IndexBackref");
            backref.setOptional(true);
            backref.setUpdatable(false);
            backref.setSelectable(false);
            backref.setCollectionRole(collectionBinding.getRole());
            backref.setEntityName(collectionBinding.getOwner().getEntityName());
            backref.setValue(collectionBinding.getIndex());
            referenced.addProperty(backref);
        }
    }

    public void bindListOrArrayIndex(MappingDocument mappingDocument, final IndexedPluralAttributeSource attributeSource, List collectionBinding) {
        PluralAttributeSequentialIndexSource indexSource = (PluralAttributeSequentialIndexSource)attributeSource.getIndexSource();
        BasicValue indexBinding = new BasicValue(mappingDocument, collectionBinding.getCollectionTable());
        ModelBinder.bindSimpleValueType(mappingDocument, indexSource.getTypeInformation(), indexBinding);
        this.relationalObjectBinder.bindColumnsAndFormulas(mappingDocument, indexSource.getRelationalValueSources(), indexBinding, attributeSource.getElementSource() instanceof PluralAttributeElementSourceOneToMany, context -> context.getBuildingOptions().getImplicitNamingStrategy().determineListIndexColumnName(new ImplicitIndexColumnNameSource(){

            @Override
            public AttributePath getPluralAttributePath() {
                return attributeSource.getAttributePath();
            }

            @Override
            public MetadataBuildingContext getBuildingContext() {
                return context;
            }
        }));
        collectionBinding.setIndex(indexBinding);
        collectionBinding.setBaseIndex(indexSource.getBase());
    }

    private void bindMapKey(MappingDocument mappingDocument, final IndexedPluralAttributeSource pluralAttributeSource, org.hibernate.mapping.Map collectionBinding) {
        PluralAttributeIndexSource indexSource = pluralAttributeSource.getIndexSource();
        if (indexSource instanceof PluralAttributeMapKeySourceBasic) {
            PluralAttributeMapKeySourceBasic mapKeySource = (PluralAttributeMapKeySourceBasic)indexSource;
            BasicValue value = new BasicValue(mappingDocument, collectionBinding.getCollectionTable());
            ModelBinder.bindSimpleValueType(mappingDocument, mapKeySource.getTypeInformation(), value);
            if (!value.isTypeSpecified()) {
                throw new MappingException("map index element must specify a type: " + pluralAttributeSource.getAttributeRole().getFullPath(), mappingDocument.getOrigin());
            }
            this.relationalObjectBinder.bindColumnsAndFormulas(mappingDocument, mapKeySource.getRelationalValueSources(), value, true, context -> this.database.toIdentifier("idx"));
            collectionBinding.setIndex(value);
        } else if (indexSource instanceof PluralAttributeMapKeySourceEmbedded) {
            PluralAttributeMapKeySourceEmbedded mapKeySource = (PluralAttributeMapKeySourceEmbedded)indexSource;
            Component componentBinding = new Component((MetadataBuildingContext)mappingDocument, collectionBinding);
            this.bindComponent(mappingDocument, mapKeySource.getEmbeddableSource(), componentBinding, null, pluralAttributeSource.getName(), false);
            collectionBinding.setIndex(componentBinding);
        } else if (indexSource instanceof PluralAttributeMapKeyManyToManySource) {
            PluralAttributeMapKeyManyToManySource mapKeySource = (PluralAttributeMapKeyManyToManySource)indexSource;
            ManyToOne mapKeyBinding = new ManyToOne(mappingDocument, collectionBinding.getCollectionTable());
            mapKeyBinding.setReferencedEntityName(mapKeySource.getReferencedEntityName());
            this.relationalObjectBinder.bindColumnsAndFormulas(mappingDocument, mapKeySource.getRelationalValueSources(), mapKeyBinding, true, context -> this.implicitNamingStrategy.determineMapKeyColumnName(new ImplicitMapKeyColumnNameSource(){

                @Override
                public AttributePath getPluralAttributePath() {
                    return pluralAttributeSource.getAttributePath();
                }

                @Override
                public MetadataBuildingContext getBuildingContext() {
                    return context;
                }
            }));
            collectionBinding.setIndex(mapKeyBinding);
        } else if (indexSource instanceof PluralAttributeMapKeyManyToAnySource) {
            PluralAttributeMapKeyManyToAnySource mapKeySource = (PluralAttributeMapKeyManyToAnySource)indexSource;
            Any mapKeyBinding = new Any(mappingDocument, collectionBinding.getCollectionTable());
            this.bindAny(mappingDocument, mapKeySource, mapKeyBinding, pluralAttributeSource.getAttributeRole().append("key"));
            collectionBinding.setIndex(mapKeyBinding);
        }
    }

    private String columns(Value value) {
        StringBuilder builder = new StringBuilder();
        for (Selectable selectable : value.getSelectables()) {
            if (!builder.isEmpty()) {
                builder.append(", ");
            }
            builder.append(selectable.getText());
        }
        return builder.toString();
    }

    private static OnDeleteAction getOnDeleteAction(boolean entitySource) {
        return entitySource ? OnDeleteAction.CASCADE : OnDeleteAction.NO_ACTION;
    }

    private static class NaturalIdUniqueKeyBinderImpl
    implements NaturalIdUniqueKeyBinder {
        private final MappingDocument mappingDocument;
        private final PersistentClass entityBinding;
        private final java.util.List<Property> attributeBindings = new ArrayList<Property>();

        public NaturalIdUniqueKeyBinderImpl(MappingDocument mappingDocument, PersistentClass entityBinding) {
            this.mappingDocument = mappingDocument;
            this.entityBinding = entityBinding;
        }

        @Override
        public void addAttributeBinding(Property attributeBinding) {
            this.attributeBindings.add(attributeBinding);
        }

        @Override
        public void process() {
            log.tracef("Binding natural-id UniqueKey for entity: %s", (Object)this.entityBinding.getEntityName());
            final ArrayList<Identifier> columnNames = new ArrayList<Identifier>();
            final UniqueKey uniqueKey = new UniqueKey(this.entityBinding.getTable());
            for (Property attributeBinding : this.attributeBindings) {
                for (Selectable selectable : attributeBinding.getSelectables()) {
                    if (!(selectable instanceof Column)) continue;
                    Column column = (Column)selectable;
                    uniqueKey.addColumn(column);
                    columnNames.add(column.getNameIdentifier(this.mappingDocument));
                }
                uniqueKey.addColumns(attributeBinding.getValue());
            }
            Identifier uniqueKeyName = this.mappingDocument.getBuildingOptions().getImplicitNamingStrategy().determineUniqueKeyName(new ImplicitUniqueKeyNameSource(){

                @Override
                public Identifier getTableName() {
                    return entityBinding.getTable().getNameIdentifier();
                }

                @Override
                public java.util.List<Identifier> getColumnNames() {
                    return columnNames;
                }

                @Override
                public MetadataBuildingContext getBuildingContext() {
                    return mappingDocument;
                }

                @Override
                public Identifier getUserProvidedIdentifier() {
                    String name = uniqueKey.getName();
                    return name == null ? null : Identifier.toIdentifier(name);
                }
            });
            uniqueKey.setName(uniqueKeyName.render(this.mappingDocument.getMetadataCollector().getDatabase().getDialect()));
            this.entityBinding.getTable().addUniqueKey(uniqueKey);
        }
    }

    private class PluralAttributeListSecondPass
    extends AbstractPluralAttributeSecondPass {
        public PluralAttributeListSecondPass(MappingDocument sourceDocument, IndexedPluralAttributeSource attributeSource, List collectionBinding) {
            super(sourceDocument, attributeSource, collectionBinding);
        }

        @Override
        public IndexedPluralAttributeSource getPluralAttributeSource() {
            return (IndexedPluralAttributeSource)super.getPluralAttributeSource();
        }

        @Override
        public List getCollectionBinding() {
            return (List)super.getCollectionBinding();
        }

        @Override
        protected void bindCollectionIndex() {
            ModelBinder.this.bindListOrArrayIndex(this.getMappingDocument(), this.getPluralAttributeSource(), this.getCollectionBinding());
        }

        @Override
        protected void createBackReferences() {
            super.createBackReferences();
            ModelBinder.this.createIndexBackRef(this.getMappingDocument(), this.getPluralAttributeSource(), this.getCollectionBinding());
        }
    }

    private class PluralAttributeSetSecondPass
    extends AbstractPluralAttributeSecondPass {
        public PluralAttributeSetSecondPass(MappingDocument sourceDocument, PluralAttributeSource attributeSource, Collection collectionBinding) {
            super(sourceDocument, attributeSource, collectionBinding);
        }
    }

    private class PluralAttributeMapSecondPass
    extends AbstractPluralAttributeSecondPass {
        public PluralAttributeMapSecondPass(MappingDocument sourceDocument, IndexedPluralAttributeSource attributeSource, org.hibernate.mapping.Map collectionBinding) {
            super(sourceDocument, attributeSource, collectionBinding);
        }

        @Override
        public IndexedPluralAttributeSource getPluralAttributeSource() {
            return (IndexedPluralAttributeSource)super.getPluralAttributeSource();
        }

        @Override
        public org.hibernate.mapping.Map getCollectionBinding() {
            return (org.hibernate.mapping.Map)super.getCollectionBinding();
        }

        @Override
        protected void bindCollectionIndex() {
            ModelBinder.this.bindMapKey(this.getMappingDocument(), this.getPluralAttributeSource(), this.getCollectionBinding());
        }

        @Override
        protected void createBackReferences() {
            super.createBackReferences();
            org.hibernate.mapping.Map collectionBinding = this.getCollectionBinding();
            boolean indexIsFormula = false;
            for (Selectable selectable : collectionBinding.getIndex().getSelectables()) {
                if (!selectable.isFormula()) continue;
                indexIsFormula = true;
                break;
            }
            if (collectionBinding.isOneToMany() && !collectionBinding.getKey().isNullable() && !collectionBinding.isInverse() && !indexIsFormula) {
                OneToMany oneToMany = (OneToMany)collectionBinding.getElement();
                String entityName = oneToMany.getReferencedEntityName();
                PersistentClass referenced = this.getMappingDocument().getMetadataCollector().getEntityBinding(entityName);
                IndexBackref backref = new IndexBackref();
                backref.setName("_" + collectionBinding.getOwnerEntityName() + "." + this.getPluralAttributeSource().getName() + "IndexBackref");
                backref.setOptional(true);
                backref.setUpdatable(false);
                backref.setSelectable(false);
                backref.setCollectionRole(collectionBinding.getRole());
                backref.setEntityName(collectionBinding.getOwner().getEntityName());
                backref.setValue(collectionBinding.getIndex());
                referenced.addProperty(backref);
            }
        }
    }

    private class PluralAttributeBagSecondPass
    extends AbstractPluralAttributeSecondPass {
        public PluralAttributeBagSecondPass(MappingDocument sourceDocument, PluralAttributeSource attributeSource, Collection collectionBinding) {
            super(sourceDocument, attributeSource, collectionBinding);
        }
    }

    private class PluralAttributeIdBagSecondPass
    extends AbstractPluralAttributeSecondPass {
        public PluralAttributeIdBagSecondPass(MappingDocument sourceDocument, PluralAttributeSource attributeSource, Collection collectionBinding) {
            super(sourceDocument, attributeSource, collectionBinding);
        }
    }

    private class PluralAttributeArraySecondPass
    extends AbstractPluralAttributeSecondPass {
        public PluralAttributeArraySecondPass(MappingDocument sourceDocument, IndexedPluralAttributeSource attributeSource, Array collectionBinding) {
            super(sourceDocument, attributeSource, collectionBinding);
        }

        @Override
        public IndexedPluralAttributeSource getPluralAttributeSource() {
            return (IndexedPluralAttributeSource)super.getPluralAttributeSource();
        }

        @Override
        public Array getCollectionBinding() {
            return (Array)super.getCollectionBinding();
        }

        @Override
        protected void bindCollectionIndex() {
            ModelBinder.this.bindListOrArrayIndex(this.getMappingDocument(), this.getPluralAttributeSource(), this.getCollectionBinding());
        }

        @Override
        protected void createBackReferences() {
            super.createBackReferences();
            ModelBinder.this.createIndexBackRef(this.getMappingDocument(), this.getPluralAttributeSource(), this.getCollectionBinding());
        }
    }

    private class PluralAttributePrimitiveArraySecondPass
    extends AbstractPluralAttributeSecondPass {
        public PluralAttributePrimitiveArraySecondPass(MappingDocument sourceDocument, IndexedPluralAttributeSource attributeSource, PrimitiveArray collectionBinding) {
            super(sourceDocument, attributeSource, collectionBinding);
        }

        @Override
        public IndexedPluralAttributeSource getPluralAttributeSource() {
            return (IndexedPluralAttributeSource)super.getPluralAttributeSource();
        }

        @Override
        public PrimitiveArray getCollectionBinding() {
            return (PrimitiveArray)super.getCollectionBinding();
        }

        @Override
        protected void bindCollectionIndex() {
            ModelBinder.this.bindListOrArrayIndex(this.getMappingDocument(), this.getPluralAttributeSource(), this.getCollectionBinding());
        }

        @Override
        protected void createBackReferences() {
            super.createBackReferences();
            ModelBinder.this.createIndexBackRef(this.getMappingDocument(), this.getPluralAttributeSource(), this.getCollectionBinding());
        }
    }

    private static class OneToOneFkSecondPass
    implements FkSecondPass {
        private final OneToOne oneToOneBinding;

        private OneToOneFkSecondPass(OneToOne oneToOneBinding) {
            this.oneToOneBinding = oneToOneBinding;
        }

        @Override
        public Value getValue() {
            return this.oneToOneBinding;
        }

        @Override
        public String getReferencedEntityName() {
            return this.oneToOneBinding.getReferencedEntityName();
        }

        @Override
        public boolean isInPrimaryKey() {
            return false;
        }

        @Override
        public void doSecondPass(Map<String, PersistentClass> persistentClasses) {
            this.oneToOneBinding.createForeignKey();
        }
    }

    public static final class DelayedPropertyReferenceHandlerImpl
    implements InFlightMetadataCollector.DelayedPropertyReferenceHandler {
        public final String referencedEntityName;
        public final String referencedPropertyName;
        public final boolean isUnique;
        private final String sourceElementSynopsis;
        public final Origin propertyRefOrigin;

        public DelayedPropertyReferenceHandlerImpl(String referencedEntityName, String referencedPropertyName, boolean isUnique, String sourceElementSynopsis, Origin propertyRefOrigin) {
            this.referencedEntityName = referencedEntityName;
            this.referencedPropertyName = referencedPropertyName;
            this.isUnique = isUnique;
            this.sourceElementSynopsis = sourceElementSynopsis;
            this.propertyRefOrigin = propertyRefOrigin;
        }

        @Override
        public void process(InFlightMetadataCollector metadataCollector) {
            log.tracef("Performing delayed property-ref handling [%s, %s, %s]", (Object)this.referencedEntityName, (Object)this.referencedPropertyName, (Object)this.sourceElementSynopsis);
            PersistentClass entityBinding = metadataCollector.getEntityBinding(this.referencedEntityName);
            if (entityBinding == null) {
                throw new MappingException(String.format(Locale.ENGLISH, "property-ref [%s] referenced an unmapped entity [%s]", this.sourceElementSynopsis, this.referencedEntityName), this.propertyRefOrigin);
            }
            Property propertyBinding = entityBinding.getReferencedProperty(this.referencedPropertyName);
            if (propertyBinding == null) {
                throw new MappingException(String.format(Locale.ENGLISH, "property-ref [%s] referenced an unknown entity property [%s#%s]", this.sourceElementSynopsis, this.referencedEntityName, this.referencedPropertyName), this.propertyRefOrigin);
            }
            if (this.isUnique) {
                ((SimpleValue)propertyBinding.getValue()).setAlternateUniqueKey(true);
            }
        }
    }

    private class ManyToOneColumnBinder
    implements ImplicitColumnNamingSecondPass {
        private final MappingDocument mappingDocument;
        private final SingularAttributeSourceManyToOne manyToOneSource;
        private final ManyToOne manyToOneBinding;
        private final String referencedEntityName;
        private final boolean allColumnsNamed;

        public ManyToOneColumnBinder(MappingDocument mappingDocument, SingularAttributeSourceManyToOne manyToOneSource, ManyToOne manyToOneBinding, String referencedEntityName) {
            this.mappingDocument = mappingDocument;
            this.manyToOneSource = manyToOneSource;
            this.manyToOneBinding = manyToOneBinding;
            this.referencedEntityName = referencedEntityName;
            boolean allNamed = true;
            for (RelationalValueSource relationalValueSource : manyToOneSource.getRelationalValueSources()) {
                ColumnSource columnSource;
                if (!(relationalValueSource instanceof ColumnSource) || (columnSource = (ColumnSource)relationalValueSource).getName() != null) continue;
                allNamed = false;
                break;
            }
            this.allColumnsNamed = allNamed;
        }

        public boolean canProcessImmediately() {
            if (this.allColumnsNamed) {
                return true;
            }
            PersistentClass referencedEntityBinding = this.mappingDocument.getMetadataCollector().getEntityBinding(this.referencedEntityName);
            if (referencedEntityBinding == null) {
                return false;
            }
            return this.manyToOneSource.getReferencedEntityAttributeName() == null;
        }

        @Override
        public void doSecondPass(Map<String, PersistentClass> persistentClasses) {
            if (this.allColumnsNamed) {
                ModelBinder.this.relationalObjectBinder.bindColumnsAndFormulas(this.mappingDocument, this.manyToOneSource.getRelationalValueSources(), this.manyToOneBinding, this.manyToOneSource.areValuesNullableByDefault(), context -> {
                    throw new AssertionFailure("Should not be called");
                });
            } else {
                PersistentClass referencedEntityBinding = this.mappingDocument.getMetadataCollector().getEntityBinding(this.referencedEntityName);
                if (referencedEntityBinding == null) {
                    throw new AssertionFailure("Unable to locate referenced entity mapping [" + this.referencedEntityName + "] in order to process many-to-one FK : " + this.manyToOneSource.getAttributeRole().getFullPath());
                }
                ModelBinder.this.relationalObjectBinder.bindColumnsAndFormulas(this.mappingDocument, this.manyToOneSource.getRelationalValueSources(), this.manyToOneBinding, this.manyToOneSource.areValuesNullableByDefault(), context -> ModelBinder.this.implicitNamingStrategy.determineBasicColumnName(new ImplicitBasicColumnNameSource(){

                    @Override
                    public AttributePath getAttributePath() {
                        return ManyToOneColumnBinder.this.manyToOneSource.getAttributePath();
                    }

                    @Override
                    public boolean isCollectionElement() {
                        return false;
                    }

                    @Override
                    public MetadataBuildingContext getBuildingContext() {
                        return context;
                    }
                }));
            }
        }
    }

    private static class ManyToOneFkSecondPass
    implements FkSecondPass {
        private final MappingDocument mappingDocument;
        private final ManyToOne manyToOneBinding;
        private final String referencedEntityName;
        private final String referencedEntityAttributeName;

        private ManyToOneFkSecondPass(MappingDocument mappingDocument, SingularAttributeSourceManyToOne manyToOneSource, ManyToOne manyToOneBinding, String referencedEntityName) {
            if (referencedEntityName == null) {
                throw new MappingException("entity name referenced by many-to-one required [" + manyToOneSource.getAttributeRole().getFullPath() + "]", mappingDocument.getOrigin());
            }
            this.mappingDocument = mappingDocument;
            this.manyToOneBinding = manyToOneBinding;
            this.referencedEntityName = referencedEntityName;
            this.referencedEntityAttributeName = manyToOneSource.getReferencedEntityAttributeName();
        }

        @Override
        public Value getValue() {
            return this.manyToOneBinding;
        }

        @Override
        public String getReferencedEntityName() {
            return this.referencedEntityName;
        }

        @Override
        public boolean isInPrimaryKey() {
            return false;
        }

        @Override
        public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws org.hibernate.MappingException {
            if (this.referencedEntityAttributeName == null) {
                this.manyToOneBinding.createForeignKey();
            } else {
                this.manyToOneBinding.createPropertyRefConstraints(this.mappingDocument.getMetadataCollector().getEntityBindingMap());
            }
        }

        public boolean canProcessImmediately() {
            PersistentClass referencedEntityBinding = this.mappingDocument.getMetadataCollector().getEntityBinding(this.referencedEntityName);
            return referencedEntityBinding != null && this.referencedEntityAttributeName != null;
        }
    }

    private static class TypeResolution {
        private final String typeName;
        private final Map<String, String> parameters;

        public TypeResolution(String typeName, Map<String, String> parameters) {
            this.typeName = typeName;
            this.parameters = parameters;
        }
    }

    private abstract class AbstractPluralAttributeSecondPass
    implements SecondPass {
        private final MappingDocument mappingDocument;
        private final PluralAttributeSource pluralAttributeSource;
        private final Collection collectionBinding;

        protected AbstractPluralAttributeSecondPass(MappingDocument mappingDocument, PluralAttributeSource pluralAttributeSource, Collection collectionBinding) {
            this.mappingDocument = mappingDocument;
            this.pluralAttributeSource = pluralAttributeSource;
            this.collectionBinding = collectionBinding;
        }

        public MappingDocument getMappingDocument() {
            return this.mappingDocument;
        }

        public PluralAttributeSource getPluralAttributeSource() {
            return this.pluralAttributeSource;
        }

        public Collection getCollectionBinding() {
            return this.collectionBinding;
        }

        @Override
        public void doSecondPass(Map<String, PersistentClass> persistentClasses) {
            this.bindCollectionTable();
            this.bindCollectionKey();
            this.bindCollectionIdentifier();
            this.bindCollectionIndex();
            this.bindCollectionElement();
            this.createBackReferences();
            this.collectionBinding.createAllKeys();
            if (log.isTraceEnabled()) {
                Collection collectionBinding = this.getCollectionBinding();
                log.tracef("Mapped collection: %s", (Object)this.getPluralAttributeSource().getAttributeRole().getFullPath());
                log.tracef("   + table -> %s", (Object)collectionBinding.getTable().getName());
                log.tracef("   + key -> %s", (Object)ModelBinder.this.columns(collectionBinding.getKey()));
                if (collectionBinding.isIndexed()) {
                    log.tracef("   + index -> %s", (Object)ModelBinder.this.columns(((IndexedCollection)collectionBinding).getIndex()));
                }
                if (collectionBinding.isOneToMany()) {
                    log.tracef("   + one-to-many -> %s", (Object)((OneToMany)collectionBinding.getElement()).getReferencedEntityName());
                } else {
                    log.tracef("   + element -> %s", (Object)ModelBinder.this.columns(collectionBinding.getElement()));
                }
            }
        }

        private void bindCollectionTable() {
            PluralAttributeElementSource pluralAttributeElementSource = this.pluralAttributeSource.getElementSource();
            if (pluralAttributeElementSource instanceof PluralAttributeElementSourceOneToMany) {
                PluralAttributeElementSourceOneToMany elementSource = (PluralAttributeElementSourceOneToMany)pluralAttributeElementSource;
                PersistentClass persistentClass = this.getReferencedEntityBinding(elementSource.getReferencedEntityName());
                this.collectionBinding.setCollectionTable(persistentClass.getTable());
            } else {
                Table collectionTable;
                TableSpecificationSource tableSpecSource = this.pluralAttributeSource.getCollectionTableSpecificationSource();
                Identifier logicalCatalogName = ModelBinder.this.determineCatalogName(tableSpecSource);
                Identifier logicalSchemaName = ModelBinder.this.determineSchemaName(tableSpecSource);
                Namespace namespace = ModelBinder.this.database.locateNamespace(logicalCatalogName, logicalSchemaName);
                if (tableSpecSource instanceof TableSource) {
                    TableSource tableSource = (TableSource)tableSpecSource;
                    collectionTable = namespace.createTable(this.logicalName(tableSource), identifier -> new Table(ModelBinder.this.metadataBuildingContext.getCurrentContributorName(), namespace, (Identifier)identifier, false));
                } else {
                    collectionTable = new Table(ModelBinder.this.metadataBuildingContext.getCurrentContributorName(), namespace, ((InLineViewSource)tableSpecSource).getSelectStatement(), false);
                }
                this.collectionBinding.setCollectionTable(collectionTable);
            }
            Table collectionTable = this.collectionBinding.getCollectionTable();
            if (log.isTraceEnabled()) {
                log.tracef("Mapping collection: %s -> %s", (Object)this.collectionBinding.getRole(), (Object)collectionTable.getName());
            }
            if (this.pluralAttributeSource.getCollectionTableComment() != null) {
                collectionTable.setComment(this.pluralAttributeSource.getCollectionTableComment());
            }
            if (this.pluralAttributeSource.getCollectionTableCheck() != null) {
                collectionTable.addCheckConstraint(this.pluralAttributeSource.getCollectionTableCheck());
            }
        }

        private Identifier logicalName(TableSource tableSource) {
            if (StringHelper.isNotEmpty(tableSource.getExplicitTableName())) {
                return Identifier.toIdentifier(tableSource.getExplicitTableName(), this.mappingDocument.getEffectiveDefaults().isDefaultQuoteIdentifiers());
            }
            final PersistentClass owner = this.collectionBinding.getOwner();
            final EntityNamingSourceImpl ownerEntityNaming = new EntityNamingSourceImpl(owner.getEntityName(), owner.getClassName(), owner.getJpaEntityName());
            ImplicitCollectionTableNameSource implicitNamingSource = new ImplicitCollectionTableNameSource(){

                @Override
                public Identifier getOwningPhysicalTableName() {
                    return owner.getTable().getNameIdentifier();
                }

                @Override
                public EntityNaming getOwningEntityNaming() {
                    return ownerEntityNaming;
                }

                @Override
                public AttributePath getOwningAttributePath() {
                    return AbstractPluralAttributeSecondPass.this.pluralAttributeSource.getAttributePath();
                }

                @Override
                public MetadataBuildingContext getBuildingContext() {
                    return AbstractPluralAttributeSecondPass.this.mappingDocument;
                }
            };
            return this.mappingDocument.getBuildingOptions().getImplicitNamingStrategy().determineCollectionTableName(implicitNamingSource);
        }

        protected void createBackReferences() {
            if (this.collectionBinding.isOneToMany() && !this.collectionBinding.isInverse() && !this.collectionBinding.getKey().isNullable()) {
                OneToMany oneToMany = (OneToMany)this.collectionBinding.getElement();
                String entityName = oneToMany.getReferencedEntityName();
                PersistentClass referenced = this.getReferencedEntityBinding(entityName);
                Backref backref = new Backref();
                backref.setName("_" + this.collectionBinding.getOwnerEntityName() + "." + this.pluralAttributeSource.getName() + "Backref");
                backref.setOptional(true);
                backref.setUpdatable(false);
                backref.setSelectable(false);
                backref.setCollectionRole(this.collectionBinding.getRole());
                backref.setEntityName(this.collectionBinding.getOwner().getEntityName());
                backref.setValue(this.collectionBinding.getKey());
                referenced.addProperty(backref);
                if (log.isTraceEnabled()) {
                    log.tracef("Added virtual backref property [%s] : %s", (Object)backref.getName(), (Object)this.pluralAttributeSource.getAttributeRole().getFullPath());
                }
            }
        }

        protected void bindCollectionKey() {
            PluralAttributeSource pluralAttributeSource = this.getPluralAttributeSource();
            PluralAttributeKeySource keySource = pluralAttributeSource.getKeySource();
            String referencedPropertyName = keySource.getReferencedPropertyName();
            Collection collectionBinding = this.getCollectionBinding();
            collectionBinding.setReferencedPropertyName(referencedPropertyName);
            PersistentClass owner = collectionBinding.getOwner();
            KeyValue keyVal = referencedPropertyName == null ? owner.getIdentifier() : (KeyValue)owner.getRecursiveProperty(referencedPropertyName).getValue();
            DependantValue key = new DependantValue(this.mappingDocument, collectionBinding.getCollectionTable(), keyVal);
            ModelBinder.setForeignKeyName(key, keySource.getExplicitForeignKeyName());
            key.setOnDeleteAction(ModelBinder.getOnDeleteAction(pluralAttributeSource.getKeySource().isCascadeDeleteEnabled()));
            ModelBinder.this.relationalObjectBinder.bindColumnsAndFormulas(this.mappingDocument, keySource.getRelationalValueSources(), key, keySource.areValuesNullableByDefault(), context -> context.getMetadataCollector().getDatabase().toIdentifier("id"));
            key.sortProperties();
            key.createForeignKey();
            collectionBinding.setKey(key);
            key.setNullable(keySource.areValuesNullableByDefault());
            key.setUpdateable(keySource.areValuesIncludedInUpdateByDefault());
        }

        protected void bindCollectionIdentifier() {
            CollectionIdSource idSource = this.getPluralAttributeSource().getCollectionIdSource();
            if (idSource != null) {
                IdentifierCollection idBagBinding = (IdentifierCollection)this.getCollectionBinding();
                BasicValue idBinding = new BasicValue(this.mappingDocument, idBagBinding.getCollectionTable());
                ModelBinder.bindSimpleValueType(this.mappingDocument, idSource.getTypeInformation(), idBinding);
                ModelBinder.this.relationalObjectBinder.bindColumn(this.mappingDocument, idSource.getColumnSource(), idBinding, false, context -> ModelBinder.this.database.toIdentifier("id"));
                idBagBinding.setIdentifier(idBinding);
                GeneratorBinder.makeIdGenerator(this.mappingDocument, new IdentifierGeneratorDefinition(idSource.getGeneratorName(), idSource.getParameters()), idBinding, ModelBinder.this.metadataBuildingContext);
            }
        }

        protected void bindCollectionIndex() {
        }

        protected void bindCollectionElement() {
            PluralAttributeElementSource pluralElementSource = this.getPluralAttributeSource().getElementSource();
            if (log.isTraceEnabled()) {
                log.tracef("Binding [%s] element type for a [%s]", (Object)pluralElementSource.getNature(), (Object)this.getPluralAttributeSource().getNature());
            }
            Collection collectionBinding = this.getCollectionBinding();
            MappingDocument mappingDocument = this.getMappingDocument();
            if (pluralElementSource instanceof PluralAttributeElementSourceBasic) {
                PluralAttributeElementSourceBasic elementSource = (PluralAttributeElementSourceBasic)pluralElementSource;
                BasicValue elementBinding = new BasicValue(mappingDocument, collectionBinding.getCollectionTable());
                ModelBinder.bindSimpleValueType(mappingDocument, elementSource.getExplicitHibernateTypeSource(), elementBinding);
                ModelBinder.this.relationalObjectBinder.bindColumnsAndFormulas(this.mappingDocument, elementSource.getRelationalValueSources(), elementBinding, elementSource.areValuesNullableByDefault(), context -> context.getMetadataCollector().getDatabase().toIdentifier("elt"));
                collectionBinding.setElement(elementBinding);
                collectionBinding.setWhere(this.getPluralAttributeSource().getWhere());
            } else if (pluralElementSource instanceof PluralAttributeElementSourceEmbedded) {
                PluralAttributeElementSourceEmbedded elementSource = (PluralAttributeElementSourceEmbedded)pluralElementSource;
                Component elementBinding = new Component((MetadataBuildingContext)mappingDocument, collectionBinding);
                EmbeddableSource embeddableSource = elementSource.getEmbeddableSource();
                ModelBinder.this.bindComponent(this.mappingDocument, embeddableSource, elementBinding, null, embeddableSource.getAttributePathBase().getProperty(), false);
                collectionBinding.setElement(elementBinding);
                collectionBinding.setWhere(this.getPluralAttributeSource().getWhere());
            } else if (pluralElementSource instanceof PluralAttributeElementSourceOneToMany) {
                PluralAttributeElementSourceOneToMany elementSource = (PluralAttributeElementSourceOneToMany)pluralElementSource;
                OneToMany elementBinding = new OneToMany(mappingDocument, collectionBinding.getOwner());
                this.collectionBinding.setElement(elementBinding);
                PersistentClass referencedEntityBinding = this.getReferencedEntityBinding(elementSource.getReferencedEntityName());
                this.collectionBinding.setWhere(StringHelper.getNonEmptyOrConjunctionIfBothNonEmpty(referencedEntityBinding.getWhere(), this.getPluralAttributeSource().getWhere()));
                elementBinding.setReferencedEntityName(referencedEntityBinding.getEntityName());
                elementBinding.setAssociatedClass(referencedEntityBinding);
                elementBinding.setIgnoreNotFound(elementSource.isIgnoreNotFound());
            } else if (pluralElementSource instanceof PluralAttributeElementSourceManyToMany) {
                PluralAttributeElementSourceManyToMany elementSource = (PluralAttributeElementSourceManyToMany)pluralElementSource;
                ManyToOne elementBinding = new ManyToOne(mappingDocument, collectionBinding.getCollectionTable());
                ModelBinder.this.relationalObjectBinder.bindColumnsAndFormulas(mappingDocument, elementSource.getRelationalValueSources(), elementBinding, false, context -> context.getMetadataCollector().getDatabase().toIdentifier("elt"));
                FetchCharacteristics fetchCharacteristics = elementSource.getFetchCharacteristics();
                elementBinding.setLazy(fetchCharacteristics.getFetchTiming() != FetchTiming.IMMEDIATE);
                elementBinding.setFetchMode(fetchCharacteristics.getFetchStyle() == FetchStyle.SELECT ? FetchMode.SELECT : FetchMode.JOIN);
                ModelBinder.setForeignKeyName(elementBinding, elementSource.getExplicitForeignKeyName());
                String referencedEntityName = elementSource.getReferencedEntityName();
                elementBinding.setReferencedEntityName(referencedEntityName);
                String referencedEntityAttributeName = elementSource.getReferencedEntityAttributeName();
                if (StringHelper.isNotEmpty(referencedEntityAttributeName)) {
                    elementBinding.setReferencedPropertyName(referencedEntityAttributeName);
                    elementBinding.setReferenceToPrimaryKey(false);
                } else {
                    elementBinding.setReferenceToPrimaryKey(true);
                }
                collectionBinding.setElement(elementBinding);
                PersistentClass referencedEntityBinding = this.getReferencedEntityBinding(referencedEntityName);
                collectionBinding.setWhere(this.getPluralAttributeSource().getWhere());
                collectionBinding.setManyToManyWhere(StringHelper.getNonEmptyOrConjunctionIfBothNonEmpty(referencedEntityBinding.getWhere(), elementSource.getWhere()));
                collectionBinding.setManyToManyOrdering(elementSource.getOrder());
                if (!(CollectionHelper.isEmpty(elementSource.getFilterSources()) && elementSource.getWhere() == null || collectionBinding.getFetchMode() != FetchMode.JOIN || elementBinding.getFetchMode() == FetchMode.JOIN)) {
                    throw new MappingException(String.format(Locale.ENGLISH, "many-to-many defining filter or where without join fetching is not valid within collection [%s] using join fetching", this.getPluralAttributeSource().getAttributeRole().getFullPath()), mappingDocument.getOrigin());
                }
                for (FilterSource filterSource : elementSource.getFilterSources()) {
                    if (filterSource.getName() == null) {
                        if (!log.isTraceEnabled()) continue;
                        log.tracef("Encountered filter with no name associated with many-to-many [%s]; skipping", (Object)this.getPluralAttributeSource().getAttributeRole().getFullPath());
                        continue;
                    }
                    if (filterSource.getCondition() == null) {
                        throw new MappingException(String.format(Locale.ENGLISH, "No filter condition found for filter [%s] associated with many-to-many [%s]", filterSource.getName(), this.getPluralAttributeSource().getAttributeRole().getFullPath()), mappingDocument.getOrigin());
                    }
                    if (log.isTraceEnabled()) {
                        log.tracef("Applying many-to-many filter [%s] as [%s] to collection [%s]", (Object)filterSource.getName(), (Object)filterSource.getCondition(), (Object)this.getPluralAttributeSource().getAttributeRole().getFullPath());
                    }
                    collectionBinding.addManyToManyFilter(filterSource.getName(), filterSource.getCondition(), filterSource.shouldAutoInjectAliases(), filterSource.getAliasToTableMap(), filterSource.getAliasToEntityMap());
                }
            } else if (pluralElementSource instanceof PluralAttributeElementSourceManyToAny) {
                PluralAttributeElementSourceManyToAny elementSource = (PluralAttributeElementSourceManyToAny)pluralElementSource;
                Any elementBinding = new Any(mappingDocument, collectionBinding.getCollectionTable());
                ModelBinder.this.bindAny(this.mappingDocument, elementSource, elementBinding, this.getPluralAttributeSource().getAttributeRole().append("element"));
                collectionBinding.setElement(elementBinding);
                collectionBinding.setWhere(this.getPluralAttributeSource().getWhere());
            }
        }

        private PersistentClass getReferencedEntityBinding(String referencedEntityName) {
            PersistentClass entityBinding = this.mappingDocument.getMetadataCollector().getEntityBinding(referencedEntityName);
            if (entityBinding == null) {
                throw new MappingException(String.format(Locale.ENGLISH, "Collection [%s] references an unmapped entity [%s]", this.getPluralAttributeSource().getAttributeRole().getFullPath(), referencedEntityName), this.getMappingDocument().getOrigin());
            }
            return entityBinding;
        }
    }
}

