/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.EntityResult;
import jakarta.persistence.FieldResult;
import jakarta.persistence.LockModeType;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.models.spi.ModelsContext;

public class EntityResultJpaAnnotation
implements EntityResult {
    private Class<?> entityClass;
    private LockModeType lockMode;
    private FieldResult[] fields;
    private String discriminatorColumn;

    public EntityResultJpaAnnotation(ModelsContext modelContext) {
        this.lockMode = LockModeType.OPTIMISTIC;
        this.fields = new FieldResult[0];
        this.discriminatorColumn = "";
    }

    public EntityResultJpaAnnotation(EntityResult annotation, ModelsContext modelContext) {
        this.entityClass = annotation.entityClass();
        this.lockMode = annotation.lockMode();
        this.fields = annotation.fields();
        this.discriminatorColumn = annotation.discriminatorColumn();
    }

    public EntityResultJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.entityClass = (Class)attributeValues.get("entityClass");
        this.lockMode = (LockModeType)attributeValues.get("lockMode");
        this.fields = (FieldResult[])attributeValues.get("fields");
        this.discriminatorColumn = (String)attributeValues.get("discriminatorColumn");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return EntityResult.class;
    }

    @Override
    public Class<?> entityClass() {
        return this.entityClass;
    }

    public void entityClass(Class<?> value) {
        this.entityClass = value;
    }

    @Override
    public LockModeType lockMode() {
        return this.lockMode;
    }

    public void lockMode(LockModeType value) {
        this.lockMode = value;
    }

    @Override
    public FieldResult[] fields() {
        return this.fields;
    }

    public void fields(FieldResult[] value) {
        this.fields = value;
    }

    @Override
    public String discriminatorColumn() {
        return this.discriminatorColumn;
    }

    public void discriminatorColumn(String value) {
        this.discriminatorColumn = value;
    }
}

