/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.models.spi.ModelsContext;

public class GeneratedValueJpaAnnotation
implements GeneratedValue {
    private GenerationType strategy;
    private String generator;

    public GeneratedValueJpaAnnotation(ModelsContext modelContext) {
        this.strategy = GenerationType.AUTO;
        this.generator = "";
    }

    public GeneratedValueJpaAnnotation(GeneratedValue annotation, ModelsContext modelContext) {
        this.strategy = annotation.strategy();
        this.generator = annotation.generator();
    }

    public GeneratedValueJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.strategy = (GenerationType)((Object)attributeValues.get("strategy"));
        this.generator = (String)attributeValues.get("generator");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return GeneratedValue.class;
    }

    @Override
    public GenerationType strategy() {
        return this.strategy;
    }

    public void strategy(GenerationType value) {
        this.strategy = value;
    }

    @Override
    public String generator() {
        return this.generator;
    }

    public void generator(String value) {
        this.generator = value;
    }
}

