/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.CascadeType;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToMany;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.models.annotations.spi.AttributeMarker;
import org.hibernate.models.spi.ModelsContext;

public class ManyToManyJpaAnnotation
implements ManyToMany,
AttributeMarker.Fetchable,
AttributeMarker.Cascadeable,
AttributeMarker.Mappable {
    private Class<?> targetEntity;
    private CascadeType[] cascade;
    private FetchType fetch;
    private String mappedBy;

    public ManyToManyJpaAnnotation(ModelsContext modelContext) {
        this.targetEntity = Void.TYPE;
        this.cascade = new CascadeType[0];
        this.fetch = FetchType.LAZY;
        this.mappedBy = "";
    }

    public ManyToManyJpaAnnotation(ManyToMany annotation, ModelsContext modelContext) {
        this.targetEntity = annotation.targetEntity();
        this.cascade = annotation.cascade();
        this.fetch = annotation.fetch();
        this.mappedBy = annotation.mappedBy();
    }

    public ManyToManyJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.targetEntity = (Class)attributeValues.get("targetEntity");
        this.cascade = (CascadeType[])attributeValues.get("cascade");
        this.fetch = (FetchType)((Object)attributeValues.get("fetch"));
        this.mappedBy = (String)attributeValues.get("mappedBy");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ManyToMany.class;
    }

    @Override
    public Class<?> targetEntity() {
        return this.targetEntity;
    }

    public void targetEntity(Class<?> value) {
        this.targetEntity = value;
    }

    @Override
    public CascadeType[] cascade() {
        return this.cascade;
    }

    @Override
    public void cascade(CascadeType[] value) {
        this.cascade = value;
    }

    @Override
    public FetchType fetch() {
        return this.fetch;
    }

    @Override
    public void fetch(FetchType value) {
        this.fetch = value;
    }

    @Override
    public String mappedBy() {
        return this.mappedBy;
    }

    @Override
    public void mappedBy(String value) {
        this.mappedBy = value;
    }
}

